/*
 * Copyright 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * SAM (Secure Access Module) internal implementation via I2C interface for Reader Library
 * $Author: NXP $
 * $Revision: $
 * $Date: $
 */

#ifndef PHBALREG_SAM_I2C_T1_H
#define PHBALREG_SAM_I2C_T1_H

#include <ph_Status.h>

#ifdef NXPBUILD__PHBAL_REG_SAM

#include <phbalReg.h>
#include <phhalHw.h>

#define PHBAL_SAM_PCB_INDEX                 1U

#define PHBAL_SAM_I2C_HEADER_LEN            3U
#define PHBAL_SAM_I2C_LRC_LEN               1U


#define PHBAL_SAM_I2C_T1_START_POS         11U
#define PHBAL_SAM_I2C_NAD_OFFSET            PHBAL_SAM_I2C_T1_START_POS
#define PHBAL_SAM_I2C_PCB_OFFSET            PHBAL_SAM_I2C_NAD_OFFSET + 1U
#define PHBAL_SAM_I2C_LEN_OFFSET            PHBAL_SAM_I2C_PCB_OFFSET + 1U
#define PHBAL_SAM_I2C_INF_BYTE_OFFSET       PHBAL_SAM_I2C_LEN_OFFSET + 1U

#define PHBAL_SAM_I2C_SEND_IFRAME           0U
#define PHBAL_SAM_I2C_SEND_SFRAME_WTX_RESP  1U
#define PHBAL_SAM_I2C_SEND_SFRAME_IFS       2U
#define PHBAL_SAM_I2C_WTX_REQ_PCB           0xC3

phStatus_t phbalReg_Sam_I2C_T1_BuildIBlock(phbalReg_Sam_DataParams_t * pDataParams, uint8_t * pTxBuffer,
    uint16_t * pTxLen);

phStatus_t phbalReg_Sam_I2C_T1_BuildSBlock(phbalReg_Sam_DataParams_t * pDataParams, uint8_t bParam);

phStatus_t phbalReg_Sam_I2C_T1_ProcessResponse(phbalReg_Sam_DataParams_t * pDataParams, uint16_t wRxBufSize,
    uint8_t * pRxBuffer, uint16_t * pRxBufLen);

#endif /* NXPBUILD__PHBAL_REG_SAM */

#endif /* PHBALREG_SAM_I2C_T1_H */
