/*
 * Copyright 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/**
 * \file
 * Software MIFARE DESFire Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  SDA: Generated 23. April 2010
 *
 */

#ifndef PHALMFDFLIGHT_SAM_X_H
#define PHALMFDFLIGHT_SAM_X_H

#include <phCryptoSym.h>
#include <phalMfdfLight.h>

#define PHAL_MFDFLIGHT_SAM_X_AUTH_KEY_DIV_ENABLED            0x0001U		/**< Bit 0 of P1. Indicating diversification of new key requred. */
#define PHAL_MFDFLIGHT_SAM_X_AUTH_KEY_DIV_MODE               (0x0018 >> 3)	/**< Bit 3-4 of P1. Indicating diversification mode. */

phStatus_t phalMfdfLight_Sam_X_AuthenticateEv2(void *pDataParams, uint8_t bAuthType, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bKeyNoCard,
	uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pPcdCapsIn, uint8_t bPcdCapsInLen, uint8_t * pPcdCapsOut, uint8_t * pPdCapsOut);




phStatus_t phalMfdfLight_Sam_X_SetConfiguration(void * pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalMfdfLight_Sam_X_GetVersion(void * pDataParams, uint8_t * pVerInfo, uint8_t * pVerLen);

phStatus_t phalMfdfLight_Sam_X_GetCardUID(void * pDataParams, uint8_t * pUid, uint8_t * pUidLen);




phStatus_t phalMfdfLight_Sam_X_ChangeKey(void * pDataParams, uint16_t wOption, uint16_t wCurrKeyNo, uint16_t wCurrKeyVer, uint16_t wNewKeyNo, uint16_t wNewKeyVer,
	uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfLight_Sam_X_GetKeyVersion(void * pDataParams, uint8_t bKeyNo, uint8_t * pKeyVersion, uint8_t * pKeyVerLen);




phStatus_t phalMfdfLight_Sam_X_CreateTransactionMacFile(void * pDataParams, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights, uint16_t wKeyNo, uint8_t bKeyVer,
	uint8_t bKeyType, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfLight_Sam_X_DeleteFile(void * pDataParams, uint8_t bFileNo);

phStatus_t phalMfdfLight_Sam_X_GetFileIDs(void * pDataParams, uint8_t * pFid, uint8_t * bNumFid);

phStatus_t phalMfdfLight_Sam_X_GetISOFileIDs(void * pDataParams, uint8_t * pFidBuffer, uint8_t * bNumFid);

phStatus_t phalMfdfLight_Sam_X_GetFileSettings(void * pDataParams, uint8_t bFileNo, uint8_t * pFSBuffer, uint8_t * pBufferLen);

phStatus_t phalMfdfLight_Sam_X_ChangeFileSettings(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights, uint8_t bTMCLimitLen,
	uint8_t * pTMCLimit);




phStatus_t phalMfdfLight_Sam_X_ReadData(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pLength, uint8_t ** ppResponse,
	uint16_t * pRespLen);

phStatus_t phalMfdfLight_Sam_X_WriteData(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pData, uint8_t * pDataLen);

phStatus_t phalMfdfLight_Sam_X_GetValue(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdfLight_Sam_X_Credit(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdfLight_Sam_X_Debit(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdfLight_Sam_X_LimitedCredit(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdfLight_Sam_X_ReadRecords(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pRecNo, uint8_t * pRecCount, uint8_t * pRecSize,
	uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalMfdfLight_Sam_X_WriteRecord(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pData, uint8_t * pDataLen);

phStatus_t phalMfdfLight_Sam_X_UpdateRecord(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pRecNo, uint8_t * pOffset, uint8_t * pData,
	uint8_t * pDataLen);

phStatus_t phalMfdfLight_Sam_X_ClearRecordFile(void * pDataParams, uint8_t bFileNo);




phStatus_t phalMfdfLight_Sam_X_CommitTransaction(void * pDataParams, uint8_t bOption, uint8_t * pTMC, uint8_t * pTMV);

phStatus_t phalMfdfLight_Sam_X_AbortTransaction(void * pDataParams);

phStatus_t phalMfdfLight_Sam_X_CommitReaderID(void * pDataParams, uint8_t * pTMRI, uint8_t * pEncTMRI);





phStatus_t phalMfdfLight_Sam_X_IsoSelectFile(void * pDataParams, uint8_t bOption, uint8_t bSelector, uint8_t * pFid, uint8_t * pDFname, uint8_t bDFnameLen,
	uint8_t	bExtendedLenApdu, uint8_t ** ppFCI, uint16_t * pFCILen);

phStatus_t phalMfdfLight_Sam_X_IsoReadBinary(void * pDataParams, uint16_t wOption, uint8_t bOffset, uint8_t bSfid, uint32_t dwBytesToRead, uint8_t bExtendedLenApdu,
	uint8_t ** ppResponse, uint16_t * pBytesRead);

phStatus_t phalMfdfLight_Sam_X_IsoUpdateBinary(void * pDataParams, uint8_t bOffset, uint8_t bSfid, uint8_t bExtendedLenApdu, uint8_t * pData, uint32_t dwDataLen );




phStatus_t phalMfdfLight_Sam_X_ReadSign(void * pDataParams, uint8_t bAddr, uint8_t ** pSignature);




phStatus_t phalMfdfLight_Sam_X_ResetAuthentication(void * pDataParams);

phStatus_t phalMfdfLight_Sam_X_GetConfig(void * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalMfdfLight_Sam_X_SetConfig(void * pDataParams, uint16_t wConfig, uint16_t wValue);




phStatus_t phalMfdfLight_Sam_X_CalculateTMV(void * pDataParams, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo,
	uint16_t wDstKeyVer, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen, uint8_t * pTMI, uint32_t dwTMILen, uint8_t * pTMV);

phStatus_t phalMfdfLight_Sam_X_DecryptReaderID(void * pDataParams, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo,
	uint16_t wDstKeyVer, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen, uint8_t * pEncTMRI, uint8_t * pTMRIPrev);

#endif /* PHALMFDFLIGHT_SAM_X_H */
