/*
 * Copyright 2018, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#include <ph_Status.h>
#include <ph_RefDefs.h>
#include <ph_TypeDefs.h>
#include <string.h>
#include <phTools.h>

#ifdef NXPBUILD__PHAL_MFDF_SAM_X

#include "../phalMfdf_Int.h"
#include "phalMfdf_Sam_X.h"
#include "phalMfdf_Sam_X_Int.h"

phStatus_t phalMfdf_Sam_X_Int_SetAuthMode(void * pDataParams, uint8_t bAuthMode)
{
    switch(PH_GET_COMPID(pDataParams))
	{
		case PHAL_MFDF_SAMAV2_X_ID:
			((phalMfdf_SamAV2_X_DataParams_t *) pDataParams)->bAuthMode = bAuthMode;
			break;

		#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
		case PHAL_MFDF_SAMAV3_X_ID:
			((phalMfdf_SamAV3_X_DataParams_t *) pDataParams)->bAuthMode = bAuthMode;
			break;
		#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

		default:
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF);
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}
phStatus_t phalMfdf_Sam_X_Int_GetAuthMode(void * pDataParams, uint8_t * pAuthMode)
{
    switch(PH_GET_COMPID(pDataParams))
	{
		case PHAL_MFDF_SAMAV2_X_ID:
			*pAuthMode = ((phalMfdf_SamAV2_X_DataParams_t *) pDataParams)->bAuthMode;
			break;

		#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
		case PHAL_MFDF_SAMAV3_X_ID:
			*pAuthMode = ((phalMfdf_SamAV3_X_DataParams_t *) pDataParams)->bAuthMode;
			break;
		#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

		default:
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF);
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}

phStatus_t phalMfdf_Sam_X_Int_SetKeyNo(void * pDataParams, uint8_t bKeyNo)
{
    switch(PH_GET_COMPID(pDataParams))
	{
		case PHAL_MFDF_SAMAV2_X_ID:
			((phalMfdf_SamAV2_X_DataParams_t *) pDataParams)->bKeyNo = bKeyNo;
			break;

		#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
		case PHAL_MFDF_SAMAV3_X_ID:
			((phalMfdf_SamAV3_X_DataParams_t *) pDataParams)->bKeyNo = bKeyNo;
			break;
		#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

		default:
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF);
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}
phStatus_t phalMfdf_Sam_X_Int_GetKeyNo(void * pDataParams, uint8_t * pKeyNo)
{
	switch(PH_GET_COMPID(pDataParams))
	{
		case PHAL_MFDF_SAMAV2_X_ID:
			*pKeyNo = ((phalMfdf_SamAV2_X_DataParams_t *) pDataParams)->bKeyNo;
			break;

		#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
		case PHAL_MFDF_SAMAV3_X_ID:
			*pKeyNo = ((phalMfdf_SamAV3_X_DataParams_t *) pDataParams)->bKeyNo;
			break;
		#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

		default:
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF);
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}

phStatus_t phalMfdf_Sam_X_Int_SetWrappedMode(void * pDataParams, uint8_t bWrappedMode)
{
    switch(PH_GET_COMPID(pDataParams))
	{
		case PHAL_MFDF_SAMAV2_X_ID:
			((phalMfdf_SamAV2_X_DataParams_t *) pDataParams)->bWrappedMode = bWrappedMode;
			break;

		#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
		case PHAL_MFDF_SAMAV3_X_ID:
			((phalMfdf_SamAV3_X_DataParams_t *) pDataParams)->bWrappedMode = bWrappedMode;
			break;
		#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

		default:
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF);
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}
phStatus_t phalMfdf_Sam_X_Int_GetWrappedMode(void * pDataParams, uint8_t * pWrappedMode)
{
    switch(PH_GET_COMPID(pDataParams))
	{
		case PHAL_MFDF_SAMAV2_X_ID:
			*pWrappedMode = ((phalMfdf_SamAV2_X_DataParams_t *) pDataParams)->bWrappedMode;
			break;

		#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
		case PHAL_MFDF_SAMAV3_X_ID:
			*pWrappedMode = ((phalMfdf_SamAV3_X_DataParams_t *) pDataParams)->bWrappedMode;
			break;
		#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

		default:
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF);
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}

phStatus_t phalMfdf_Sam_X_Int_SetAdditionalInfo(void * pDataParams, uint16_t wAdditionalInfo)
{
    switch(PH_GET_COMPID(pDataParams))
	{
		case PHAL_MFDF_SAMAV2_X_ID:
			((phalMfdf_SamAV2_X_DataParams_t *) pDataParams)->wAdditionalInfo = wAdditionalInfo;
			break;

		#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
		case PHAL_MFDF_SAMAV3_X_ID:
			((phalMfdf_SamAV3_X_DataParams_t *) pDataParams)->wAdditionalInfo = wAdditionalInfo;
			break;
		#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

		default:
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF);
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}
phStatus_t phalMfdf_Sam_X_Int_GetAdditionalInfo(void * pDataParams, uint16_t * pAdditionalInfo)
{
    switch(PH_GET_COMPID(pDataParams))
	{
		case PHAL_MFDF_SAMAV2_X_ID:
			*pAdditionalInfo = ((phalMfdf_SamAV2_X_DataParams_t *) pDataParams)->wAdditionalInfo;
			break;

		#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
		case PHAL_MFDF_SAMAV3_X_ID:
			*pAdditionalInfo = ((phalMfdf_SamAV3_X_DataParams_t *) pDataParams)->wAdditionalInfo;
			break;
		#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

		default:
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF);
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}

phStatus_t phalMfdf_Sam_X_Int_SetAid(void * pDataParams, uint8_t * pAid)
{
    switch(PH_GET_COMPID(pDataParams))
	{
		case PHAL_MFDF_SAMAV2_X_ID:
			memcpy(((phalMfdf_SamAV2_X_DataParams_t *) pDataParams)->pAid, pAid, 3);	/* PRQA S 3200 */
			break;

		#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
		case PHAL_MFDF_SAMAV3_X_ID:
			memcpy(((phalMfdf_SamAV3_X_DataParams_t *) pDataParams)->pAid, pAid, 3);	/* PRQA S 3200 */
			break;
		#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

		default:
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF);
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}
phStatus_t phalMfdf_Sam_X_Int_GetAid(void * pDataParams, uint8_t * pAid)
{
    switch(PH_GET_COMPID(pDataParams))
	{
		case PHAL_MFDF_SAMAV2_X_ID:
			memcpy(pAid, ((phalMfdf_SamAV2_X_DataParams_t *) pDataParams)->pAid, 3);	/* PRQA S 3200 */
			break;

		#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
		case PHAL_MFDF_SAMAV3_X_ID:
			memcpy(pAid, ((phalMfdf_SamAV3_X_DataParams_t *) pDataParams)->pAid, 3);	/* PRQA S 3200 */
			break;
		#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

		default:
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF);
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}

phStatus_t phalMfdf_Sam_X_Int_ValidateResponse(void * pDataParams, uint16_t wStatus, uint8_t * pPiccRetCode)
{
    phStatus_t  PH_MEMLOC_REM wStatus_Tmp = 0;
	uint8_t		PH_MEMLOC_REM bWrappedMode = 0;
	uint8_t		PH_MEMLOC_REM bISOMode = 0;
	uint16_t	PH_MEMLOC_REM wPiccErrorCode = 0;

	/* Set ISOMode. */
	PH_CHECK_SUCCESS_FCT(wStatus_Tmp, phalMfdf_Sam_X_Int_GetWrappedMode(pDataParams, &bWrappedMode));
	bISOMode = (uint8_t) (bWrappedMode ? 1 : 0);

	/* Evaluate the response. */
	if ((wStatus == PH_ERR_SUCCESS) || ((wStatus & PH_ERR_MASK) == (PH_ERR_CUSTOM_BEGIN + 23) /* PHHAL_HW_SAMAV2_ERR_DESFIRE_GEN */))
	{
		if(wStatus != PH_ERR_SUCCESS)
		{
			/* Get the PICC error code form HAL for SAM AV2. */
			if(PH_GET_COMPID(pDataParams) == PHAL_MFDF_SAMAV2_X_ID)
			{
				PH_CHECK_SUCCESS_FCT(wStatus_Tmp, PHHAL_HW_GET_CONFIG(
					pDataParams,
					PHHAL_HW_CONFIG_ADDITIONAL_INFO,
					&wPiccErrorCode));

				pPiccRetCode[0] = (uint8_t) (bISOMode ? ((wPiccErrorCode & 0xFF00) >> 8) : (wPiccErrorCode & 0x00FF));
				pPiccRetCode[1] = (uint8_t) (wPiccErrorCode & 0x00FF);
			}

			/* Validate if proper wrapped PICC status is available. First byte should be 91. */
			if(bISOMode)
			{
				if(pPiccRetCode[0] != 0x91)
					return PH_ADD_COMPCODE(PH_ERR_PROTOCOL_ERROR, PH_COMP_AL_MFDF);
			}

			/* Validate the PICC Status. */
			PH_CHECK_SUCCESS_FCT(wStatus, phalMfdf_Int_ComputeErrorResponse(pDataParams, pPiccRetCode[bISOMode ? 1 : 0]));
		}
	}
	else
	{
		if((wStatus & PH_ERR_MASK) == PH_ERR_SUCCESS_CHAINING)
		{
			wStatus = PH_ADD_COMPCODE(PH_ERR_SUCCESS_CHAINING, PH_COMP_AL_MFDF);
		}

		PH_CHECK_SUCCESS(wStatus);
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}

phStatus_t phalMfdf_Sam_X_Int_Iso7816Wrap(void * pDataParams, uint8_t bLengthPresent, uint8_t bLengthLen, uint8_t bLePresent, uint8_t * pPlainData, uint8_t * pDataLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
	uint8_t		PH_MEMLOC_REM bCmdCode = 0;
	uint8_t		PH_MEMLOC_REM bLC = 0;
	uint8_t		PH_MEMLOC_REM bOffset = 0;
	uint8_t		PH_MEMLOC_REM bWrappedMode = 0;

	/* Extract the command code. */
	bCmdCode = pPlainData[bLengthPresent ? bLengthLen :0];

	/* Wrap the command if needed. */
	PH_CHECK_SUCCESS_FCT(wStatus, phalMfdf_Sam_X_Int_GetWrappedMode(pDataParams, &bWrappedMode));
	if(bWrappedMode)
	{
		/* Set the LC value */
		bLC = (uint8_t) (*pDataLen - 1 /* Removing the command code. */);

		/* Subtract LC by 3 if Length is present. */
		bLC = (uint8_t) (bLengthPresent ? ( bLC - bLengthLen)  : bLC);

		/* Compute the offset. */
		bOffset = (uint8_t) (bLengthPresent ? (bLengthLen + 1) : 1);

		/* Copy the data to the Pointer. */
		memmove(&pPlainData[bLengthPresent ? (bLengthLen + 5) : 5], &pPlainData[bOffset], bLC);	/* PRQA S 3200 */

		/* Reset the length buffer. */
		*pDataLen = (uint8_t) (bLengthPresent ? bLengthLen : 0);

		/* Frame the initial ISO7816 header. */
		pPlainData[(*pDataLen)++] = PHAL_MFDF_WRAPPEDAPDU_CLA;
		pPlainData[(*pDataLen)++] = bCmdCode;
		pPlainData[(*pDataLen)++] = PHAL_MFDF_WRAPPEDAPDU_P1;
		pPlainData[(*pDataLen)++] = PHAL_MFDF_WRAPPEDAPDU_P2;

		/* Add LC if there is data. */
		if(bLC)
		{
			pPlainData[(*pDataLen)++] = bLC;

			/* Update Frame length based on LC. */
			*pDataLen = (uint8_t) (*pDataLen + bLC);
		}

		if(bLePresent)
		{
			pPlainData[(*pDataLen)++] = PHAL_MFDF_WRAPPEDAPDU_LE;
		}
	}

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}

phStatus_t phalMfdf_Sam_X_Int_WriteX(void * pDataParams, uint16_t wOption, uint8_t bCommMode, uint8_t * pData, uint8_t bDataLen, uint8_t bDataOffset, uint8_t bIsDataComd)
{
	phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t     PH_MEMLOC_REM bCrypto = 0;
    uint8_t     PH_MEMLOC_REM aPiccRetCode[2];
	uint8_t		PH_MEMLOC_REM bPiccRetCodeLen = 0;

#ifndef NXPBUILD__PHAL_MFDF_SAMAV3_X
	/* Actuall these parametes are not used when Sam is AV2 HAL. When Package manager is build using only SAM AV2 HAL
	 * these parameter are shown as warning resulting in error in Release mode. So package manager to run smoothly,
	 * initializating the unused parameters.
	 */
	PHAL_MFDF_UNUSED_VARIABLE(bPiccRetCodeLen);
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

	/* Clear the PICC wStatus code buffer. */
	memset(aPiccRetCode, 0x00, sizeof(aPiccRetCode));	/* PRQA S 3200 */

	/* Wrap the command if required. */
	PH_CHECK_SUCCESS_FCT(wStatus, phalMfdf_Sam_X_Int_Iso7816Wrap(
		pDataParams,
		PH_OFF,
		0,
		PH_OFF,
		pData,
		&bDataLen));

	/* Frame the Crypto information. */
	bCrypto = bCommMode;

	if(bCommMode != PHAL_MFDF_COMMUNICATION_PLAIN)
	{
		bCrypto = (uint8_t) (bCrypto + (bDataLen - bDataOffset));
		bCrypto = (uint8_t) (bIsDataComd ? (bCommMode + bDataOffset) : bCrypto);
	}

	/* Exchange the information to Sam. */
	wStatus = PHHAL_HW_SAM_CMD_DESFIRE_WRITEX(
		pDataParams,
		wOption,
		bCrypto,
		pData,
		bDataLen,
		aPiccRetCode,
		&bPiccRetCodeLen);

    /* Evaluate the response. */
	PH_CHECK_SUCCESS_FCT(wStatus, phalMfdf_Sam_X_Int_ValidateResponse(pDataParams, wStatus, aPiccRetCode));

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}

phStatus_t phalMfdf_Sam_X_Int_ReadX(void * pDataParams, uint16_t wOption, uint8_t bCommMode, uint8_t * pAppData, uint8_t bAppDataLen, uint8_t bLenPresent, uint8_t bLen,
	uint8_t ** ppResponse, uint16_t * pRespLen)
{
	phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t     PH_MEMLOC_REM aPiccRetCode[2];
	uint8_t		PH_MEMLOC_REM bPiccRetCodeLen = 0;

#ifndef NXPBUILD__PHAL_MFDF_SAMAV3_X
	/* Actuall these parametes are not used when Sam is AV2 HAL. When Package manager is build using only SAM AV2 HAL
	 * these parameter are shown as warning resulting in error in Release mode. So package manager to run smoothly,
	 * initializating the unused parameters.
	 */
	PHAL_MFDF_UNUSED_VARIABLE(bPiccRetCodeLen);
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

	/* Clear the PICC wStatus code buffer. */
	memset(aPiccRetCode, 0x00, sizeof(aPiccRetCode));	/* PRQA S 3200 */

	/* Wrap the command if required. */
	PH_CHECK_SUCCESS_FCT(wStatus, phalMfdf_Sam_X_Int_Iso7816Wrap(
		pDataParams,
		bLenPresent,
		bLen,
		PH_ON,
		pAppData,
		&bAppDataLen));

	/* Exchange the information to Sam. */
	wStatus = PHHAL_HW_SAM_CMD_DESFIRE_READX(
		pDataParams,
		wOption,
		bCommMode,
		pAppData,
		bAppDataLen,
		ppResponse,
		pRespLen,
		aPiccRetCode,
		&bPiccRetCodeLen);

    /* Evaluate the response. */
	PH_CHECK_SUCCESS_FCT(wStatus, phalMfdf_Sam_X_Int_ValidateResponse(pDataParams, wStatus, aPiccRetCode));

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFDF);
}

#endif /* NXPBUILD__PHAL_MFDFEVX_SAM_X */
