/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2011
*  ALL RIGHTS RESERVED
*
*  File Name:   Main.c
*                                                                          
*  Description: DataLogger application
*                                                                                     
*  Assembler:   Codewarrior for HC(S)08 V6.1
*                                            
*  Version:     1.1                                                         
*                                                                                                                                                         
*  Author:      Jose Ruiz (SSE Americas)
*                                                                                       
*  Location:    Guadalajara,Mexico                                              
*                                                                                                                  
*                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.0   2008.02.18  Jose Ruiz     Initial version
* 1.1   2011.09.27  Carlos C.     Create the file if it doesn't exist
* 
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/


#include <hidef.h>          /* for EnableInterrupts macro */
#include "derivative.h"     /* include peripheral declarations */
#include "FslTypes.h"       /* Freescale Types */
#include "SD.h"             /* SD Driver */
#include "FAT.h"            /* FAT Driver */
#include "RTC.h"            /* RTC */
#include "ADC.h"            /* ADC */
#include "Config.h"

/* Global variables */
UINT8 gu8IntFlags=0;
UINT8 u16SampleCounter;
UINT8 gau8LogArray[SAMPLES_WRITE];
UINT8 gu8Result[3]={0,0,0};

/* Prototypes */
void MCU_Init(void);
void DEC_to_ACC(UINT8);

/********************************************************/
void main(void) 
{                                      
    volatile UINT8 u8Error;

    u8Error=153;
    DEC_to_ACC(u8Error);

    MCU_Init();
    SPI_Init();
    RTC_Init();
    ADC_Init();
    EnableInterrupts;

    PTFDD_PTFDD4=_OUT;    
    
    u8Error=SD_Init();
    FAT_Read_Master_Block();
    
    /* Creating the file if it doesn't exist */
    if (FAT_FileOpen(FILE_NAME, MODIFY) == FILE_NOT_FOUND) 
    {
      u8Error=FAT_FileOpen(FILE_NAME,CREATE); 
    }        
    FAT_FileClose();   

    /* Start Code */
    u16SampleCounter=0;
    while(1)
    {
        _WAIT;
        
        if(FLAG_CHK(ADC_Flag,gu8IntFlags)); 
        {
          FLAG_CLR(ADC_Flag,gu8IntFlags);    
          DEC_to_ACC(gu8ADCResult);
          gau8LogArray[u16SampleCounter++]=gu8Result[0];
          gau8LogArray[u16SampleCounter++]=gu8Result[1];
          gau8LogArray[u16SampleCounter++]=gu8Result[2];
          gau8LogArray[u16SampleCounter++]=',';
        }
        if(u16SampleCounter==SAMPLES_WRITE)
        {
            PTFD_PTFD4=~PTFD_PTFD4;                             // user LED toogle
            u16SampleCounter=0;
            u8Error=FAT_FileOpen(FILE_NAME,MODIFY);
            FAT_FileWrite(gau8LogArray,SAMPLES_WRITE);
            FAT_FileClose();
        }
    }
}

/********************************************************/
/********************************************************/
void MCU_Init(void) 
{
    SOPT1 = 0x20;                 // disable COP
    SOPT2 = 0x00;                 // enable high rate SPI  
  
    // MCG clock initialization
    MCGC2 = 0x36;
  
    while(!(MCGSC & 0x02));		    //wait for the OSC stable
  
    MCGC1 = 0x1B;
    MCGC3 = 0x48;
    while ((MCGSC & 0x48) != 0x48);		//wait for the PLL is locked}
}


/********************************************************/
void DEC_to_ACC (UINT8 u8Data)
{

    gu8Result[0]=(u8Data/100);
    u8Data-=gu8Result[0]*100;
    gu8Result[1]=(u8Data/10);
    u8Data-=gu8Result[1]*10;
    gu8Result[2]=u8Data;

    gu8Result[0]+=0x30;
    gu8Result[1]+=0x30;
    gu8Result[2]+=0x30;
}