/*
 * ADC.h
 *
 *  Created on: 05/06/2012
 *      Author: B34981
 */

#ifndef ADC_H_
#define ADC_H_

/*******************************************************************************
* Includes
********************************************************************************/

#include "derivative.h"

/*******************************************************************************
* Constants
********************************************************************************/


/*******************************************************************************
* Macros
********************************************************************************/
#define CMD_SEL(x)	((unsigned long)((x)&0x03)<<30)
#define INTFLG_SEL(x)	((unsigned long)((x)&0x0F)<<24)
#define VRH_SEL(x)	((unsigned long)((x)&0x01)<<23)
#define VRL_SEL(x)	((unsigned long)((x)&0x01)<<22)
#define CH_SEL(x)	((unsigned long)((x)&0x3F)<<16)
#define SMP(x)		((unsigned long)((x)&0x1F)<<11)
                
/*******************************************************************************
* Types
********************************************************************************/


/*******************************************************************************
* Variables
********************************************************************************/


/*******************************************************************************
* Global Variables
********************************************************************************/


/*******************************************************************************
* Global Functions
********************************************************************************/

/***********************************************************************************************
*
* @brief    ADC_Init - Initialize the ADC module to read only one element on the list
* @param    none
* @return   none
*
************************************************************************************************/  
void ADC_Init(void);

/***********************************************************************************************
*
* @brief    ADC_Read - Read the only channel specified on the ADC_Init list
* @param    none
* @return   none
*
************************************************************************************************/  
UINT16 ADC_Read(void);

#endif /* ADC_H_ */
