/******************************************************************************								
*    ADC.c                                                                    *								
*                                                                             *								
*       Created on: 05/06/2012                                                *								
*       Author: B34981                                                        *								
*                                                                             *								
*       The Analog-To-Digital Conversion module features the new List based   *								
*    control scheme. This driver configures the ADC module to execute a       *								
*    single element list converting the POT analog input with a 12-bit        *								
*    resolution, left justified results.                                      *								
******************************************************************************/								


#include "ADC.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/
#pragma DATA_SEG adcLists		/* ADC lists must be aligned to a 4 byte boundary, defined on linker file */
	UINT32 adc0_cmdlist[8];
	UINT16 adc0_results[8];
#pragma DATA_SEG DEFAULT	
/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    ADC_Init - Initialize the ADC module to read only one element on the list
* @param    none
* @return   none
*
************************************************************************************************/  
void ADC_Init()
{
	  adc0_cmdlist[0] = CMD_SEL(3)+ INTFLG_SEL(3)+ VRH_SEL(1)+ VRL_SEL(1)+ CH_SEL(0x10);   //Channel 0 read	
	  
	  //Configure ADC0 control
	  ADC0CTL_0 = 0x0D;	//set dual-access mode, trigger mode
	  ADC0CTL_1 = 0x00;	//single CSL & RVL buffers, Normal access, No Auto-Restart after exit from STOP 
	  ADC0STS = 0x00;		//select CSL 0 and RVL 0
	  ADC0TIM = 0x03;		//32Mhz/8Mhz-1 = 3 => fADCCLK = 8MHz
	  
	  //Configure pointers to ADC0 CSL & RVL
	 
	  ADC0CBP = adc0_cmdlist;		/* Store the pointer to the command list */
	  ADC0RBP = adc0_results;		/* Store the pointer to the result list */
	  
	  ADC0FMT_DJM = 1;			/* Left Justified results */
	  ADC0FMT_SRES = 4;			/* 12-bit resolution */
	  
	  //Start conversion -- ADC0
	  ADC0CTL_0_ADC_EN = 1;	//Enable the ADC
}


/***********************************************************************************************
*
* @brief    ADC_Read - Read the only channel specified on the ADC_Init list
* @param    none
* @return   none
*
************************************************************************************************/  
UINT16 ADC_Read()
{
		
	  ADC0FLWCTL_RSTA = 1;							// Trigger a Restart event		
	  while(1 == ADC0FLWCTL_RSTA) {}				// Wait for restart to finish
	    
	  while (0x00 == ADC0CONIF){}					//Wait until ADC conversion is complete
	    
	  ADC0CONIF = ADC0CONIF;						//Clear conversion interrupt flag
	 
	  return adc0_results[0];						// Return the result 0 on the result list
}
