#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

void main(void) {
	
	/********************************************/
	/************ PLL INITIALIZATION ************/
	/********************************************/
	CPMUCLKS_PLLSEL = 1;			//FBUS = FPLL/2.   FBUS = 32MHz, 
	CPMUREFDIV_REFFRQ = 1;			//Reference clock between 2MHZ and 6MHZ.	
	CPMUREFDIV_REFDIV = 0x1;		//FREF=8/(1+1) = 4MHZ		
	CPMUSYNR_VCOFRQ = 0x1;          //FVCO is between 48MHZ and 80MHZ	
	CPMUSYNR_SYNDIV = 0x7;			//FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x4x(7+1) = 64MHZ
	CPMUPOSTDIV_POSTDIV = 0x0;		//FPLL = FVCO/(POSTDIV+1).  FPLL = 64MHZ/(0+1)    FPLL = 64MHz	
	CPMUOSC_OSCE = 1;				//External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)		
	while(!CPMUIFLG_LOCK){}			//Wait for LOCK.      	
	CPMUIFLG = 0xFF;				//clear CMPMU flags
	
	/********************************************/
	/*********** GPIO INITIALIZATION ************/
	/********************************************/
	
	//Use PP6 as output for LED
	DDRP_DDRP6 = 1;
	
	/********************************************/
	/************ TIM INITIALIZATION ************/
	/********************************************/
	
	//1. Configure the prescaler (TSCR2[PR]).
	TIM0TSCR2_PR = 0b111;
	
	//2. Configure needed channels as Input Capture (TIOS[IOSx]=0) or Output Compare (TIOS[IOSx]=1).
	TIM0TIOS = 0;
	
	//3. Enable interrupts if needed in the timer interrupt enable register (TIE).
	TIM0TIE = 0;
	
	//4. Set the timer enable bit (TSCR1[TEN]).
	TIM0TSCR1_TEN = 1;
	
	/********************************************/
	/************ LED BLINK LOOP ****************/
	/********************************************/
	for(;;){
		
		//wait until timer flag is set
		while(TIM0TFLG2_TOF==0){
			__RESET_WATCHDOG();	/* feeds the dog */
		}
		
		//clear timer flag
		TIM0TFLG2_TOF = 1;
		
		//change LED state
		PTP_PTP6 ^= 1;
	}
}
