/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : TimerInt
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 15:16, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_TimerInt */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "TI1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

extern word count;

#define COUNT 10

void main(void)
{
  word Ticks[COUNT];
  byte i;
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/


  TEST1_testStart(&testRec, "Periodic Interrupt test");
  
  count = 0;

  for(i=0;i<COUNT;i++) {
    Cpu_Delay100US(5000); /* delay 500ms */
    Ticks[i]=count;
  }
  TEST1_testComment(&testRec, "test measured ticks (5%)");
  for(i=0;i<COUNT;i++) {
    if ((Ticks[i] < (i+1)*(10-1)) || (Ticks[i] > (i+1)*(10+1))) {
      TEST1_testFailed(&testRec, "");
    } else {
      TEST1_testComment(&testRec, "number of ticks OK");
    }  
  }

  TEST1_testEnd(&testRec);

}


/* END demo_TimerInt */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
