/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : TmDt1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : TimeDate
**     Version     : Component 02.108, Driver 02.05, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 13:52, # CodeGen: 7
**     Abstract    :
**         This component "TimeDate" implements real time and date.
**         The component requires a periodic interrupt generator: timer
**         compare or reload register or timer-overflow interrupt
**         (of free running counter). User can select precision of
**         selected timer.
**         The component supports also alarm with event OnAlarm.
**     Settings    :
**         Timer name                  : TMRA0 (16-bit)
**
**         Counter                     : TMRA_0_CNTR [E145]
**         Mode register               : TMRA_0_CTRL [E146]
**         Run register                : TMRA_0_CTRL [E146]
**         Prescaler                   : TMRA_0_CTRL [E146]
**         Compare register            : TMRA_0_COMP1 [E140]
**         Flip-flop register          : TMRA_0_SCTRL [E147]
**
**         Interrupt name              : INT_TMRA_0
**         Interrupt enable reg.       : TMRA_0_SCTRL [E147]
**         Priority                    : 1
**         User handling procedure     : TmDt1_OnAlarm
**         This event is called whenever the current time is equal
**         to alarm time
**
**         High speed mode
**             Prescaler               : divide-by-32
**             Clock                   : 3125000 Hz
**           Resolution of timer
**             Xtal ticks              : 160000
**             microseconds            : 20000
**             milliseconds            : 20
**             seconds (real)          : 0.02
**             Hz                      : 50
**
**         Initialization:
**              Timer                  : Enabled
**
**              Time                   : 11:59:55
**              Date                   : 1/1/2008
**     Contents    :
**         SetTime  - byte TmDt1_SetTime(byte Hour, byte Min, byte Sec, byte Sec100);
**         SetDate  - byte TmDt1_SetDate(word Year, byte Month, byte Day);
**         GetDate  - byte TmDt1_GetDate(DATEREC *Date);
**         SetAlarm - byte TmDt1_SetAlarm(byte Hour, byte Min, byte Sec, byte Sec100);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __TmDt1
#define __TmDt1

/* MODULE TmDt1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Cpu.h"
#include <limits.h>


#ifndef __BWUserType_DATEREC
#define __BWUserType_DATEREC
  typedef struct { /* It contains actual year, month, and day description. */
    word Year; /* years (0x07CE - 0x0833) */
    byte Month; /* months (1 - 0x0C) */
    byte Day; /* days (0 - 0x06) */
  } DATEREC;
#endif

byte TmDt1_SetTime(byte Hour,byte Min,byte Sec,byte Sec100);
/*
** ===================================================================
**     Method      :  TmDt1_SetTime (component TimeDate)
**
**     Description :
**         This method sets a new actual time.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Hour            - Hours (0 - 23)
**         Min             - Minutes (0 - 59)
**         Sec             - Seconds (0 - 59)
**         Sec100          - Hundredths of seconds (0 - 99)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/

byte TmDt1_SetDate(word Year,byte Month,byte Day);
/*
** ===================================================================
**     Method      :  TmDt1_SetDate (component TimeDate)
**
**     Description :
**         This method sets a new actual date. See limitations at the
**         page <General Info>.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Year            - Years (16-bit unsigned integer)
**         Month           - Months (8-bit unsigned integer)
**         Day             - Days (8-bit unsigned integer)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/

byte TmDt1_GetDate(DATEREC *Date);
/*
** ===================================================================
**     Method      :  TmDt1_GetDate (component TimeDate)
**
**     Description :
**         This method returns current date.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Date            - Pointer to the structure DATEREC. It
**                           contains actual year, month, and day
**                           description.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte TmDt1_SetAlarm(byte Hour,byte Min,byte Sec,byte Sec100);
/*
** ===================================================================
**     Method      :  TmDt1_SetAlarm (component TimeDate)
**
**     Description :
**         This method sets a new time of alarm. (only time, not date -
**         alarm event <OnAlarm> is called every 24 hours). Setting any
**         parameter out of its range disables alarm.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Hour            - Hours (0 - 23)
**         Min             - Minutes (0 - 59)
**         Sec             - Seconds (0 - 59)
**         Sec100          - Hundredths of seconds (0 - 99)
**     Returns     :
**         ---             - Error code, possible codes: 
**                           - ERR_OK - OK 
**                           - ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

void TmDt1_Init(void);
/*
** ===================================================================
**     Method      :  TmDt1_Init (component TimeDate)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void TmDt1_Interrupt(void);
/*
** ===================================================================
**     Method      :  TmDt1_Interrupt (component TimeDate)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/* END TmDt1. */

#endif /* ifndef __TmDt1 */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
