/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : SS1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : SynchroSlave
**     Version     : Component 02.249, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 13:51, # CodeGen: 41
**     Abstract    :
**         This component "SynchroSlave" implements SLAVE part of synchronous
**         serial master-slave communication.
**     Settings    :
**         Synchro type                : SLAVE
**
**         Serial channel              : QSPI2
**
**         Protocol
**             Clock edge              : rising
**             Width                   : 8 bits
**             Empty character         : 32
**             Empty char. on input    : RECEIVED
**
**         Registers
**             Input buffer            : QSPI2_SPDRR [57554]
**             Output buffer           : QSPI2_SPDTR [57555]
**             Control register        : QSPI2_SPSCR [57552]
**             Mode register           : QSPI2_SPDSR [57553]
**             Baud setting reg.       : QSPI2_SPSCR [57552]
**
**         Input interrupt
**             Vector name             : INT_QSPI2_RCV
**             Priority                : 1
**
**         Output interrupt
**             Vector name             : INT_QSPI2_XMIT
**             Priority                : 1
**
**         Used pins                   :
**         ----------------------------------------------------------
**              Function    | On package |    Name
**         ----------------------------------------------------------
**               Input      |     40     |  GPIOB10/ANC22/XB_IN8/MOSI2
**               Output     |     39     |  GPIOB9/ANC21/XB_IN9/MISO2
**               Clock      |     41     |  GPIOB11/ANC23/XB_IN7/SCK2
**           Select slave   |     51     |  GPIOG10/PWMB_2X/PWMA_2X/XB_IN8/SS2_B
**         ----------------------------------------------------------
**     Contents    :
**         RecvChar        - byte SS1_RecvChar(SS1_TComData *Chr);
**         SendChar        - byte SS1_SendChar(SS1_TComData Chr);
**         RecvBlock       - byte SS1_RecvBlock(SS1_TComData *Ptr, word Size, word *Rcv);
**         SendBlock       - byte SS1_SendBlock(SS1_TComData *Ptr, word Size, word *Snd);
**         ClearRxBuf      - byte SS1_ClearRxBuf(void);
**         ClearTxBuf      - byte SS1_ClearTxBuf(void);
**         GetCharsInRxBuf - word SS1_GetCharsInRxBuf(void);
**         GetCharsInTxBuf - word SS1_GetCharsInTxBuf(void);
**         GetError        - byte SS1_GetError(SS1_TError *Err);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __SS1
#define __SS1

/* MODULE SS1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"


#ifndef __BWUserType_SS1_TError
#define __BWUserType_SS1_TError
  typedef union {
    byte err;
    struct {
      /*lint -save  -e46 Disable MISRA rule (6.4) checking. */
      bool OverRun  : 1;               /* OverRun error flag */
      bool RxBufOvf : 1;               /* Rx buffer full error flag */
      bool FaultErr : 1;               /* Fault mode error flag */
      /*lint -restore Enable MISRA rule (6.4) checking. */
    }errName;
  } SS1_TError;                        /* Error flags. For languages which don't support bit access is byte access only to error flags possible. */
#endif

#define SS1_EOF 32                     /* Empty character*/

#ifndef __BWUserType_SS1_TComData
#define __BWUserType_SS1_TComData
  typedef byte SS1_TComData;           /* User type for communication. Size of this type depends on the communication data witdh. */
#endif


#define SS1_INP_BUF_SIZE 20U           /* Input buffer size */
#define SS1_OUT_BUF_SIZE 20U           /* Output buffer size */

extern volatile word SS1_OutLen;       /* Length of output buffer's content */

extern volatile word SS1_InpLen;       /* Length of input buffer's content */

byte SS1_RecvChar(SS1_TComData *Chr);
/*
** ===================================================================
**     Method      :  SS1_RecvChar (component SynchroSlave)
**
**     Description :
**         If any data is received, this method returns one character,
**         otherwise it returns an error code (it does not wait for
**         data). 
**         For information about SW overrun behavior please see
**         <General info page>.
**         [ Version specific information for Freescale 56800
**         derivatives ] 
**         DMA mode:
**         If DMA controller is available on selected CPU and receiver
**         is configured to use DMA controller then this method only
**         sets the selected DMA channel. Status of the DMA transfer
**         can then be checked using method GetCharsInRxBuf. See
**         typical usage for details about communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - A pointer to the received character
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_RXEMPTY - No data in receiver
**                           ERR_OVERRUN - Overrun error is detected
**                           from the last char or block received. In
**                           polling mode, this error code is returned
**                           only when the hardware supports detection
**                           of the overrun error. 
**                           ERR_FAULT - Fault error was detected from
**                           the last char or block received. This error
**                           does not need to be supported on some Cpu
**                           (see generated code).
** ===================================================================
*/

byte SS1_SendChar(SS1_TComData Chr);
/*
** ===================================================================
**     Method      :  SS1_SendChar (component SynchroSlave)
**
**     Description :
**         Sends one character to the channel.
**         [ Version specific information for Freescale 56800
**         derivatives ] 
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         transmitter is configured to use DMA controller then this
**         method only sets the selected DMA channel. The status of the
**         DMA transfer can then be checked using GetCharsInTxBuf
**         method. See the typical usage for details about
**         communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_DISABLED -  Device is disabled (only if
**                           output DMA is supported and enabled)
**                           ERR_TXFULL - Transmitter is full
** ===================================================================
*/

byte SS1_RecvBlock(SS1_TComData *Ptr,word Size,word *Rcv);
/*
** ===================================================================
**     Method      :  SS1_RecvBlock (component SynchroSlave)
**
**     Description :
**         If any data received, this method returns the block of the
**         data and its length (and incidental error), otherwise it
**         returns error code (it does not wait for data).
**         If less than requested number of characters is received only
**         the available data is copied from the receive buffer to the
**         user specified destination and the ERR_EXEMPTY value is
**         returned.
**         This method is available only if non-zero length of input
**         buffer is defined. 
**         For information about SW overrun behavior please see
**         <General info page>.
**         [ Version specific information for Freescale 56800
**         derivatives ] 
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         receiver is configured to use DMA controller then this
**         method only sets the selected DMA channel. The status of the
**         DMA transfer can then be checked using GetCharsInRxBuf
**         method. See the typical usage for details about
**         communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - A pointer to the block of received data
**         Size            - The size of the block
**       * Rcv             - Pointer to a variable where an actual
**                           number of copied characters is stored
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_RXEMPTY - It was not possible to read
**                           requested number of bytes from the buffer
**                           ERR_FAULT - Fault error was detected from
**                           the last char or block received. This error
**                           does not need to be supported on some Cpu
**                           (see generated code).
** ===================================================================
*/

byte SS1_SendBlock(SS1_TComData *Ptr,word Size,word *Snd);
/*
** ===================================================================
**     Method      :  SS1_SendBlock (component SynchroSlave)
**
**     Description :
**         Sends a block of characters to the channel. This method is
**         only available if a non-zero length of output buffer is
**         defined.
**         [ Version specific information for Freescale 56800
**         derivatives ] 
**         DMA mode:
**         If DMA controller is available on the selected CPU and
**         transmitter is configured to use DMA controller then this
**         method only sets the selected DMA channel. The status of the
**         DMA transfer can then be checked using GetCharsInTxBuf
**         method. See the typical usage for details about
**         communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - Pointer to the block of data to send
**         Size            - Size of the block
**       * Snd             - Pointer to number of data that are sent
**                           (moved to buffer)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_DISABLED -  Device is disabled (only if
**                           output DMA is supported and enabled)
**                           ERR_TXFULL - It was not possible to send
**                           requested number of bytes
** ===================================================================
*/

byte SS1_ClearRxBuf(void);
/*
** ===================================================================
**     Method      :  SS1_ClearRxBuf (component SynchroSlave)
**
**     Description :
**         Clears the receive buffer. This method is available only if
**         a non-zero length of input buffer is defined.
**         [ Version specific information for Freescale 56800
**         derivatives ] 
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         receiver is configured to use DMA controller then this
**         method only stops the selected DMA channel.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
** ===================================================================
*/

byte SS1_ClearTxBuf(void);
/*
** ===================================================================
**     Method      :  SS1_ClearTxBuf (component SynchroSlave)
**
**     Description :
**         Clears the transmit buffer. This method is only available if
**         a non-zero length of output buffer is defined.
**         [ Version specific information for Freescale 56800
**         derivatives ] 
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         transmitter is configured to use DMA controller then this
**         method only stops the selected DMA channel.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
** ===================================================================
*/

#define SS1_GetCharsInRxBuf() (SS1_InpLen) /* Return number of chars in the receive buffer */
/*
** ===================================================================
**     Method      :  SS1_GetCharsInRxBuf (component SynchroSlave)
**
**     Description :
**         Returns the number of characters in the input buffer.
**         Note: If the Interrupt service is disabled, and the Ignore
**         empty character is set to yes, and a character has been
**         received, then this method returns 1 although it was an
**         empty character.
**         [ Version specific information for Freescale 56800
**         derivatives ] 
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         receiver is configured to use DMA controller then this
**         method returns the number of characters in the receive
**         buffer.
**     Parameters  : None
**     Returns     :
**         ---             - Number of characters in the input buffer.
** ===================================================================
*/

#define SS1_GetCharsInTxBuf() (SS1_OutLen) /* Return number of chars in the transmitter buffer */
/*
** ===================================================================
**     Method      :  SS1_GetCharsInTxBuf (component SynchroSlave)
**
**     Description :
**         Returns the number of characters in the output buffer.
**         [ Version specific information for Freescale 56800
**         derivatives ] 
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         transmitter is configured to use DMA controller then this
**         method returns the number of characters in the transmit
**         buffer.
**     Parameters  : None
**     Returns     :
**         ---             - Number of characters in the output buffer.
** ===================================================================
*/

byte SS1_GetError(SS1_TError *Err);
/*
** ===================================================================
**     Method      :  SS1_GetError (component SynchroSlave)
**
**     Description :
**         Returns a set of errors on the channel (errors that cannot
**         be returned in given methods). The component accumulates
**         errors in a set; after calling [GetError] this set is
**         returned and cleared. This method is available only if the
**         "Interrupt service/event" property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Err             - A pointer to the returned set of errors
**     Returns     :
**         ---             - Error code (if GetError did not succeed),
**                           possible codes:
**                           ERR_OK - OK
** ===================================================================
*/

void SS1_InterruptRx(void);
/*
** ===================================================================
**     Method      :  SS1_InterruptRx (component SynchroSlave)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void SS1_Init(void);
/*
** ===================================================================
**     Method      :  SS1_Init (component SynchroSlave)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/* END SS1. */

#endif /* ifndef __SS1 */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
