/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : SPI1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : SWSPI
**     Version     : Component 01.019, Driver 01.17, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 12:29, # CodeGen: 7
**     Abstract    :
**          This component implements an external SPI communication interface specialy 
**          designed for SPI compatible components. The interface uses three general-purpose 
**          I/O pins, first for the Input line, second for the Output line, third for 
**          the Serial Clock line. Is supported only Master mode with MSB first 
**          communication. 
**     Contents    :
**         RecvChar     - byte SPI1_RecvChar(byte *Chr);
**         SendChar     - byte SPI1_SendChar(byte Chr);
**         CharsInRxBuf - byte SPI1_CharsInRxBuf(word *Chr);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __SPI1
#define __SPI1

/* MODULE SPI1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/* Include inherited components */
#include "Inhr1.h"
#include "Inhr2.h"
#include "Inhr3.h"

#include "Cpu.h"


#ifndef __BWUserType_TPtrByte
#define __BWUserType_TPtrByte
  typedef byte* TPtrByte ; /* Pointer to byte */
#endif


byte SPI1_RecvChar(byte *Chr);
/*
** ===================================================================
**     Method      :  SPI1_RecvChar (component SWSPI)
**
**     Description :
**         If any data received, this method returns one character,
**         otherwise it returns an error code (it does not wait for
**         data).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - A pointer to the received character.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_RXEMPTY - No data in receiver
**                           ERR_OVERRUN - Overrun error is detected
** ===================================================================
*/

byte SPI1_SendChar(byte Chr);
/*
** ===================================================================
**     Method      :  SPI1_SendChar (component SWSPI)
**
**     Description :
**         Sends one character to the channel.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
** ===================================================================
*/

byte SPI1_CharsInRxBuf(word *Chr);
/*
** ===================================================================
**     Method      :  SPI1_CharsInRxBuf (component SWSPI)
**
**     Description :
**         Returns number of characters in the input buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - A pointer to the number of characters in
**                           the input buffer.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
** ===================================================================
*/

void SPI1_Init(void);
/*
** ===================================================================
**     Method      :  SPI1_Init (component SWSPI)
**
**     Description :
**         Initializes the associated peripheral(s) and the components 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/


/* END SPI1. */

#endif /* ifndef __SPI1 */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
