/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : WDog1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : WatchDog
**     Version     : Component 02.136, Driver 02.03, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-05-15, 19:30, # CodeGen: 11
**     Abstract    :
**         This device "WatchDog" implements a watchdog.
**         When enabled, the watchdog timer counts until it reaches
**         a critical value corresponding to the period specified
**         in 'Properties'. Then, the watchdog causes a CPU reset.
**         Applications may clear the timer before it reaches the critical
**         value. The timer then restarts the watchdog counter.
**         Watchdog is used for increasing the safety of the system
**         (unforeseeable situations can cause system crash or an
**         infinite loop - watchdog can restart the system or handle
**         the situation).
**
**         Note: Watchdog can be enabled or disabled in the initialization
**               code only. If the watchdog is once enabled user have
**               to call Clear method in defined time intervals.
**     Settings    :
**         Watchdog causes             : Reset CPU
**
**         Initial Watchdog state      : Enabled
**
**         High speed mode
**           Watchdog period/frequency
**             microseconds            : 2031616
**             milliseconds            : 2032
**             seconds                 : 2
**
**         Run register                : COP_CTRL  [E320]
**         Mode register               : COP_CTRL  [E320]
**         Prescaler register          : COP_TOUT  [E321]
**     Contents    :
**         Enable  - byte WDog1_Enable(void);
**         Disable - byte WDog1_Disable(void);
**         Clear   - byte WDog1_Clear(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE WDog1. */

#include "WDog1.h"

static bool EnUser;                    /* Enable/Disable device by user */

/*
** ===================================================================
**     Method      :  WDog1_Enable (component WatchDog)
**
**     Description :
**         Enables the component - starts the watchdog timer counting. 
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_PROTECT - This device does is protected
** ===================================================================
*/
byte WDog1_Enable(void)
{
  EnUser = TRUE;                       /* Set the flag "device enabled" */
  setRegBit(COP_CTRL,CEN);             /* Enable COP */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  WDog1_Disable (component WatchDog)
**
**     Description :
**         Disables the component - stops the watchdog timer counting.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_PROTECT - This device does is protected
** ===================================================================
*/
byte WDog1_Disable(void)
{
  EnUser = FALSE;                      /* Set the flag "device disabled" */
  clrRegBit(COP_CTRL,CEN);             /* Disable COP */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  WDog1_Clear (component WatchDog)
**
**     Description :
**         Clears the watchdog timer (it makes the timer restart from
**         zero).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - The component is disabled
** ===================================================================
*/
byte WDog1_Clear(void)
{
  if (!EnUser) {                       /* Is COP disabled? */
    return ERR_DISABLED;               /* If yes then error */
  }
  setReg(COP_CNTR,0x5555);             /* Write first key */
  setReg(COP_CNTR,0xAAAA);             /* Write second key */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  WDog1_Init (component WatchDog)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void WDog1_Init(void)
{
  /* COP_CTRL: ??=0,??=0,??=0,??=0,??=0,??=0,PSS=2,INTEN=0,CLKSEL=0,CLOREN=0,CSEN=0,CWEN=0,CEN=0,CWP=0 */
  setReg(COP_CTRL,0x0200);             /* Set up mode */
  EnUser = TRUE;                       /* Set the flag "device enabled" by user */
  setReg(COP_TOUT,0xF7FF);             /* Initial timeout value */
}

/* END WDog1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
