/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : CDC_Bridge_J8_2_3.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : AsynchroSerial
**     Version     : Component 02.507, Driver 02.07, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-05-15, 19:30, # CodeGen: 11
**     Abstract    :
**         This component "AsynchroSerial" implements an asynchronous serial
**         communication. The component supports different settings of
**         parity, word width, stop-bit and communication speed,
**         user can select interrupt or polling handler.
**         Communication speed can be changed also in runtime.
**         The component requires one on-chip asynchronous serial channel.
**     Settings    :
**         Serial channel              : QSCI0
**
**         Protocol
**             Init baud rate          : 38400baud
**             Width                   : 8 bits
**             Stop bits               : 1
**             Parity                  : none
**             Breaks                  : Disabled
**             Input buffer size       : 0
**             Output buffer size      : 0
**
**         Registers
**             Input buffer            : QSCI0_DATA [E084]
**             Output buffer           : QSCI0_DATA [E084]
**             Control register        : QSCI0_CTRL1 [E081]
**             Mode register           : QSCI0_CTRL1 [E081]
**             Baud setting reg.       : QSCI0_RATE [E080]
**
**
**
**         Used pins:
**         ----------------------------------------------------------
**           Function | On package           |    Name
**         ----------------------------------------------------------
**            Input   |     6                |  GPIOF8/RXD0/TB1/CMPD_O
**            Output  |     5                |  GPIOC2/TXD0/TB0/XB_IN2/CLKO0
**         ----------------------------------------------------------
**
**
**
**     Contents    :
**         RecvChar        - byte CDC_Bridge_J8_2_3_RecvChar(CDC_Bridge_J8_2_3_TComData *Chr);
**         SendChar        - byte CDC_Bridge_J8_2_3_SendChar(CDC_Bridge_J8_2_3_TComData Chr);
**         GetCharsInRxBuf - word CDC_Bridge_J8_2_3_GetCharsInRxBuf(void);
**         GetCharsInTxBuf - word CDC_Bridge_J8_2_3_GetCharsInTxBuf(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE CDC_Bridge_J8_2_3. */

#include "CDC_Bridge_J8_2_3.h"


#define OVERRUN_ERR      0x01U         /* Overrun error flag bit    */
#define FRAMING_ERR      0x02U         /* Framing error flag bit    */
#define PARITY_ERR       0x04U         /* Parity error flag bit     */
#define CHAR_IN_RX       0x08U         /* Char is in RX buffer      */
#define FULL_TX          0x10U         /* Full transmit buffer      */
#define RUNINT_FROM_TX   0x20U         /* Interrupt is in progress  */
#define FULL_RX          0x40U         /* Full receive buffer       */
#define NOISE_ERR        0x80U         /* Noise error flag bit      */
#define IDLE_ERR         0x0100U       /* Idle character flag bit   */
#define BREAK_ERR        0x0200U       /* Break detect              */

static word SerFlag;                   /* Flags for serial communication */
                                       /* Bits: 0 - OverRun error */
                                       /*       1 - Framing error */
                                       /*       2 - Parity error */
                                       /*       3 - Char in RX buffer */
                                       /*       4 - Full TX buffer */
                                       /*       5 - Unused */
                                       /*       6 - Full RX buffer */
                                       /*       7 - Noise error */
                                       /*       8 - Idle character  */
                                       /*       9 - Break detected  */
                                       /*      10 - Unused */
                                       /*      11 - Unused */

/*
** ===================================================================
**     Method      :  HWEnDi (component AsynchroSerial)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  setRegBits(QSCI0_CTRL1, (QSCI0_CTRL1_TE_MASK | QSCI0_CTRL1_RE_MASK)); /* Enable device */
}

/*
** ===================================================================
**     Method      :  CDC_Bridge_J8_2_3_RecvChar (component AsynchroSerial)
**
**     Description :
**         If any data is received, this method returns one character,
**         otherwise it returns an error code (it does not wait for
**         data). This method is enabled only if the receiver property
**         is enabled.
**         [Note:] Because the preferred method to handle error and
**         break exception in the interrupt mode is to use events
**         <OnError> and <OnBreak> the return value ERR_RXEMPTY has
**         higher priority than other error codes. As a consequence the
**         information about an exception in interrupt mode is returned
**         only if there is a valid character ready to be read.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         receiver is configured to use DMA controller then this
**         method only sets the selected DMA channel. Then the status
**         of the DMA transfer can be checked using GetCharsInRxBuf
**         method. See an example of a typical usage for details about
**         the communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - Pointer to a received character
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - No data in receiver
**                           ERR_BREAK - Break character is detected
**                           (only when the <Interrupt service> property
**                           is disabled and the <Break signal> property
**                           is enabled)
**                           ERR_COMMON - common error occurred (the
**                           <GetError> method can be used for error
**                           specification)
**                           Version specific information for Freescale
**                           56800 derivatives 
**                           DMA mode:
**                           If DMA controller is available on the
**                           selected CPU and the receiver is configured
**                           to use DMA controller then only ERR_OK,
**                           ERR_RXEMPTY, and ERR_SPEED error code can
**                           be returned from this method.
** ===================================================================
*/
byte CDC_Bridge_J8_2_3_RecvChar(CDC_Bridge_J8_2_3_TComData *Chr)
{
  register byte Result = ERR_OK;       /* Return error code */
  register word StatReg = getReg(QSCI0_STAT); /* Read status register */

  setReg(QSCI0_STAT, 0x00U);           /* Reset error request flags */
  if ((StatReg & (QSCI0_STAT_OR_MASK|QSCI0_STAT_NF_MASK|QSCI0_STAT_FE_MASK|QSCI0_STAT_PF_MASK)) != 0x00U) { /* Is any error set? */
    Result = ERR_COMMON;               /* If yes then set common error value */
  } else {
    if ((StatReg & QSCI0_STAT_RDRF_MASK) == 0x00U) { /* Is the reciver empty and no error is set? */
      return ERR_RXEMPTY;              /* If yes then error */
    }
  }
  *Chr = (CDC_Bridge_J8_2_3_TComData)getReg(QSCI0_DATA); /* Read data from the receiver */
  return Result;                       /* Return error code */
}

/*
** ===================================================================
**     Method      :  CDC_Bridge_J8_2_3_SendChar (component AsynchroSerial)
**
**     Description :
**         Sends one character to the channel. If the component is
**         temporarily disabled (Disable method) SendChar method only
**         stores data into an output buffer. In case of a zero output
**         buffer size, only one character can be stored. Enabling the
**         component (Enable method) starts the transmission of the
**         stored data. This method is available only if the
**         transmitter property is enabled.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         transmitter is configured to use DMA controller then this
**         method only sets selected DMA channel. Then the status of
**         the DMA transfer can be checked using GetCharsInTxBuf method.
**         See an example of a typical usage for details about
**         communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - Transmitter is full
** ===================================================================
*/
byte CDC_Bridge_J8_2_3_SendChar(CDC_Bridge_J8_2_3_TComData Chr)
{
  if ((getRegBit(QSCI0_STAT, TDRE) == 0x00U)) { /* Is the transmitter empty? */
    return ERR_TXFULL;                 /* If yes then error */
  }
  setReg(QSCI0_DATA, Chr);             /* Store char to transmitter register */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  CDC_Bridge_J8_2_3_GetCharsInRxBuf (component AsynchroSerial)
**
**     Description :
**         Returns the number of characters in the input buffer. This
**         method is available only if the receiver property is enabled.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         receiver is configured to use DMA controller then this
**         method returns the number of characters in the receive
**         buffer.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the input
**                           buffer.
** ===================================================================
*/
word CDC_Bridge_J8_2_3_GetCharsInRxBuf(void)
{
  return (word)((getRegBit(QSCI0_STAT, RDRF) != 0U)? 1 : 0); /* Return number of chars in receive buffer */
}

/*
** ===================================================================
**     Method      :  CDC_Bridge_J8_2_3_GetCharsInTxBuf (component AsynchroSerial)
**
**     Description :
**         Returns the number of characters in the output buffer. This
**         method is available only if the transmitter property is
**         enabled.
**         Version specific information for Freescale 56800 derivatives
**         DMA mode:
**         If DMA controller is available on the selected CPU and the
**         transmitter is configured to use DMA controller then this
**         method returns the number of characters in the transmit
**         buffer.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the output
**                           buffer.
** ===================================================================
*/
word CDC_Bridge_J8_2_3_GetCharsInTxBuf(void)
{
  return (word)((getRegBit(QSCI0_STAT, TDRE) == 0U)? 1 : 0); /* Return number of chars in the transmitter buffer */
}

/*
** ===================================================================
**     Method      :  CDC_Bridge_J8_2_3_Init (component AsynchroSerial)
**
**     Description :
**         Initializes the associated peripheral(s) and the bean internal 
**         variables. The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void CDC_Bridge_J8_2_3_Init(void)
{
  SerFlag = 0x00U;                     /* Reset flags */
  /* QSCI0_CTRL1: LOOP=0,SWAI=0,RSRC=0,M=0,WAKE=0,POL=0,PE=0,PT=0,TEIE=0,TIIE=0,RFIE=0,REIE=0,TE=0,RE=0,RWU=0,SBK=0 */
  setReg(QSCI0_CTRL1, 0x00U);          /* Set the SCI configuration */
  /* QSCI0_RATE: SBR=0x0145,FRAC_SBR=4 */
  setReg(QSCI0_RATE, 0x0A2CU);         /* Set prescaler bits */
  HWEnDi();                            /* Enable/disable device according to status flags */
}


/* END CDC_Bridge_J8_2_3. */


/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
