/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : PulseStrm
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 13:13, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_PulseStrm */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "PS1.h"
#include "Cap1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

void main(void)
{
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/


  TEST1_testStart(&testRec, "PulseStream test");
  TEST1_testComment(&testRec, "Please interconnect pins GPIOC3_TA0_CMPA_O_RXD0 and GPIOC4_TA1_CMPB_O.");

  
  overflow = FALSE;
  end = FALSE;
  event = 0;

  TEST1_testComment(&testRec, "bean will generate 3 pulses (10ms low, 10ms high)");
  Cap1_Enable();        /* enable measuring */
  PS1_Enable();       /* start pulse generation */
  Cpu_Delay100US(610);  /* wait 61ms */
  Cap1_Disable();   /* 3 pulses should be measured then disable capture bean */
  
  TEST1_testComment(&testRec, "test capture overflow");
  if (overflow) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "OK");
  }  
  TEST1_testComment(&testRec, "test PulseStream event OnEnd");
  if (!end) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "OK");
  }  
  event=0;
  TEST1_testComment(&testRec, "first pulse - low level (1%)");
  if ((Ticks[event] < (6250-63)) || (Ticks[event] > (6250+63))) {   /* 10ms */
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  
  event++;
  TEST1_testComment(&testRec, "first pulse - high level (1%)");
  if ((Ticks[event] < (12500-125)) || (Ticks[event] > (12500+125))) {   /* 20ms */
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  
  event++;
  TEST1_testComment(&testRec, "second pulse - low level (1%)");
  if ((Ticks[event] < (18750-188)) || (Ticks[event] > (18750+188))) { /* 30ms */
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  
  event++;
  TEST1_testComment(&testRec, "second pulse - high level (1%)");
  if ((Ticks[event] < (25000-250)) || (Ticks[event] > (25000+250))) { /* 40ms */
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  
  event++;
  TEST1_testComment(&testRec, "third pulse - low level (1%)");
  if ((Ticks[event] < (31217-312)) || (Ticks[event] > (31217+312))) { /* 50ms */
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  
  event++;
  TEST1_testComment(&testRec, "third pulse - high level (1%)");
  if ((Ticks[event] < (37500-375)) || (Ticks[event] > (37500+375))) { /* 60ms */
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  

  TEST1_testEnd(&testRec);

}


/* END demo_PulseStrm */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
