/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Cap1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : Capture
**     Version     : Component 02.216, Driver 02.05, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 12:23, # CodeGen: 7
**     Abstract    :
**         This component "Capture" simply implements the capture function
**         of timer. The counter counts the same way as in free run mode. On
**         the selected edge of the input signal (on the input pin), the current
**         content of the counter register is written into the capture
**         register and the OnCapture event is called.
**     Driver      :
**         It is recommended to use method GetCaptureValue in event OnCapture.
**         Content of the capture register is protected from update only
**         to end of event Cap1_OnCapture.
**     Settings    :
**             Timer capture encapsulation : Capture
**
**         Timer
**             Timer                   : TMRA1
**             Counter shared          : No
**
**         High speed mode
**             Prescaler               : divide-by-128
**           Maximal time for capture register
**             Xtal ticks              : 671089
**             microseconds            : 83886
**             milliseconds            : 84
**             seconds (real)          : 0.08388608
**             Hz                      : 12
**           One tick of timer is
**             microseconds            : 1.28
**
**         Initialization:
**              Timer                  : Disabled
**              Events                 : Enabled
**
**         Timer registers
**              Capture                : TMRA_1_CAPT [E152]
**              Counter                : TMRA_1_CNTR [E155]
**              Mode                   : TMRA_1_CTRL [E156]
**              Run                    : TMRA_1_CTRL [E156]
**              Prescaler              : TMRA_1_CTRL [E156]
**
**         Used input pin              : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       12            |  GPIOC4/TA1/CMPB_O/XB_IN8/EWM_OUT_B
**             ----------------------------------------------------
**
**         Port name                   : GPIOC_Low
**         Bit number (in port)        : 4
**         Bit mask of the port        : 0010
**
**         Signal edge/level           : both
**         Priority                    : 1
**         Pull option                 : off
**
**     Contents    :
**         Enable          - byte Cap1_Enable(void);
**         Disable         - byte Cap1_Disable(void);
**         Reset           - byte Cap1_Reset(void);
**         GetCaptureValue - byte Cap1_GetCaptureValue(Cap1_TCapturedValue *Value);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Cap1. */

#include "Events.h"
#include "Cap1.h"

static bool EnUser;                    /* Enable/Disable device by user */

/* Internal method prototypes */
static void HWEnDi(void);

/*
** ===================================================================
**     Method      :  Cap1_HWEnDi (component Capture)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  if (EnUser) {                        /* Enable device? */
    setRegBitGroup(TMRA_1_CTRL,CM,0x01); /* Run counter */
    setRegBitGroup(TMRA_1_SCTRL,CAPTURE_MODE,0x03); /* Enable capture */
  }
  else {                               /* Disable device? */
    setRegBitGroup(TMRA_1_SCTRL,CAPTURE_MODE,0x00); /* Disable capture */
    setRegBitGroup(TMRA_1_CTRL,CM,0x00); /* Stop counter */
  }
}

/*
** ===================================================================
**     Method      :  Cap1_Enable (component Capture)
**
**     Description :
**         This method enables the component - it starts the capture. Events
**         may be generated (<DisableEvent>/<EnableEvent>).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap1_Enable(void)
{
  if (!EnUser) {                       /* Is the device disabled by user? */
    EnUser = TRUE;                     /* If yes then set the flag "device enabled" */
    HWEnDi();                          /* Enable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap1_Disable (component Capture)
**
**     Description :
**         This method disables the component - it stops the capture. No
**         events will be generated.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap1_Disable(void)
{
  if (EnUser) {                        /* Is the device enabled by user? */
    EnUser = FALSE;                    /* If yes then set the flag "device disabled" */
    HWEnDi();                          /* Disable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap1_Reset (component Capture)
**
**     Description :
**         This method resets the counter register (see implementation
**         note in <General Info>).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap1_Reset(void)
{
  setReg(TMRA_1_CNTR,0x00);            /* Reset counter register */
  clrRegBit(TMRA_1_SCTRL,IEF);         /* Clear input edge flag - enable updating of capture register */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap1_GetCaptureValue (component Capture)
**
**     Description :
**         This method gets the last value captured by enabled timer.
**         Note: one tick of timer is
**               1.28 us in high speed mode
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Value           - A pointer to the content of the
**                           capture register
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap1_GetCaptureValue(Cap1_TCapturedValue *Value)
{
  *Value = getReg(TMRA_1_CAPT);        /* Return captured value of counter register */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap1_Init (component Capture)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void Cap1_Init(void)
{
  /* TMRA_1_CTRL: CM=0,PCS=0,SCS=1,ONCE=0,LENGTH=0,DIR=0,COINIT=0,OUTMODE=0 */
  setReg(TMRA_1_CTRL,0x80);            /* Set up mode */
  /* TMRA_1_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=1,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMRA_1_SCTRL,0x0400);
  setReg(TMRA_1_CNTR,0x00);            /* Reset counter register */
  setReg(TMRA_1_LOAD,0x00);            /* Reset load register */
  setReg(TMRA_1_CAPT,0x00);            /* Reset capture register */
  /* TMRA_1_FILT: ??=0,??=0,??=0,??=0,??=0,FILT_CNT=0,FILT_PER=0 */
  setReg(TMRA_1_FILT,0x00);            /* Set up input filter register */
  EnUser = FALSE;                      /* Disable device */
  setRegBitGroup(TMRA_1_CTRL,PCS,0x0F); /* Set prescaler register according to the selected high speed CPU mode */
  HWEnDi();                            /* Enable/disable device according to status flags */
}

/*
** ===================================================================
**     Method      :  Cap1_Interrupt (component Capture)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void Cap1_Interrupt(void)
{
  Cap1_OnCapture();                    /* Invoke user event */
  clrRegBit(TMRA_1_SCTRL,IEF);         /* Reset interrupt request flag and enable updating of the capture register */
}

/* END Cap1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
