/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : PWM1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : PWM
**     Version     : Component 02.233, Driver 02.05, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 12:26, # CodeGen: 12
**     Abstract    :
**         This component implements a pulse-width modulation generator
**         that generates signal with variable duty and fixed cycle. 
**     Settings    :
**         Used output pin             : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       11            |  GPIOC3/TA0/CMPA_O/RXD0/CLKIN1
**             ----------------------------------------------------
**
**         Timer name                  : TMRA0 [16-bit]
**         Counter                     : TMRA_0_CNTR [E145]
**         Mode register               : TMRA_0_CTRL [E146]
**         Run register                : TMRA_0_CTRL [E146]
**         Prescaler                   : TMRA_0_CTRL [E146]
**         Compare register            : TMRA_0_COMP1 [E140]
**         Flip-flop register          : TMRA_0_SCTRL [E147]
**
**         Interrupt name              : INT_TMRA_0
**         Interrupt enable reg.       : TMRA_0_SCTRL [E147]
**         Priority                    : 1
**         User handling procedure     : PWM1_OnEnd
**         This event is called when the 3 of cycles is generated
**
**         Port name                   : GPIOC_Low
**         Bit number (in port)        : 3
**         Bit mask of the port        : 0008
**         Port data register          : GPIOC_DR  [E221]
**         Port control register       : GPIOC_DDR [E222]
**         Port function register      : GPIOC_PER [E223]
**
**         Initialization:
**              Output level           : low
**              Timer                  : Disabled
**              Event                  : Enabled
**         High speed mode
**             Prescaler               : divide-by-32
**             Clock                   : 3125000 Hz
**           Initial value of            period     pulse width
**             Xtal ticks              : 167772     24000
**             microseconds            : 20972      3000
**             milliseconds            : 21         3
**             seconds (real)          : 0.02097152 0.003
**
**     Contents    :
**         Enable  - byte PWM1_Enable(void);
**         Disable - byte PWM1_Disable(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/


/* MODULE PWM1. */

#include "Events.h"
#include "PWM1.h"

static bool EnUser;                    /* Enable/Disable device by user */
static byte Cnt;                       /* Number of period */

/* Internal method prototypes */
static void HWEnDi(void);

#define SetPV(Val) setRegBitGroup(TMRA_0_CTRL,PCS,(Val))

/*
** ===================================================================
**     Method      :  HWEnDi (component PWM)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  if (EnUser) {                        /* Enable device? */
    setRegBit(TMRA_0_CTRL,CM0);        /* Run counter */
  }
  else {                               /* Disable device? */
    clrRegBit(TMRA_0_CTRL,CM0);        /* Stop counter */
    setRegBit(TMRA_0_SCTRL,FORCE);     /* Force output signal level */
    setReg(TMRA_0_CNTR,0);             /* Reset counter */
  }
}

/*
** ===================================================================
**     Method      :  PWM1_Enable (component PWM)
**
**     Description :
**         This method enables the component - it starts the signal
**         generation. Events may be generated (<DisableEvent>
**         /<EnableEvent>).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte PWM1_Enable(void)
{
  if (!EnUser) {                       /* Is the device disabled by user? */
    EnUser = TRUE;                     /* If yes then set the flag "device enabled" */
    HWEnDi();                          /* Enable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  PWM1_Disable (component PWM)
**
**     Description :
**         This method disables the component - it stops the signal
**         generation and events calling. When the timer is disabled,
**         it is possible to call <ClrValue> and <SetValue> methods.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte PWM1_Disable(void)
{
  if (EnUser) {                        /* Is the device enabled by user? */
    EnUser = FALSE;                    /* If yes then set the flag "device disabled" */
    HWEnDi();                          /* Disable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  PWM1_Interrupt (component PWM)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void PWM1_Interrupt(void)
{
  clrRegBit(TMRA_0_SCTRL,TOF);         /* Reset interrupt request flag */
  Cnt++;                               /* Increment number of period */
  if (Cnt == 0x03U) {                  /* Is it now the event time? */
    Cnt = 0U;                          /* Reset counter */
    PWM1_OnEnd();                      /* Invoke user event */
  }
}

/*
** ===================================================================
**     Method      :  PWM1_Init (component PWM)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PWM1_Init(void)
{
  Cnt = 0;                             /* Number of period */
  setReg(TMRA_0_CNTR,0);               /* Reset counter */
  /* TMRA_0_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=1,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=1,OPS=0,OEN=1 */
  setReg(TMRA_0_SCTRL,0x1005);         /* Enable output */
  EnUser = FALSE;                      /* Disable device */
  setReg(TMRA_0_COMP1,0x249E);         /* Store initial value to the duty-compare register */
  SetPV((byte)0x0D);                   /* Set prescaler register according to the selected high speed CPU mode */
  /* TMRA_0_CTRL: CM=0,PCS=8,SCS=0,ONCE=0,LENGTH=0,DIR=0,COINIT=0,OUTMODE=6 */
  setRegBits(TMRA_0_CTRL,0x1006);      /* Set fixed PWM mode and stop counter */
}

/* END PWM1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
