/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : MC2.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : MC_Ramp
**     Version     : Component 01.009, Driver 01.03, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-27, 15:13, # CodeGen: 2
**     Abstract    :
**          The Ramp Generation Algorithm generates the acceleration ramp.
**          The RampGetValue function computes the next value of acceleration
**          ramp related to the current acceleration ramp direction.
**     Settings    :
**          This bean has no settings.
**     Contents    :
**         rampGetValue - Frac16 MC2_rampGetValue(Frac16 incrementUp, Frac16 incrementDown, Frac16...
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __MC2
#define __MC2

/* MODULE MC2. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/* Include inherited beans */
#include "port.h"

#include "Cpu.h"




#define rampGetValue(incrementUp, incrementDown, p_actualValue, p_requestedValue) MC2_rampGetValue(incrementUp, incrementDown, p_actualValue, p_requestedValue)
Frac16 MC2_rampGetValue(Frac16 incrementUp,Frac16 incrementDown,Frac16 *p_actualValue,Frac16 *p_requestedValue);
/*
** ===================================================================
**     Method      :  MC2_rampGetValue (component MC_Ramp)
**
**     Description :
**         The function performs a linear Ramp generation determined by
**         input parameters.
**     Parameters  :
**         NAME            - DESCRIPTION
**         incrementUp     - Increment up.
**         incrementDown   - Increment down.
**       * p_actualValue   - Pointer to variable
**                           containing actualValue.
**       * p_requestedValue - Pointer to
**                           variable containing requestedValue.
**     Returns     :
**         ---             - If the requestedValue is greater than
**                           actualValue, the rampGetValue function
**                           returns actualValue + incrementUp until the
**                           maximum is reached, (maximum is
**                           requestedValue), at which point it will
**                           return requestedValue. If the
**                           requestedValue is less than actualValue,
**                           the rampGetValue function returns
**                           actualValue - incrementDown until the
**                           minimum is reached, (minimum is
**                           requestedValue), at which point it will
**                           return requestedValue.
** ===================================================================
*/

/* END MC2. */

#endif /* ifndef __MC2 */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
