/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : TO1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : TimerOut
**     Version     : Component 03.023, Driver 02.05, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 12:01, # CodeGen: 10
**     Abstract    :
**         This component implements a periodic signal generator 1:1 (Flip-Flop Output).
**         The signal alternates the "0" and "1" output values in exactly
**         regular intervals; that is why the time length of the "0" part
**         of one pulse is equal to the "1" part of one pulse.
**     Settings    :
**         Used output pin             : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       11            |  GPIOC3/TA0/CMPA_O/RXD0/CLKIN1
**             ----------------------------------------------------
**
**         Timer name                  : TMRA0 (16-bit)
**         Compare name                : TMRA0_Compare
**           Counter shared            : No
**
**         High speed mode
**             Prescaler               : divide-by-8
**             Clock                   : 12500000 Hz
**           Pulse width
**             Xtal ticks              : 40000
**             microseconds            : 5000
**             milliseconds            : 5
**             seconds (real)          : 0.005
**             Hz                      : 200
**
**         Runtime setting             : none
**
**         Initialization:
**              Output level           : low
**              Timer                  : Enabled
**              Events                 : Enabled
**
**         Timer registers
**              Counter                : TMRA_0_CNTR [E145]
**              Mode                   : TMRA_0_CTRL [E146]
**              Run                    : TMRA_0_CTRL [E146]
**              Prescaler              : TMRA_0_CTRL [E146]
**
**         Compare registers
**              Compare                : TMRA_0_COMP1 [E140]
**
**         Flip-flop registers
**              Mode                   : TMRA_0_SCTRL [E147]
**     Contents    :
**         No public methods
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE TO1. */

#include "TO1.h"



/* Internal method prototypes */
static void SetCV(word Val);
static void SetPV(byte Val);

/*
** ===================================================================
**     Method      :  SetCV (component TimerOut)
**
**     Description :
**         Sets compare or preload register value. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetCV(word Val)
{
  EnterCritical();                     /* Disable global interrupts */
  setReg(TMRA_0_CMPLD1,Val);           /* Store given value to the compare preload register */
  setReg(TMRA_0_CMPLD2,Val);
  ExitCritical();                      /* Enable global interrupts */
}

/*
** ===================================================================
**     Method      :  SetPV (component TimerOut)
**
**     Description :
**         Sets prescaler value. The method is called automatically as a 
**         part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  setRegBitGroup(TMRA_0_CTRL,PCS,Val); /* Store given value to the prescaler */
  setReg(TMRA_0_CNTR,0);               /* Reset counter */
}

/*
** ===================================================================
**     Method      :  TO1_Init (component TimerOut)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void TO1_Init(void)
{
  /* TMRA_0_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=1,DIR=0,COINIT=0,OUTMODE=4 */
  setReg(TMRA_0_CTRL,0x24);            /* Set up mode */
  /* TMRA_0_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=1 */
  setReg(TMRA_0_SCTRL,0x01);
  setReg(TMRA_0_CNTR,0x00);            /* Reset counter register */
  setReg(TMRA_0_LOAD,0x00);            /* Reset load register */
  setReg(TMRA_0_COMP1,0xF423);         /* Set up compare 1 register */
  setReg(TMRA_0_COMP2,0xF423);         /* Set up compare 2 register */
  /* TMRA_0_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,ROC=0,TCI=0,UP=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=1,CL1=2 */
  setReg(TMRA_0_CSCTRL,0x06);          /* Set up comparator control register */
  SetCV((word)0xF423);                 /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV((byte)0x0B);                   /* Set prescaler register according to the selected high speed CPU mode */
  setRegBitGroup(TMRA_0_CTRL,CM,0x01); /* Run counter */
}

/* END TO1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
