/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Cap1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : Capture
**     Version     : Component 02.216, Driver 02.05, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:54, # CodeGen: 46
**     Abstract    :
**         This component "Capture" simply implements the capture function
**         of timer. The counter counts the same way as in free run mode. On
**         the selected edge of the input signal (on the input pin), the current
**         content of the counter register is written into the capture
**         register and the OnCapture event is called.
**     Driver      :
**         It is recommended to use method GetCaptureValue in event OnCapture.
**         Content of the capture register is protected from update only
**         to end of event Cap1_OnCapture.
**     Settings    :
**             Timer capture encapsulation : Capture
**
**         Timer
**             Timer                   : TMRA0
**             Counter shared          : No
**
**         High speed mode
**             Prescaler               : divide-by-8
**           Maximal time for capture register
**             Xtal ticks              : 41943
**             microseconds            : 5243
**             milliseconds            : 5
**             seconds (real)          : 0.00524288
**             Hz                      : 191
**           One tick of timer is
**             nanoseconds             : 83.333333333333
**
**         Initialization:
**              Timer                  : Enabled
**              Events                 : Enabled
**
**         Timer registers
**              Capture                : TMRA_0_CAPT [E142]
**              Counter                : TMRA_0_CNTR [E145]
**              Mode                   : TMRA_0_CTRL [E146]
**              Run                    : TMRA_0_CTRL [E146]
**              Prescaler              : TMRA_0_CTRL [E146]
**
**         Used input pin              : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       77            |  GPIOF1/CLKO1/XB_IN7/CMPD_O
**             ----------------------------------------------------
**
**         Port name                   : GPIOF_Low
**         Bit number (in port)        : 1
**         Bit mask of the port        : 0002
**
**         Signal edge/level           : both
**         Priority                    : 1
**         Pull option                 : off
**
**     Contents    :
**         Enable          - byte Cap1_Enable(void);
**         Disable         - byte Cap1_Disable(void);
**         EnableEvent     - byte Cap1_EnableEvent(void);
**         DisableEvent    - byte Cap1_DisableEvent(void);
**         Reset           - byte Cap1_Reset(void);
**         GetCaptureValue - byte Cap1_GetCaptureValue(Cap1_TCapturedValue *Value);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Cap1. */

#include "Events.h"
#include "Cap1.h"

static bool EnUser;                    /* Enable/Disable device by user */
static bool EnEvent;                   /* Enable/Disable events */

/* Internal method prototypes */
static void HWEnDi(void);

/*
** ===================================================================
**     Method      :  Cap1_HWEnDi (component Capture)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  if (EnUser) {                        /* Enable device? */
    setRegBitGroup(TMRA_0_CTRL,CM,0x01); /* Run counter */
    setRegBitGroup(TMRA_0_SCTRL,CAPTURE_MODE,0x03); /* Enable capture */
  }
  else {                               /* Disable device? */
    setRegBitGroup(TMRA_0_SCTRL,CAPTURE_MODE,0x00); /* Disable capture */
    setRegBitGroup(TMRA_0_CTRL,CM,0x00); /* Stop counter */
  }
}

/*
** ===================================================================
**     Method      :  Cap1_Enable (component Capture)
**
**     Description :
**         This method enables the component - it starts the capture. Events
**         may be generated (<DisableEvent>/<EnableEvent>).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap1_Enable(void)
{
  if (!EnUser) {                       /* Is the device disabled by user? */
    EnUser = TRUE;                     /* If yes then set the flag "device enabled" */
    HWEnDi();                          /* Enable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap1_Disable (component Capture)
**
**     Description :
**         This method disables the component - it stops the capture. No
**         events will be generated.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap1_Disable(void)
{
  if (EnUser) {                        /* Is the device enabled by user? */
    EnUser = FALSE;                    /* If yes then set the flag "device disabled" */
    HWEnDi();                          /* Disable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap1_EnableEvent (component Capture)
**
**     Description :
**         This method enables the events. This method is available
**         only if any event is selected.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap1_EnableEvent(void)
{
  EnEvent = TRUE;                      /* Set the flag "events enabled" */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap1_DisableEvent (component Capture)
**
**     Description :
**         This method disables the events.  This method is available
**         only if any event is selected.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap1_DisableEvent(void)
{
  EnEvent = FALSE;                     /* Set the flag "events disabled" */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap1_Reset (component Capture)
**
**     Description :
**         This method resets the counter register (see implementation
**         note in <General Info>).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap1_Reset(void)
{
  setReg(TMRA_0_CNTR,0x00);            /* Reset counter register */
  clrRegBit(TMRA_0_SCTRL,IEF);         /* Clear input edge flag - enable updating of capture register */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap1_GetCaptureValue (component Capture)
**
**     Description :
**         This method gets the last value captured by enabled timer.
**         Note: one tick of timer is
**               83.333333333333 ns in high speed mode
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Value           - A pointer to the content of the
**                           capture register
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Cap1_GetCaptureValue(Cap1_TCapturedValue *Value)
{
  *Value = getReg(TMRA_0_CAPT);        /* Return captured value of counter register */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Cap1_Init (component Capture)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void Cap1_Init(void)
{
  /* TMRA_0_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=0,DIR=0,COINIT=0,OUTMODE=0 */
  setReg(TMRA_0_CTRL,0x00);            /* Set up mode */
  /* TMRA_0_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=1,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMRA_0_SCTRL,0x0400);
  setReg(TMRA_0_CNTR,0x00);            /* Reset counter register */
  setReg(TMRA_0_LOAD,0x00);            /* Reset load register */
  setReg(TMRA_0_CAPT,0x00);            /* Reset capture register */
  /* TMRA_0_FILT: ??=0,??=0,??=0,??=0,??=0,FILT_CNT=0,FILT_PER=0 */
  setReg(TMRA_0_FILT,0x00);            /* Set up input filter register */
  EnEvent = TRUE;                      /* Enable events */
  EnUser = TRUE;                       /* Enable device */
  setRegBitGroup(TMRA_0_CTRL,PCS,0x0B); /* Set prescaler register according to the selected high speed CPU mode */
  HWEnDi();                            /* Enable/disable device according to status flags */
}

/*
** ===================================================================
**     Method      :  Cap1_Interrupt (component Capture)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void Cap1_Interrupt(void)
{
  if (EnEvent) {                       /* Are the events enabled? */
    Cap1_OnCapture();                  /* Invoke user event */
  }
  clrRegBit(TMRA_0_SCTRL,IEF);         /* Reset interrupt request flag and enable updating of the capture register */
}

/* END Cap1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
