/* DEVICES=ENC */
#if (CPUtype == _MC56F84441VLF) || (CPUtype == _MC56F84442VLH) || (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
/*
** #################################################################################################################
**     THIS MODULE IS A PART OF PROCESSOR EXPERT SYSTEM LIBRARY.
**
**     Filename  : DECODER.H
**
**     Family    : Freescale DSP
**
**     Compiler  : Freescale DSP C Compiler
**
**     Abstract  :
**
**         This PESL module implements a DECODER.
**
**         Implemented devices:
**
**           ENC - Quadrature Encoder/Decoder
**
**         Supported CPUs:
**           MC56F84441VLF,MC56F84442VLH,MC56F84451VLF,MC56F84452VLH,MC56F84462VLH,MC56F84565VLK,MC56F84567VLL,MC56F84585VLK,MC56F84587VLL,MC56F84766VLK,MC56F84769VLL,MC56F84786VLK,MC56F84789VLL
**
**     (c) Freescale Semiconductor
**     2012 All Rights Reserved
**
**     http      : www.freescale.com
**
** #################################################################################################################
*/

#ifndef __PE_peslDECODER
#define __PE_peslDECODER

#include "PE_Types.h"
#include "periph.h"
#include "PESL.h" /* here is constant CPUtype */

/***************************************************************************************************************
* DECODER module identifiers                                                                                **
***************************************************************************************************************/
#if (CPUtype == _MC56F84441VLF) || (CPUtype == _MC56F84442VLH) || (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define ENC ArchIO.enc
#endif

/* DECODER module identifiers - backward compatibility */


/***************************************************************************************************************
** METHODS OVERVIEW                                                                                           **
****************************************************************************************************************
**       METHOD                      DESCRIPTION                     PARAMETERS              RESULT           **
***************************************************************************************************************/
#define DEC_CLEAR_HOME_INT_REQUEST      /* Clear HOME Signal Transition Interrupt Request NULL    NULL         */
#define DEC_HOME_INT                    /* Enable/Disable HOME Interrupt DEC_ENABLE,DEC_DISABLE   NULL         */
#define DEC_HOME_TRIGGERED_INIT         /* Enable HOME to Initialize Position Counters UPOS and LPOS DEC_ENABLE,DEC_DISABLE NULL */
#define DEC_HOME_EDGE                   /* Use Negative or Positive Edge of HOME Input DEC_NEGATIVE,DEC_POSITIVE NULL */
#define DEC_SOFTWARE_TRIGGERED_INIT     /* Set Software Triggered Initialization of Position Counters UPOS and LPOS NULL NULL */
#define DEC_DIRECTION_COUNTING_ENABLE   /* Enable Reverse Direction Counting or Count Normally DEC_REVERSE,DEC_NORMAL NULL */
#define DEC_SINGLE_PHASE_COUNT          /* Enable/Disable Signal Phase Count Mode DEC_ENABLE,DEC_DISABLE NULL  */
#define DEC_CLEAR_INDEX_PULSE_INT_REQUEST /* Clear Index Pulse Interrupt Request NULL             NULL         */
#define DEC_INDEX_PULSE_INT             /* Enable/Disable Index Pulse Interrupt DEC_ENABLE,DEC_DISABLE NULL    */
#define DEC_INDEX_TRIGGERED_INIT        /* Set Index Triggered Initialization of Position Counters UPOS and LPOS DEC_ENABLE,DEC_DISABLE NULL */
#define DEC_INDEX_EDGE                  /* Use Negative or Posotive Edge of Index Pulse DEC_NEGATIVE,DEC_POSITIVE NULL */
#define DEC_CLEAR_WATCHDOG_INT_REQUEST  /* Clear Watchdog Timeout Interrupt Request NULL          NULL         */
#define DEC_WATCHDOG_INT                /* Enable/Disable Watchdog Timeout Interrupt DEC_ENABLE,DEC_DISABLE NULL */
#define DEC_WATCHDOG                    /* Enable/Disable Watchdog       DEC_ENABLE,DEC_DISABLE   NULL         */
#define DEC_INT_ENABLE                  /* Enable Selected Interrupts    DEC_HOME,DEC_INDEX,DEC_WDTIMEOUT,DEC_COMPARE,DEC_ROLLUNDER,DEC_ROLLOVER NULL */
#define DEC_INT_DISABLE                 /* Disable Selected Interrupts   DEC_HOME,DEC_INDEX,DEC_WDTIMEOUT,DEC_COMPARE,DEC_ROLLUNDER,DEC_ROLLOVER NULL */
#define DEC_INT_REQUEST_CLEAR           /* Clear Selected Interrupt Requests DEC_HOME,DEC_INDEX,DEC_WDTIMEOUT NULL */
#define DEC_READ_CONTROL_REG            /* Read Decoder control register NULL                     word         */
#define DEC_WRITE_WATCHDOG_TIMEOUT      /* Set Watchdog time-out register Word - UWord16          NULL         */
#define DEC_READ_POSITION_DIFFERENCE    /* Read Position difference counter register NULL         UWord16      */
#define DEC_READ_REVOLUTION             /* Read Revolution counter register NULL                  UWord16      */
#define DEC_WRITE_REVOLUTION            /* Set Revolution counter register Word - UWord16         NULL         */
#define DEC_READ_POSITION               /* Read the 32-bit position counter Pointer - pointer to decoder_uReg32bit NULL */
#define DEC_WRITE_POSITION              /* Write the 32-bit position counter via the initialization UWord32 - UWord32 NULL */
#define DEC_WRITE_INIT_STATE            /* Set the 32-bit position initialization register UWord32 - 32bit value NULL */
#define DEC_READ_MONITOR_REG            /* Read Input monitor register   NULL                     word         */
#define DEC_GET_RAW_ENCSIGNALS          /* Get Raw Signals               NULL                     word         */
#define DEC_GET_FILTERED_ENCSIGNALS     /* Get Filtered Signals          NULL                     word         */
#define DEC_READ_HOLD_DATA_REGS         /* Read Data Registers           Pointer - decoder_sState NULL         */
#define DEC_CALCULATE_SCALE_COEF        /* Read Data Registers           Word - decoder_sEncScale NULL         */
#define DEC_GET_SCALED_POSITION         /* Get scaled position           Word - decoder_sEncScale word         */
#define DEC_GET_SCALED_POSITION_DIFFERENCE /* Get scaled position        Word - decoder_sEncScale word         */
#define DEC_CLEAR_COMPARE_INT_REQUEST   /* Clear Compare Interrupt Request NULL                   NULL         */
#define DEC_COMPARE_INT                 /* Enable/Disable Compare Interrupt DEC_ENABLE,DEC_DISABLE NULL        */
#define DEC_WRITE_FILTER_PERIOD         /* Write Input Filter Sample Period Byte - Sampling period (in IPBus clock cycles) of the decoder input signals NULL */
#define DEC_WRITE_FILTER_COUNT          /* Write Input Filter Sample Count DEC_COUNT_3,DEC_COUNT_4,DEC_COUNT_5,DEC_COUNT_6,DEC_COUNT_7,DEC_COUNT_8,DEC_COUNT_9,DEC_COUNT_10 NULL */
#define DEC_WRITE_TEST_REG              /* Write Test Register           Word - UWord16           NULL         */
#define DEC_READ_TEST_REG               /* Read Test Register            NULL                     UWord16      */
#define DEC_WRITE_CONTROL2_REG          /* Write Control 2 Register      Word - UWord16           NULL         */
#define DEC_READ_CONTROL2_REG           /* Read Control 2 Register       NULL                     UWord16      */
#define DEC_WRITE_MODULUS_REG           /* Write Modulus Registers       UWord32 - UWord32        NULL         */
#define DEC_READ_MODULUS_REG            /* Read Modulus Registers        NULL                     UWord32      */
#define DEC_WRITE_POSITION_COMPARE_REG  /* Write Position Compare Registers UWord32 - UWord32     NULL         */
#define DEC_READ_POSITION_COMPARE_REG   /* Read Position Compare Register NULL                    UWord32      */
#define DEC_READ_FILTER_REG             /* Read Input Filter Register    NULL                     word         */
#define DEC_READ_WATCHDOG_TIMEOUT_REG   /* Read Watchdog Timeout Register NULL                    word         */
#define DEC_READ_UPPER_INIT_REG         /* Read Upper Initialization Register NULL                word         */
#define DEC_READ_LOWER_INIT_REG         /* Read Lower Initialization Register NULL                word         */
#define DEC_READ_UPPER_MODULUS_REG      /* Read Upper Modulus Register   NULL                     word         */
#define DEC_READ_LOWER_MODULUS_REG      /* Read Lower Modulus Register   NULL                     word         */
#define DEC_READ_UPPER_POSITION_COMPARE_REG /* Read Upper Position Compare Register NULL          word         */
#define DEC_READ_LOWER_POSITION_COMPARE_REG /* Read Lower Position Compare Register NULL          word         */
#define DEC_WRITE_FILTER_REG            /* Write Input Filter Register   Word - Value 0 - 65535   NULL         */
#define DEC_WRITE_WATCHDOG_TIMEOUT_REG  /* Write Watchdog Timeout Register Word - Value 0 - 65535 NULL         */
#define DEC_WRITE_POSITION_DIFFERENCE_REG /* Write Position Difference Counter Register Word - Value 0 - 65535 NULL */
#define DEC_WRITE_UPPER_POSITION_REG    /* Write Upper Position Counter Register Word - Value 0 - 65535 NULL   */
#define DEC_WRITE_LOWER_POSITION_REG    /* Write Lower Position Counter Register Word - Value 0 - 65535 NULL   */
#define DEC_WRITE_UPPER_INIT_REG        /* Write Upper Initialization Register Word - Value 0 - 65535 NULL     */
#define DEC_WRITE_LOWER_INIT_REG        /* Write Lower Initialization Register Word - Value 0 - 65535 NULL     */
#define DEC_WRITE_MONITOR_REG           /* Write Input Monitor Register  Word - Value 0 - 65535   NULL         */
#define DEC_WRITE_UPPER_MODULUS_REG     /* Write Upper Modulus Register  Word - Value 0 - 65535   NULL         */
#define DEC_WRITE_LOWER_MODULUS_REG     /* Write Lower Modulus Register  Word - Value 0 - 65535   NULL         */
#define DEC_WRITE_UPPER_POSITION_COMPARE_REG /* Write Upper Position Compare Register Word - Value 0 - 65535 NULL */
#define DEC_WRITE_LOWER_POSITION_COMPARE_REG /* Write Lower Position Compare Register Word - Value 0 - 65535 NULL */
#define DEC_READ_POSITION_DIFFERENCE_REG /* Read Position Difference Counter Register NULL        word         */
#define DEC_READ_REVOLUTION_REG         /* Read Revolution Counter Register NULL                  word         */
#define DEC_READ_UPPER_POSITION_REG     /* Read Upper Position Counter Register NULL              word         */
#define DEC_READ_LOWER_POSITION_REG     /* Read Lower Position Counter Register NULL              word         */
#define DEC_WRITE_CONTROL_REG           /* Write Control Register        Word - Value 0 - 65535   NULL         */
#define DEC_WRITE_REVOLUTION_REG        /* Write Revolution Counter Register Word - Value 0 - 65535 NULL       */
#define DEC_CLEAR_ROLLOVER_INT_REQUEST  /* Clear Roll-over Interrupt Request NULL                 NULL         */
#define DEC_CLEAR_ROLLUNDER_INT_REQUEST /* Clear Roll-under Interrupt Request NULL                NULL         */
#define DEC_READ_POSITION_DIFFERENCE_HOLD_REG /* Read Position Difference Hold Register NULL      word         */
#define DEC_READ_REVOLUTION_HOLD_REG    /* Read Revolution Hold Register NULL                     word         */
#define DEC_READ_UPPER_POSITION_HOLD_REG /* Read Upper Position Hold Register NULL                word         */
#define DEC_READ_LOWER_POSITION_HOLD_REG /* Read Lower Position Hold Register NULL                word         */

/***********************************************************************************************************
** DECODER PARAMETERS DEFINITION                                                                        **
***********************************************************************************************************/
#define DEC_ENABLE                                0x01
#define DEC_DISABLE                               0x00
#define DEC_NEGATIVE                              0x01
#define DEC_POSITIVE                              0x00
#define DEC_REVERSE                               0x01
#define DEC_NORMAL                                0x00
#define DEC_HOME                                  DECODER_CTRL_HIE
#define DEC_INDEX                                 DECODER_CTRL_XIE
#define DEC_WDTIMEOUT                             DECODER_CTRL_DIE
#define DEC_COMPARE                               DECODER_CTRL_CMPIE
#define DEC_ROLLUNDER                             (UWord32)(ENC_CTRL2 ## _RUIE_MASK << 16)
#define DEC_ROLLOVER                              (UWord32)(ENC_CTRL2 ## _ROIE_MASK << 16)
#define DEC_COUNT_3                               0x0000
#define DEC_COUNT_4                               0x0001
#define DEC_COUNT_5                               0x0002
#define DEC_COUNT_6                               0x0003
#define DEC_COUNT_7                               0x0004
#define DEC_COUNT_8                               0x0005
#define DEC_COUNT_9                               0x0006
#define DEC_COUNT_10                              0x0007

/***********************************************************************************************************
** DECODER REGISTER BIT MASKS DEFINITION                                                                **
***********************************************************************************************************/
/* Masks for registers CTRL */
#define DECODER_CTRL_MASK                              0xFFFF 
#define DECODER_CTRL_HIRQ                              0x8000
#define DECODER_CTRL_HIE                               0x4000
#define DECODER_CTRL_HIP                               0x2000
#define DECODER_CTRL_HNE                               0x1000
#define DECODER_CTRL_SWIP                              0x0800
#define DECODER_CTRL_REV                               0x0400
#define DECODER_CTRL_PH1                               0x0200
#define DECODER_CTRL_XIRQ                              0x0100
#define DECODER_CTRL_XIE                               0x0080
#define DECODER_CTRL_XIP                               0x0040
#define DECODER_CTRL_XNE                               0x0020
#define DECODER_CTRL_DIRQ                              0x0010
#define DECODER_CTRL_DIE                               0x0008
#define DECODER_CTRL_WDE                               0x0004
#define DECODER_CTRL_CMPIRQ                            0x0002
#define DECODER_CTRL_CMPIE                             0x0001

/* Masks for registers FILT */
#define DECODER_FILT_MASK                              0x7FF 
#define DECODER_FILT_FILT_CNT2                         0x0400
#define DECODER_FILT_FILT_CNT1                         0x0200
#define DECODER_FILT_FILT_CNT0                         0x0100
#define DECODER_FILT_FILT_CNT                          0x0700
#define DECODER_FILT_FILT_PER7                         0x0080
#define DECODER_FILT_FILT_PER6                         0x0040
#define DECODER_FILT_FILT_PER5                         0x0020
#define DECODER_FILT_FILT_PER4                         0x0010
#define DECODER_FILT_FILT_PER3                         0x0008
#define DECODER_FILT_FILT_PER2                         0x0004
#define DECODER_FILT_FILT_PER1                         0x0002
#define DECODER_FILT_FILT_PER0                         0x0001
#define DECODER_FILT_FILT_PER                          0x00FF

/* Masks for registers WTR */
#define DECODER_WTR_MASK                               0xFFFF 
#define DECODER_WTR_WDOG15                             0x8000
#define DECODER_WTR_WDOG14                             0x4000
#define DECODER_WTR_WDOG13                             0x2000
#define DECODER_WTR_WDOG12                             0x1000
#define DECODER_WTR_WDOG11                             0x0800
#define DECODER_WTR_WDOG10                             0x0400
#define DECODER_WTR_WDOG9                              0x0200
#define DECODER_WTR_WDOG8                              0x0100
#define DECODER_WTR_WDOG7                              0x0080
#define DECODER_WTR_WDOG6                              0x0040
#define DECODER_WTR_WDOG5                              0x0020
#define DECODER_WTR_WDOG4                              0x0010
#define DECODER_WTR_WDOG3                              0x0008
#define DECODER_WTR_WDOG2                              0x0004
#define DECODER_WTR_WDOG1                              0x0002
#define DECODER_WTR_WDOG0                              0x0001
#define DECODER_WTR_WDOG                               0xFFFF

/* Masks for registers POSD */
#define DECODER_POSD_MASK                              0xFFFF 
#define DECODER_POSD_POSD15                            0x8000
#define DECODER_POSD_POSD14                            0x4000
#define DECODER_POSD_POSD13                            0x2000
#define DECODER_POSD_POSD12                            0x1000
#define DECODER_POSD_POSD11                            0x0800
#define DECODER_POSD_POSD10                            0x0400
#define DECODER_POSD_POSD9                             0x0200
#define DECODER_POSD_POSD8                             0x0100
#define DECODER_POSD_POSD7                             0x0080
#define DECODER_POSD_POSD6                             0x0040
#define DECODER_POSD_POSD5                             0x0020
#define DECODER_POSD_POSD4                             0x0010
#define DECODER_POSD_POSD3                             0x0008
#define DECODER_POSD_POSD2                             0x0004
#define DECODER_POSD_POSD1                             0x0002
#define DECODER_POSD_POSD0                             0x0001
#define DECODER_POSD_POSD                              0xFFFF

/* Masks for registers POSDH */
#define DECODER_POSDH_MASK                             0xFFFF 
#define DECODER_POSDH_POSDH15                          0x8000
#define DECODER_POSDH_POSDH14                          0x4000
#define DECODER_POSDH_POSDH13                          0x2000
#define DECODER_POSDH_POSDH12                          0x1000
#define DECODER_POSDH_POSDH11                          0x0800
#define DECODER_POSDH_POSDH10                          0x0400
#define DECODER_POSDH_POSDH9                           0x0200
#define DECODER_POSDH_POSDH8                           0x0100
#define DECODER_POSDH_POSDH7                           0x0080
#define DECODER_POSDH_POSDH6                           0x0040
#define DECODER_POSDH_POSDH5                           0x0020
#define DECODER_POSDH_POSDH4                           0x0010
#define DECODER_POSDH_POSDH3                           0x0008
#define DECODER_POSDH_POSDH2                           0x0004
#define DECODER_POSDH_POSDH1                           0x0002
#define DECODER_POSDH_POSDH0                           0x0001
#define DECODER_POSDH_POSDH                            0xFFFF

/* Masks for registers REV */
#define DECODER_REV_MASK                               0xFFFF 
#define DECODER_REV_REV15                              0x8000
#define DECODER_REV_REV14                              0x4000
#define DECODER_REV_REV13                              0x2000
#define DECODER_REV_REV12                              0x1000
#define DECODER_REV_REV11                              0x0800
#define DECODER_REV_REV10                              0x0400
#define DECODER_REV_REV9                               0x0200
#define DECODER_REV_REV8                               0x0100
#define DECODER_REV_REV7                               0x0080
#define DECODER_REV_REV6                               0x0040
#define DECODER_REV_REV5                               0x0020
#define DECODER_REV_REV4                               0x0010
#define DECODER_REV_REV3                               0x0008
#define DECODER_REV_REV2                               0x0004
#define DECODER_REV_REV1                               0x0002
#define DECODER_REV_REV0                               0x0001
#define DECODER_REV_REV                                0xFFFF

/* Masks for registers REVH */
#define DECODER_REVH_MASK                              0xFFFF 
#define DECODER_REVH_REVH15                            0x8000
#define DECODER_REVH_REVH14                            0x4000
#define DECODER_REVH_REVH13                            0x2000
#define DECODER_REVH_REVH12                            0x1000
#define DECODER_REVH_REVH11                            0x0800
#define DECODER_REVH_REVH10                            0x0400
#define DECODER_REVH_REVH9                             0x0200
#define DECODER_REVH_REVH8                             0x0100
#define DECODER_REVH_REVH7                             0x0080
#define DECODER_REVH_REVH6                             0x0040
#define DECODER_REVH_REVH5                             0x0020
#define DECODER_REVH_REVH4                             0x0010
#define DECODER_REVH_REVH3                             0x0008
#define DECODER_REVH_REVH2                             0x0004
#define DECODER_REVH_REVH1                             0x0002
#define DECODER_REVH_REVH0                             0x0001
#define DECODER_REVH_REVH                              0xFFFF

/* Masks for registers UPOS */
#define DECODER_UPOS_MASK                              0xFFFF 
#define DECODER_UPOS_POS15                             0x8000
#define DECODER_UPOS_POS14                             0x4000
#define DECODER_UPOS_POS13                             0x2000
#define DECODER_UPOS_POS12                             0x1000
#define DECODER_UPOS_POS11                             0x0800
#define DECODER_UPOS_POS10                             0x0400
#define DECODER_UPOS_POS9                              0x0200
#define DECODER_UPOS_POS8                              0x0100
#define DECODER_UPOS_POS7                              0x0080
#define DECODER_UPOS_POS6                              0x0040
#define DECODER_UPOS_POS5                              0x0020
#define DECODER_UPOS_POS4                              0x0010
#define DECODER_UPOS_POS3                              0x0008
#define DECODER_UPOS_POS2                              0x0004
#define DECODER_UPOS_POS1                              0x0002
#define DECODER_UPOS_POS0                              0x0001
#define DECODER_UPOS_POS                               0xFFFF

/* Masks for registers LPOS */
#define DECODER_LPOS_MASK                              0xFFFF 
#define DECODER_LPOS_POS15                             0x8000
#define DECODER_LPOS_POS14                             0x4000
#define DECODER_LPOS_POS13                             0x2000
#define DECODER_LPOS_POS12                             0x1000
#define DECODER_LPOS_POS11                             0x0800
#define DECODER_LPOS_POS10                             0x0400
#define DECODER_LPOS_POS9                              0x0200
#define DECODER_LPOS_POS8                              0x0100
#define DECODER_LPOS_POS7                              0x0080
#define DECODER_LPOS_POS6                              0x0040
#define DECODER_LPOS_POS5                              0x0020
#define DECODER_LPOS_POS4                              0x0010
#define DECODER_LPOS_POS3                              0x0008
#define DECODER_LPOS_POS2                              0x0004
#define DECODER_LPOS_POS1                              0x0002
#define DECODER_LPOS_POS0                              0x0001
#define DECODER_LPOS_POS                               0xFFFF

/* Masks for registers UPOSH */
#define DECODER_UPOSH_MASK                             0xFFFF 
#define DECODER_UPOSH_POSH15                           0x8000
#define DECODER_UPOSH_POSH14                           0x4000
#define DECODER_UPOSH_POSH13                           0x2000
#define DECODER_UPOSH_POSH12                           0x1000
#define DECODER_UPOSH_POSH11                           0x0800
#define DECODER_UPOSH_POSH10                           0x0400
#define DECODER_UPOSH_POSH9                            0x0200
#define DECODER_UPOSH_POSH8                            0x0100
#define DECODER_UPOSH_POSH7                            0x0080
#define DECODER_UPOSH_POSH6                            0x0040
#define DECODER_UPOSH_POSH5                            0x0020
#define DECODER_UPOSH_POSH4                            0x0010
#define DECODER_UPOSH_POSH3                            0x0008
#define DECODER_UPOSH_POSH2                            0x0004
#define DECODER_UPOSH_POSH1                            0x0002
#define DECODER_UPOSH_POSH0                            0x0001
#define DECODER_UPOSH_POSH                             0xFFFF

/* Masks for registers LPOSH */
#define DECODER_LPOSH_MASK                             0xFFFF 
#define DECODER_LPOSH_POSH15                           0x8000
#define DECODER_LPOSH_POSH14                           0x4000
#define DECODER_LPOSH_POSH13                           0x2000
#define DECODER_LPOSH_POSH12                           0x1000
#define DECODER_LPOSH_POSH11                           0x0800
#define DECODER_LPOSH_POSH10                           0x0400
#define DECODER_LPOSH_POSH9                            0x0200
#define DECODER_LPOSH_POSH8                            0x0100
#define DECODER_LPOSH_POSH7                            0x0080
#define DECODER_LPOSH_POSH6                            0x0040
#define DECODER_LPOSH_POSH5                            0x0020
#define DECODER_LPOSH_POSH4                            0x0010
#define DECODER_LPOSH_POSH3                            0x0008
#define DECODER_LPOSH_POSH2                            0x0004
#define DECODER_LPOSH_POSH1                            0x0002
#define DECODER_LPOSH_POSH0                            0x0001
#define DECODER_LPOSH_POSH                             0xFFFF

/* Masks for registers UINIT */
#define DECODER_UINIT_MASK                             0xFFFF 
#define DECODER_UINIT_INIT15                           0x8000
#define DECODER_UINIT_INIT14                           0x4000
#define DECODER_UINIT_INIT13                           0x2000
#define DECODER_UINIT_INIT12                           0x1000
#define DECODER_UINIT_INIT11                           0x0800
#define DECODER_UINIT_INIT10                           0x0400
#define DECODER_UINIT_INIT9                            0x0200
#define DECODER_UINIT_INIT8                            0x0100
#define DECODER_UINIT_INIT7                            0x0080
#define DECODER_UINIT_INIT6                            0x0040
#define DECODER_UINIT_INIT5                            0x0020
#define DECODER_UINIT_INIT4                            0x0010
#define DECODER_UINIT_INIT3                            0x0008
#define DECODER_UINIT_INIT2                            0x0004
#define DECODER_UINIT_INIT1                            0x0002
#define DECODER_UINIT_INIT0                            0x0001
#define DECODER_UINIT_INIT                             0xFFFF

/* Masks for registers LINIT */
#define DECODER_LINIT_MASK                             0xFFFF 
#define DECODER_LINIT_INIT15                           0x8000
#define DECODER_LINIT_INIT14                           0x4000
#define DECODER_LINIT_INIT13                           0x2000
#define DECODER_LINIT_INIT12                           0x1000
#define DECODER_LINIT_INIT11                           0x0800
#define DECODER_LINIT_INIT10                           0x0400
#define DECODER_LINIT_INIT9                            0x0200
#define DECODER_LINIT_INIT8                            0x0100
#define DECODER_LINIT_INIT7                            0x0080
#define DECODER_LINIT_INIT6                            0x0040
#define DECODER_LINIT_INIT5                            0x0020
#define DECODER_LINIT_INIT4                            0x0010
#define DECODER_LINIT_INIT3                            0x0008
#define DECODER_LINIT_INIT2                            0x0004
#define DECODER_LINIT_INIT1                            0x0002
#define DECODER_LINIT_INIT0                            0x0001
#define DECODER_LINIT_INIT                             0xFFFF

/* Masks for registers IMR */
#define DECODER_IMR_MASK                               0xFF 
#define DECODER_IMR_FPHA                               0x0080
#define DECODER_IMR_FPHB                               0x0040
#define DECODER_IMR_FIND                               0x0020
#define DECODER_IMR_FHOM                               0x0010
#define DECODER_IMR_PHA                                0x0008
#define DECODER_IMR_PHB                                0x0004
#define DECODER_IMR_INDEX                              0x0002
#define DECODER_IMR_HOME                               0x0001

/* Masks for registers TST */
#define DECODER_TST_MASK                               0xFFFF 
#define DECODER_TST_TEN                                0x8000
#define DECODER_TST_TCE                                0x4000
#define DECODER_TST_QDN                                0x2000
#define DECODER_TST_TEST_PERIOD4                       0x1000
#define DECODER_TST_TEST_PERIOD3                       0x0800
#define DECODER_TST_TEST_PERIOD2                       0x0400
#define DECODER_TST_TEST_PERIOD1                       0x0200
#define DECODER_TST_TEST_PERIOD0                       0x0100
#define DECODER_TST_TEST_PERIOD                        0x1F00
#define DECODER_TST_TEST_COUNT7                        0x0080
#define DECODER_TST_TEST_COUNT6                        0x0040
#define DECODER_TST_TEST_COUNT5                        0x0020
#define DECODER_TST_TEST_COUNT4                        0x0010
#define DECODER_TST_TEST_COUNT3                        0x0008
#define DECODER_TST_TEST_COUNT2                        0x0004
#define DECODER_TST_TEST_COUNT1                        0x0002
#define DECODER_TST_TEST_COUNT0                        0x0001
#define DECODER_TST_TEST_COUNT                         0x00FF

/* Masks for registers CTRL2 */
#define DECODER_CTRL2_MASK                             0x3FF 
#define DECODER_CTRL2_OUTCTL                           0x0200
#define DECODER_CTRL2_REVMOD                           0x0100
#define DECODER_CTRL2_ROIRQ                            0x0080
#define DECODER_CTRL2_ROIE                             0x0040
#define DECODER_CTRL2_RUIRQ                            0x0020
#define DECODER_CTRL2_RUIE                             0x0010
#define DECODER_CTRL2_DIR                              0x0008
#define DECODER_CTRL2_MOD                              0x0004
#define DECODER_CTRL2_UPDPOS                           0x0002
#define DECODER_CTRL2_UPDHLD                           0x0001

/* Masks for registers UMOD */
#define DECODER_UMOD_MASK                              0xFFFF 
#define DECODER_UMOD_MOD15                             0x8000
#define DECODER_UMOD_MOD14                             0x4000
#define DECODER_UMOD_MOD13                             0x2000
#define DECODER_UMOD_MOD12                             0x1000
#define DECODER_UMOD_MOD11                             0x0800
#define DECODER_UMOD_MOD10                             0x0400
#define DECODER_UMOD_MOD9                              0x0200
#define DECODER_UMOD_MOD8                              0x0100
#define DECODER_UMOD_MOD7                              0x0080
#define DECODER_UMOD_MOD6                              0x0040
#define DECODER_UMOD_MOD5                              0x0020
#define DECODER_UMOD_MOD4                              0x0010
#define DECODER_UMOD_MOD3                              0x0008
#define DECODER_UMOD_MOD2                              0x0004
#define DECODER_UMOD_MOD1                              0x0002
#define DECODER_UMOD_MOD0                              0x0001
#define DECODER_UMOD_MOD                               0xFFFF

/* Masks for registers LMOD */
#define DECODER_LMOD_MASK                              0xFFFF 
#define DECODER_LMOD_MOD15                             0x8000
#define DECODER_LMOD_MOD14                             0x4000
#define DECODER_LMOD_MOD13                             0x2000
#define DECODER_LMOD_MOD12                             0x1000
#define DECODER_LMOD_MOD11                             0x0800
#define DECODER_LMOD_MOD10                             0x0400
#define DECODER_LMOD_MOD9                              0x0200
#define DECODER_LMOD_MOD8                              0x0100
#define DECODER_LMOD_MOD7                              0x0080
#define DECODER_LMOD_MOD6                              0x0040
#define DECODER_LMOD_MOD5                              0x0020
#define DECODER_LMOD_MOD4                              0x0010
#define DECODER_LMOD_MOD3                              0x0008
#define DECODER_LMOD_MOD2                              0x0004
#define DECODER_LMOD_MOD1                              0x0002
#define DECODER_LMOD_MOD0                              0x0001
#define DECODER_LMOD_MOD                               0xFFFF

/* Masks for registers UCOMP */
#define DECODER_UCOMP_MASK                             0xFFFF 
#define DECODER_UCOMP_COMP15                           0x8000
#define DECODER_UCOMP_COMP14                           0x4000
#define DECODER_UCOMP_COMP13                           0x2000
#define DECODER_UCOMP_COMP12                           0x1000
#define DECODER_UCOMP_COMP11                           0x0800
#define DECODER_UCOMP_COMP10                           0x0400
#define DECODER_UCOMP_COMP9                            0x0200
#define DECODER_UCOMP_COMP8                            0x0100
#define DECODER_UCOMP_COMP7                            0x0080
#define DECODER_UCOMP_COMP6                            0x0040
#define DECODER_UCOMP_COMP5                            0x0020
#define DECODER_UCOMP_COMP4                            0x0010
#define DECODER_UCOMP_COMP3                            0x0008
#define DECODER_UCOMP_COMP2                            0x0004
#define DECODER_UCOMP_COMP1                            0x0002
#define DECODER_UCOMP_COMP0                            0x0001
#define DECODER_UCOMP_COMP                             0xFFFF

/* Masks for registers LCOMP */
#define DECODER_LCOMP_MASK                             0xFFFF 
#define DECODER_LCOMP_COMP15                           0x8000
#define DECODER_LCOMP_COMP14                           0x4000
#define DECODER_LCOMP_COMP13                           0x2000
#define DECODER_LCOMP_COMP12                           0x1000
#define DECODER_LCOMP_COMP11                           0x0800
#define DECODER_LCOMP_COMP10                           0x0400
#define DECODER_LCOMP_COMP9                            0x0200
#define DECODER_LCOMP_COMP8                            0x0100
#define DECODER_LCOMP_COMP7                            0x0080
#define DECODER_LCOMP_COMP6                            0x0040
#define DECODER_LCOMP_COMP5                            0x0020
#define DECODER_LCOMP_COMP4                            0x0010
#define DECODER_LCOMP_COMP3                            0x0008
#define DECODER_LCOMP_COMP2                            0x0004
#define DECODER_LCOMP_COMP1                            0x0002
#define DECODER_LCOMP_COMP0                            0x0001
#define DECODER_LCOMP_COMP                             0xFFFF



#define DECCR_Flag_BitsMask 0x8910

/* function prototypes, implemented in decoder.c */
void decoderCoefCalc( decoder_sEncScale *pEncScale );
typedef arch_sENC arch_sDecoder;
Word32 decoderGetScaledPosition(arch_sDecoder *pDecBase, decoder_sEncScale *pEncScale);
Word16 decoderGetScaledPositionDifference(arch_sDecoder *pDecBase, decoder_sEncScale *pEncScale);
/***********************************************************************************************************
** DECODER METHODS                                                                                   **
***********************************************************************************************************/
/*********************************************************************************************************
** Method:       DEC_CLEAR_HOME_INT_REQUEST                                                             **
** Description:                                                                                         **
**               Clear HOME Signal Transition Interrupt Request.                                        **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_CLEAR_HOME_INT_REQUEST, NULL );                                    **
**               ioctl( deviceID, DEC_CLEAR_HOME_INT_REQUEST, NULL );                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_CLEAR_HOME_INT_REQUEST(periph, param) \
  periphBitClear((DECODER_CTRL_XIRQ | DECODER_CTRL_DIRQ | DECODER_CTRL_CMPIE), &periph.ctrl)

/*********************************************************************************************************
** Method:       DEC_HOME_INT                                                                           **
** Description:                                                                                         **
**               Enable/Disable HOME Interrupt.                                                         **
** Parameters:                                                                                          **
**               DEC_ENABLE - Enable HOME interrupts                                                    **
**               DEC_DISABLE - Disable HOME interrupts                                                  **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_HOME_INT, DEC_ENABLE );                                            **
**               ioctl( deviceID, DEC_HOME_INT, DEC_ENABLE );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_HOME_INT(periph, param) \
  if (param)\
    periphBitSet(DECODER_CTRL_HIE, &periph.ctrl);   /* set bit HIE */\
  else\
    periphBitClear(DECODER_CTRL_HIE, &periph.ctrl); /* clear bit HIE */

/*********************************************************************************************************
** Method:       DEC_HOME_TRIGGERED_INIT                                                                **
** Description:                                                                                         **
**               Enable HOME to Initialize Position Counters UPOS and LPOS.                             **
** Parameters:                                                                                          **
**               DEC_ENABLE - HOME signal initializes the position counter                              **
**               DEC_DISABLE - No action                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_HOME_TRIGGERED_INIT, DEC_ENABLE );                                 **
**               ioctl( deviceID, DEC_HOME_TRIGGERED_INIT, DEC_ENABLE );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_HOME_TRIGGERED_INIT(periph, param) \
  if (param)\
    periphBitSet(DECODER_CTRL_HIP, &periph.ctrl);   /* set bit HIP */\
  else\
    periphBitClear(DECODER_CTRL_HIP, &periph.ctrl); /* clear bit HIP */

/*********************************************************************************************************
** Method:       DEC_HOME_EDGE                                                                          **
** Description:                                                                                         **
**               Use Negative or Positive Edge of HOME Input.                                           **
** Parameters:                                                                                          **
**               DEC_NEGATIVE - Use negative going edge-to-trigger initialization of position counters UPOS and LPOS **
**               DEC_POSITIVE - Use positive going edge-to-trigger initialization of position counters UPOS and LPOS **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_HOME_EDGE, DEC_NEGATIVE );                                         **
**               ioctl( deviceID, DEC_HOME_EDGE, DEC_NEGATIVE );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_HOME_EDGE(periph, param) \
  if (param)\
    periphBitSet(DECODER_CTRL_HNE, &periph.ctrl);   /* set bit HNE */\
  else\
    periphBitClear(DECODER_CTRL_HNE, &periph.ctrl); /* clear bit HNE */

/*********************************************************************************************************
** Method:       DEC_SOFTWARE_TRIGGERED_INIT                                                            **
** Description:                                                                                         **
**               Set Software Triggered Initialization of Position Counters UPOS and LPOS.              **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_SOFTWARE_TRIGGERED_INIT, NULL );                                   **
**               ioctl( deviceID, DEC_SOFTWARE_TRIGGERED_INIT, NULL );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_SOFTWARE_TRIGGERED_INIT(periph, param) \
  periphBitSet(DECODER_CTRL_SWIP, &periph.ctrl) /* set bit SWIP */

/*********************************************************************************************************
** Method:       DEC_DIRECTION_COUNTING_ENABLE                                                          **
** Description:                                                                                         **
**               Enable Reverse Direction Counting or Count Normally.                                   **
** Parameters:                                                                                          **
**               DEC_REVERSE - Count in the reverse direction                                           **
**               DEC_NORMAL - Count normally                                                            **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_DIRECTION_COUNTING_ENABLE, DEC_REVERSE );                          **
**               ioctl( deviceID, DEC_DIRECTION_COUNTING_ENABLE, DEC_REVERSE );                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_DIRECTION_COUNTING_ENABLE(periph, param) \
  if (param)\
    periphBitSet(DECODER_CTRL_REV, &periph.ctrl);   /* set bit REV */\
  else\
    periphBitClear(DECODER_CTRL_REV, &periph.ctrl); /* clear bit REV */

/*********************************************************************************************************
** Method:       DEC_SINGLE_PHASE_COUNT                                                                 **
** Description:                                                                                         **
**               Enable/Disable Signal Phase Count Mode.                                                **
** Parameters:                                                                                          **
**               DEC_ENABLE - Bypass the Quadrature Decoder.                                            **
**               DEC_DISABLE - Use standard Quadrature Decoder                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_SINGLE_PHASE_COUNT, DEC_ENABLE );                                  **
**               ioctl( deviceID, DEC_SINGLE_PHASE_COUNT, DEC_ENABLE );                                 **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_SINGLE_PHASE_COUNT(periph, param) \
  if (param)\
    periphBitSet(DECODER_CTRL_PH1, &periph.ctrl);   /* set bit PH1 */\
  else\
    periphBitClear(DECODER_CTRL_PH1, &periph.ctrl); /* clear bit PH1 */

/*********************************************************************************************************
** Method:       DEC_CLEAR_INDEX_PULSE_INT_REQUEST                                                      **
** Description:                                                                                         **
**               Clear Index Pulse Interrupt Request.                                                   **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_CLEAR_INDEX_PULSE_INT_REQUEST, NULL );                             **
**               ioctl( deviceID, DEC_CLEAR_INDEX_PULSE_INT_REQUEST, NULL );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_CLEAR_INDEX_PULSE_INT_REQUEST(periph, param) \
  periphBitClear((DECODER_CTRL_HIRQ | DECODER_CTRL_DIRQ | DECODER_CTRL_CMPIE), &periph.ctrl)

/*********************************************************************************************************
** Method:       DEC_INDEX_PULSE_INT                                                                    **
** Description:                                                                                         **
**               Enable/Disable Index Pulse Interrupt.                                                  **
** Parameters:                                                                                          **
**               DEC_ENABLE - INDEX pulse interrupt is enabled                                          **
**               DEC_DISABLE - INDEX pulse interrupt is disabled                                        **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_INDEX_PULSE_INT, DEC_ENABLE );                                     **
**               ioctl( deviceID, DEC_INDEX_PULSE_INT, DEC_ENABLE );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_INDEX_PULSE_INT(periph, param) \
  if (param)\
    periphBitSet(DECODER_CTRL_XIE, &periph.ctrl);   /* set bit XIE */\
  else\
    periphBitClear(DECODER_CTRL_XIE, &periph.ctrl); /* clear bit XIE */

/*********************************************************************************************************
** Method:       DEC_INDEX_TRIGGERED_INIT                                                               **
** Description:                                                                                         **
**               Set Index Triggered Initialization of Position Counters UPOS and LPOS.                 **
** Parameters:                                                                                          **
**               DEC_ENABLE - INDEX pulse initializes the position counter                              **
**               DEC_DISABLE - No action                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_INDEX_TRIGGERED_INIT, DEC_ENABLE );                                **
**               ioctl( deviceID, DEC_INDEX_TRIGGERED_INIT, DEC_ENABLE );                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_INDEX_TRIGGERED_INIT(periph, param) \
  if (param)\
    periphBitSet(DECODER_CTRL_XIP, &periph.ctrl);   /* set bit XIP */\
  else\
    periphBitClear(DECODER_CTRL_XIP, &periph.ctrl); /* clear bit XIP */

/*********************************************************************************************************
** Method:       DEC_INDEX_EDGE                                                                         **
** Description:                                                                                         **
**               Use Negative or Posotive Edge of Index Pulse.                                          **
** Parameters:                                                                                          **
**               DEC_NEGATIVE - Use negative transition edge of INDEX pulse                             **
**               DEC_POSITIVE - Use positive transition edge of INDEX pulse                             **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_INDEX_EDGE, DEC_NEGATIVE );                                        **
**               ioctl( deviceID, DEC_INDEX_EDGE, DEC_NEGATIVE );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_INDEX_EDGE(periph, param) \
  if (param)\
    periphBitSet(DECODER_CTRL_XNE, &periph.ctrl);   /* set bit XNE */\
  else\
    periphBitClear(DECODER_CTRL_XNE, &periph.ctrl); /* clear bit XNE */

/*********************************************************************************************************
** Method:       DEC_CLEAR_WATCHDOG_INT_REQUEST                                                         **
** Description:                                                                                         **
**               Clear Watchdog Timeout Interrupt Request.                                              **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_CLEAR_WATCHDOG_INT_REQUEST, NULL );                                **
**               ioctl( deviceID, DEC_CLEAR_WATCHDOG_INT_REQUEST, NULL );                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_CLEAR_WATCHDOG_INT_REQUEST(periph, param) \
  periphBitClear((DECODER_CTRL_HIRQ | DECODER_CTRL_XIRQ | DECODER_CTRL_CMPIE), &periph.ctrl)

/*********************************************************************************************************
** Method:       DEC_WATCHDOG_INT                                                                       **
** Description:                                                                                         **
**               Enable/Disable Watchdog Timeout Interrupt.                                             **
** Parameters:                                                                                          **
**               DEC_ENABLE - Watchdog timer interrupt is enabled                                       **
**               DEC_DISABLE - Watchdog timer interrupt is disabled                                     **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WATCHDOG_INT, DEC_ENABLE );                                        **
**               ioctl( deviceID, DEC_WATCHDOG_INT, DEC_ENABLE );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WATCHDOG_INT(periph, param) \
  if (param)\
    periphBitSet(DECODER_CTRL_DIE, &periph.ctrl);   /* set bit DIE */\
  else\
    periphBitClear(DECODER_CTRL_DIE, &periph.ctrl); /* clear bit DIE */

/*********************************************************************************************************
** Method:       DEC_WATCHDOG                                                                           **
** Description:                                                                                         **
**               Enable/Disable Watchdog.                                                               **
** Parameters:                                                                                          **
**               DEC_ENABLE - Watchdog timer is enabled                                                 **
**               DEC_DISABLE - Watchdog timer is disabled                                               **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WATCHDOG, DEC_ENABLE );                                            **
**               ioctl( deviceID, DEC_WATCHDOG, DEC_ENABLE );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WATCHDOG(periph, param) \
  if (param)\
    periphBitSet(DECODER_CTRL_WDE, &periph.ctrl);   /* set bit WDE */\
  else\
    periphBitClear(DECODER_CTRL_WDE, &periph.ctrl); /* clear bit WDE */

/*********************************************************************************************************
** Method:       DEC_INT_ENABLE                                                                         **
** Description:                                                                                         **
**               Enable Selected Interrupts.                                                            **
** Parameters:                                                                                          **
**               DEC_HOME - Enable HOME interrupts                                                      **
**               DEC_INDEX - Enable INDEX pulse interrupt                                               **
**               DEC_WDTIMEOUT - Enable Watchdog timer interrupt                                        **
**               DEC_COMPARE - Enable Compare interrupt                                                 **
**               DEC_ROLLUNDER - Enable Rollunder interrupt                                             **
**               DEC_ROLLOVER - Enable Rollover interrupt                                               **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_INT_ENABLE, DEC_HOME );                                            **
**               ioctl( deviceID, DEC_INT_ENABLE, DEC_HOME );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_INT_ENABLE(periph, param) \
  if (param & (DEC_ROLLUNDER | DEC_ROLLOVER)) \
    periphBitSet((param) >> 16, &periph.ctrl2); \
  else \
    periphBitSet((param), &periph.ctrl);

/*********************************************************************************************************
** Method:       DEC_INT_DISABLE                                                                        **
** Description:                                                                                         **
**               Disable Selected Interrupts.                                                           **
** Parameters:                                                                                          **
**               DEC_HOME - Disable HOME interrupts                                                     **
**               DEC_INDEX - Disable INDEX pulse interrupt                                              **
**               DEC_WDTIMEOUT - Disable Watchdog timer interrupt                                       **
**               DEC_COMPARE - Disable Compare interrupt                                                **
**               DEC_ROLLUNDER - Disable Rollunder interrupt                                            **
**               DEC_ROLLOVER - Disable Rollover interrupt                                              **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_INT_DISABLE, DEC_HOME );                                           **
**               ioctl( deviceID, DEC_INT_DISABLE, DEC_HOME );                                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_INT_DISABLE(periph, param) \
  if (param & (DEC_ROLLUNDER | DEC_ROLLOVER)) \
    periphBitClear((param) >> 16, &periph.ctrl2); \
  else \
    periphBitClear((param), &periph.ctrl);

/*********************************************************************************************************
** Method:       DEC_INT_REQUEST_CLEAR                                                                  **
** Description:                                                                                         **
**               Clear Selected Interrupt Requests.                                                     **
** Parameters:                                                                                          **
**               DEC_HOME - Clear HOME signal transition interrupt request                              **
**               DEC_INDEX - Clear INDEX Pulse Interrupt Request                                        **
**               DEC_WDTIMEOUT - Clear Watchdog Timeout Interrupt Request                               **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_INT_REQUEST_CLEAR, DEC_HOME );                                     **
**               ioctl( deviceID, DEC_INT_REQUEST_CLEAR, DEC_HOME );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_INT_REQUEST_CLEAR(periph, param) periphBitClear( DECCR_Flag_BitsMask & (~((param) << 1)), &periph.ctrl )

/*********************************************************************************************************
** Method:       DEC_READ_CONTROL_REG                                                                   **
** Description:                                                                                         **
**               Read Decoder control register.                                                         **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_CONTROL_REG, NULL );                                      **
**               w = ioctl( deviceID, DEC_READ_CONTROL_REG, NULL );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_CONTROL_REG(periph, param)  \
  periphMemRead(&periph.ctrl)

/*********************************************************************************************************
** Method:       DEC_WRITE_WATCHDOG_TIMEOUT                                                             **
** Description:                                                                                         **
**               Set Watchdog time-out register.                                                        **
** Parameters:                                                                                          **
**               Word - UWord16                                                                         **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_WATCHDOG_TIMEOUT, 1 );                                       **
**               ioctl( deviceID, DEC_WRITE_WATCHDOG_TIMEOUT, 1 );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_WATCHDOG_TIMEOUT(periph, param) \
  periphMemWrite(param, &periph.wtr) /* set group WDOG */

/*********************************************************************************************************
** Method:       DEC_READ_POSITION_DIFFERENCE                                                           **
** Description:                                                                                         **
**               Read Position difference counter register.                                             **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord16                                                                                **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_POSITION_DIFFERENCE, NULL );                              **
**               w = ioctl( deviceID, DEC_READ_POSITION_DIFFERENCE, NULL );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_POSITION_DIFFERENCE(periph, param) \
  ((periphMemRead(&periph.posd) & (DECODER_POSD_POSD)) >> 0) /* read group POSD */

/*********************************************************************************************************
** Method:       DEC_READ_REVOLUTION                                                                    **
** Description:                                                                                         **
**               Read Revolution counter register.                                                      **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord16                                                                                **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_REVOLUTION, NULL );                                       **
**               w = ioctl( deviceID, DEC_READ_REVOLUTION, NULL );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_REVOLUTION(periph, param)  \
  periphMemRead(&periph.rev)

/*********************************************************************************************************
** Method:       DEC_WRITE_REVOLUTION                                                                   **
** Description:                                                                                         **
**               Set Revolution counter register.                                                       **
** Parameters:                                                                                          **
**               Word - UWord16                                                                         **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_REVOLUTION, 1 );                                             **
**               ioctl( deviceID, DEC_WRITE_REVOLUTION, 1 );                                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_REVOLUTION(periph, param) \
  periphMemWrite(param, &periph.rev)

/*********************************************************************************************************
** Method:       DEC_READ_POSITION                                                                      **
** Description:                                                                                         **
**               Read the 32-bit position counter.                                                      **
** Parameters:                                                                                          **
**               Pointer - pointer to decoder_uReg32bit                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**                decoder_uReg32bit PositionCounter;                                                    **
**                . . .                                                                                 **
**               PESL( deviceID, DEC_READ_POSITION, &PositionCounter );                                 **
**               ioctl( deviceID, DEC_READ_POSITION, &PositionCounter );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_POSITION(periph, param) \
  { ((decoder_uReg32bit*)param)->RegParts.LSBpart = (UWord16) periphMemRead((UWord16 *)(&ENC_LPOS)); \
    ((decoder_uReg32bit*)param)->RegParts.MSBpart = (Word16) periphMemRead((UWord16 *)(&ENC_UPOS)); }

/*********************************************************************************************************
** Method:       DEC_WRITE_POSITION                                                                     **
** Description:                                                                                         **
**               Write the 32-bit position counter via the initialization.                              **
** Parameters:                                                                                          **
**               UWord32 - UWord32                                                                      **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_POSITION, 1 );                                               **
**               ioctl( deviceID, DEC_WRITE_POSITION, 1 );                                              **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_POSITION(periph, param) \
 {  periphMemWrite((UWord16)param, (UWord16 *) &ENC_LINIT); \
    periphMemWrite((UWord16)(param >> 16), (UWord16 *) &ENC_UINIT); \
    periphBitSet( 0x800, (UWord16 *)&ENC_CTRL); /* set bit SWIP*/ \
 }

/*********************************************************************************************************
** Method:       DEC_WRITE_INIT_STATE                                                                   **
** Description:                                                                                         **
**               Set the 32-bit position initialization register.                                       **
** Parameters:                                                                                          **
**               UWord32 - 32bit value                                                                  **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_INIT_STATE, 1 );                                             **
**               ioctl( deviceID, DEC_WRITE_INIT_STATE, 1 );                                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_INIT_STATE(periph, param) \
 { \
    periphMemWrite((UWord16)(param >> 16), &periph.uinit); \
    periphMemWrite((UWord16)(param) & 0xFFFF, &periph.linit); \
 }

/*********************************************************************************************************
** Method:       DEC_READ_MONITOR_REG                                                                   **
** Description:                                                                                         **
**               Read Input monitor register.                                                           **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_MONITOR_REG, NULL );                                      **
**               w = ioctl( deviceID, DEC_READ_MONITOR_REG, NULL );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_MONITOR_REG(periph, param)  \
  periphMemRead(&periph.imr)

/*********************************************************************************************************
** Method:       DEC_GET_RAW_ENCSIGNALS                                                                 **
** Description:                                                                                         **
**               Get Raw Signals.                                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_GET_RAW_ENCSIGNALS, NULL );                                    **
**               w = ioctl( deviceID, DEC_GET_RAW_ENCSIGNALS, NULL );                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_GET_RAW_ENCSIGNALS(periph, param) \
  ((periphMemRead(&periph.imr) & (DECODER_IMR_HOME | DECODER_IMR_INDEX | DECODER_IMR_PHB | DECODER_IMR_PHA)))

/*********************************************************************************************************
** Method:       DEC_GET_FILTERED_ENCSIGNALS                                                            **
** Description:                                                                                         **
**               Get Filtered Signals.                                                                  **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_GET_FILTERED_ENCSIGNALS, NULL );                               **
**               w = ioctl( deviceID, DEC_GET_FILTERED_ENCSIGNALS, NULL );                              **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_GET_FILTERED_ENCSIGNALS(periph, param) \
  ((periphMemRead(&periph.imr) & (DECODER_IMR_FHOM | DECODER_IMR_FIND | DECODER_IMR_FPHB | DECODER_IMR_FPHA)) >> 4)

/*********************************************************************************************************
** Method:       DEC_READ_HOLD_DATA_REGS                                                                **
** Description:                                                                                         **
**               Read Data Registers.                                                                   **
** Parameters:                                                                                          **
**               Pointer - decoder_sState                                                               **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**                decoder_sState decoderState;                                                          **
**                . . .                                                                                 **
**               PESL( deviceID, DEC_READ_HOLD_DATA_REGS, &decoderState );                              **
**               ioctl( deviceID, DEC_READ_HOLD_DATA_REGS, &decoderState );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_HOLD_DATA_REGS(periph, param) \
  { ((decoder_sState*)param)->PositionDifferenceHoldReg = (Word16) periphMemRead((UWord16 *)(&ENC_POSD)); \
    ((decoder_sState*)param)->RevolutionHoldReg = (Word16) periphMemRead((UWord16 *)(&ENC_REVH)); \
    ((decoder_sState*)param)->PositionHoldReg.RegParts.LSBpart = (UWord16) periphMemRead((UWord16 *)&(ENC_LPOSH)); \
    ((decoder_sState*)param)->PositionHoldReg.RegParts.MSBpart = (Word16) periphMemRead((UWord16 *)&(ENC_UPOSH)); }

/*********************************************************************************************************
** Method:       DEC_CALCULATE_SCALE_COEF                                                               **
** Description:                                                                                         **
**               Read Data Registers.                                                                   **
** Parameters:                                                                                          **
**               Word - decoder_sEncScale                                                               **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_CALCULATE_SCALE_COEF, 1 );                                         **
**               ioctl( deviceID, DEC_CALCULATE_SCALE_COEF, 1 );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_CALCULATE_SCALE_COEF(periph, param) \
  decoderCoefCalc((decoder_sEncScale *)param)

/*********************************************************************************************************
** Method:       DEC_GET_SCALED_POSITION                                                                **
** Description:                                                                                         **
**               Get scaled position.                                                                   **
** Parameters:                                                                                          **
**               Word - decoder_sEncScale                                                               **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                Word32 w32;                                                                           **
**                . . .                                                                                 **
**               w32 = PESL( deviceID, DEC_GET_SCALED_POSITION, 1 );                                    **
**               w32 = ioctl( deviceID, DEC_GET_SCALED_POSITION, 1 );                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_GET_SCALED_POSITION(periph, param) \
  decoderGetScaledPosition((arch_sDecoder *)&periph, (decoder_sEncScale *)param)


/*********************************************************************************************************
** Method:       DEC_GET_SCALED_POSITION_DIFFERENCE                                                     **
** Description:                                                                                         **
**               Get scaled position.                                                                   **
** Parameters:                                                                                          **
**               Word - decoder_sEncScale                                                               **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                Word16 w16;                                                                           **
**                . . .                                                                                 **
**               w16 = PESL( deviceID, DEC_GET_SCALED_POSITION_DIFFERENCE, 1 );                         **
**               w16 = ioctl( deviceID, DEC_GET_SCALED_POSITION_DIFFERENCE, 1 );                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_GET_SCALED_POSITION_DIFFERENCE(periph, param) \
  decoderGetScaledPositionDifference((arch_sDecoder *)&periph, (decoder_sEncScale *)param)

/*********************************************************************************************************
** Method:       DEC_CLEAR_COMPARE_INT_REQUEST                                                          **
** Description:                                                                                         **
**               Clear Compare Interrupt Request.                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_CLEAR_COMPARE_INT_REQUEST, NULL );                                 **
**               ioctl( deviceID, DEC_CLEAR_COMPARE_INT_REQUEST, NULL );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_CLEAR_COMPARE_INT_REQUEST(periph, param) \
  periphBitClear((DECODER_CTRL_DIRQ | DECODER_CTRL_XIRQ | DECODER_CTRL_HIRQ), &periph.ctrl)

/*********************************************************************************************************
** Method:       DEC_COMPARE_INT                                                                        **
** Description:                                                                                         **
**               Enable/Disable Compare Interrupt.                                                      **
** Parameters:                                                                                          **
**               DEC_ENABLE - Watchdog timer interrupt is enabled                                       **
**               DEC_DISABLE - Watchdog timer interrupt is disabled                                     **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_COMPARE_INT, DEC_ENABLE );                                         **
**               ioctl( deviceID, DEC_COMPARE_INT, DEC_ENABLE );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_COMPARE_INT(periph, param) \
  if (param)\
    periphBitSet(DECODER_CTRL_CMPIE, &periph.ctrl);   /* set bit CMPIE */\
  else\
    periphBitClear(DECODER_CTRL_CMPIE, &periph.ctrl); /* clear bit CMPIE */

/*********************************************************************************************************
** Method:       DEC_WRITE_FILTER_PERIOD                                                                **
** Description:                                                                                         **
**               Write Input Filter Sample Period.                                                      **
** Parameters:                                                                                          **
**               Byte - Sampling period (in IPBus clock cycles) of the decoder input signals            **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_FILTER_PERIOD, 1 );                                          **
**               ioctl( deviceID, DEC_WRITE_FILTER_PERIOD, 1 );                                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_FILTER_PERIOD(periph, param) \
  periphBitGrpSet((DECODER_FILT_FILT_PER), param, &periph.filt) /* set group FILT_PER */

/*********************************************************************************************************
** Method:       DEC_WRITE_FILTER_COUNT                                                                 **
** Description:                                                                                         **
**               Write Input Filter Sample Count.                                                       **
** Parameters:                                                                                          **
**               DEC_COUNT_3 - 3 samples                                                                **
**               DEC_COUNT_4 - 4 samples                                                                **
**               DEC_COUNT_5 - 5 samples                                                                **
**               DEC_COUNT_6 - 6 samples                                                                **
**               DEC_COUNT_7 - 7 samples                                                                **
**               DEC_COUNT_8 - 8 samples                                                                **
**               DEC_COUNT_9 - 9 samples                                                                **
**               DEC_COUNT_10 - 10 samples                                                              **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_FILTER_COUNT, DEC_COUNT_3 );                                 **
**               ioctl( deviceID, DEC_WRITE_FILTER_COUNT, DEC_COUNT_3 );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_FILTER_COUNT(periph, param) \
  periphBitGrpSet((DECODER_FILT_FILT_CNT), (param) << 8, &periph.filt) /* set group FILT_CNT */

/*********************************************************************************************************
** Method:       DEC_WRITE_TEST_REG                                                                     **
** Description:                                                                                         **
**               Write Test Register.                                                                   **
** Parameters:                                                                                          **
**               Word - UWord16                                                                         **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_TEST_REG, 1 );                                               **
**               ioctl( deviceID, DEC_WRITE_TEST_REG, 1 );                                              **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_TEST_REG(periph, param) \
  periphMemWrite(param, &periph.tst)

/*********************************************************************************************************
** Method:       DEC_READ_TEST_REG                                                                      **
** Description:                                                                                         **
**               Read Test Register.                                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord16                                                                                **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_TEST_REG, NULL );                                         **
**               w = ioctl( deviceID, DEC_READ_TEST_REG, NULL );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_TEST_REG(periph, param)  \
  periphMemRead(&periph.tst)

/*********************************************************************************************************
** Method:       DEC_WRITE_CONTROL2_REG                                                                 **
** Description:                                                                                         **
**               Write Control 2 Register.                                                              **
** Parameters:                                                                                          **
**               Word - UWord16                                                                         **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_CONTROL2_REG, 1 );                                           **
**               ioctl( deviceID, DEC_WRITE_CONTROL2_REG, 1 );                                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_CONTROL2_REG(periph, param) \
  periphMemWrite(param, &periph.ctrl2)

/*********************************************************************************************************
** Method:       DEC_READ_CONTROL2_REG                                                                  **
** Description:                                                                                         **
**               Read Control 2 Register.                                                               **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord16                                                                                **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_CONTROL2_REG, NULL );                                     **
**               w = ioctl( deviceID, DEC_READ_CONTROL2_REG, NULL );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_CONTROL2_REG(periph, param)  \
  periphMemRead(&periph.ctrl2)

/*********************************************************************************************************
** Method:       DEC_WRITE_MODULUS_REG                                                                  **
** Description:                                                                                         **
**               Write Modulus Registers.                                                               **
** Parameters:                                                                                          **
**               UWord32 - UWord32                                                                      **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_MODULUS_REG, 1 );                                            **
**               ioctl( deviceID, DEC_WRITE_MODULUS_REG, 1 );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_MODULUS_REG(periph, param) \
 { \
    periphMemWrite((UWord16)(param >> 16), &periph.umod); \
    periphMemWrite((UWord16)(param) & 0xFFFF, &periph.lmod); \
 }

/*********************************************************************************************************
** Method:       DEC_READ_MODULUS_REG                                                                   **
** Description:                                                                                         **
**               Read Modulus Registers.                                                                **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_MODULUS_REG, NULL );                                      **
**               w = ioctl( deviceID, DEC_READ_MODULUS_REG, NULL );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_MODULUS_REG(periph, param) \
 (((UWord32)periph.lmod) | ((UWord32)periph.umod << 16))

/*********************************************************************************************************
** Method:       DEC_WRITE_POSITION_COMPARE_REG                                                         **
** Description:                                                                                         **
**               Write Position Compare Registers.                                                      **
** Parameters:                                                                                          **
**               UWord32 - UWord32                                                                      **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_POSITION_COMPARE_REG, 1 );                                   **
**               ioctl( deviceID, DEC_WRITE_POSITION_COMPARE_REG, 1 );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_POSITION_COMPARE_REG(periph, param) \
 { \
    periphMemWrite((UWord16)(param >> 16), &periph.ucomp); \
    periphMemWrite((UWord16)(param) & 0xFFFF, &periph.lcomp); \
 }

/*********************************************************************************************************
** Method:       DEC_READ_POSITION_COMPARE_REG                                                          **
** Description:                                                                                         **
**               Read Position Compare Register.                                                        **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_POSITION_COMPARE_REG, NULL );                             **
**               w = ioctl( deviceID, DEC_READ_POSITION_COMPARE_REG, NULL );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_POSITION_COMPARE_REG(periph, param) \
 (((UWord32)periph.lcomp) | ((UWord32)periph.ucomp << 16))

/*********************************************************************************************************
** Method:       DEC_READ_FILTER_REG                                                                    **
** Description:                                                                                         **
**               Read Input Filter Register.                                                            **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_FILTER_REG, NULL );                                       **
**               w = ioctl( deviceID, DEC_READ_FILTER_REG, NULL );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_FILTER_REG(periph, param)  \
  periphMemRead(&periph.filt)

/*********************************************************************************************************
** Method:       DEC_READ_WATCHDOG_TIMEOUT_REG                                                          **
** Description:                                                                                         **
**               Read Watchdog Timeout Register.                                                        **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_WATCHDOG_TIMEOUT_REG, NULL );                             **
**               w = ioctl( deviceID, DEC_READ_WATCHDOG_TIMEOUT_REG, NULL );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_WATCHDOG_TIMEOUT_REG(periph, param)  \
  periphMemRead(&periph.wtr)

/*********************************************************************************************************
** Method:       DEC_READ_UPPER_INIT_REG                                                                **
** Description:                                                                                         **
**               Read Upper Initialization Register.                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_UPPER_INIT_REG, NULL );                                   **
**               w = ioctl( deviceID, DEC_READ_UPPER_INIT_REG, NULL );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_UPPER_INIT_REG(periph, param)  \
  periphMemRead(&periph.uinit)

/*********************************************************************************************************
** Method:       DEC_READ_LOWER_INIT_REG                                                                **
** Description:                                                                                         **
**               Read Lower Initialization Register.                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_LOWER_INIT_REG, NULL );                                   **
**               w = ioctl( deviceID, DEC_READ_LOWER_INIT_REG, NULL );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_LOWER_INIT_REG(periph, param)  \
  periphMemRead(&periph.linit)

/*********************************************************************************************************
** Method:       DEC_READ_UPPER_MODULUS_REG                                                             **
** Description:                                                                                         **
**               Read Upper Modulus Register.                                                           **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_UPPER_MODULUS_REG, NULL );                                **
**               w = ioctl( deviceID, DEC_READ_UPPER_MODULUS_REG, NULL );                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_UPPER_MODULUS_REG(periph, param)  \
  periphMemRead(&periph.umod)

/*********************************************************************************************************
** Method:       DEC_READ_LOWER_MODULUS_REG                                                             **
** Description:                                                                                         **
**               Read Lower Modulus Register.                                                           **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_LOWER_MODULUS_REG, NULL );                                **
**               w = ioctl( deviceID, DEC_READ_LOWER_MODULUS_REG, NULL );                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_LOWER_MODULUS_REG(periph, param)  \
  periphMemRead(&periph.lmod)

/*********************************************************************************************************
** Method:       DEC_READ_UPPER_POSITION_COMPARE_REG                                                    **
** Description:                                                                                         **
**               Read Upper Position Compare Register.                                                  **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_UPPER_POSITION_COMPARE_REG, NULL );                       **
**               w = ioctl( deviceID, DEC_READ_UPPER_POSITION_COMPARE_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_UPPER_POSITION_COMPARE_REG(periph, param)  \
  periphMemRead(&periph.ucomp)

/*********************************************************************************************************
** Method:       DEC_READ_LOWER_POSITION_COMPARE_REG                                                    **
** Description:                                                                                         **
**               Read Lower Position Compare Register.                                                  **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_LOWER_POSITION_COMPARE_REG, NULL );                       **
**               w = ioctl( deviceID, DEC_READ_LOWER_POSITION_COMPARE_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_LOWER_POSITION_COMPARE_REG(periph, param)  \
  periphMemRead(&periph.lcomp)

/*********************************************************************************************************
** Method:       DEC_WRITE_FILTER_REG                                                                   **
** Description:                                                                                         **
**               Write Input Filter Register.                                                           **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_FILTER_REG, 1 );                                             **
**               ioctl( deviceID, DEC_WRITE_FILTER_REG, 1 );                                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_FILTER_REG(periph, param) \
  periphMemWrite(param, &periph.filt)

/*********************************************************************************************************
** Method:       DEC_WRITE_WATCHDOG_TIMEOUT_REG                                                         **
** Description:                                                                                         **
**               Write Watchdog Timeout Register.                                                       **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_WATCHDOG_TIMEOUT_REG, 1 );                                   **
**               ioctl( deviceID, DEC_WRITE_WATCHDOG_TIMEOUT_REG, 1 );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_WATCHDOG_TIMEOUT_REG(periph, param) \
  periphMemWrite(param, &periph.wtr)

/*********************************************************************************************************
** Method:       DEC_WRITE_POSITION_DIFFERENCE_REG                                                      **
** Description:                                                                                         **
**               Write Position Difference Counter Register.                                            **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_POSITION_DIFFERENCE_REG, 1 );                                **
**               ioctl( deviceID, DEC_WRITE_POSITION_DIFFERENCE_REG, 1 );                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_POSITION_DIFFERENCE_REG(periph, param) \
  periphMemWrite(param, &periph.posd)

/*********************************************************************************************************
** Method:       DEC_WRITE_UPPER_POSITION_REG                                                           **
** Description:                                                                                         **
**               Write Upper Position Counter Register.                                                 **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_UPPER_POSITION_REG, 1 );                                     **
**               ioctl( deviceID, DEC_WRITE_UPPER_POSITION_REG, 1 );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_UPPER_POSITION_REG(periph, param) \
  periphMemWrite(param, &periph.upos)

/*********************************************************************************************************
** Method:       DEC_WRITE_LOWER_POSITION_REG                                                           **
** Description:                                                                                         **
**               Write Lower Position Counter Register.                                                 **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_LOWER_POSITION_REG, 1 );                                     **
**               ioctl( deviceID, DEC_WRITE_LOWER_POSITION_REG, 1 );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_LOWER_POSITION_REG(periph, param) \
  periphMemWrite(param, &periph.lpos)

/*********************************************************************************************************
** Method:       DEC_WRITE_UPPER_INIT_REG                                                               **
** Description:                                                                                         **
**               Write Upper Initialization Register.                                                   **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_UPPER_INIT_REG, 1 );                                         **
**               ioctl( deviceID, DEC_WRITE_UPPER_INIT_REG, 1 );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_UPPER_INIT_REG(periph, param) \
  periphMemWrite(param, &periph.uinit)

/*********************************************************************************************************
** Method:       DEC_WRITE_LOWER_INIT_REG                                                               **
** Description:                                                                                         **
**               Write Lower Initialization Register.                                                   **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_LOWER_INIT_REG, 1 );                                         **
**               ioctl( deviceID, DEC_WRITE_LOWER_INIT_REG, 1 );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_LOWER_INIT_REG(periph, param) \
  periphMemWrite(param, &periph.linit)

/*********************************************************************************************************
** Method:       DEC_WRITE_MONITOR_REG                                                                  **
** Description:                                                                                         **
**               Write Input Monitor Register.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_MONITOR_REG, 1 );                                            **
**               ioctl( deviceID, DEC_WRITE_MONITOR_REG, 1 );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_MONITOR_REG(periph, param) \
  periphMemWrite(param, &periph.imr)

/*********************************************************************************************************
** Method:       DEC_WRITE_UPPER_MODULUS_REG                                                            **
** Description:                                                                                         **
**               Write Upper Modulus Register.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_UPPER_MODULUS_REG, 1 );                                      **
**               ioctl( deviceID, DEC_WRITE_UPPER_MODULUS_REG, 1 );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_UPPER_MODULUS_REG(periph, param) \
  periphMemWrite(param, &periph.umod)

/*********************************************************************************************************
** Method:       DEC_WRITE_LOWER_MODULUS_REG                                                            **
** Description:                                                                                         **
**               Write Lower Modulus Register.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_LOWER_MODULUS_REG, 1 );                                      **
**               ioctl( deviceID, DEC_WRITE_LOWER_MODULUS_REG, 1 );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_LOWER_MODULUS_REG(periph, param) \
  periphMemWrite(param, &periph.lmod)

/*********************************************************************************************************
** Method:       DEC_WRITE_UPPER_POSITION_COMPARE_REG                                                   **
** Description:                                                                                         **
**               Write Upper Position Compare Register.                                                 **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_UPPER_POSITION_COMPARE_REG, 1 );                             **
**               ioctl( deviceID, DEC_WRITE_UPPER_POSITION_COMPARE_REG, 1 );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_UPPER_POSITION_COMPARE_REG(periph, param) \
  periphMemWrite(param, &periph.ucomp)

/*********************************************************************************************************
** Method:       DEC_WRITE_LOWER_POSITION_COMPARE_REG                                                   **
** Description:                                                                                         **
**               Write Lower Position Compare Register.                                                 **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_LOWER_POSITION_COMPARE_REG, 1 );                             **
**               ioctl( deviceID, DEC_WRITE_LOWER_POSITION_COMPARE_REG, 1 );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_LOWER_POSITION_COMPARE_REG(periph, param) \
  periphMemWrite(param, &periph.lcomp)

/*********************************************************************************************************
** Method:       DEC_READ_POSITION_DIFFERENCE_REG                                                       **
** Description:                                                                                         **
**               Read Position Difference Counter Register.                                             **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_POSITION_DIFFERENCE_REG, NULL );                          **
**               w = ioctl( deviceID, DEC_READ_POSITION_DIFFERENCE_REG, NULL );                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_POSITION_DIFFERENCE_REG(periph, param)  \
  periphMemRead(&periph.posd)

/*********************************************************************************************************
** Method:       DEC_READ_REVOLUTION_REG                                                                **
** Description:                                                                                         **
**               Read Revolution Counter Register.                                                      **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_REVOLUTION_REG, NULL );                                   **
**               w = ioctl( deviceID, DEC_READ_REVOLUTION_REG, NULL );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_REVOLUTION_REG(periph, param)  \
  periphMemRead(&periph.rev)

/*********************************************************************************************************
** Method:       DEC_READ_UPPER_POSITION_REG                                                            **
** Description:                                                                                         **
**               Read Upper Position Counter Register.                                                  **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_UPPER_POSITION_REG, NULL );                               **
**               w = ioctl( deviceID, DEC_READ_UPPER_POSITION_REG, NULL );                              **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_UPPER_POSITION_REG(periph, param)  \
  periphMemRead(&periph.upos)

/*********************************************************************************************************
** Method:       DEC_READ_LOWER_POSITION_REG                                                            **
** Description:                                                                                         **
**               Read Lower Position Counter Register.                                                  **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_LOWER_POSITION_REG, NULL );                               **
**               w = ioctl( deviceID, DEC_READ_LOWER_POSITION_REG, NULL );                              **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_LOWER_POSITION_REG(periph, param)  \
  periphMemRead(&periph.lpos)

/*********************************************************************************************************
** Method:       DEC_WRITE_CONTROL_REG                                                                  **
** Description:                                                                                         **
**               Write Control Register.                                                                **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_CONTROL_REG, 1 );                                            **
**               ioctl( deviceID, DEC_WRITE_CONTROL_REG, 1 );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_CONTROL_REG(periph, param) \
  periphMemWrite(param, &periph.ctrl)

/*********************************************************************************************************
** Method:       DEC_WRITE_REVOLUTION_REG                                                               **
** Description:                                                                                         **
**               Write Revolution Counter Register.                                                     **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_WRITE_REVOLUTION_REG, 1 );                                         **
**               ioctl( deviceID, DEC_WRITE_REVOLUTION_REG, 1 );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_WRITE_REVOLUTION_REG(periph, param) \
  periphMemWrite(param, &periph.rev)

/*********************************************************************************************************
** Method:       DEC_CLEAR_ROLLOVER_INT_REQUEST                                                         **
** Description:                                                                                         **
**               Clear Roll-over Interrupt Request.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_CLEAR_ROLLOVER_INT_REQUEST, NULL );                                **
**               ioctl( deviceID, DEC_CLEAR_ROLLOVER_INT_REQUEST, NULL );                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_CLEAR_ROLLOVER_INT_REQUEST(periph, param) \
  periphBitClear(DECODER_CTRL2_RUIRQ, &periph.ctrl2) /* clear bit RUIRQ */

/*********************************************************************************************************
** Method:       DEC_CLEAR_ROLLUNDER_INT_REQUEST                                                        **
** Description:                                                                                         **
**               Clear Roll-under Interrupt Request.                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, DEC_CLEAR_ROLLUNDER_INT_REQUEST, NULL );                               **
**               ioctl( deviceID, DEC_CLEAR_ROLLUNDER_INT_REQUEST, NULL );                              **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_CLEAR_ROLLUNDER_INT_REQUEST(periph, param) \
  periphBitClear(DECODER_CTRL2_ROIRQ, &periph.ctrl2) /* clear bit ROIRQ */

/*********************************************************************************************************
** Method:       DEC_READ_POSITION_DIFFERENCE_HOLD_REG                                                  **
** Description:                                                                                         **
**               Read Position Difference Hold Register.                                                **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_POSITION_DIFFERENCE_HOLD_REG, NULL );                     **
**               w = ioctl( deviceID, DEC_READ_POSITION_DIFFERENCE_HOLD_REG, NULL );                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_POSITION_DIFFERENCE_HOLD_REG(periph, param)  \
  periphMemRead(&periph.posdh)

/*********************************************************************************************************
** Method:       DEC_READ_REVOLUTION_HOLD_REG                                                           **
** Description:                                                                                         **
**               Read Revolution Hold Register.                                                         **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_REVOLUTION_HOLD_REG, NULL );                              **
**               w = ioctl( deviceID, DEC_READ_REVOLUTION_HOLD_REG, NULL );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_REVOLUTION_HOLD_REG(periph, param)  \
  periphMemRead(&periph.revh)

/*********************************************************************************************************
** Method:       DEC_READ_UPPER_POSITION_HOLD_REG                                                       **
** Description:                                                                                         **
**               Read Upper Position Hold Register.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_UPPER_POSITION_HOLD_REG, NULL );                          **
**               w = ioctl( deviceID, DEC_READ_UPPER_POSITION_HOLD_REG, NULL );                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_UPPER_POSITION_HOLD_REG(periph, param)  \
  periphMemRead(&periph.uposh)

/*********************************************************************************************************
** Method:       DEC_READ_LOWER_POSITION_HOLD_REG                                                       **
** Description:                                                                                         **
**               Read Lower Position Hold Register.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, DEC_READ_LOWER_POSITION_HOLD_REG, NULL );                          **
**               w = ioctl( deviceID, DEC_READ_LOWER_POSITION_HOLD_REG, NULL );                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlDEC_READ_LOWER_POSITION_HOLD_REG(periph, param)  \
  periphMemRead(&periph.lposh)

/**********************************************************************************************************/
/**********************************************************************************************************/
#endif __PE_peslDECODER
/**********************************************************************************************************/
/**********************************************************************************************************/
#endif
