/* DEVICES=CAN */
#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
/*
** #################################################################################################################
**     THIS MODULE IS A PART OF PROCESSOR EXPERT SYSTEM LIBRARY.
**
**     Filename  : CAN.H
**
**     Family    : Freescale DSP
**
**     Compiler  : Freescale DSP C Compiler
**
**     Abstract  :
**
**         This PESL module implements a CAN.
**
**         Implemented devices:
**
**           CAN - Flex Controller Area Network module
**
**         Supported CPUs:
**           MC56F84451VLF,MC56F84452VLH,MC56F84462VLH,MC56F84540VLF,MC56F84543VLH,MC56F84565VLK,MC56F84567VLL,MC56F84585VLK,MC56F84587VLL,MC56F84763VLH,MC56F84766VLK,MC56F84769VLL,MC56F84786VLK,MC56F84789VLL
**
**     (c) Freescale Semiconductor
**     2012 All Rights Reserved
**
**     http      : www.freescale.com
**
** #################################################################################################################
*/

#ifndef __PE_peslCAN
#define __PE_peslCAN

#include "PE_Types.h"
#include "periph.h"
#include "PESL.h" /* here is constant CPUtype */

/***************************************************************************************************************
* CAN module identifiers                                                                                **
***************************************************************************************************************/
#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CAN ArchIO.can
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB0 (*((arch_sFCAN_MB0 *)(&(ArchIO.can.cs0))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB1 (*((arch_sFCAN_MB1 *)(&(ArchIO.can.cs1))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB2 (*((arch_sFCAN_MB2 *)(&(ArchIO.can.cs2))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB3 (*((arch_sFCAN_MB3 *)(&(ArchIO.can.cs3))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB4 (*((arch_sFCAN_MB4 *)(&(ArchIO.can.cs4))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB5 (*((arch_sFCAN_MB5 *)(&(ArchIO.can.cs5))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB6 (*((arch_sFCAN_MB6 *)(&(ArchIO.can.cs6))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB7 (*((arch_sFCAN_MB7 *)(&(ArchIO.can.cs7))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB8 (*((arch_sFCAN_MB8 *)(&(ArchIO.can.cs8))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB9 (*((arch_sFCAN_MB9 *)(&(ArchIO.can.cs9))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB10 (*((arch_sFCAN_MB10 *)(&(ArchIO.can.cs10))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB11 (*((arch_sFCAN_MB11 *)(&(ArchIO.can.cs11))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB12 (*((arch_sFCAN_MB12 *)(&(ArchIO.can.cs12))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB13 (*((arch_sFCAN_MB13 *)(&(ArchIO.can.cs13))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB14 (*((arch_sFCAN_MB14 *)(&(ArchIO.can.cs14))))
#endif

#if (CPUtype == _MC56F84451VLF) || (CPUtype == _MC56F84452VLH) || (CPUtype == _MC56F84462VLH) || (CPUtype == _MC56F84540VLF) || (CPUtype == _MC56F84543VLH) || (CPUtype == _MC56F84565VLK) || (CPUtype == _MC56F84567VLL) || (CPUtype == _MC56F84585VLK) || (CPUtype == _MC56F84587VLL) || (CPUtype == _MC56F84763VLH) || (CPUtype == _MC56F84766VLK) || (CPUtype == _MC56F84769VLL) || (CPUtype == _MC56F84786VLK) || (CPUtype == _MC56F84789VLL)
#define CANMB15 (*((arch_sFCAN_MB15 *)(&(ArchIO.can.cs15))))
#endif

/* CAN module identifiers - backward compatibility */


/***************************************************************************************************************
** METHODS OVERVIEW                                                                                           **
****************************************************************************************************************
**       METHOD                      DESCRIPTION                     PARAMETERS              RESULT           **
***************************************************************************************************************/
#define FCAN_DEVICE                     /* Module Enable/Disable         FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_ENABLED_ENTER_FREEZE_MODE  /* Freeze Enable/Disable         FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_RX_FIFO                    /* Rx FIFO Enable/Disable        FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_FREEZE_MODE                /* Halt FlexCAN Enable/Disable   FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_TEST_READY                 /* Get FlexCAN Not Ready         NULL                     Bool         */
#define FCAN_WAKEUP_INT                 /* Wake Up Interrupt Mask Enable/Disable FCAN_DISABLE,FCAN_ENABLE NULL */
#define FCAN_WARNING_INT                /* Warning Interrupt Enable/Disable FCAN_DISABLE,FCAN_ENABLE NULL      */
#define FCAN_SOFT_RESET                 /* Soft Reset                    NULL                     NULL         */
#define FCAN_TEST_FREEZE_MODE           /* Get Freeze Mode Acknowledge   NULL                     Bool         */
#define FCAN_MODE                       /* Set Supervisor Mode           FCAN_USER,FCAN_SUPERVISOR NULL        */
#define FCAN_SELF_WAKEUP_MODE           /* Self Wake Up Enable/Disable   FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_TEST_LOW_POWER_MODE        /* Get Low Power Mode Acknowledge NULL                    Bool         */
#define FCAN_WAKE_UP_SOURCE             /* Set Wake Up Source            FCAN_UNFILTRED_RX,FCAN_FILTRED_RX NULL */
#define FCAN_DOZE_MODE                  /* Doze Mode Enable/Disable      FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_SELF_RECEPTION             /* Self Reception Enable/Disable FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_INVIDUAL_MASKING           /* Individual Rx Masking and Queue Enable/Disable FCAN_DISABLE,FCAN_ENABLE NULL */
#define FCAN_LOCAL_PRIORITY             /* Local Priority Enable/Disable FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_ABORT_MODE                 /* Abort Enable/Disable          FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_ID_ACCEPTANCE_MODE         /* Set ID Acceptance Mode        FCAN_FORMAT_A,FCAN_FORMAT_B,FCAN_FORMAT_C,FCAN_FORMAT_D NULL */
#define FCAN_SET_MAXMB                  /* Set Number of the Last Message Buffer Byte - Value 0-127 NULL       */
#define FCAN_SET_PRESCALER              /* Prescaler Division FactorSet  Byte - Value 0-255       NULL         */
#define FCAN_SET_RJW                    /* Set Resync Jump Width         FCAN_RJW_1,FCAN_RJW_2,FCAN_RJW_3,FCAN_RJW_4 NULL */
#define FCAN_SET_PHASE_SEG1             /* Set Phase Segment 1           FCAN_PSEG_1,FCAN_PSEG_2,FCAN_PSEG_3,FCAN_PSEG_4,FCAN_PSEG_5,FCAN_PSEG_6,FCAN_PSEG_7,FCAN_PSEG_8 NULL */
#define FCAN_SET_PHASE_SEG2             /* Set Phase Segment 2           FCAN_PSEG_1,FCAN_PSEG_2,FCAN_PSEG_3,FCAN_PSEG_4,FCAN_PSEG_5,FCAN_PSEG_6,FCAN_PSEG_7,FCAN_PSEG_8 NULL */
#define FCAN_BUS_OFF_INT                /* Bus Off Mask Enable/Disable   FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_ERROR_INT                  /* Error Mask Enable/Disable     FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_SET_CLOCK_SOURCE           /* Set CAN Engine Clock Source   FCAN_OSCILLATOR_CLK,FCAN_BUS_CLK NULL */
#define FCAN_LOOPBACK_MODE              /* Loop Back Mode Enable/Disable FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_TX_WARNING_INT             /* Tx Warning Interrupt Mask Enable/Disable FCAN_DISABLE,FCAN_ENABLE NULL */
#define FCAN_RX_WARNING_INT             /* Rx Warning Interrupt Mask Enable/Disable FCAN_DISABLE,FCAN_ENABLE NULL */
#define FCAN_SET_BIT_SAMPLING           /* Rx Warning Interrupt Mask Enable/Disable FCAN_1SAMP_PER_BIT,FCAN_3SAMPS_PER_BIT NULL */
#define FCAN_BUS_OFF_RECOVERY           /* Bus Off Recovery Enable/Disable FCAN_DISABLE,FCAN_ENABLE NULL       */
#define FCAN_TIMER_SYNC_MODE            /* Timer Sync Enable/Disable     FCAN_DISABLE,FCAN_ENABLE NULL         */
#define FCAN_SET_TX_FIRST_SCHEME        /* Set Timer Sync Scheme         FCAN_LOWEST_ID,FCAN_LOWEST_MB_NUMBER NULL */
#define FCAN_LISTEN_ONLY_MODE           /* Listen-Only Mode Enable/Disable FCAN_DISABLE,FCAN_ENABLE NULL       */
#define FCAN_SET_PROP_SEG               /* Set Propagation Segment       FCAN_PROPSEG_1,FCAN_PROPSEG_2,FCAN_PROPSEG_3,FCAN_PROPSEG_4,FCAN_PROPSEG_5,FCAN_PROPSEG_6,FCAN_PROPSEG_7,FCAN_PROPSEG_8 NULL */
#define FCAN_SET_TIMER                  /* Set Timer value               Word - Value 0 - 65535   NULL         */
#define FCAN_GET_TIMER                  /* Get Timer value               NULL                     word         */
#define FCAN_SET_RXMGMASK               /* Set Rx Mailboxes Global Mask Register UWord32          NULL         */
#define FCAN_SET_RX14MGMASK             /* Set Rx 14 Mask Register       UWord32                  NULL         */
#define FCAN_SET_RX15MGMASK             /* Set Rx 15 Mask Register       UWord32                  NULL         */
#define FCAN_WRITE_RX_MAILBOXES_REG     /* Write Rx Mailboxes Global Mask Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_RX_14_MASK_REG       /* Write Rx 14 Mask Register     UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_RX_15_MASK_REG       /* Write Rx 15 Mask Register     UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_GET_RX_ERR_COUNT           /* Get Receive Error Counter     NULL                     word         */
#define FCAN_GET_TX_ERR_COUNT           /* Get Transmit Error Counter    NULL                     word         */
#define FCAN_READ_ERROR_STATUS_REG1     /* Get Error and Status 1 Register NULL                   UWord32      */
#define FCAN_GET_SYNCHRONIZATION_STATUS /* Get CAN Synchronization Status NULL                    Bool         */
#define FCAN_GET_RX_WARNING_FLAG        /* Get Rx Warning Interrupt Flag NULL                     Bool         */
#define FCAN_CLEAR_RX_WARNING_FLAG      /* Clear Rx Warning Interrupt Flag NULL                   NULL         */
#define FCAN_GET_TX_WARNING_FLAG        /* Get Tx Warning Interrupt Flag NULL                     Bool         */
#define FCAN_CLEAR_TX_WARNING_FLAG      /* Clear Tx Warning Interrupt Flag NULL                   NULL         */
#define FCAN_GET_BIT1_ERROR             /* Get Bit1 Error                NULL                     Bool         */
#define FCAN_GET_BIT0_ERROR             /* Get Bit0 Error                NULL                     Bool         */
#define FCAN_GET_ACKNOWLEDGE_ERROR      /* Get Acknowledge Error         NULL                     Bool         */
#define FCAN_GET_CRC_ERROR              /* Get Cyclic Redundancy Check Error NULL                 Bool         */
#define FCAN_GET_FORM_ERROR             /* Get Form Error                NULL                     Bool         */
#define FCAN_GET_STUFFING_ERROR         /* Get Stuffing Error            NULL                     Bool         */
#define FCAN_GET_TX_WARNING_ERROR       /* Get TX Error Warning          NULL                     Bool         */
#define FCAN_GET_RX_WARNING_ERROR       /* Get RX Error Warning          NULL                     Bool         */
#define FCAN_GET_IDLE_BUS               /* Get CAN bus in IDLE state.    NULL                     Bool         */
#define FCAN_GET_TRANSMISSION           /* Get FlexCAN in Transmission   NULL                     Bool         */
#define FCAN_GET_FAULT_CONFINEMENT      /* Get Fault Confinement State   NULL                     word         */
#define FCAN_GET_RECEPTION              /* Get FlexCAN in Reception      NULL                     Bool         */
#define FCAN_GET_BUS_OFF_FLAG           /* Get Bus Off Interrupt         NULL                     Bool         */
#define FCAN_CLEAR_BUS_OFF_FLAG         /* Clear Bus Off Interrupt Flag  NULL                     NULL         */
#define FCAN_GET_ERROR_FLAG             /* Get Error Interrupt           NULL                     Bool         */
#define FCAN_CLEAR_ERROR_FLAG           /* Clear Error Interrupt Flag    NULL                     NULL         */
#define FCAN_GET_WAKE_UP_FLAG           /* Get Wake-Up Interrupt         NULL                     Bool         */
#define FCAN_CLEAR_WAKE_UP_FLAG         /* Clear Wake-Up Interrupt Flag  NULL                     NULL         */
#define FCAN_MBINT_0_31_ENABLE          /* Enable Buffer MBi Mask        FCAN_MBINT_0,FCAN_MBINT_1,FCAN_MBINT_2,FCAN_MBINT_3,FCAN_MBINT_4,FCAN_MBINT_5,FCAN_MBINT_6,FCAN_MBINT_7,FCAN_MBINT_8,FCAN_MBINT_9,FCAN_MBINT_10,FCAN_MBINT_11,FCAN_MBINT_12,FCAN_MBINT_13,FCAN_MBINT_14,FCAN_MBINT_15,FCAN_MBINT_16,FCAN_MBINT_17,FCAN_MBINT_18,FCAN_MBINT_19,FCAN_MBINT_20,FCAN_MBINT_21,FCAN_MBINT_22,FCAN_MBINT_23,FCAN_MBINT_24,FCAN_MBINT_25,FCAN_MBINT_26,FCAN_MBINT_27,FCAN_MBINT_28,FCAN_MBINT_29,FCAN_MBINT_30,FCAN_MBINT_31 NULL */
#define FCAN_MBINT_0_31_DISABLE         /* Disable Buffer MBi Mask       FCAN_MBINT_0,FCAN_MBINT_1,FCAN_MBINT_2,FCAN_MBINT_3,FCAN_MBINT_4,FCAN_MBINT_5,FCAN_MBINT_6,FCAN_MBINT_7,FCAN_MBINT_8,FCAN_MBINT_9,FCAN_MBINT_10,FCAN_MBINT_11,FCAN_MBINT_12,FCAN_MBINT_13,FCAN_MBINT_14,FCAN_MBINT_15,FCAN_MBINT_16,FCAN_MBINT_17,FCAN_MBINT_18,FCAN_MBINT_19,FCAN_MBINT_20,FCAN_MBINT_21,FCAN_MBINT_22,FCAN_MBINT_23,FCAN_MBINT_24,FCAN_MBINT_25,FCAN_MBINT_26,FCAN_MBINT_27,FCAN_MBINT_28,FCAN_MBINT_29,FCAN_MBINT_30,FCAN_MBINT_31 NULL */
#define FCAN_GET_MBINT_0_15_FLAGS       /* Get Interrupt Flags 0-15      NULL                     word - constants from FCAN_CLEAR_MBINT_0_15_FLAGS can be used */
#define FCAN_CLEAR_MBINT_0_15_FLAGS     /* Clear Interrupt Flags 0-15    FCAN_MBINT_0,FCAN_MBINT_1,FCAN_MBINT_2,FCAN_MBINT_3,FCAN_MBINT_4,FCAN_MBINT_5,FCAN_MBINT_6,FCAN_MBINT_7,FCAN_MBINT_8,FCAN_MBINT_9,FCAN_MBINT_10,FCAN_MBINT_11,FCAN_MBINT_12,FCAN_MBINT_13,FCAN_MBINT_14,FCAN_MBINT_15 NULL */
#define FCAN_WRITE_ACCESS_TO_MEMORY     /* Enable/Disable Write-Access to Memory in Freeze mode FCAN_DISABLE,FCAN_ENABLE NULL */
#define FCAN_SET_RX_FIFO_FILTER_NUMBER  /* Set Number of Rx FIFO Filters Byte - Value 0 - 15      NULL         */
#define FCAN_SET_TX_ARBITRATION_START_DELAY /* Set Tx Arbitration Start Delay Byte - Value 0 - 31 NULL         */
#define FCAN_SET_RECEPTION_PRIORITY     /* Set Mailboxes Reception Priority FCAN_MAILBOXES_START  NULL         */
#define FCAN_SET_REMOTE_REQUEST         /* Set Remote Request Storing    FCAN_GENERATED           NULL         */
#define FCAN_RTR_COMPARISON             /* Enable/Disable Entire Frame Arbitration Field Comparison for Rx Mailboxes FCAN_DISABLE,FCAN_ENABLE NULL */
#define FCAN_READ_ERROR_STATUS_2_REG    /* Read Error and Status 2 Register NULL                  UWord32      */
#define FCAN_READ_CRC_REG               /* Read CRC Register             NULL                     UWord32      */
#define FCAN_SET_RX_FIFO_GMASK          /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_READ_RX_FIFO_INFO_REG      /* Read Rx FIFO Information Register NULL                 UWord32      */
#define FCAN_SET_RXIMR0MASK             /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR1MASK             /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR2MASK             /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR3MASK             /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR4MASK             /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR5MASK             /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR6MASK             /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR7MASK             /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR8MASK             /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR9MASK             /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR10MASK            /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR11MASK            /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR12MASK            /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR13MASK            /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR14MASK            /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_SET_RXIMR15MASK            /* Set Rx FIFO Global Mask Bits  Word - Value 0x0 - 0xFFFFFFFF NULL    */
#define FCAN_READ_CONFIGURATION_REG     /* Read Module Configuration Register NULL                UWord32      */
#define FCAN_READ_CONTROL_1_REG         /* Read Control 1 Register       NULL                     UWord32      */
#define FCAN_READ_TIMER_REG             /* Read Free Running Timer       NULL                     UWord32      */
#define FCAN_READ_RX_MAILBOXES_REG      /* Read Rx Mailboxes Global Mask Register NULL            UWord32      */
#define FCAN_READ_RX_14_MASK_REG        /* Read Rx 14 Mask Register      NULL                     UWord32      */
#define FCAN_READ_RX_15_MASK_REG        /* Read Rx 15 Mask Register      NULL                     UWord32      */
#define FCAN_READ_ERROR_COUNTER_REG     /* Read Error Counter            NULL                     UWord32      */
#define FCAN_READ_INT_MASK_2_REG        /* Read Interrupt Masks 2 Register NULL                   UWord32      */
#define FCAN_READ_INT_MASK_1_REG        /* Read Interrupt Masks 1 Register NULL                   UWord32      */
#define FCAN_READ_INT_FLAG_2_REG        /* Read Interrupt Flags 2 Register NULL                   UWord32      */
#define FCAN_READ_INT_FLAG_1_REG        /* Read Interrupt Flags 1 Register NULL                   UWord32      */
#define FCAN_READ_CONTROL_2_REG         /* Read Control 2 Register       NULL                     UWord32      */
#define FCAN_READ_RX_FIFO_REG           /* Read Rx FIFO Global Mask Register NULL                 UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_0_REG /* Read Rx Individual Mask Registers NULL              UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_1_REG /* Read Rx Individual Mask Registers NULL              UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_2_REG /* Read Rx Individual Mask Registers NULL              UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_3_REG /* Read Rx Individual Mask Registers NULL              UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_4_REG /* Read Rx Individual Mask Registers NULL              UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_5_REG /* Read Rx Individual Mask Registers NULL              UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_6_REG /* Read Rx Individual Mask Registers NULL              UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_7_REG /* Read Rx Individual Mask Registers NULL              UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_8_REG /* Read Rx Individual Mask Registers NULL              UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_9_REG /* Read Rx Individual Mask Registers NULL              UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_10_REG /* Read Rx Individual Mask Registers NULL             UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_11_REG /* Read Rx Individual Mask Registers NULL             UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_12_REG /* Read Rx Individual Mask Registers NULL             UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_13_REG /* Read Rx Individual Mask Registers NULL             UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_14_REG /* Read Rx Individual Mask Registers NULL             UWord32      */
#define FCAN_READ_RX_INDIVIDUAL_MASK_15_REG /* Read Rx Individual Mask Registers NULL             UWord32      */
#define FCAN_WRITE_CONFIGURATION_REG    /* Write Module Configuration Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_CONTROL_1_REG        /* Write Control 1 Register      UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_TIMER_REG            /* Write Free Running Timer      UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_ERROR_COUNTER_REG    /* Write Error Counter           UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_CAN_ESR_1_REG        /* Write Error and Status 1 Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_INT_MASK_2_REG       /* Write Interrupt Masks 2 Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_INT_MASK_1_REG       /* Write Interrupt Masks 1 Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_INT_FLAG_2_REG       /* Write Interrupt Flags 2 Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_INT_FLAG_1_REG       /* Write Interrupt Flags 1 Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_CONTROL_2_REG        /* Write Control 2 Register      UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_RX_FIFO_REG          /* Write Rx FIFO Global Mask Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_RX_FIFO_INFO_REG     /* Write Rx FIFO Information Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_0_REG /* Write Rx Individual Mask Registers UWord32         NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_1_REG /* Write Rx Individual Mask Registers UWord32         NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_2_REG /* Write Rx Individual Mask Registers UWord32         NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_3_REG /* Write Rx Individual Mask Registers UWord32         NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_4_REG /* Write Rx Individual Mask Registers UWord32         NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_5_REG /* Write Rx Individual Mask Registers UWord32         NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_6_REG /* Write Rx Individual Mask Registers UWord32         NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_7_REG /* Write Rx Individual Mask Registers UWord32         NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_8_REG /* Write Rx Individual Mask Registers UWord32         NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_9_REG /* Write Rx Individual Mask Registers UWord32         NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_10_REG /* Write Rx Individual Mask Registers UWord32        NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_11_REG /* Write Rx Individual Mask Registers UWord32        NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_12_REG /* Write Rx Individual Mask Registers UWord32        NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_13_REG /* Write Rx Individual Mask Registers UWord32        NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_14_REG /* Write Rx Individual Mask Registers UWord32        NULL         */
#define FCAN_WRITE_RX_INDIVIDUAL_MASK_15_REG /* Write Rx Individual Mask Registers UWord32        NULL         */
#define FCANMB_READ_CS_REG              /* Read Message Buffer CS Register NULL                   UWord32      */
#define FCANMB_READ_ID_REG              /* Read Message Buffer ID Register NULL                   UWord32      */
#define FCANMB_READ_WORD_0_REG          /* Read Message Buffer WORD0 Register NULL                UWord32      */
#define FCANMB_READ_WORD_1_REG          /* Read Message Buffer WORD1 Register NULL                UWord32      */
#define FCANMB_WRITE_CS_REG             /* Write Message Buffer CS Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCANMB_WRITE_ID_REG             /* Write Message Buffer ID Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCANMB_WRITE_WORD_0_REG         /* Write Message Buffer WORD0 Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCANMB_WRITE_WORD_1_REG         /* Write Message Buffer WORD1 Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCANMB_SET_CODE                 /* Set Message Buffer 0 Code     FCANMB_RX_NOT_ACTIVE,FCANMB_RX_EMPTY,FCANMB_RX_FULL,FCANMB_RX_OVERRUN,FCANMB_RX_RANSWER,FCANMB_RX_BUSY,FCANMB_TX_NOT_ACTIVE,FCANMB_TX_ABORT,FCANMB_TX_DATA_FRAME,FCANMB_TX_TANSWER NULL */
#define FCANMB_GET_CODE                 /* Get Message Buffer 0 Code     NULL                     UWord32 - FCANMB_SET_CODE constants can be used */
#define FCANMB_SRR                      /* Enable/Disable Substitute Remote Request FCANMB_DISABLE,FCANMB_ENABLE NULL */
#define FCANMB_GET_SRR                  /* Get Substitute Remote Request NULL                     Bool         */
#define FCANMB_SET_ID_TYPE              /* Set ID Extended               FCANMB_STANDARD,FCANMB_EXTENDED NULL  */
#define FCANMB_GET_ID_TYPE              /* Get ID Extended               NULL                     UWord32 - FCANMB_SET_ID_TYPE constants can be used */
#define FCANMB_SET_DATA_LENGTH          /* Set length of the data to be stored/transmitted Byte - Value 0 - 15 NULL */
#define FCANMB_GET_DATA_LENGTH          /* Get length of the data to be stored/transmitted NULL   Byte         */
#define FCANMB_SET_TIME_STAMP           /* Set Free-Running Counter Time stamp. Word - Value 0 - 65535 NULL    */
#define FCANMB_GET_TIME_STAMP           /* Get Free-Running Counter Time stamp. NULL              word         */
#define FCANMB_RTR                      /* Enable/Disable Remote Transmission Request FCANMB_DISABLE,FCANMB_ENABLE NULL */
#define FCANMB_GET_RTR                  /* Get Remote Transmission Request NULL                   Bool         */
#define FCANMB_SET_LOCAL_PRIO           /* Set Local priority            Byte - Value 0 - 7       NULL         */
#define FCANMB_GET_LOCAL_PRIO           /* Get local priority            NULL                     Byte         */
#define FCANMB_SET_ID_STD               /* Set standard identifier of message buffer Word - Value 0x0 - 0x7FF NULL */
#define FCANMB_GET_ID_STD               /* Get standard identifier of message buffer NULL         word         */
#define FCANMB_SET_ID_EXT               /* Set extended identifier of message buffer UWord32 - Value 0x0 - 0x1FFFFFFF NULL */
#define FCANMB_GET_ID_EXT               /* Get extended identifier of message buffer NULL         UWord32      */
#define FCANMB_SET_DATA_WORD0           /* Write Message Buffer WORD0 Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCANMB_GET_DATA_WORD0           /* Read Message Buffer WORD0 Register NULL                UWord32      */
#define FCANMB_SET_DATA_WORD1           /* Write Message Buffer WORD1 Register UWord32 - Value 0x0 - 0xFFFFFFFF NULL */
#define FCANMB_GET_DATA_WORD1           /* Read Message Buffer WORD1 Register NULL                UWord32      */

/***********************************************************************************************************
** CAN PARAMETERS DEFINITION                                                                        **
***********************************************************************************************************/
#define FCAN_DISABLE                              0x00UL
#define FCAN_ENABLE                               0x01UL
#define FCAN_USER                                 0x00UL
#define FCAN_SUPERVISOR                           0x01UL
#define FCAN_UNFILTRED_RX                         0x00UL
#define FCAN_FILTRED_RX                           0x01UL
#define FCAN_FORMAT_A                             0x00UL
#define FCAN_FORMAT_B                             0x01UL
#define FCAN_FORMAT_C                             0x02UL
#define FCAN_FORMAT_D                             0x03UL
#define FCAN_RJW_1                                0x00UL
#define FCAN_RJW_2                                0x01UL
#define FCAN_RJW_3                                0x02UL
#define FCAN_RJW_4                                0x03UL
#define FCAN_PSEG_1                               0x00UL
#define FCAN_PSEG_2                               0x01UL
#define FCAN_PSEG_3                               0x02UL
#define FCAN_PSEG_4                               0x03UL
#define FCAN_PSEG_5                               0x04UL
#define FCAN_PSEG_6                               0x05UL
#define FCAN_PSEG_7                               0x06UL
#define FCAN_PSEG_8                               0x07UL
#define FCAN_OSCILLATOR_CLK                       0x00UL
#define FCAN_BUS_CLK                              0x01UL
#define FCAN_1SAMP_PER_BIT                        0x00UL
#define FCAN_3SAMPS_PER_BIT                       0x01UL
#define FCAN_LOWEST_ID                            0x00UL
#define FCAN_LOWEST_MB_NUMBER                     0x01UL
#define FCAN_PROPSEG_1                            0x00UL
#define FCAN_PROPSEG_2                            0x01UL
#define FCAN_PROPSEG_3                            0x02UL
#define FCAN_PROPSEG_4                            0x03UL
#define FCAN_PROPSEG_5                            0x04UL
#define FCAN_PROPSEG_6                            0x05UL
#define FCAN_PROPSEG_7                            0x06UL
#define FCAN_PROPSEG_8                            0x07UL
#define FCAN_ERROR_ACTIVE                         0x00UL
#define FCAN_ERROR_PASSIVE                        0x01UL
#define FCAN_BUS_OFF                              0x02UL
#define FCAN_MBINT_0                              0x01UL
#define FCAN_MBINT_1                              0x02UL
#define FCAN_MBINT_2                              0x04UL
#define FCAN_MBINT_3                              0x08UL
#define FCAN_MBINT_4                              0x10UL
#define FCAN_MBINT_5                              0x20UL
#define FCAN_MBINT_6                              0x40UL
#define FCAN_MBINT_7                              0x80UL
#define FCAN_MBINT_8                              0x100UL
#define FCAN_MBINT_9                              0x200UL
#define FCAN_MBINT_10                             0x400UL
#define FCAN_MBINT_11                             0x800UL
#define FCAN_MBINT_12                             0x1000UL
#define FCAN_MBINT_13                             0x2000UL
#define FCAN_MBINT_14                             0x4000UL
#define FCAN_MBINT_15                             0x8000UL
#define FCAN_MBINT_16                             0x10000UL
#define FCAN_MBINT_17                             0x20000UL
#define FCAN_MBINT_18                             0x40000UL
#define FCAN_MBINT_19                             0x80000UL
#define FCAN_MBINT_20                             0x100000UL
#define FCAN_MBINT_21                             0x200000UL
#define FCAN_MBINT_22                             0x400000UL
#define FCAN_MBINT_23                             0x800000UL
#define FCAN_MBINT_24                             0x1000000UL
#define FCAN_MBINT_25                             0x2000000UL
#define FCAN_MBINT_26                             0x4000000UL
#define FCAN_MBINT_27                             0x8000000UL
#define FCAN_MBINT_28                             0x10000000UL
#define FCAN_MBINT_29                             0x20000000UL
#define FCAN_MBINT_30                             0x40000000UL
#define FCAN_MBINT_31                             0x80000000UL
#define FCAN_MAILBOXES_START                      0x00UL
#define FCAN_RX_FIFO_START                        0x01UL
#define FCAN_GENERATED                            0x00UL
#define FCAN_STORED                               0x01UL
#define FCANMB_RX_NOT_ACTIVE                      0x00UL
#define FCANMB_RX_EMPTY                           0x04UL
#define FCANMB_RX_FULL                            0x02UL
#define FCANMB_RX_OVERRUN                         0x06UL
#define FCANMB_RX_RANSWER                         0x0AUL
#define FCANMB_RX_BUSY                            0x01UL
#define FCANMB_TX_NOT_ACTIVE                      0x08UL
#define FCANMB_TX_ABORT                           0x09UL
#define FCANMB_TX_DATA_FRAME                      0x0CUL
#define FCANMB_TX_TANSWER                         0x0EUL
#define FCANMB_DISABLE                            0x00UL
#define FCANMB_ENABLE                             0x01UL
#define FCANMB_STANDARD                           0x00UL
#define FCANMB_EXTENDED                           CAN_CS0_IDE

/***********************************************************************************************************
** CAN REGISTER BIT MASKS DEFINITION                                                                **
***********************************************************************************************************/
/* Masks for registers MCR */
#define CAN_MCR_MASK                                   0xFFFF337FUL
#define CAN_MCR_MDIS                                   0x80000000UL
#define CAN_MCR_FRZ                                    0x40000000UL
#define CAN_MCR_RFEN                                   0x20000000UL
#define CAN_MCR_HALT                                   0x10000000UL
#define CAN_MCR_NOTRDY                                 0x8000000UL
#define CAN_MCR_WAKMSK                                 0x4000000UL
#define CAN_MCR_SOFTRST                                0x2000000UL
#define CAN_MCR_FRZACK                                 0x1000000UL
#define CAN_MCR_SUPV                                   0x800000UL
#define CAN_MCR_SLFWAK                                 0x400000UL
#define CAN_MCR_WRNEN                                  0x200000UL
#define CAN_MCR_LPMACK                                 0x100000UL
#define CAN_MCR_WAKSRC                                 0x80000UL
#define CAN_MCR_DOZE                                   0x40000UL
#define CAN_MCR_SRXDIS                                 0x20000UL
#define CAN_MCR_IRMQ                                   0x10000UL
#define CAN_MCR_LPRIOEN                                0x2000UL
#define CAN_MCR_AEN                                    0x1000UL
#define CAN_MCR_IDAM1                                  0x0200UL
#define CAN_MCR_IDAM0                                  0x0100UL
#define CAN_MCR_IDAM                                   0x0300UL
#define CAN_MCR_MAXMB6                                 0x0040UL
#define CAN_MCR_MAXMB5                                 0x0020UL
#define CAN_MCR_MAXMB4                                 0x0010UL
#define CAN_MCR_MAXMB3                                 0x0008UL
#define CAN_MCR_MAXMB2                                 0x0004UL
#define CAN_MCR_MAXMB1                                 0x0002UL
#define CAN_MCR_MAXMB0                                 0x0001UL
#define CAN_MCR_MAXMB                                  0x007FUL

/* Masks for registers CTRL1 */
#define CAN_CTRL1_MASK                                 0xFFFFFCFFUL
#define CAN_CTRL1_PRESDIV7                             0x80000000UL
#define CAN_CTRL1_PRESDIV6                             0x40000000UL
#define CAN_CTRL1_PRESDIV5                             0x20000000UL
#define CAN_CTRL1_PRESDIV4                             0x10000000UL
#define CAN_CTRL1_PRESDIV3                             0x8000000UL
#define CAN_CTRL1_PRESDIV2                             0x4000000UL
#define CAN_CTRL1_PRESDIV1                             0x2000000UL
#define CAN_CTRL1_PRESDIV0                             0x1000000UL
#define CAN_CTRL1_PRESDIV                              0xFF000000UL
#define CAN_CTRL1_RJW1                                 0x800000UL
#define CAN_CTRL1_RJW0                                 0x400000UL
#define CAN_CTRL1_RJW                                  0xC00000UL
#define CAN_CTRL1_PSEG12                               0x200000UL
#define CAN_CTRL1_PSEG11                               0x100000UL
#define CAN_CTRL1_PSEG10                               0x80000UL
#define CAN_CTRL1_PSEG1                                0x380000UL
#define CAN_CTRL1_PSEG22                               0x40000UL
#define CAN_CTRL1_PSEG21                               0x20000UL
#define CAN_CTRL1_PSEG20                               0x10000UL
#define CAN_CTRL1_PSEG2                                0x70000UL
#define CAN_CTRL1_BOFFMSK                              0x8000UL
#define CAN_CTRL1_ERRMSK                               0x4000UL
#define CAN_CTRL1_CLKSRC                               0x2000UL
#define CAN_CTRL1_LPB                                  0x1000UL
#define CAN_CTRL1_TWRNMSK                              0x0800UL
#define CAN_CTRL1_RWRNMSK                              0x0400UL
#define CAN_CTRL1_SMP                                  0x0080UL
#define CAN_CTRL1_BOFFREC                              0x0040UL
#define CAN_CTRL1_TSYN                                 0x0020UL
#define CAN_CTRL1_LBUF                                 0x0010UL
#define CAN_CTRL1_LOM                                  0x0008UL
#define CAN_CTRL1_PROPSEG2                             0x0004UL
#define CAN_CTRL1_PROPSEG1                             0x0002UL
#define CAN_CTRL1_PROPSEG0                             0x0001UL
#define CAN_CTRL1_PROPSEG                              0x0007UL

/* Masks for registers TIMER */
#define CAN_TIMER_MASK                                 0xFFFFUL
#define CAN_TIMER_TIMER15                              0x8000UL
#define CAN_TIMER_TIMER14                              0x4000UL
#define CAN_TIMER_TIMER13                              0x2000UL
#define CAN_TIMER_TIMER12                              0x1000UL
#define CAN_TIMER_TIMER11                              0x0800UL
#define CAN_TIMER_TIMER10                              0x0400UL
#define CAN_TIMER_TIMER9                               0x0200UL
#define CAN_TIMER_TIMER8                               0x0100UL
#define CAN_TIMER_TIMER7                               0x0080UL
#define CAN_TIMER_TIMER6                               0x0040UL
#define CAN_TIMER_TIMER5                               0x0020UL
#define CAN_TIMER_TIMER4                               0x0010UL
#define CAN_TIMER_TIMER3                               0x0008UL
#define CAN_TIMER_TIMER2                               0x0004UL
#define CAN_TIMER_TIMER1                               0x0002UL
#define CAN_TIMER_TIMER0                               0x0001UL
#define CAN_TIMER_TIMER                                0xFFFFUL

/* Masks for registers RXMGMASK */
#define CAN_RXMGMASK_MASK                              0xFFFFFFFFUL
#define CAN_RXMGMASK_MG31                              0x80000000UL
#define CAN_RXMGMASK_MG30                              0x40000000UL
#define CAN_RXMGMASK_MG29                              0x20000000UL
#define CAN_RXMGMASK_MG28                              0x10000000UL
#define CAN_RXMGMASK_MG27                              0x8000000UL
#define CAN_RXMGMASK_MG26                              0x4000000UL
#define CAN_RXMGMASK_MG25                              0x2000000UL
#define CAN_RXMGMASK_MG24                              0x1000000UL
#define CAN_RXMGMASK_MG23                              0x800000UL
#define CAN_RXMGMASK_MG22                              0x400000UL
#define CAN_RXMGMASK_MG21                              0x200000UL
#define CAN_RXMGMASK_MG20                              0x100000UL
#define CAN_RXMGMASK_MG19                              0x80000UL
#define CAN_RXMGMASK_MG18                              0x40000UL
#define CAN_RXMGMASK_MG17                              0x20000UL
#define CAN_RXMGMASK_MG16                              0x10000UL
#define CAN_RXMGMASK_MG15                              0x8000UL
#define CAN_RXMGMASK_MG14                              0x4000UL
#define CAN_RXMGMASK_MG13                              0x2000UL
#define CAN_RXMGMASK_MG12                              0x1000UL
#define CAN_RXMGMASK_MG11                              0x0800UL
#define CAN_RXMGMASK_MG10                              0x0400UL
#define CAN_RXMGMASK_MG9                               0x0200UL
#define CAN_RXMGMASK_MG8                               0x0100UL
#define CAN_RXMGMASK_MG7                               0x0080UL
#define CAN_RXMGMASK_MG6                               0x0040UL
#define CAN_RXMGMASK_MG5                               0x0020UL
#define CAN_RXMGMASK_MG4                               0x0010UL
#define CAN_RXMGMASK_MG3                               0x0008UL
#define CAN_RXMGMASK_MG2                               0x0004UL
#define CAN_RXMGMASK_MG1                               0x0002UL
#define CAN_RXMGMASK_MG0                               0x0001UL
#define CAN_RXMGMASK_MG                                0xFFFFFFFFUL

/* Masks for registers RX14MASK */
#define CAN_RX14MASK_MASK                              0xFFFFFFFFUL
#define CAN_RX14MASK_RX14M31                           0x80000000UL
#define CAN_RX14MASK_RX14M30                           0x40000000UL
#define CAN_RX14MASK_RX14M29                           0x20000000UL
#define CAN_RX14MASK_RX14M28                           0x10000000UL
#define CAN_RX14MASK_RX14M27                           0x8000000UL
#define CAN_RX14MASK_RX14M26                           0x4000000UL
#define CAN_RX14MASK_RX14M25                           0x2000000UL
#define CAN_RX14MASK_RX14M24                           0x1000000UL
#define CAN_RX14MASK_RX14M23                           0x800000UL
#define CAN_RX14MASK_RX14M22                           0x400000UL
#define CAN_RX14MASK_RX14M21                           0x200000UL
#define CAN_RX14MASK_RX14M20                           0x100000UL
#define CAN_RX14MASK_RX14M19                           0x80000UL
#define CAN_RX14MASK_RX14M18                           0x40000UL
#define CAN_RX14MASK_RX14M17                           0x20000UL
#define CAN_RX14MASK_RX14M16                           0x10000UL
#define CAN_RX14MASK_RX14M15                           0x8000UL
#define CAN_RX14MASK_RX14M14                           0x4000UL
#define CAN_RX14MASK_RX14M13                           0x2000UL
#define CAN_RX14MASK_RX14M12                           0x1000UL
#define CAN_RX14MASK_RX14M11                           0x0800UL
#define CAN_RX14MASK_RX14M10                           0x0400UL
#define CAN_RX14MASK_RX14M9                            0x0200UL
#define CAN_RX14MASK_RX14M8                            0x0100UL
#define CAN_RX14MASK_RX14M7                            0x0080UL
#define CAN_RX14MASK_RX14M6                            0x0040UL
#define CAN_RX14MASK_RX14M5                            0x0020UL
#define CAN_RX14MASK_RX14M4                            0x0010UL
#define CAN_RX14MASK_RX14M3                            0x0008UL
#define CAN_RX14MASK_RX14M2                            0x0004UL
#define CAN_RX14MASK_RX14M1                            0x0002UL
#define CAN_RX14MASK_RX14M0                            0x0001UL
#define CAN_RX14MASK_RX14M                             0xFFFFFFFFUL

/* Masks for registers RX15MASK */
#define CAN_RX15MASK_MASK                              0xFFFFFFFFUL
#define CAN_RX15MASK_RX15M31                           0x80000000UL
#define CAN_RX15MASK_RX15M30                           0x40000000UL
#define CAN_RX15MASK_RX15M29                           0x20000000UL
#define CAN_RX15MASK_RX15M28                           0x10000000UL
#define CAN_RX15MASK_RX15M27                           0x8000000UL
#define CAN_RX15MASK_RX15M26                           0x4000000UL
#define CAN_RX15MASK_RX15M25                           0x2000000UL
#define CAN_RX15MASK_RX15M24                           0x1000000UL
#define CAN_RX15MASK_RX15M23                           0x800000UL
#define CAN_RX15MASK_RX15M22                           0x400000UL
#define CAN_RX15MASK_RX15M21                           0x200000UL
#define CAN_RX15MASK_RX15M20                           0x100000UL
#define CAN_RX15MASK_RX15M19                           0x80000UL
#define CAN_RX15MASK_RX15M18                           0x40000UL
#define CAN_RX15MASK_RX15M17                           0x20000UL
#define CAN_RX15MASK_RX15M16                           0x10000UL
#define CAN_RX15MASK_RX15M15                           0x8000UL
#define CAN_RX15MASK_RX15M14                           0x4000UL
#define CAN_RX15MASK_RX15M13                           0x2000UL
#define CAN_RX15MASK_RX15M12                           0x1000UL
#define CAN_RX15MASK_RX15M11                           0x0800UL
#define CAN_RX15MASK_RX15M10                           0x0400UL
#define CAN_RX15MASK_RX15M9                            0x0200UL
#define CAN_RX15MASK_RX15M8                            0x0100UL
#define CAN_RX15MASK_RX15M7                            0x0080UL
#define CAN_RX15MASK_RX15M6                            0x0040UL
#define CAN_RX15MASK_RX15M5                            0x0020UL
#define CAN_RX15MASK_RX15M4                            0x0010UL
#define CAN_RX15MASK_RX15M3                            0x0008UL
#define CAN_RX15MASK_RX15M2                            0x0004UL
#define CAN_RX15MASK_RX15M1                            0x0002UL
#define CAN_RX15MASK_RX15M0                            0x0001UL
#define CAN_RX15MASK_RX15M                             0xFFFFFFFFUL

/* Masks for registers ECR */
#define CAN_ECR_MASK                                   0xFFFFUL
#define CAN_ECR_RXERRCNT7                              0x8000UL
#define CAN_ECR_RXERRCNT6                              0x4000UL
#define CAN_ECR_RXERRCNT5                              0x2000UL
#define CAN_ECR_RXERRCNT4                              0x1000UL
#define CAN_ECR_RXERRCNT3                              0x0800UL
#define CAN_ECR_RXERRCNT2                              0x0400UL
#define CAN_ECR_RXERRCNT1                              0x0200UL
#define CAN_ECR_RXERRCNT0                              0x0100UL
#define CAN_ECR_RXERRCNT                               0xFF00UL
#define CAN_ECR_TXERRCNT7                              0x0080UL
#define CAN_ECR_TXERRCNT6                              0x0040UL
#define CAN_ECR_TXERRCNT5                              0x0020UL
#define CAN_ECR_TXERRCNT4                              0x0010UL
#define CAN_ECR_TXERRCNT3                              0x0008UL
#define CAN_ECR_TXERRCNT2                              0x0004UL
#define CAN_ECR_TXERRCNT1                              0x0002UL
#define CAN_ECR_TXERRCNT0                              0x0001UL
#define CAN_ECR_TXERRCNT                               0x00FFUL

/* Masks for registers ESR1 */
#define CAN_ESR1_MASK                                  0x7FFFFUL
#define CAN_ESR1_SYNCH                                 0x40000UL
#define CAN_ESR1_TWRNINT                               0x20000UL
#define CAN_ESR1_RWRNINT                               0x10000UL
#define CAN_ESR1_BIT1ERR                               0x8000UL
#define CAN_ESR1_BIT0ERR                               0x4000UL
#define CAN_ESR1_ACKERR                                0x2000UL
#define CAN_ESR1_CRCERR                                0x1000UL
#define CAN_ESR1_FRMERR                                0x0800UL
#define CAN_ESR1_STFERR                                0x0400UL
#define CAN_ESR1_TXWRN                                 0x0200UL
#define CAN_ESR1_RXWRN                                 0x0100UL
#define CAN_ESR1_IDLE                                  0x0080UL
#define CAN_ESR1_TX                                    0x0040UL
#define CAN_ESR1_FLTCONF1                              0x0020UL
#define CAN_ESR1_FLTCONF0                              0x0010UL
#define CAN_ESR1_FLTCONF                               0x0030UL
#define CAN_ESR1_RX                                    0x0008UL
#define CAN_ESR1_BOFFINT                               0x0004UL
#define CAN_ESR1_ERRINT                                0x0002UL
#define CAN_ESR1_WAKINT                                0x0001UL

/* Masks for registers IMASK2 */
#define CAN_IMASK2_MASK                                0xFFFFFFFFUL
#define CAN_IMASK2_BUFHM31                             0x80000000UL
#define CAN_IMASK2_BUFHM30                             0x40000000UL
#define CAN_IMASK2_BUFHM29                             0x20000000UL
#define CAN_IMASK2_BUFHM28                             0x10000000UL
#define CAN_IMASK2_BUFHM27                             0x8000000UL
#define CAN_IMASK2_BUFHM26                             0x4000000UL
#define CAN_IMASK2_BUFHM25                             0x2000000UL
#define CAN_IMASK2_BUFHM24                             0x1000000UL
#define CAN_IMASK2_BUFHM23                             0x800000UL
#define CAN_IMASK2_BUFHM22                             0x400000UL
#define CAN_IMASK2_BUFHM21                             0x200000UL
#define CAN_IMASK2_BUFHM20                             0x100000UL
#define CAN_IMASK2_BUFHM19                             0x80000UL
#define CAN_IMASK2_BUFHM18                             0x40000UL
#define CAN_IMASK2_BUFHM17                             0x20000UL
#define CAN_IMASK2_BUFHM16                             0x10000UL
#define CAN_IMASK2_BUFHM15                             0x8000UL
#define CAN_IMASK2_BUFHM14                             0x4000UL
#define CAN_IMASK2_BUFHM13                             0x2000UL
#define CAN_IMASK2_BUFHM12                             0x1000UL
#define CAN_IMASK2_BUFHM11                             0x0800UL
#define CAN_IMASK2_BUFHM10                             0x0400UL
#define CAN_IMASK2_BUFHM9                              0x0200UL
#define CAN_IMASK2_BUFHM8                              0x0100UL
#define CAN_IMASK2_BUFHM7                              0x0080UL
#define CAN_IMASK2_BUFHM6                              0x0040UL
#define CAN_IMASK2_BUFHM5                              0x0020UL
#define CAN_IMASK2_BUFHM4                              0x0010UL
#define CAN_IMASK2_BUFHM3                              0x0008UL
#define CAN_IMASK2_BUFHM2                              0x0004UL
#define CAN_IMASK2_BUFHM1                              0x0002UL
#define CAN_IMASK2_BUFHM0                              0x0001UL
#define CAN_IMASK2_BUFHM                               0xFFFFFFFFUL

/* Masks for registers IMASK1 */
#define CAN_IMASK1_MASK                                0xFFFFFFFFUL
#define CAN_IMASK1_BUFLM31                             0x80000000UL
#define CAN_IMASK1_BUFLM30                             0x40000000UL
#define CAN_IMASK1_BUFLM29                             0x20000000UL
#define CAN_IMASK1_BUFLM28                             0x10000000UL
#define CAN_IMASK1_BUFLM27                             0x8000000UL
#define CAN_IMASK1_BUFLM26                             0x4000000UL
#define CAN_IMASK1_BUFLM25                             0x2000000UL
#define CAN_IMASK1_BUFLM24                             0x1000000UL
#define CAN_IMASK1_BUFLM23                             0x800000UL
#define CAN_IMASK1_BUFLM22                             0x400000UL
#define CAN_IMASK1_BUFLM21                             0x200000UL
#define CAN_IMASK1_BUFLM20                             0x100000UL
#define CAN_IMASK1_BUFLM19                             0x80000UL
#define CAN_IMASK1_BUFLM18                             0x40000UL
#define CAN_IMASK1_BUFLM17                             0x20000UL
#define CAN_IMASK1_BUFLM16                             0x10000UL
#define CAN_IMASK1_BUFLM15                             0x8000UL
#define CAN_IMASK1_BUFLM14                             0x4000UL
#define CAN_IMASK1_BUFLM13                             0x2000UL
#define CAN_IMASK1_BUFLM12                             0x1000UL
#define CAN_IMASK1_BUFLM11                             0x0800UL
#define CAN_IMASK1_BUFLM10                             0x0400UL
#define CAN_IMASK1_BUFLM9                              0x0200UL
#define CAN_IMASK1_BUFLM8                              0x0100UL
#define CAN_IMASK1_BUFLM7                              0x0080UL
#define CAN_IMASK1_BUFLM6                              0x0040UL
#define CAN_IMASK1_BUFLM5                              0x0020UL
#define CAN_IMASK1_BUFLM4                              0x0010UL
#define CAN_IMASK1_BUFLM3                              0x0008UL
#define CAN_IMASK1_BUFLM2                              0x0004UL
#define CAN_IMASK1_BUFLM1                              0x0002UL
#define CAN_IMASK1_BUFLM0                              0x0001UL
#define CAN_IMASK1_BUFLM                               0xFFFFFFFFUL

/* Masks for registers IFLAG2 */
#define CAN_IFLAG2_MASK                                0xFFFFFFFFUL
#define CAN_IFLAG2_BUFHI31                             0x80000000UL
#define CAN_IFLAG2_BUFHI30                             0x40000000UL
#define CAN_IFLAG2_BUFHI29                             0x20000000UL
#define CAN_IFLAG2_BUFHI28                             0x10000000UL
#define CAN_IFLAG2_BUFHI27                             0x8000000UL
#define CAN_IFLAG2_BUFHI26                             0x4000000UL
#define CAN_IFLAG2_BUFHI25                             0x2000000UL
#define CAN_IFLAG2_BUFHI24                             0x1000000UL
#define CAN_IFLAG2_BUFHI23                             0x800000UL
#define CAN_IFLAG2_BUFHI22                             0x400000UL
#define CAN_IFLAG2_BUFHI21                             0x200000UL
#define CAN_IFLAG2_BUFHI20                             0x100000UL
#define CAN_IFLAG2_BUFHI19                             0x80000UL
#define CAN_IFLAG2_BUFHI18                             0x40000UL
#define CAN_IFLAG2_BUFHI17                             0x20000UL
#define CAN_IFLAG2_BUFHI16                             0x10000UL
#define CAN_IFLAG2_BUFHI15                             0x8000UL
#define CAN_IFLAG2_BUFHI14                             0x4000UL
#define CAN_IFLAG2_BUFHI13                             0x2000UL
#define CAN_IFLAG2_BUFHI12                             0x1000UL
#define CAN_IFLAG2_BUFHI11                             0x0800UL
#define CAN_IFLAG2_BUFHI10                             0x0400UL
#define CAN_IFLAG2_BUFHI9                              0x0200UL
#define CAN_IFLAG2_BUFHI8                              0x0100UL
#define CAN_IFLAG2_BUFHI7                              0x0080UL
#define CAN_IFLAG2_BUFHI6                              0x0040UL
#define CAN_IFLAG2_BUFHI5                              0x0020UL
#define CAN_IFLAG2_BUFHI4                              0x0010UL
#define CAN_IFLAG2_BUFHI3                              0x0008UL
#define CAN_IFLAG2_BUFHI2                              0x0004UL
#define CAN_IFLAG2_BUFHI1                              0x0002UL
#define CAN_IFLAG2_BUFHI0                              0x0001UL
#define CAN_IFLAG2_BUFHI                               0xFFFFFFFFUL

/* Masks for registers IFLAG1 */
#define CAN_IFLAG1_MASK                                0xFFFFFFFFUL
#define CAN_IFLAG1_BUF31TO8I23                         0x80000000UL
#define CAN_IFLAG1_BUF31TO8I22                         0x40000000UL
#define CAN_IFLAG1_BUF31TO8I21                         0x20000000UL
#define CAN_IFLAG1_BUF31TO8I20                         0x10000000UL
#define CAN_IFLAG1_BUF31TO8I19                         0x8000000UL
#define CAN_IFLAG1_BUF31TO8I18                         0x4000000UL
#define CAN_IFLAG1_BUF31TO8I17                         0x2000000UL
#define CAN_IFLAG1_BUF31TO8I16                         0x1000000UL
#define CAN_IFLAG1_BUF31TO8I15                         0x800000UL
#define CAN_IFLAG1_BUF31TO8I14                         0x400000UL
#define CAN_IFLAG1_BUF31TO8I13                         0x200000UL
#define CAN_IFLAG1_BUF31TO8I12                         0x100000UL
#define CAN_IFLAG1_BUF31TO8I11                         0x80000UL
#define CAN_IFLAG1_BUF31TO8I10                         0x40000UL
#define CAN_IFLAG1_BUF31TO8I9                          0x20000UL
#define CAN_IFLAG1_BUF31TO8I8                          0x10000UL
#define CAN_IFLAG1_BUF31TO8I7                          0x8000UL
#define CAN_IFLAG1_BUF31TO8I6                          0x4000UL
#define CAN_IFLAG1_BUF31TO8I5                          0x2000UL
#define CAN_IFLAG1_BUF31TO8I4                          0x1000UL
#define CAN_IFLAG1_BUF31TO8I3                          0x0800UL
#define CAN_IFLAG1_BUF31TO8I2                          0x0400UL
#define CAN_IFLAG1_BUF31TO8I1                          0x0200UL
#define CAN_IFLAG1_BUF31TO8I0                          0x0100UL
#define CAN_IFLAG1_BUF31TO8I                           0xFFFFFF00UL
#define CAN_IFLAG1_BUF7I                               0x0080UL
#define CAN_IFLAG1_BUF6I                               0x0040UL
#define CAN_IFLAG1_BUF5I                               0x0020UL
#define CAN_IFLAG1_BUF4TO0I4                           0x0010UL
#define CAN_IFLAG1_BUF4TO0I3                           0x0008UL
#define CAN_IFLAG1_BUF4TO0I2                           0x0004UL
#define CAN_IFLAG1_BUF4TO0I1                           0x0002UL
#define CAN_IFLAG1_BUF4TO0I0                           0x0001UL
#define CAN_IFLAG1_BUF4TO0I                            0x001FUL

/* Masks for registers CTRL2 */
#define CAN_CTRL2_MASK                                 0x1FFF0000UL
#define CAN_CTRL2_WRMFRZ                               0x10000000UL
#define CAN_CTRL2_RFFN3                                0x8000000UL
#define CAN_CTRL2_RFFN2                                0x4000000UL
#define CAN_CTRL2_RFFN1                                0x2000000UL
#define CAN_CTRL2_RFFN0                                0x1000000UL
#define CAN_CTRL2_RFFN                                 0xF000000UL
#define CAN_CTRL2_TASD4                                0x800000UL
#define CAN_CTRL2_TASD3                                0x400000UL
#define CAN_CTRL2_TASD2                                0x200000UL
#define CAN_CTRL2_TASD1                                0x100000UL
#define CAN_CTRL2_TASD0                                0x80000UL
#define CAN_CTRL2_TASD                                 0xF80000UL
#define CAN_CTRL2_MRP                                  0x40000UL
#define CAN_CTRL2_RRS                                  0x20000UL
#define CAN_CTRL2_EACEN                                0x10000UL

/* Masks for registers ESR2 */
#define CAN_ESR2_MASK                                  0x7F6000UL
#define CAN_ESR2_LPTM6                                 0x400000UL
#define CAN_ESR2_LPTM5                                 0x200000UL
#define CAN_ESR2_LPTM4                                 0x100000UL
#define CAN_ESR2_LPTM3                                 0x80000UL
#define CAN_ESR2_LPTM2                                 0x40000UL
#define CAN_ESR2_LPTM1                                 0x20000UL
#define CAN_ESR2_LPTM0                                 0x10000UL
#define CAN_ESR2_LPTM                                  0x7F0000UL
#define CAN_ESR2_VPS                                   0x4000UL
#define CAN_ESR2_IMB                                   0x2000UL

/* Masks for registers CRCR */
#define CAN_CRCR_MASK                                  0x7F7FFFUL
#define CAN_CRCR_MBCRC6                                0x400000UL
#define CAN_CRCR_MBCRC5                                0x200000UL
#define CAN_CRCR_MBCRC4                                0x100000UL
#define CAN_CRCR_MBCRC3                                0x80000UL
#define CAN_CRCR_MBCRC2                                0x40000UL
#define CAN_CRCR_MBCRC1                                0x20000UL
#define CAN_CRCR_MBCRC0                                0x10000UL
#define CAN_CRCR_MBCRC                                 0x7F0000UL
#define CAN_CRCR_TXCRC14                               0x4000UL
#define CAN_CRCR_TXCRC13                               0x2000UL
#define CAN_CRCR_TXCRC12                               0x1000UL
#define CAN_CRCR_TXCRC11                               0x0800UL
#define CAN_CRCR_TXCRC10                               0x0400UL
#define CAN_CRCR_TXCRC9                                0x0200UL
#define CAN_CRCR_TXCRC8                                0x0100UL
#define CAN_CRCR_TXCRC7                                0x0080UL
#define CAN_CRCR_TXCRC6                                0x0040UL
#define CAN_CRCR_TXCRC5                                0x0020UL
#define CAN_CRCR_TXCRC4                                0x0010UL
#define CAN_CRCR_TXCRC3                                0x0008UL
#define CAN_CRCR_TXCRC2                                0x0004UL
#define CAN_CRCR_TXCRC1                                0x0002UL
#define CAN_CRCR_TXCRC0                                0x0001UL
#define CAN_CRCR_TXCRC                                 0x7FFFUL

/* Masks for registers RXFGMASK */
#define CAN_RXFGMASK_MASK                              0xFFFFFFFFUL
#define CAN_RXFGMASK_FGM31                             0x80000000UL
#define CAN_RXFGMASK_FGM30                             0x40000000UL
#define CAN_RXFGMASK_FGM29                             0x20000000UL
#define CAN_RXFGMASK_FGM28                             0x10000000UL
#define CAN_RXFGMASK_FGM27                             0x8000000UL
#define CAN_RXFGMASK_FGM26                             0x4000000UL
#define CAN_RXFGMASK_FGM25                             0x2000000UL
#define CAN_RXFGMASK_FGM24                             0x1000000UL
#define CAN_RXFGMASK_FGM23                             0x800000UL
#define CAN_RXFGMASK_FGM22                             0x400000UL
#define CAN_RXFGMASK_FGM21                             0x200000UL
#define CAN_RXFGMASK_FGM20                             0x100000UL
#define CAN_RXFGMASK_FGM19                             0x80000UL
#define CAN_RXFGMASK_FGM18                             0x40000UL
#define CAN_RXFGMASK_FGM17                             0x20000UL
#define CAN_RXFGMASK_FGM16                             0x10000UL
#define CAN_RXFGMASK_FGM15                             0x8000UL
#define CAN_RXFGMASK_FGM14                             0x4000UL
#define CAN_RXFGMASK_FGM13                             0x2000UL
#define CAN_RXFGMASK_FGM12                             0x1000UL
#define CAN_RXFGMASK_FGM11                             0x0800UL
#define CAN_RXFGMASK_FGM10                             0x0400UL
#define CAN_RXFGMASK_FGM9                              0x0200UL
#define CAN_RXFGMASK_FGM8                              0x0100UL
#define CAN_RXFGMASK_FGM7                              0x0080UL
#define CAN_RXFGMASK_FGM6                              0x0040UL
#define CAN_RXFGMASK_FGM5                              0x0020UL
#define CAN_RXFGMASK_FGM4                              0x0010UL
#define CAN_RXFGMASK_FGM3                              0x0008UL
#define CAN_RXFGMASK_FGM2                              0x0004UL
#define CAN_RXFGMASK_FGM1                              0x0002UL
#define CAN_RXFGMASK_FGM0                              0x0001UL
#define CAN_RXFGMASK_FGM                               0xFFFFFFFFUL

/* Masks for registers RXFIR */
#define CAN_RXFIR_MASK                                 0x1FFUL
#define CAN_RXFIR_IDHIT8                               0x0100UL
#define CAN_RXFIR_IDHIT7                               0x0080UL
#define CAN_RXFIR_IDHIT6                               0x0040UL
#define CAN_RXFIR_IDHIT5                               0x0020UL
#define CAN_RXFIR_IDHIT4                               0x0010UL
#define CAN_RXFIR_IDHIT3                               0x0008UL
#define CAN_RXFIR_IDHIT2                               0x0004UL
#define CAN_RXFIR_IDHIT1                               0x0002UL
#define CAN_RXFIR_IDHIT0                               0x0001UL
#define CAN_RXFIR_IDHIT                                0x01FFUL

/* Masks for registers CS0 */
#define CAN_CS0_MASK                                   0xF7FFFFFUL
#define CAN_CS0_CODE3                                  0x8000000UL
#define CAN_CS0_CODE2                                  0x4000000UL
#define CAN_CS0_CODE1                                  0x2000000UL
#define CAN_CS0_CODE0                                  0x1000000UL
#define CAN_CS0_CODE                                   0xF000000UL
#define CAN_CS0_SRR                                    0x400000UL
#define CAN_CS0_IDE                                    0x200000UL
#define CAN_CS0_RTR                                    0x100000UL
#define CAN_CS0_DLC3                                   0x80000UL
#define CAN_CS0_DLC2                                   0x40000UL
#define CAN_CS0_DLC1                                   0x20000UL
#define CAN_CS0_DLC0                                   0x10000UL
#define CAN_CS0_DLC                                    0xF0000UL
#define CAN_CS0_TIME_STAMP15                           0x8000UL
#define CAN_CS0_TIME_STAMP14                           0x4000UL
#define CAN_CS0_TIME_STAMP13                           0x2000UL
#define CAN_CS0_TIME_STAMP12                           0x1000UL
#define CAN_CS0_TIME_STAMP11                           0x0800UL
#define CAN_CS0_TIME_STAMP10                           0x0400UL
#define CAN_CS0_TIME_STAMP9                            0x0200UL
#define CAN_CS0_TIME_STAMP8                            0x0100UL
#define CAN_CS0_TIME_STAMP7                            0x0080UL
#define CAN_CS0_TIME_STAMP6                            0x0040UL
#define CAN_CS0_TIME_STAMP5                            0x0020UL
#define CAN_CS0_TIME_STAMP4                            0x0010UL
#define CAN_CS0_TIME_STAMP3                            0x0008UL
#define CAN_CS0_TIME_STAMP2                            0x0004UL
#define CAN_CS0_TIME_STAMP1                            0x0002UL
#define CAN_CS0_TIME_STAMP0                            0x0001UL
#define CAN_CS0_TIME_STAMP                             0xFFFFUL

/* Masks for registers ID0 */
#define CAN_ID0_MASK                                   0xFFFFFFFFUL
#define CAN_ID0_PRIO2                                  0x80000000UL
#define CAN_ID0_PRIO1                                  0x40000000UL
#define CAN_ID0_PRIO0                                  0x20000000UL
#define CAN_ID0_PRIO                                   0xE0000000UL
#define CAN_ID0_STD10                                  0x10000000UL
#define CAN_ID0_STD9                                   0x8000000UL
#define CAN_ID0_STD8                                   0x4000000UL
#define CAN_ID0_STD7                                   0x2000000UL
#define CAN_ID0_STD6                                   0x1000000UL
#define CAN_ID0_STD5                                   0x800000UL
#define CAN_ID0_STD4                                   0x400000UL
#define CAN_ID0_STD3                                   0x200000UL
#define CAN_ID0_STD2                                   0x100000UL
#define CAN_ID0_STD1                                   0x80000UL
#define CAN_ID0_STD0                                   0x40000UL
#define CAN_ID0_STD                                    0x1FFC0000UL
#define CAN_ID0_EXT17                                  0x20000UL
#define CAN_ID0_EXT16                                  0x10000UL
#define CAN_ID0_EXT15                                  0x8000UL
#define CAN_ID0_EXT14                                  0x4000UL
#define CAN_ID0_EXT13                                  0x2000UL
#define CAN_ID0_EXT12                                  0x1000UL
#define CAN_ID0_EXT11                                  0x0800UL
#define CAN_ID0_EXT10                                  0x0400UL
#define CAN_ID0_EXT9                                   0x0200UL
#define CAN_ID0_EXT8                                   0x0100UL
#define CAN_ID0_EXT7                                   0x0080UL
#define CAN_ID0_EXT6                                   0x0040UL
#define CAN_ID0_EXT5                                   0x0020UL
#define CAN_ID0_EXT4                                   0x0010UL
#define CAN_ID0_EXT3                                   0x0008UL
#define CAN_ID0_EXT2                                   0x0004UL
#define CAN_ID0_EXT1                                   0x0002UL
#define CAN_ID0_EXT0                                   0x0001UL
#define CAN_ID0_EXT                                    0x3FFFFUL

/* Masks for registers WORD00 */
#define CAN_WORD00_MASK                                0xFFFFFFFFUL
#define CAN_WORD00_DATA_BYTE_07                        0x80000000UL
#define CAN_WORD00_DATA_BYTE_06                        0x40000000UL
#define CAN_WORD00_DATA_BYTE_05                        0x20000000UL
#define CAN_WORD00_DATA_BYTE_04                        0x10000000UL
#define CAN_WORD00_DATA_BYTE_03                        0x8000000UL
#define CAN_WORD00_DATA_BYTE_02                        0x4000000UL
#define CAN_WORD00_DATA_BYTE_01                        0x2000000UL
#define CAN_WORD00_DATA_BYTE_00                        0x1000000UL
#define CAN_WORD00_DATA_BYTE_0                         0xFF000000UL
#define CAN_WORD00_DATA_BYTE_17                        0x800000UL
#define CAN_WORD00_DATA_BYTE_16                        0x400000UL
#define CAN_WORD00_DATA_BYTE_15                        0x200000UL
#define CAN_WORD00_DATA_BYTE_14                        0x100000UL
#define CAN_WORD00_DATA_BYTE_13                        0x80000UL
#define CAN_WORD00_DATA_BYTE_12                        0x40000UL
#define CAN_WORD00_DATA_BYTE_11                        0x20000UL
#define CAN_WORD00_DATA_BYTE_10                        0x10000UL
#define CAN_WORD00_DATA_BYTE_1                         0xFF0000UL
#define CAN_WORD00_DATA_BYTE_27                        0x8000UL
#define CAN_WORD00_DATA_BYTE_26                        0x4000UL
#define CAN_WORD00_DATA_BYTE_25                        0x2000UL
#define CAN_WORD00_DATA_BYTE_24                        0x1000UL
#define CAN_WORD00_DATA_BYTE_23                        0x0800UL
#define CAN_WORD00_DATA_BYTE_22                        0x0400UL
#define CAN_WORD00_DATA_BYTE_21                        0x0200UL
#define CAN_WORD00_DATA_BYTE_20                        0x0100UL
#define CAN_WORD00_DATA_BYTE_2                         0xFF00UL
#define CAN_WORD00_DATA_BYTE_37                        0x0080UL
#define CAN_WORD00_DATA_BYTE_36                        0x0040UL
#define CAN_WORD00_DATA_BYTE_35                        0x0020UL
#define CAN_WORD00_DATA_BYTE_34                        0x0010UL
#define CAN_WORD00_DATA_BYTE_33                        0x0008UL
#define CAN_WORD00_DATA_BYTE_32                        0x0004UL
#define CAN_WORD00_DATA_BYTE_31                        0x0002UL
#define CAN_WORD00_DATA_BYTE_30                        0x0001UL
#define CAN_WORD00_DATA_BYTE_3                         0x00FFUL

/* Masks for registers WORD10 */
#define CAN_WORD10_MASK                                0xFFFFFFFFUL
#define CAN_WORD10_DATA_BYTE_47                        0x80000000UL
#define CAN_WORD10_DATA_BYTE_46                        0x40000000UL
#define CAN_WORD10_DATA_BYTE_45                        0x20000000UL
#define CAN_WORD10_DATA_BYTE_44                        0x10000000UL
#define CAN_WORD10_DATA_BYTE_43                        0x8000000UL
#define CAN_WORD10_DATA_BYTE_42                        0x4000000UL
#define CAN_WORD10_DATA_BYTE_41                        0x2000000UL
#define CAN_WORD10_DATA_BYTE_40                        0x1000000UL
#define CAN_WORD10_DATA_BYTE_4                         0xFF000000UL
#define CAN_WORD10_DATA_BYTE_57                        0x800000UL
#define CAN_WORD10_DATA_BYTE_56                        0x400000UL
#define CAN_WORD10_DATA_BYTE_55                        0x200000UL
#define CAN_WORD10_DATA_BYTE_54                        0x100000UL
#define CAN_WORD10_DATA_BYTE_53                        0x80000UL
#define CAN_WORD10_DATA_BYTE_52                        0x40000UL
#define CAN_WORD10_DATA_BYTE_51                        0x20000UL
#define CAN_WORD10_DATA_BYTE_50                        0x10000UL
#define CAN_WORD10_DATA_BYTE_5                         0xFF0000UL
#define CAN_WORD10_DATA_BYTE_67                        0x8000UL
#define CAN_WORD10_DATA_BYTE_66                        0x4000UL
#define CAN_WORD10_DATA_BYTE_65                        0x2000UL
#define CAN_WORD10_DATA_BYTE_64                        0x1000UL
#define CAN_WORD10_DATA_BYTE_63                        0x0800UL
#define CAN_WORD10_DATA_BYTE_62                        0x0400UL
#define CAN_WORD10_DATA_BYTE_61                        0x0200UL
#define CAN_WORD10_DATA_BYTE_60                        0x0100UL
#define CAN_WORD10_DATA_BYTE_6                         0xFF00UL
#define CAN_WORD10_DATA_BYTE_77                        0x0080UL
#define CAN_WORD10_DATA_BYTE_76                        0x0040UL
#define CAN_WORD10_DATA_BYTE_75                        0x0020UL
#define CAN_WORD10_DATA_BYTE_74                        0x0010UL
#define CAN_WORD10_DATA_BYTE_73                        0x0008UL
#define CAN_WORD10_DATA_BYTE_72                        0x0004UL
#define CAN_WORD10_DATA_BYTE_71                        0x0002UL
#define CAN_WORD10_DATA_BYTE_70                        0x0001UL
#define CAN_WORD10_DATA_BYTE_7                         0x00FFUL

/* Masks for registers CS1 */
#define CAN_CS1_MASK                                   0xF7FFFFFUL
#define CAN_CS1_CODE3                                  0x8000000UL
#define CAN_CS1_CODE2                                  0x4000000UL
#define CAN_CS1_CODE1                                  0x2000000UL
#define CAN_CS1_CODE0                                  0x1000000UL
#define CAN_CS1_CODE                                   0xF000000UL
#define CAN_CS1_SRR                                    0x400000UL
#define CAN_CS1_IDE                                    0x200000UL
#define CAN_CS1_RTR                                    0x100000UL
#define CAN_CS1_DLC3                                   0x80000UL
#define CAN_CS1_DLC2                                   0x40000UL
#define CAN_CS1_DLC1                                   0x20000UL
#define CAN_CS1_DLC0                                   0x10000UL
#define CAN_CS1_DLC                                    0xF0000UL
#define CAN_CS1_TIME_STAMP15                           0x8000UL
#define CAN_CS1_TIME_STAMP14                           0x4000UL
#define CAN_CS1_TIME_STAMP13                           0x2000UL
#define CAN_CS1_TIME_STAMP12                           0x1000UL
#define CAN_CS1_TIME_STAMP11                           0x0800UL
#define CAN_CS1_TIME_STAMP10                           0x0400UL
#define CAN_CS1_TIME_STAMP9                            0x0200UL
#define CAN_CS1_TIME_STAMP8                            0x0100UL
#define CAN_CS1_TIME_STAMP7                            0x0080UL
#define CAN_CS1_TIME_STAMP6                            0x0040UL
#define CAN_CS1_TIME_STAMP5                            0x0020UL
#define CAN_CS1_TIME_STAMP4                            0x0010UL
#define CAN_CS1_TIME_STAMP3                            0x0008UL
#define CAN_CS1_TIME_STAMP2                            0x0004UL
#define CAN_CS1_TIME_STAMP1                            0x0002UL
#define CAN_CS1_TIME_STAMP0                            0x0001UL
#define CAN_CS1_TIME_STAMP                             0xFFFFUL

/* Masks for registers ID1 */
#define CAN_ID1_MASK                                   0xFFFFFFFFUL
#define CAN_ID1_PRIO2                                  0x80000000UL
#define CAN_ID1_PRIO1                                  0x40000000UL
#define CAN_ID1_PRIO0                                  0x20000000UL
#define CAN_ID1_PRIO                                   0xE0000000UL
#define CAN_ID1_STD10                                  0x10000000UL
#define CAN_ID1_STD9                                   0x8000000UL
#define CAN_ID1_STD8                                   0x4000000UL
#define CAN_ID1_STD7                                   0x2000000UL
#define CAN_ID1_STD6                                   0x1000000UL
#define CAN_ID1_STD5                                   0x800000UL
#define CAN_ID1_STD4                                   0x400000UL
#define CAN_ID1_STD3                                   0x200000UL
#define CAN_ID1_STD2                                   0x100000UL
#define CAN_ID1_STD1                                   0x80000UL
#define CAN_ID1_STD0                                   0x40000UL
#define CAN_ID1_STD                                    0x1FFC0000UL
#define CAN_ID1_EXT17                                  0x20000UL
#define CAN_ID1_EXT16                                  0x10000UL
#define CAN_ID1_EXT15                                  0x8000UL
#define CAN_ID1_EXT14                                  0x4000UL
#define CAN_ID1_EXT13                                  0x2000UL
#define CAN_ID1_EXT12                                  0x1000UL
#define CAN_ID1_EXT11                                  0x0800UL
#define CAN_ID1_EXT10                                  0x0400UL
#define CAN_ID1_EXT9                                   0x0200UL
#define CAN_ID1_EXT8                                   0x0100UL
#define CAN_ID1_EXT7                                   0x0080UL
#define CAN_ID1_EXT6                                   0x0040UL
#define CAN_ID1_EXT5                                   0x0020UL
#define CAN_ID1_EXT4                                   0x0010UL
#define CAN_ID1_EXT3                                   0x0008UL
#define CAN_ID1_EXT2                                   0x0004UL
#define CAN_ID1_EXT1                                   0x0002UL
#define CAN_ID1_EXT0                                   0x0001UL
#define CAN_ID1_EXT                                    0x3FFFFUL

/* Masks for registers WORD01 */
#define CAN_WORD01_MASK                                0xFFFFFFFFUL
#define CAN_WORD01_DATA_BYTE_07                        0x80000000UL
#define CAN_WORD01_DATA_BYTE_06                        0x40000000UL
#define CAN_WORD01_DATA_BYTE_05                        0x20000000UL
#define CAN_WORD01_DATA_BYTE_04                        0x10000000UL
#define CAN_WORD01_DATA_BYTE_03                        0x8000000UL
#define CAN_WORD01_DATA_BYTE_02                        0x4000000UL
#define CAN_WORD01_DATA_BYTE_01                        0x2000000UL
#define CAN_WORD01_DATA_BYTE_00                        0x1000000UL
#define CAN_WORD01_DATA_BYTE_0                         0xFF000000UL
#define CAN_WORD01_DATA_BYTE_17                        0x800000UL
#define CAN_WORD01_DATA_BYTE_16                        0x400000UL
#define CAN_WORD01_DATA_BYTE_15                        0x200000UL
#define CAN_WORD01_DATA_BYTE_14                        0x100000UL
#define CAN_WORD01_DATA_BYTE_13                        0x80000UL
#define CAN_WORD01_DATA_BYTE_12                        0x40000UL
#define CAN_WORD01_DATA_BYTE_11                        0x20000UL
#define CAN_WORD01_DATA_BYTE_10                        0x10000UL
#define CAN_WORD01_DATA_BYTE_1                         0xFF0000UL
#define CAN_WORD01_DATA_BYTE_27                        0x8000UL
#define CAN_WORD01_DATA_BYTE_26                        0x4000UL
#define CAN_WORD01_DATA_BYTE_25                        0x2000UL
#define CAN_WORD01_DATA_BYTE_24                        0x1000UL
#define CAN_WORD01_DATA_BYTE_23                        0x0800UL
#define CAN_WORD01_DATA_BYTE_22                        0x0400UL
#define CAN_WORD01_DATA_BYTE_21                        0x0200UL
#define CAN_WORD01_DATA_BYTE_20                        0x0100UL
#define CAN_WORD01_DATA_BYTE_2                         0xFF00UL
#define CAN_WORD01_DATA_BYTE_37                        0x0080UL
#define CAN_WORD01_DATA_BYTE_36                        0x0040UL
#define CAN_WORD01_DATA_BYTE_35                        0x0020UL
#define CAN_WORD01_DATA_BYTE_34                        0x0010UL
#define CAN_WORD01_DATA_BYTE_33                        0x0008UL
#define CAN_WORD01_DATA_BYTE_32                        0x0004UL
#define CAN_WORD01_DATA_BYTE_31                        0x0002UL
#define CAN_WORD01_DATA_BYTE_30                        0x0001UL
#define CAN_WORD01_DATA_BYTE_3                         0x00FFUL

/* Masks for registers WORD11 */
#define CAN_WORD11_MASK                                0xFFFFFFFFUL
#define CAN_WORD11_DATA_BYTE_47                        0x80000000UL
#define CAN_WORD11_DATA_BYTE_46                        0x40000000UL
#define CAN_WORD11_DATA_BYTE_45                        0x20000000UL
#define CAN_WORD11_DATA_BYTE_44                        0x10000000UL
#define CAN_WORD11_DATA_BYTE_43                        0x8000000UL
#define CAN_WORD11_DATA_BYTE_42                        0x4000000UL
#define CAN_WORD11_DATA_BYTE_41                        0x2000000UL
#define CAN_WORD11_DATA_BYTE_40                        0x1000000UL
#define CAN_WORD11_DATA_BYTE_4                         0xFF000000UL
#define CAN_WORD11_DATA_BYTE_57                        0x800000UL
#define CAN_WORD11_DATA_BYTE_56                        0x400000UL
#define CAN_WORD11_DATA_BYTE_55                        0x200000UL
#define CAN_WORD11_DATA_BYTE_54                        0x100000UL
#define CAN_WORD11_DATA_BYTE_53                        0x80000UL
#define CAN_WORD11_DATA_BYTE_52                        0x40000UL
#define CAN_WORD11_DATA_BYTE_51                        0x20000UL
#define CAN_WORD11_DATA_BYTE_50                        0x10000UL
#define CAN_WORD11_DATA_BYTE_5                         0xFF0000UL
#define CAN_WORD11_DATA_BYTE_67                        0x8000UL
#define CAN_WORD11_DATA_BYTE_66                        0x4000UL
#define CAN_WORD11_DATA_BYTE_65                        0x2000UL
#define CAN_WORD11_DATA_BYTE_64                        0x1000UL
#define CAN_WORD11_DATA_BYTE_63                        0x0800UL
#define CAN_WORD11_DATA_BYTE_62                        0x0400UL
#define CAN_WORD11_DATA_BYTE_61                        0x0200UL
#define CAN_WORD11_DATA_BYTE_60                        0x0100UL
#define CAN_WORD11_DATA_BYTE_6                         0xFF00UL
#define CAN_WORD11_DATA_BYTE_77                        0x0080UL
#define CAN_WORD11_DATA_BYTE_76                        0x0040UL
#define CAN_WORD11_DATA_BYTE_75                        0x0020UL
#define CAN_WORD11_DATA_BYTE_74                        0x0010UL
#define CAN_WORD11_DATA_BYTE_73                        0x0008UL
#define CAN_WORD11_DATA_BYTE_72                        0x0004UL
#define CAN_WORD11_DATA_BYTE_71                        0x0002UL
#define CAN_WORD11_DATA_BYTE_70                        0x0001UL
#define CAN_WORD11_DATA_BYTE_7                         0x00FFUL

/* Masks for registers CS2 */
#define CAN_CS2_MASK                                   0xF7FFFFFUL
#define CAN_CS2_CODE3                                  0x8000000UL
#define CAN_CS2_CODE2                                  0x4000000UL
#define CAN_CS2_CODE1                                  0x2000000UL
#define CAN_CS2_CODE0                                  0x1000000UL
#define CAN_CS2_CODE                                   0xF000000UL
#define CAN_CS2_SRR                                    0x400000UL
#define CAN_CS2_IDE                                    0x200000UL
#define CAN_CS2_RTR                                    0x100000UL
#define CAN_CS2_DLC3                                   0x80000UL
#define CAN_CS2_DLC2                                   0x40000UL
#define CAN_CS2_DLC1                                   0x20000UL
#define CAN_CS2_DLC0                                   0x10000UL
#define CAN_CS2_DLC                                    0xF0000UL
#define CAN_CS2_TIME_STAMP15                           0x8000UL
#define CAN_CS2_TIME_STAMP14                           0x4000UL
#define CAN_CS2_TIME_STAMP13                           0x2000UL
#define CAN_CS2_TIME_STAMP12                           0x1000UL
#define CAN_CS2_TIME_STAMP11                           0x0800UL
#define CAN_CS2_TIME_STAMP10                           0x0400UL
#define CAN_CS2_TIME_STAMP9                            0x0200UL
#define CAN_CS2_TIME_STAMP8                            0x0100UL
#define CAN_CS2_TIME_STAMP7                            0x0080UL
#define CAN_CS2_TIME_STAMP6                            0x0040UL
#define CAN_CS2_TIME_STAMP5                            0x0020UL
#define CAN_CS2_TIME_STAMP4                            0x0010UL
#define CAN_CS2_TIME_STAMP3                            0x0008UL
#define CAN_CS2_TIME_STAMP2                            0x0004UL
#define CAN_CS2_TIME_STAMP1                            0x0002UL
#define CAN_CS2_TIME_STAMP0                            0x0001UL
#define CAN_CS2_TIME_STAMP                             0xFFFFUL

/* Masks for registers ID2 */
#define CAN_ID2_MASK                                   0xFFFFFFFFUL
#define CAN_ID2_PRIO2                                  0x80000000UL
#define CAN_ID2_PRIO1                                  0x40000000UL
#define CAN_ID2_PRIO0                                  0x20000000UL
#define CAN_ID2_PRIO                                   0xE0000000UL
#define CAN_ID2_STD10                                  0x10000000UL
#define CAN_ID2_STD9                                   0x8000000UL
#define CAN_ID2_STD8                                   0x4000000UL
#define CAN_ID2_STD7                                   0x2000000UL
#define CAN_ID2_STD6                                   0x1000000UL
#define CAN_ID2_STD5                                   0x800000UL
#define CAN_ID2_STD4                                   0x400000UL
#define CAN_ID2_STD3                                   0x200000UL
#define CAN_ID2_STD2                                   0x100000UL
#define CAN_ID2_STD1                                   0x80000UL
#define CAN_ID2_STD0                                   0x40000UL
#define CAN_ID2_STD                                    0x1FFC0000UL
#define CAN_ID2_EXT17                                  0x20000UL
#define CAN_ID2_EXT16                                  0x10000UL
#define CAN_ID2_EXT15                                  0x8000UL
#define CAN_ID2_EXT14                                  0x4000UL
#define CAN_ID2_EXT13                                  0x2000UL
#define CAN_ID2_EXT12                                  0x1000UL
#define CAN_ID2_EXT11                                  0x0800UL
#define CAN_ID2_EXT10                                  0x0400UL
#define CAN_ID2_EXT9                                   0x0200UL
#define CAN_ID2_EXT8                                   0x0100UL
#define CAN_ID2_EXT7                                   0x0080UL
#define CAN_ID2_EXT6                                   0x0040UL
#define CAN_ID2_EXT5                                   0x0020UL
#define CAN_ID2_EXT4                                   0x0010UL
#define CAN_ID2_EXT3                                   0x0008UL
#define CAN_ID2_EXT2                                   0x0004UL
#define CAN_ID2_EXT1                                   0x0002UL
#define CAN_ID2_EXT0                                   0x0001UL
#define CAN_ID2_EXT                                    0x3FFFFUL

/* Masks for registers WORD02 */
#define CAN_WORD02_MASK                                0xFFFFFFFFUL
#define CAN_WORD02_DATA_BYTE_07                        0x80000000UL
#define CAN_WORD02_DATA_BYTE_06                        0x40000000UL
#define CAN_WORD02_DATA_BYTE_05                        0x20000000UL
#define CAN_WORD02_DATA_BYTE_04                        0x10000000UL
#define CAN_WORD02_DATA_BYTE_03                        0x8000000UL
#define CAN_WORD02_DATA_BYTE_02                        0x4000000UL
#define CAN_WORD02_DATA_BYTE_01                        0x2000000UL
#define CAN_WORD02_DATA_BYTE_00                        0x1000000UL
#define CAN_WORD02_DATA_BYTE_0                         0xFF000000UL
#define CAN_WORD02_DATA_BYTE_17                        0x800000UL
#define CAN_WORD02_DATA_BYTE_16                        0x400000UL
#define CAN_WORD02_DATA_BYTE_15                        0x200000UL
#define CAN_WORD02_DATA_BYTE_14                        0x100000UL
#define CAN_WORD02_DATA_BYTE_13                        0x80000UL
#define CAN_WORD02_DATA_BYTE_12                        0x40000UL
#define CAN_WORD02_DATA_BYTE_11                        0x20000UL
#define CAN_WORD02_DATA_BYTE_10                        0x10000UL
#define CAN_WORD02_DATA_BYTE_1                         0xFF0000UL
#define CAN_WORD02_DATA_BYTE_27                        0x8000UL
#define CAN_WORD02_DATA_BYTE_26                        0x4000UL
#define CAN_WORD02_DATA_BYTE_25                        0x2000UL
#define CAN_WORD02_DATA_BYTE_24                        0x1000UL
#define CAN_WORD02_DATA_BYTE_23                        0x0800UL
#define CAN_WORD02_DATA_BYTE_22                        0x0400UL
#define CAN_WORD02_DATA_BYTE_21                        0x0200UL
#define CAN_WORD02_DATA_BYTE_20                        0x0100UL
#define CAN_WORD02_DATA_BYTE_2                         0xFF00UL
#define CAN_WORD02_DATA_BYTE_37                        0x0080UL
#define CAN_WORD02_DATA_BYTE_36                        0x0040UL
#define CAN_WORD02_DATA_BYTE_35                        0x0020UL
#define CAN_WORD02_DATA_BYTE_34                        0x0010UL
#define CAN_WORD02_DATA_BYTE_33                        0x0008UL
#define CAN_WORD02_DATA_BYTE_32                        0x0004UL
#define CAN_WORD02_DATA_BYTE_31                        0x0002UL
#define CAN_WORD02_DATA_BYTE_30                        0x0001UL
#define CAN_WORD02_DATA_BYTE_3                         0x00FFUL

/* Masks for registers WORD12 */
#define CAN_WORD12_MASK                                0xFFFFFFFFUL
#define CAN_WORD12_DATA_BYTE_47                        0x80000000UL
#define CAN_WORD12_DATA_BYTE_46                        0x40000000UL
#define CAN_WORD12_DATA_BYTE_45                        0x20000000UL
#define CAN_WORD12_DATA_BYTE_44                        0x10000000UL
#define CAN_WORD12_DATA_BYTE_43                        0x8000000UL
#define CAN_WORD12_DATA_BYTE_42                        0x4000000UL
#define CAN_WORD12_DATA_BYTE_41                        0x2000000UL
#define CAN_WORD12_DATA_BYTE_40                        0x1000000UL
#define CAN_WORD12_DATA_BYTE_4                         0xFF000000UL
#define CAN_WORD12_DATA_BYTE_57                        0x800000UL
#define CAN_WORD12_DATA_BYTE_56                        0x400000UL
#define CAN_WORD12_DATA_BYTE_55                        0x200000UL
#define CAN_WORD12_DATA_BYTE_54                        0x100000UL
#define CAN_WORD12_DATA_BYTE_53                        0x80000UL
#define CAN_WORD12_DATA_BYTE_52                        0x40000UL
#define CAN_WORD12_DATA_BYTE_51                        0x20000UL
#define CAN_WORD12_DATA_BYTE_50                        0x10000UL
#define CAN_WORD12_DATA_BYTE_5                         0xFF0000UL
#define CAN_WORD12_DATA_BYTE_67                        0x8000UL
#define CAN_WORD12_DATA_BYTE_66                        0x4000UL
#define CAN_WORD12_DATA_BYTE_65                        0x2000UL
#define CAN_WORD12_DATA_BYTE_64                        0x1000UL
#define CAN_WORD12_DATA_BYTE_63                        0x0800UL
#define CAN_WORD12_DATA_BYTE_62                        0x0400UL
#define CAN_WORD12_DATA_BYTE_61                        0x0200UL
#define CAN_WORD12_DATA_BYTE_60                        0x0100UL
#define CAN_WORD12_DATA_BYTE_6                         0xFF00UL
#define CAN_WORD12_DATA_BYTE_77                        0x0080UL
#define CAN_WORD12_DATA_BYTE_76                        0x0040UL
#define CAN_WORD12_DATA_BYTE_75                        0x0020UL
#define CAN_WORD12_DATA_BYTE_74                        0x0010UL
#define CAN_WORD12_DATA_BYTE_73                        0x0008UL
#define CAN_WORD12_DATA_BYTE_72                        0x0004UL
#define CAN_WORD12_DATA_BYTE_71                        0x0002UL
#define CAN_WORD12_DATA_BYTE_70                        0x0001UL
#define CAN_WORD12_DATA_BYTE_7                         0x00FFUL

/* Masks for registers CS3 */
#define CAN_CS3_MASK                                   0xF7FFFFFUL
#define CAN_CS3_CODE3                                  0x8000000UL
#define CAN_CS3_CODE2                                  0x4000000UL
#define CAN_CS3_CODE1                                  0x2000000UL
#define CAN_CS3_CODE0                                  0x1000000UL
#define CAN_CS3_CODE                                   0xF000000UL
#define CAN_CS3_SRR                                    0x400000UL
#define CAN_CS3_IDE                                    0x200000UL
#define CAN_CS3_RTR                                    0x100000UL
#define CAN_CS3_DLC3                                   0x80000UL
#define CAN_CS3_DLC2                                   0x40000UL
#define CAN_CS3_DLC1                                   0x20000UL
#define CAN_CS3_DLC0                                   0x10000UL
#define CAN_CS3_DLC                                    0xF0000UL
#define CAN_CS3_TIME_STAMP15                           0x8000UL
#define CAN_CS3_TIME_STAMP14                           0x4000UL
#define CAN_CS3_TIME_STAMP13                           0x2000UL
#define CAN_CS3_TIME_STAMP12                           0x1000UL
#define CAN_CS3_TIME_STAMP11                           0x0800UL
#define CAN_CS3_TIME_STAMP10                           0x0400UL
#define CAN_CS3_TIME_STAMP9                            0x0200UL
#define CAN_CS3_TIME_STAMP8                            0x0100UL
#define CAN_CS3_TIME_STAMP7                            0x0080UL
#define CAN_CS3_TIME_STAMP6                            0x0040UL
#define CAN_CS3_TIME_STAMP5                            0x0020UL
#define CAN_CS3_TIME_STAMP4                            0x0010UL
#define CAN_CS3_TIME_STAMP3                            0x0008UL
#define CAN_CS3_TIME_STAMP2                            0x0004UL
#define CAN_CS3_TIME_STAMP1                            0x0002UL
#define CAN_CS3_TIME_STAMP0                            0x0001UL
#define CAN_CS3_TIME_STAMP                             0xFFFFUL

/* Masks for registers ID3 */
#define CAN_ID3_MASK                                   0xFFFFFFFFUL
#define CAN_ID3_PRIO2                                  0x80000000UL
#define CAN_ID3_PRIO1                                  0x40000000UL
#define CAN_ID3_PRIO0                                  0x20000000UL
#define CAN_ID3_PRIO                                   0xE0000000UL
#define CAN_ID3_STD10                                  0x10000000UL
#define CAN_ID3_STD9                                   0x8000000UL
#define CAN_ID3_STD8                                   0x4000000UL
#define CAN_ID3_STD7                                   0x2000000UL
#define CAN_ID3_STD6                                   0x1000000UL
#define CAN_ID3_STD5                                   0x800000UL
#define CAN_ID3_STD4                                   0x400000UL
#define CAN_ID3_STD3                                   0x200000UL
#define CAN_ID3_STD2                                   0x100000UL
#define CAN_ID3_STD1                                   0x80000UL
#define CAN_ID3_STD0                                   0x40000UL
#define CAN_ID3_STD                                    0x1FFC0000UL
#define CAN_ID3_EXT17                                  0x20000UL
#define CAN_ID3_EXT16                                  0x10000UL
#define CAN_ID3_EXT15                                  0x8000UL
#define CAN_ID3_EXT14                                  0x4000UL
#define CAN_ID3_EXT13                                  0x2000UL
#define CAN_ID3_EXT12                                  0x1000UL
#define CAN_ID3_EXT11                                  0x0800UL
#define CAN_ID3_EXT10                                  0x0400UL
#define CAN_ID3_EXT9                                   0x0200UL
#define CAN_ID3_EXT8                                   0x0100UL
#define CAN_ID3_EXT7                                   0x0080UL
#define CAN_ID3_EXT6                                   0x0040UL
#define CAN_ID3_EXT5                                   0x0020UL
#define CAN_ID3_EXT4                                   0x0010UL
#define CAN_ID3_EXT3                                   0x0008UL
#define CAN_ID3_EXT2                                   0x0004UL
#define CAN_ID3_EXT1                                   0x0002UL
#define CAN_ID3_EXT0                                   0x0001UL
#define CAN_ID3_EXT                                    0x3FFFFUL

/* Masks for registers WORD03 */
#define CAN_WORD03_MASK                                0xFFFFFFFFUL
#define CAN_WORD03_DATA_BYTE_07                        0x80000000UL
#define CAN_WORD03_DATA_BYTE_06                        0x40000000UL
#define CAN_WORD03_DATA_BYTE_05                        0x20000000UL
#define CAN_WORD03_DATA_BYTE_04                        0x10000000UL
#define CAN_WORD03_DATA_BYTE_03                        0x8000000UL
#define CAN_WORD03_DATA_BYTE_02                        0x4000000UL
#define CAN_WORD03_DATA_BYTE_01                        0x2000000UL
#define CAN_WORD03_DATA_BYTE_00                        0x1000000UL
#define CAN_WORD03_DATA_BYTE_0                         0xFF000000UL
#define CAN_WORD03_DATA_BYTE_17                        0x800000UL
#define CAN_WORD03_DATA_BYTE_16                        0x400000UL
#define CAN_WORD03_DATA_BYTE_15                        0x200000UL
#define CAN_WORD03_DATA_BYTE_14                        0x100000UL
#define CAN_WORD03_DATA_BYTE_13                        0x80000UL
#define CAN_WORD03_DATA_BYTE_12                        0x40000UL
#define CAN_WORD03_DATA_BYTE_11                        0x20000UL
#define CAN_WORD03_DATA_BYTE_10                        0x10000UL
#define CAN_WORD03_DATA_BYTE_1                         0xFF0000UL
#define CAN_WORD03_DATA_BYTE_27                        0x8000UL
#define CAN_WORD03_DATA_BYTE_26                        0x4000UL
#define CAN_WORD03_DATA_BYTE_25                        0x2000UL
#define CAN_WORD03_DATA_BYTE_24                        0x1000UL
#define CAN_WORD03_DATA_BYTE_23                        0x0800UL
#define CAN_WORD03_DATA_BYTE_22                        0x0400UL
#define CAN_WORD03_DATA_BYTE_21                        0x0200UL
#define CAN_WORD03_DATA_BYTE_20                        0x0100UL
#define CAN_WORD03_DATA_BYTE_2                         0xFF00UL
#define CAN_WORD03_DATA_BYTE_37                        0x0080UL
#define CAN_WORD03_DATA_BYTE_36                        0x0040UL
#define CAN_WORD03_DATA_BYTE_35                        0x0020UL
#define CAN_WORD03_DATA_BYTE_34                        0x0010UL
#define CAN_WORD03_DATA_BYTE_33                        0x0008UL
#define CAN_WORD03_DATA_BYTE_32                        0x0004UL
#define CAN_WORD03_DATA_BYTE_31                        0x0002UL
#define CAN_WORD03_DATA_BYTE_30                        0x0001UL
#define CAN_WORD03_DATA_BYTE_3                         0x00FFUL

/* Masks for registers WORD13 */
#define CAN_WORD13_MASK                                0xFFFFFFFFUL
#define CAN_WORD13_DATA_BYTE_47                        0x80000000UL
#define CAN_WORD13_DATA_BYTE_46                        0x40000000UL
#define CAN_WORD13_DATA_BYTE_45                        0x20000000UL
#define CAN_WORD13_DATA_BYTE_44                        0x10000000UL
#define CAN_WORD13_DATA_BYTE_43                        0x8000000UL
#define CAN_WORD13_DATA_BYTE_42                        0x4000000UL
#define CAN_WORD13_DATA_BYTE_41                        0x2000000UL
#define CAN_WORD13_DATA_BYTE_40                        0x1000000UL
#define CAN_WORD13_DATA_BYTE_4                         0xFF000000UL
#define CAN_WORD13_DATA_BYTE_57                        0x800000UL
#define CAN_WORD13_DATA_BYTE_56                        0x400000UL
#define CAN_WORD13_DATA_BYTE_55                        0x200000UL
#define CAN_WORD13_DATA_BYTE_54                        0x100000UL
#define CAN_WORD13_DATA_BYTE_53                        0x80000UL
#define CAN_WORD13_DATA_BYTE_52                        0x40000UL
#define CAN_WORD13_DATA_BYTE_51                        0x20000UL
#define CAN_WORD13_DATA_BYTE_50                        0x10000UL
#define CAN_WORD13_DATA_BYTE_5                         0xFF0000UL
#define CAN_WORD13_DATA_BYTE_67                        0x8000UL
#define CAN_WORD13_DATA_BYTE_66                        0x4000UL
#define CAN_WORD13_DATA_BYTE_65                        0x2000UL
#define CAN_WORD13_DATA_BYTE_64                        0x1000UL
#define CAN_WORD13_DATA_BYTE_63                        0x0800UL
#define CAN_WORD13_DATA_BYTE_62                        0x0400UL
#define CAN_WORD13_DATA_BYTE_61                        0x0200UL
#define CAN_WORD13_DATA_BYTE_60                        0x0100UL
#define CAN_WORD13_DATA_BYTE_6                         0xFF00UL
#define CAN_WORD13_DATA_BYTE_77                        0x0080UL
#define CAN_WORD13_DATA_BYTE_76                        0x0040UL
#define CAN_WORD13_DATA_BYTE_75                        0x0020UL
#define CAN_WORD13_DATA_BYTE_74                        0x0010UL
#define CAN_WORD13_DATA_BYTE_73                        0x0008UL
#define CAN_WORD13_DATA_BYTE_72                        0x0004UL
#define CAN_WORD13_DATA_BYTE_71                        0x0002UL
#define CAN_WORD13_DATA_BYTE_70                        0x0001UL
#define CAN_WORD13_DATA_BYTE_7                         0x00FFUL

/* Masks for registers CS4 */
#define CAN_CS4_MASK                                   0xF7FFFFFUL
#define CAN_CS4_CODE3                                  0x8000000UL
#define CAN_CS4_CODE2                                  0x4000000UL
#define CAN_CS4_CODE1                                  0x2000000UL
#define CAN_CS4_CODE0                                  0x1000000UL
#define CAN_CS4_CODE                                   0xF000000UL
#define CAN_CS4_SRR                                    0x400000UL
#define CAN_CS4_IDE                                    0x200000UL
#define CAN_CS4_RTR                                    0x100000UL
#define CAN_CS4_DLC3                                   0x80000UL
#define CAN_CS4_DLC2                                   0x40000UL
#define CAN_CS4_DLC1                                   0x20000UL
#define CAN_CS4_DLC0                                   0x10000UL
#define CAN_CS4_DLC                                    0xF0000UL
#define CAN_CS4_TIME_STAMP15                           0x8000UL
#define CAN_CS4_TIME_STAMP14                           0x4000UL
#define CAN_CS4_TIME_STAMP13                           0x2000UL
#define CAN_CS4_TIME_STAMP12                           0x1000UL
#define CAN_CS4_TIME_STAMP11                           0x0800UL
#define CAN_CS4_TIME_STAMP10                           0x0400UL
#define CAN_CS4_TIME_STAMP9                            0x0200UL
#define CAN_CS4_TIME_STAMP8                            0x0100UL
#define CAN_CS4_TIME_STAMP7                            0x0080UL
#define CAN_CS4_TIME_STAMP6                            0x0040UL
#define CAN_CS4_TIME_STAMP5                            0x0020UL
#define CAN_CS4_TIME_STAMP4                            0x0010UL
#define CAN_CS4_TIME_STAMP3                            0x0008UL
#define CAN_CS4_TIME_STAMP2                            0x0004UL
#define CAN_CS4_TIME_STAMP1                            0x0002UL
#define CAN_CS4_TIME_STAMP0                            0x0001UL
#define CAN_CS4_TIME_STAMP                             0xFFFFUL

/* Masks for registers ID4 */
#define CAN_ID4_MASK                                   0xFFFFFFFFUL
#define CAN_ID4_PRIO2                                  0x80000000UL
#define CAN_ID4_PRIO1                                  0x40000000UL
#define CAN_ID4_PRIO0                                  0x20000000UL
#define CAN_ID4_PRIO                                   0xE0000000UL
#define CAN_ID4_STD10                                  0x10000000UL
#define CAN_ID4_STD9                                   0x8000000UL
#define CAN_ID4_STD8                                   0x4000000UL
#define CAN_ID4_STD7                                   0x2000000UL
#define CAN_ID4_STD6                                   0x1000000UL
#define CAN_ID4_STD5                                   0x800000UL
#define CAN_ID4_STD4                                   0x400000UL
#define CAN_ID4_STD3                                   0x200000UL
#define CAN_ID4_STD2                                   0x100000UL
#define CAN_ID4_STD1                                   0x80000UL
#define CAN_ID4_STD0                                   0x40000UL
#define CAN_ID4_STD                                    0x1FFC0000UL
#define CAN_ID4_EXT17                                  0x20000UL
#define CAN_ID4_EXT16                                  0x10000UL
#define CAN_ID4_EXT15                                  0x8000UL
#define CAN_ID4_EXT14                                  0x4000UL
#define CAN_ID4_EXT13                                  0x2000UL
#define CAN_ID4_EXT12                                  0x1000UL
#define CAN_ID4_EXT11                                  0x0800UL
#define CAN_ID4_EXT10                                  0x0400UL
#define CAN_ID4_EXT9                                   0x0200UL
#define CAN_ID4_EXT8                                   0x0100UL
#define CAN_ID4_EXT7                                   0x0080UL
#define CAN_ID4_EXT6                                   0x0040UL
#define CAN_ID4_EXT5                                   0x0020UL
#define CAN_ID4_EXT4                                   0x0010UL
#define CAN_ID4_EXT3                                   0x0008UL
#define CAN_ID4_EXT2                                   0x0004UL
#define CAN_ID4_EXT1                                   0x0002UL
#define CAN_ID4_EXT0                                   0x0001UL
#define CAN_ID4_EXT                                    0x3FFFFUL

/* Masks for registers WORD04 */
#define CAN_WORD04_MASK                                0xFFFFFFFFUL
#define CAN_WORD04_DATA_BYTE_07                        0x80000000UL
#define CAN_WORD04_DATA_BYTE_06                        0x40000000UL
#define CAN_WORD04_DATA_BYTE_05                        0x20000000UL
#define CAN_WORD04_DATA_BYTE_04                        0x10000000UL
#define CAN_WORD04_DATA_BYTE_03                        0x8000000UL
#define CAN_WORD04_DATA_BYTE_02                        0x4000000UL
#define CAN_WORD04_DATA_BYTE_01                        0x2000000UL
#define CAN_WORD04_DATA_BYTE_00                        0x1000000UL
#define CAN_WORD04_DATA_BYTE_0                         0xFF000000UL
#define CAN_WORD04_DATA_BYTE_17                        0x800000UL
#define CAN_WORD04_DATA_BYTE_16                        0x400000UL
#define CAN_WORD04_DATA_BYTE_15                        0x200000UL
#define CAN_WORD04_DATA_BYTE_14                        0x100000UL
#define CAN_WORD04_DATA_BYTE_13                        0x80000UL
#define CAN_WORD04_DATA_BYTE_12                        0x40000UL
#define CAN_WORD04_DATA_BYTE_11                        0x20000UL
#define CAN_WORD04_DATA_BYTE_10                        0x10000UL
#define CAN_WORD04_DATA_BYTE_1                         0xFF0000UL
#define CAN_WORD04_DATA_BYTE_27                        0x8000UL
#define CAN_WORD04_DATA_BYTE_26                        0x4000UL
#define CAN_WORD04_DATA_BYTE_25                        0x2000UL
#define CAN_WORD04_DATA_BYTE_24                        0x1000UL
#define CAN_WORD04_DATA_BYTE_23                        0x0800UL
#define CAN_WORD04_DATA_BYTE_22                        0x0400UL
#define CAN_WORD04_DATA_BYTE_21                        0x0200UL
#define CAN_WORD04_DATA_BYTE_20                        0x0100UL
#define CAN_WORD04_DATA_BYTE_2                         0xFF00UL
#define CAN_WORD04_DATA_BYTE_37                        0x0080UL
#define CAN_WORD04_DATA_BYTE_36                        0x0040UL
#define CAN_WORD04_DATA_BYTE_35                        0x0020UL
#define CAN_WORD04_DATA_BYTE_34                        0x0010UL
#define CAN_WORD04_DATA_BYTE_33                        0x0008UL
#define CAN_WORD04_DATA_BYTE_32                        0x0004UL
#define CAN_WORD04_DATA_BYTE_31                        0x0002UL
#define CAN_WORD04_DATA_BYTE_30                        0x0001UL
#define CAN_WORD04_DATA_BYTE_3                         0x00FFUL

/* Masks for registers WORD14 */
#define CAN_WORD14_MASK                                0xFFFFFFFFUL
#define CAN_WORD14_DATA_BYTE_47                        0x80000000UL
#define CAN_WORD14_DATA_BYTE_46                        0x40000000UL
#define CAN_WORD14_DATA_BYTE_45                        0x20000000UL
#define CAN_WORD14_DATA_BYTE_44                        0x10000000UL
#define CAN_WORD14_DATA_BYTE_43                        0x8000000UL
#define CAN_WORD14_DATA_BYTE_42                        0x4000000UL
#define CAN_WORD14_DATA_BYTE_41                        0x2000000UL
#define CAN_WORD14_DATA_BYTE_40                        0x1000000UL
#define CAN_WORD14_DATA_BYTE_4                         0xFF000000UL
#define CAN_WORD14_DATA_BYTE_57                        0x800000UL
#define CAN_WORD14_DATA_BYTE_56                        0x400000UL
#define CAN_WORD14_DATA_BYTE_55                        0x200000UL
#define CAN_WORD14_DATA_BYTE_54                        0x100000UL
#define CAN_WORD14_DATA_BYTE_53                        0x80000UL
#define CAN_WORD14_DATA_BYTE_52                        0x40000UL
#define CAN_WORD14_DATA_BYTE_51                        0x20000UL
#define CAN_WORD14_DATA_BYTE_50                        0x10000UL
#define CAN_WORD14_DATA_BYTE_5                         0xFF0000UL
#define CAN_WORD14_DATA_BYTE_67                        0x8000UL
#define CAN_WORD14_DATA_BYTE_66                        0x4000UL
#define CAN_WORD14_DATA_BYTE_65                        0x2000UL
#define CAN_WORD14_DATA_BYTE_64                        0x1000UL
#define CAN_WORD14_DATA_BYTE_63                        0x0800UL
#define CAN_WORD14_DATA_BYTE_62                        0x0400UL
#define CAN_WORD14_DATA_BYTE_61                        0x0200UL
#define CAN_WORD14_DATA_BYTE_60                        0x0100UL
#define CAN_WORD14_DATA_BYTE_6                         0xFF00UL
#define CAN_WORD14_DATA_BYTE_77                        0x0080UL
#define CAN_WORD14_DATA_BYTE_76                        0x0040UL
#define CAN_WORD14_DATA_BYTE_75                        0x0020UL
#define CAN_WORD14_DATA_BYTE_74                        0x0010UL
#define CAN_WORD14_DATA_BYTE_73                        0x0008UL
#define CAN_WORD14_DATA_BYTE_72                        0x0004UL
#define CAN_WORD14_DATA_BYTE_71                        0x0002UL
#define CAN_WORD14_DATA_BYTE_70                        0x0001UL
#define CAN_WORD14_DATA_BYTE_7                         0x00FFUL

/* Masks for registers CS5 */
#define CAN_CS5_MASK                                   0xF7FFFFFUL
#define CAN_CS5_CODE3                                  0x8000000UL
#define CAN_CS5_CODE2                                  0x4000000UL
#define CAN_CS5_CODE1                                  0x2000000UL
#define CAN_CS5_CODE0                                  0x1000000UL
#define CAN_CS5_CODE                                   0xF000000UL
#define CAN_CS5_SRR                                    0x400000UL
#define CAN_CS5_IDE                                    0x200000UL
#define CAN_CS5_RTR                                    0x100000UL
#define CAN_CS5_DLC3                                   0x80000UL
#define CAN_CS5_DLC2                                   0x40000UL
#define CAN_CS5_DLC1                                   0x20000UL
#define CAN_CS5_DLC0                                   0x10000UL
#define CAN_CS5_DLC                                    0xF0000UL
#define CAN_CS5_TIME_STAMP15                           0x8000UL
#define CAN_CS5_TIME_STAMP14                           0x4000UL
#define CAN_CS5_TIME_STAMP13                           0x2000UL
#define CAN_CS5_TIME_STAMP12                           0x1000UL
#define CAN_CS5_TIME_STAMP11                           0x0800UL
#define CAN_CS5_TIME_STAMP10                           0x0400UL
#define CAN_CS5_TIME_STAMP9                            0x0200UL
#define CAN_CS5_TIME_STAMP8                            0x0100UL
#define CAN_CS5_TIME_STAMP7                            0x0080UL
#define CAN_CS5_TIME_STAMP6                            0x0040UL
#define CAN_CS5_TIME_STAMP5                            0x0020UL
#define CAN_CS5_TIME_STAMP4                            0x0010UL
#define CAN_CS5_TIME_STAMP3                            0x0008UL
#define CAN_CS5_TIME_STAMP2                            0x0004UL
#define CAN_CS5_TIME_STAMP1                            0x0002UL
#define CAN_CS5_TIME_STAMP0                            0x0001UL
#define CAN_CS5_TIME_STAMP                             0xFFFFUL

/* Masks for registers ID5 */
#define CAN_ID5_MASK                                   0xFFFFFFFFUL
#define CAN_ID5_PRIO2                                  0x80000000UL
#define CAN_ID5_PRIO1                                  0x40000000UL
#define CAN_ID5_PRIO0                                  0x20000000UL
#define CAN_ID5_PRIO                                   0xE0000000UL
#define CAN_ID5_STD10                                  0x10000000UL
#define CAN_ID5_STD9                                   0x8000000UL
#define CAN_ID5_STD8                                   0x4000000UL
#define CAN_ID5_STD7                                   0x2000000UL
#define CAN_ID5_STD6                                   0x1000000UL
#define CAN_ID5_STD5                                   0x800000UL
#define CAN_ID5_STD4                                   0x400000UL
#define CAN_ID5_STD3                                   0x200000UL
#define CAN_ID5_STD2                                   0x100000UL
#define CAN_ID5_STD1                                   0x80000UL
#define CAN_ID5_STD0                                   0x40000UL
#define CAN_ID5_STD                                    0x1FFC0000UL
#define CAN_ID5_EXT17                                  0x20000UL
#define CAN_ID5_EXT16                                  0x10000UL
#define CAN_ID5_EXT15                                  0x8000UL
#define CAN_ID5_EXT14                                  0x4000UL
#define CAN_ID5_EXT13                                  0x2000UL
#define CAN_ID5_EXT12                                  0x1000UL
#define CAN_ID5_EXT11                                  0x0800UL
#define CAN_ID5_EXT10                                  0x0400UL
#define CAN_ID5_EXT9                                   0x0200UL
#define CAN_ID5_EXT8                                   0x0100UL
#define CAN_ID5_EXT7                                   0x0080UL
#define CAN_ID5_EXT6                                   0x0040UL
#define CAN_ID5_EXT5                                   0x0020UL
#define CAN_ID5_EXT4                                   0x0010UL
#define CAN_ID5_EXT3                                   0x0008UL
#define CAN_ID5_EXT2                                   0x0004UL
#define CAN_ID5_EXT1                                   0x0002UL
#define CAN_ID5_EXT0                                   0x0001UL
#define CAN_ID5_EXT                                    0x3FFFFUL

/* Masks for registers WORD05 */
#define CAN_WORD05_MASK                                0xFFFFFFFFUL
#define CAN_WORD05_DATA_BYTE_07                        0x80000000UL
#define CAN_WORD05_DATA_BYTE_06                        0x40000000UL
#define CAN_WORD05_DATA_BYTE_05                        0x20000000UL
#define CAN_WORD05_DATA_BYTE_04                        0x10000000UL
#define CAN_WORD05_DATA_BYTE_03                        0x8000000UL
#define CAN_WORD05_DATA_BYTE_02                        0x4000000UL
#define CAN_WORD05_DATA_BYTE_01                        0x2000000UL
#define CAN_WORD05_DATA_BYTE_00                        0x1000000UL
#define CAN_WORD05_DATA_BYTE_0                         0xFF000000UL
#define CAN_WORD05_DATA_BYTE_17                        0x800000UL
#define CAN_WORD05_DATA_BYTE_16                        0x400000UL
#define CAN_WORD05_DATA_BYTE_15                        0x200000UL
#define CAN_WORD05_DATA_BYTE_14                        0x100000UL
#define CAN_WORD05_DATA_BYTE_13                        0x80000UL
#define CAN_WORD05_DATA_BYTE_12                        0x40000UL
#define CAN_WORD05_DATA_BYTE_11                        0x20000UL
#define CAN_WORD05_DATA_BYTE_10                        0x10000UL
#define CAN_WORD05_DATA_BYTE_1                         0xFF0000UL
#define CAN_WORD05_DATA_BYTE_27                        0x8000UL
#define CAN_WORD05_DATA_BYTE_26                        0x4000UL
#define CAN_WORD05_DATA_BYTE_25                        0x2000UL
#define CAN_WORD05_DATA_BYTE_24                        0x1000UL
#define CAN_WORD05_DATA_BYTE_23                        0x0800UL
#define CAN_WORD05_DATA_BYTE_22                        0x0400UL
#define CAN_WORD05_DATA_BYTE_21                        0x0200UL
#define CAN_WORD05_DATA_BYTE_20                        0x0100UL
#define CAN_WORD05_DATA_BYTE_2                         0xFF00UL
#define CAN_WORD05_DATA_BYTE_37                        0x0080UL
#define CAN_WORD05_DATA_BYTE_36                        0x0040UL
#define CAN_WORD05_DATA_BYTE_35                        0x0020UL
#define CAN_WORD05_DATA_BYTE_34                        0x0010UL
#define CAN_WORD05_DATA_BYTE_33                        0x0008UL
#define CAN_WORD05_DATA_BYTE_32                        0x0004UL
#define CAN_WORD05_DATA_BYTE_31                        0x0002UL
#define CAN_WORD05_DATA_BYTE_30                        0x0001UL
#define CAN_WORD05_DATA_BYTE_3                         0x00FFUL

/* Masks for registers WORD15 */
#define CAN_WORD15_MASK                                0xFFFFFFFFUL
#define CAN_WORD15_DATA_BYTE_47                        0x80000000UL
#define CAN_WORD15_DATA_BYTE_46                        0x40000000UL
#define CAN_WORD15_DATA_BYTE_45                        0x20000000UL
#define CAN_WORD15_DATA_BYTE_44                        0x10000000UL
#define CAN_WORD15_DATA_BYTE_43                        0x8000000UL
#define CAN_WORD15_DATA_BYTE_42                        0x4000000UL
#define CAN_WORD15_DATA_BYTE_41                        0x2000000UL
#define CAN_WORD15_DATA_BYTE_40                        0x1000000UL
#define CAN_WORD15_DATA_BYTE_4                         0xFF000000UL
#define CAN_WORD15_DATA_BYTE_57                        0x800000UL
#define CAN_WORD15_DATA_BYTE_56                        0x400000UL
#define CAN_WORD15_DATA_BYTE_55                        0x200000UL
#define CAN_WORD15_DATA_BYTE_54                        0x100000UL
#define CAN_WORD15_DATA_BYTE_53                        0x80000UL
#define CAN_WORD15_DATA_BYTE_52                        0x40000UL
#define CAN_WORD15_DATA_BYTE_51                        0x20000UL
#define CAN_WORD15_DATA_BYTE_50                        0x10000UL
#define CAN_WORD15_DATA_BYTE_5                         0xFF0000UL
#define CAN_WORD15_DATA_BYTE_67                        0x8000UL
#define CAN_WORD15_DATA_BYTE_66                        0x4000UL
#define CAN_WORD15_DATA_BYTE_65                        0x2000UL
#define CAN_WORD15_DATA_BYTE_64                        0x1000UL
#define CAN_WORD15_DATA_BYTE_63                        0x0800UL
#define CAN_WORD15_DATA_BYTE_62                        0x0400UL
#define CAN_WORD15_DATA_BYTE_61                        0x0200UL
#define CAN_WORD15_DATA_BYTE_60                        0x0100UL
#define CAN_WORD15_DATA_BYTE_6                         0xFF00UL
#define CAN_WORD15_DATA_BYTE_77                        0x0080UL
#define CAN_WORD15_DATA_BYTE_76                        0x0040UL
#define CAN_WORD15_DATA_BYTE_75                        0x0020UL
#define CAN_WORD15_DATA_BYTE_74                        0x0010UL
#define CAN_WORD15_DATA_BYTE_73                        0x0008UL
#define CAN_WORD15_DATA_BYTE_72                        0x0004UL
#define CAN_WORD15_DATA_BYTE_71                        0x0002UL
#define CAN_WORD15_DATA_BYTE_70                        0x0001UL
#define CAN_WORD15_DATA_BYTE_7                         0x00FFUL

/* Masks for registers CS6 */
#define CAN_CS6_MASK                                   0xF7FFFFFUL
#define CAN_CS6_CODE3                                  0x8000000UL
#define CAN_CS6_CODE2                                  0x4000000UL
#define CAN_CS6_CODE1                                  0x2000000UL
#define CAN_CS6_CODE0                                  0x1000000UL
#define CAN_CS6_CODE                                   0xF000000UL
#define CAN_CS6_SRR                                    0x400000UL
#define CAN_CS6_IDE                                    0x200000UL
#define CAN_CS6_RTR                                    0x100000UL
#define CAN_CS6_DLC3                                   0x80000UL
#define CAN_CS6_DLC2                                   0x40000UL
#define CAN_CS6_DLC1                                   0x20000UL
#define CAN_CS6_DLC0                                   0x10000UL
#define CAN_CS6_DLC                                    0xF0000UL
#define CAN_CS6_TIME_STAMP15                           0x8000UL
#define CAN_CS6_TIME_STAMP14                           0x4000UL
#define CAN_CS6_TIME_STAMP13                           0x2000UL
#define CAN_CS6_TIME_STAMP12                           0x1000UL
#define CAN_CS6_TIME_STAMP11                           0x0800UL
#define CAN_CS6_TIME_STAMP10                           0x0400UL
#define CAN_CS6_TIME_STAMP9                            0x0200UL
#define CAN_CS6_TIME_STAMP8                            0x0100UL
#define CAN_CS6_TIME_STAMP7                            0x0080UL
#define CAN_CS6_TIME_STAMP6                            0x0040UL
#define CAN_CS6_TIME_STAMP5                            0x0020UL
#define CAN_CS6_TIME_STAMP4                            0x0010UL
#define CAN_CS6_TIME_STAMP3                            0x0008UL
#define CAN_CS6_TIME_STAMP2                            0x0004UL
#define CAN_CS6_TIME_STAMP1                            0x0002UL
#define CAN_CS6_TIME_STAMP0                            0x0001UL
#define CAN_CS6_TIME_STAMP                             0xFFFFUL

/* Masks for registers ID6 */
#define CAN_ID6_MASK                                   0xFFFFFFFFUL
#define CAN_ID6_PRIO2                                  0x80000000UL
#define CAN_ID6_PRIO1                                  0x40000000UL
#define CAN_ID6_PRIO0                                  0x20000000UL
#define CAN_ID6_PRIO                                   0xE0000000UL
#define CAN_ID6_STD10                                  0x10000000UL
#define CAN_ID6_STD9                                   0x8000000UL
#define CAN_ID6_STD8                                   0x4000000UL
#define CAN_ID6_STD7                                   0x2000000UL
#define CAN_ID6_STD6                                   0x1000000UL
#define CAN_ID6_STD5                                   0x800000UL
#define CAN_ID6_STD4                                   0x400000UL
#define CAN_ID6_STD3                                   0x200000UL
#define CAN_ID6_STD2                                   0x100000UL
#define CAN_ID6_STD1                                   0x80000UL
#define CAN_ID6_STD0                                   0x40000UL
#define CAN_ID6_STD                                    0x1FFC0000UL
#define CAN_ID6_EXT17                                  0x20000UL
#define CAN_ID6_EXT16                                  0x10000UL
#define CAN_ID6_EXT15                                  0x8000UL
#define CAN_ID6_EXT14                                  0x4000UL
#define CAN_ID6_EXT13                                  0x2000UL
#define CAN_ID6_EXT12                                  0x1000UL
#define CAN_ID6_EXT11                                  0x0800UL
#define CAN_ID6_EXT10                                  0x0400UL
#define CAN_ID6_EXT9                                   0x0200UL
#define CAN_ID6_EXT8                                   0x0100UL
#define CAN_ID6_EXT7                                   0x0080UL
#define CAN_ID6_EXT6                                   0x0040UL
#define CAN_ID6_EXT5                                   0x0020UL
#define CAN_ID6_EXT4                                   0x0010UL
#define CAN_ID6_EXT3                                   0x0008UL
#define CAN_ID6_EXT2                                   0x0004UL
#define CAN_ID6_EXT1                                   0x0002UL
#define CAN_ID6_EXT0                                   0x0001UL
#define CAN_ID6_EXT                                    0x3FFFFUL

/* Masks for registers WORD06 */
#define CAN_WORD06_MASK                                0xFFFFFFFFUL
#define CAN_WORD06_DATA_BYTE_07                        0x80000000UL
#define CAN_WORD06_DATA_BYTE_06                        0x40000000UL
#define CAN_WORD06_DATA_BYTE_05                        0x20000000UL
#define CAN_WORD06_DATA_BYTE_04                        0x10000000UL
#define CAN_WORD06_DATA_BYTE_03                        0x8000000UL
#define CAN_WORD06_DATA_BYTE_02                        0x4000000UL
#define CAN_WORD06_DATA_BYTE_01                        0x2000000UL
#define CAN_WORD06_DATA_BYTE_00                        0x1000000UL
#define CAN_WORD06_DATA_BYTE_0                         0xFF000000UL
#define CAN_WORD06_DATA_BYTE_17                        0x800000UL
#define CAN_WORD06_DATA_BYTE_16                        0x400000UL
#define CAN_WORD06_DATA_BYTE_15                        0x200000UL
#define CAN_WORD06_DATA_BYTE_14                        0x100000UL
#define CAN_WORD06_DATA_BYTE_13                        0x80000UL
#define CAN_WORD06_DATA_BYTE_12                        0x40000UL
#define CAN_WORD06_DATA_BYTE_11                        0x20000UL
#define CAN_WORD06_DATA_BYTE_10                        0x10000UL
#define CAN_WORD06_DATA_BYTE_1                         0xFF0000UL
#define CAN_WORD06_DATA_BYTE_27                        0x8000UL
#define CAN_WORD06_DATA_BYTE_26                        0x4000UL
#define CAN_WORD06_DATA_BYTE_25                        0x2000UL
#define CAN_WORD06_DATA_BYTE_24                        0x1000UL
#define CAN_WORD06_DATA_BYTE_23                        0x0800UL
#define CAN_WORD06_DATA_BYTE_22                        0x0400UL
#define CAN_WORD06_DATA_BYTE_21                        0x0200UL
#define CAN_WORD06_DATA_BYTE_20                        0x0100UL
#define CAN_WORD06_DATA_BYTE_2                         0xFF00UL
#define CAN_WORD06_DATA_BYTE_37                        0x0080UL
#define CAN_WORD06_DATA_BYTE_36                        0x0040UL
#define CAN_WORD06_DATA_BYTE_35                        0x0020UL
#define CAN_WORD06_DATA_BYTE_34                        0x0010UL
#define CAN_WORD06_DATA_BYTE_33                        0x0008UL
#define CAN_WORD06_DATA_BYTE_32                        0x0004UL
#define CAN_WORD06_DATA_BYTE_31                        0x0002UL
#define CAN_WORD06_DATA_BYTE_30                        0x0001UL
#define CAN_WORD06_DATA_BYTE_3                         0x00FFUL

/* Masks for registers WORD16 */
#define CAN_WORD16_MASK                                0xFFFFFFFFUL
#define CAN_WORD16_DATA_BYTE_47                        0x80000000UL
#define CAN_WORD16_DATA_BYTE_46                        0x40000000UL
#define CAN_WORD16_DATA_BYTE_45                        0x20000000UL
#define CAN_WORD16_DATA_BYTE_44                        0x10000000UL
#define CAN_WORD16_DATA_BYTE_43                        0x8000000UL
#define CAN_WORD16_DATA_BYTE_42                        0x4000000UL
#define CAN_WORD16_DATA_BYTE_41                        0x2000000UL
#define CAN_WORD16_DATA_BYTE_40                        0x1000000UL
#define CAN_WORD16_DATA_BYTE_4                         0xFF000000UL
#define CAN_WORD16_DATA_BYTE_57                        0x800000UL
#define CAN_WORD16_DATA_BYTE_56                        0x400000UL
#define CAN_WORD16_DATA_BYTE_55                        0x200000UL
#define CAN_WORD16_DATA_BYTE_54                        0x100000UL
#define CAN_WORD16_DATA_BYTE_53                        0x80000UL
#define CAN_WORD16_DATA_BYTE_52                        0x40000UL
#define CAN_WORD16_DATA_BYTE_51                        0x20000UL
#define CAN_WORD16_DATA_BYTE_50                        0x10000UL
#define CAN_WORD16_DATA_BYTE_5                         0xFF0000UL
#define CAN_WORD16_DATA_BYTE_67                        0x8000UL
#define CAN_WORD16_DATA_BYTE_66                        0x4000UL
#define CAN_WORD16_DATA_BYTE_65                        0x2000UL
#define CAN_WORD16_DATA_BYTE_64                        0x1000UL
#define CAN_WORD16_DATA_BYTE_63                        0x0800UL
#define CAN_WORD16_DATA_BYTE_62                        0x0400UL
#define CAN_WORD16_DATA_BYTE_61                        0x0200UL
#define CAN_WORD16_DATA_BYTE_60                        0x0100UL
#define CAN_WORD16_DATA_BYTE_6                         0xFF00UL
#define CAN_WORD16_DATA_BYTE_77                        0x0080UL
#define CAN_WORD16_DATA_BYTE_76                        0x0040UL
#define CAN_WORD16_DATA_BYTE_75                        0x0020UL
#define CAN_WORD16_DATA_BYTE_74                        0x0010UL
#define CAN_WORD16_DATA_BYTE_73                        0x0008UL
#define CAN_WORD16_DATA_BYTE_72                        0x0004UL
#define CAN_WORD16_DATA_BYTE_71                        0x0002UL
#define CAN_WORD16_DATA_BYTE_70                        0x0001UL
#define CAN_WORD16_DATA_BYTE_7                         0x00FFUL

/* Masks for registers CS7 */
#define CAN_CS7_MASK                                   0xF7FFFFFUL
#define CAN_CS7_CODE3                                  0x8000000UL
#define CAN_CS7_CODE2                                  0x4000000UL
#define CAN_CS7_CODE1                                  0x2000000UL
#define CAN_CS7_CODE0                                  0x1000000UL
#define CAN_CS7_CODE                                   0xF000000UL
#define CAN_CS7_SRR                                    0x400000UL
#define CAN_CS7_IDE                                    0x200000UL
#define CAN_CS7_RTR                                    0x100000UL
#define CAN_CS7_DLC3                                   0x80000UL
#define CAN_CS7_DLC2                                   0x40000UL
#define CAN_CS7_DLC1                                   0x20000UL
#define CAN_CS7_DLC0                                   0x10000UL
#define CAN_CS7_DLC                                    0xF0000UL
#define CAN_CS7_TIME_STAMP15                           0x8000UL
#define CAN_CS7_TIME_STAMP14                           0x4000UL
#define CAN_CS7_TIME_STAMP13                           0x2000UL
#define CAN_CS7_TIME_STAMP12                           0x1000UL
#define CAN_CS7_TIME_STAMP11                           0x0800UL
#define CAN_CS7_TIME_STAMP10                           0x0400UL
#define CAN_CS7_TIME_STAMP9                            0x0200UL
#define CAN_CS7_TIME_STAMP8                            0x0100UL
#define CAN_CS7_TIME_STAMP7                            0x0080UL
#define CAN_CS7_TIME_STAMP6                            0x0040UL
#define CAN_CS7_TIME_STAMP5                            0x0020UL
#define CAN_CS7_TIME_STAMP4                            0x0010UL
#define CAN_CS7_TIME_STAMP3                            0x0008UL
#define CAN_CS7_TIME_STAMP2                            0x0004UL
#define CAN_CS7_TIME_STAMP1                            0x0002UL
#define CAN_CS7_TIME_STAMP0                            0x0001UL
#define CAN_CS7_TIME_STAMP                             0xFFFFUL

/* Masks for registers ID7 */
#define CAN_ID7_MASK                                   0xFFFFFFFFUL
#define CAN_ID7_PRIO2                                  0x80000000UL
#define CAN_ID7_PRIO1                                  0x40000000UL
#define CAN_ID7_PRIO0                                  0x20000000UL
#define CAN_ID7_PRIO                                   0xE0000000UL
#define CAN_ID7_STD10                                  0x10000000UL
#define CAN_ID7_STD9                                   0x8000000UL
#define CAN_ID7_STD8                                   0x4000000UL
#define CAN_ID7_STD7                                   0x2000000UL
#define CAN_ID7_STD6                                   0x1000000UL
#define CAN_ID7_STD5                                   0x800000UL
#define CAN_ID7_STD4                                   0x400000UL
#define CAN_ID7_STD3                                   0x200000UL
#define CAN_ID7_STD2                                   0x100000UL
#define CAN_ID7_STD1                                   0x80000UL
#define CAN_ID7_STD0                                   0x40000UL
#define CAN_ID7_STD                                    0x1FFC0000UL
#define CAN_ID7_EXT17                                  0x20000UL
#define CAN_ID7_EXT16                                  0x10000UL
#define CAN_ID7_EXT15                                  0x8000UL
#define CAN_ID7_EXT14                                  0x4000UL
#define CAN_ID7_EXT13                                  0x2000UL
#define CAN_ID7_EXT12                                  0x1000UL
#define CAN_ID7_EXT11                                  0x0800UL
#define CAN_ID7_EXT10                                  0x0400UL
#define CAN_ID7_EXT9                                   0x0200UL
#define CAN_ID7_EXT8                                   0x0100UL
#define CAN_ID7_EXT7                                   0x0080UL
#define CAN_ID7_EXT6                                   0x0040UL
#define CAN_ID7_EXT5                                   0x0020UL
#define CAN_ID7_EXT4                                   0x0010UL
#define CAN_ID7_EXT3                                   0x0008UL
#define CAN_ID7_EXT2                                   0x0004UL
#define CAN_ID7_EXT1                                   0x0002UL
#define CAN_ID7_EXT0                                   0x0001UL
#define CAN_ID7_EXT                                    0x3FFFFUL

/* Masks for registers WORD07 */
#define CAN_WORD07_MASK                                0xFFFFFFFFUL
#define CAN_WORD07_DATA_BYTE_07                        0x80000000UL
#define CAN_WORD07_DATA_BYTE_06                        0x40000000UL
#define CAN_WORD07_DATA_BYTE_05                        0x20000000UL
#define CAN_WORD07_DATA_BYTE_04                        0x10000000UL
#define CAN_WORD07_DATA_BYTE_03                        0x8000000UL
#define CAN_WORD07_DATA_BYTE_02                        0x4000000UL
#define CAN_WORD07_DATA_BYTE_01                        0x2000000UL
#define CAN_WORD07_DATA_BYTE_00                        0x1000000UL
#define CAN_WORD07_DATA_BYTE_0                         0xFF000000UL
#define CAN_WORD07_DATA_BYTE_17                        0x800000UL
#define CAN_WORD07_DATA_BYTE_16                        0x400000UL
#define CAN_WORD07_DATA_BYTE_15                        0x200000UL
#define CAN_WORD07_DATA_BYTE_14                        0x100000UL
#define CAN_WORD07_DATA_BYTE_13                        0x80000UL
#define CAN_WORD07_DATA_BYTE_12                        0x40000UL
#define CAN_WORD07_DATA_BYTE_11                        0x20000UL
#define CAN_WORD07_DATA_BYTE_10                        0x10000UL
#define CAN_WORD07_DATA_BYTE_1                         0xFF0000UL
#define CAN_WORD07_DATA_BYTE_27                        0x8000UL
#define CAN_WORD07_DATA_BYTE_26                        0x4000UL
#define CAN_WORD07_DATA_BYTE_25                        0x2000UL
#define CAN_WORD07_DATA_BYTE_24                        0x1000UL
#define CAN_WORD07_DATA_BYTE_23                        0x0800UL
#define CAN_WORD07_DATA_BYTE_22                        0x0400UL
#define CAN_WORD07_DATA_BYTE_21                        0x0200UL
#define CAN_WORD07_DATA_BYTE_20                        0x0100UL
#define CAN_WORD07_DATA_BYTE_2                         0xFF00UL
#define CAN_WORD07_DATA_BYTE_37                        0x0080UL
#define CAN_WORD07_DATA_BYTE_36                        0x0040UL
#define CAN_WORD07_DATA_BYTE_35                        0x0020UL
#define CAN_WORD07_DATA_BYTE_34                        0x0010UL
#define CAN_WORD07_DATA_BYTE_33                        0x0008UL
#define CAN_WORD07_DATA_BYTE_32                        0x0004UL
#define CAN_WORD07_DATA_BYTE_31                        0x0002UL
#define CAN_WORD07_DATA_BYTE_30                        0x0001UL
#define CAN_WORD07_DATA_BYTE_3                         0x00FFUL

/* Masks for registers WORD17 */
#define CAN_WORD17_MASK                                0xFFFFFFFFUL
#define CAN_WORD17_DATA_BYTE_47                        0x80000000UL
#define CAN_WORD17_DATA_BYTE_46                        0x40000000UL
#define CAN_WORD17_DATA_BYTE_45                        0x20000000UL
#define CAN_WORD17_DATA_BYTE_44                        0x10000000UL
#define CAN_WORD17_DATA_BYTE_43                        0x8000000UL
#define CAN_WORD17_DATA_BYTE_42                        0x4000000UL
#define CAN_WORD17_DATA_BYTE_41                        0x2000000UL
#define CAN_WORD17_DATA_BYTE_40                        0x1000000UL
#define CAN_WORD17_DATA_BYTE_4                         0xFF000000UL
#define CAN_WORD17_DATA_BYTE_57                        0x800000UL
#define CAN_WORD17_DATA_BYTE_56                        0x400000UL
#define CAN_WORD17_DATA_BYTE_55                        0x200000UL
#define CAN_WORD17_DATA_BYTE_54                        0x100000UL
#define CAN_WORD17_DATA_BYTE_53                        0x80000UL
#define CAN_WORD17_DATA_BYTE_52                        0x40000UL
#define CAN_WORD17_DATA_BYTE_51                        0x20000UL
#define CAN_WORD17_DATA_BYTE_50                        0x10000UL
#define CAN_WORD17_DATA_BYTE_5                         0xFF0000UL
#define CAN_WORD17_DATA_BYTE_67                        0x8000UL
#define CAN_WORD17_DATA_BYTE_66                        0x4000UL
#define CAN_WORD17_DATA_BYTE_65                        0x2000UL
#define CAN_WORD17_DATA_BYTE_64                        0x1000UL
#define CAN_WORD17_DATA_BYTE_63                        0x0800UL
#define CAN_WORD17_DATA_BYTE_62                        0x0400UL
#define CAN_WORD17_DATA_BYTE_61                        0x0200UL
#define CAN_WORD17_DATA_BYTE_60                        0x0100UL
#define CAN_WORD17_DATA_BYTE_6                         0xFF00UL
#define CAN_WORD17_DATA_BYTE_77                        0x0080UL
#define CAN_WORD17_DATA_BYTE_76                        0x0040UL
#define CAN_WORD17_DATA_BYTE_75                        0x0020UL
#define CAN_WORD17_DATA_BYTE_74                        0x0010UL
#define CAN_WORD17_DATA_BYTE_73                        0x0008UL
#define CAN_WORD17_DATA_BYTE_72                        0x0004UL
#define CAN_WORD17_DATA_BYTE_71                        0x0002UL
#define CAN_WORD17_DATA_BYTE_70                        0x0001UL
#define CAN_WORD17_DATA_BYTE_7                         0x00FFUL

/* Masks for registers CS8 */
#define CAN_CS8_MASK                                   0xF7FFFFFUL
#define CAN_CS8_CODE3                                  0x8000000UL
#define CAN_CS8_CODE2                                  0x4000000UL
#define CAN_CS8_CODE1                                  0x2000000UL
#define CAN_CS8_CODE0                                  0x1000000UL
#define CAN_CS8_CODE                                   0xF000000UL
#define CAN_CS8_SRR                                    0x400000UL
#define CAN_CS8_IDE                                    0x200000UL
#define CAN_CS8_RTR                                    0x100000UL
#define CAN_CS8_DLC3                                   0x80000UL
#define CAN_CS8_DLC2                                   0x40000UL
#define CAN_CS8_DLC1                                   0x20000UL
#define CAN_CS8_DLC0                                   0x10000UL
#define CAN_CS8_DLC                                    0xF0000UL
#define CAN_CS8_TIME_STAMP15                           0x8000UL
#define CAN_CS8_TIME_STAMP14                           0x4000UL
#define CAN_CS8_TIME_STAMP13                           0x2000UL
#define CAN_CS8_TIME_STAMP12                           0x1000UL
#define CAN_CS8_TIME_STAMP11                           0x0800UL
#define CAN_CS8_TIME_STAMP10                           0x0400UL
#define CAN_CS8_TIME_STAMP9                            0x0200UL
#define CAN_CS8_TIME_STAMP8                            0x0100UL
#define CAN_CS8_TIME_STAMP7                            0x0080UL
#define CAN_CS8_TIME_STAMP6                            0x0040UL
#define CAN_CS8_TIME_STAMP5                            0x0020UL
#define CAN_CS8_TIME_STAMP4                            0x0010UL
#define CAN_CS8_TIME_STAMP3                            0x0008UL
#define CAN_CS8_TIME_STAMP2                            0x0004UL
#define CAN_CS8_TIME_STAMP1                            0x0002UL
#define CAN_CS8_TIME_STAMP0                            0x0001UL
#define CAN_CS8_TIME_STAMP                             0xFFFFUL

/* Masks for registers ID8 */
#define CAN_ID8_MASK                                   0xFFFFFFFFUL
#define CAN_ID8_PRIO2                                  0x80000000UL
#define CAN_ID8_PRIO1                                  0x40000000UL
#define CAN_ID8_PRIO0                                  0x20000000UL
#define CAN_ID8_PRIO                                   0xE0000000UL
#define CAN_ID8_STD10                                  0x10000000UL
#define CAN_ID8_STD9                                   0x8000000UL
#define CAN_ID8_STD8                                   0x4000000UL
#define CAN_ID8_STD7                                   0x2000000UL
#define CAN_ID8_STD6                                   0x1000000UL
#define CAN_ID8_STD5                                   0x800000UL
#define CAN_ID8_STD4                                   0x400000UL
#define CAN_ID8_STD3                                   0x200000UL
#define CAN_ID8_STD2                                   0x100000UL
#define CAN_ID8_STD1                                   0x80000UL
#define CAN_ID8_STD0                                   0x40000UL
#define CAN_ID8_STD                                    0x1FFC0000UL
#define CAN_ID8_EXT17                                  0x20000UL
#define CAN_ID8_EXT16                                  0x10000UL
#define CAN_ID8_EXT15                                  0x8000UL
#define CAN_ID8_EXT14                                  0x4000UL
#define CAN_ID8_EXT13                                  0x2000UL
#define CAN_ID8_EXT12                                  0x1000UL
#define CAN_ID8_EXT11                                  0x0800UL
#define CAN_ID8_EXT10                                  0x0400UL
#define CAN_ID8_EXT9                                   0x0200UL
#define CAN_ID8_EXT8                                   0x0100UL
#define CAN_ID8_EXT7                                   0x0080UL
#define CAN_ID8_EXT6                                   0x0040UL
#define CAN_ID8_EXT5                                   0x0020UL
#define CAN_ID8_EXT4                                   0x0010UL
#define CAN_ID8_EXT3                                   0x0008UL
#define CAN_ID8_EXT2                                   0x0004UL
#define CAN_ID8_EXT1                                   0x0002UL
#define CAN_ID8_EXT0                                   0x0001UL
#define CAN_ID8_EXT                                    0x3FFFFUL

/* Masks for registers WORD08 */
#define CAN_WORD08_MASK                                0xFFFFFFFFUL
#define CAN_WORD08_DATA_BYTE_07                        0x80000000UL
#define CAN_WORD08_DATA_BYTE_06                        0x40000000UL
#define CAN_WORD08_DATA_BYTE_05                        0x20000000UL
#define CAN_WORD08_DATA_BYTE_04                        0x10000000UL
#define CAN_WORD08_DATA_BYTE_03                        0x8000000UL
#define CAN_WORD08_DATA_BYTE_02                        0x4000000UL
#define CAN_WORD08_DATA_BYTE_01                        0x2000000UL
#define CAN_WORD08_DATA_BYTE_00                        0x1000000UL
#define CAN_WORD08_DATA_BYTE_0                         0xFF000000UL
#define CAN_WORD08_DATA_BYTE_17                        0x800000UL
#define CAN_WORD08_DATA_BYTE_16                        0x400000UL
#define CAN_WORD08_DATA_BYTE_15                        0x200000UL
#define CAN_WORD08_DATA_BYTE_14                        0x100000UL
#define CAN_WORD08_DATA_BYTE_13                        0x80000UL
#define CAN_WORD08_DATA_BYTE_12                        0x40000UL
#define CAN_WORD08_DATA_BYTE_11                        0x20000UL
#define CAN_WORD08_DATA_BYTE_10                        0x10000UL
#define CAN_WORD08_DATA_BYTE_1                         0xFF0000UL
#define CAN_WORD08_DATA_BYTE_27                        0x8000UL
#define CAN_WORD08_DATA_BYTE_26                        0x4000UL
#define CAN_WORD08_DATA_BYTE_25                        0x2000UL
#define CAN_WORD08_DATA_BYTE_24                        0x1000UL
#define CAN_WORD08_DATA_BYTE_23                        0x0800UL
#define CAN_WORD08_DATA_BYTE_22                        0x0400UL
#define CAN_WORD08_DATA_BYTE_21                        0x0200UL
#define CAN_WORD08_DATA_BYTE_20                        0x0100UL
#define CAN_WORD08_DATA_BYTE_2                         0xFF00UL
#define CAN_WORD08_DATA_BYTE_37                        0x0080UL
#define CAN_WORD08_DATA_BYTE_36                        0x0040UL
#define CAN_WORD08_DATA_BYTE_35                        0x0020UL
#define CAN_WORD08_DATA_BYTE_34                        0x0010UL
#define CAN_WORD08_DATA_BYTE_33                        0x0008UL
#define CAN_WORD08_DATA_BYTE_32                        0x0004UL
#define CAN_WORD08_DATA_BYTE_31                        0x0002UL
#define CAN_WORD08_DATA_BYTE_30                        0x0001UL
#define CAN_WORD08_DATA_BYTE_3                         0x00FFUL

/* Masks for registers WORD18 */
#define CAN_WORD18_MASK                                0xFFFFFFFFUL
#define CAN_WORD18_DATA_BYTE_47                        0x80000000UL
#define CAN_WORD18_DATA_BYTE_46                        0x40000000UL
#define CAN_WORD18_DATA_BYTE_45                        0x20000000UL
#define CAN_WORD18_DATA_BYTE_44                        0x10000000UL
#define CAN_WORD18_DATA_BYTE_43                        0x8000000UL
#define CAN_WORD18_DATA_BYTE_42                        0x4000000UL
#define CAN_WORD18_DATA_BYTE_41                        0x2000000UL
#define CAN_WORD18_DATA_BYTE_40                        0x1000000UL
#define CAN_WORD18_DATA_BYTE_4                         0xFF000000UL
#define CAN_WORD18_DATA_BYTE_57                        0x800000UL
#define CAN_WORD18_DATA_BYTE_56                        0x400000UL
#define CAN_WORD18_DATA_BYTE_55                        0x200000UL
#define CAN_WORD18_DATA_BYTE_54                        0x100000UL
#define CAN_WORD18_DATA_BYTE_53                        0x80000UL
#define CAN_WORD18_DATA_BYTE_52                        0x40000UL
#define CAN_WORD18_DATA_BYTE_51                        0x20000UL
#define CAN_WORD18_DATA_BYTE_50                        0x10000UL
#define CAN_WORD18_DATA_BYTE_5                         0xFF0000UL
#define CAN_WORD18_DATA_BYTE_67                        0x8000UL
#define CAN_WORD18_DATA_BYTE_66                        0x4000UL
#define CAN_WORD18_DATA_BYTE_65                        0x2000UL
#define CAN_WORD18_DATA_BYTE_64                        0x1000UL
#define CAN_WORD18_DATA_BYTE_63                        0x0800UL
#define CAN_WORD18_DATA_BYTE_62                        0x0400UL
#define CAN_WORD18_DATA_BYTE_61                        0x0200UL
#define CAN_WORD18_DATA_BYTE_60                        0x0100UL
#define CAN_WORD18_DATA_BYTE_6                         0xFF00UL
#define CAN_WORD18_DATA_BYTE_77                        0x0080UL
#define CAN_WORD18_DATA_BYTE_76                        0x0040UL
#define CAN_WORD18_DATA_BYTE_75                        0x0020UL
#define CAN_WORD18_DATA_BYTE_74                        0x0010UL
#define CAN_WORD18_DATA_BYTE_73                        0x0008UL
#define CAN_WORD18_DATA_BYTE_72                        0x0004UL
#define CAN_WORD18_DATA_BYTE_71                        0x0002UL
#define CAN_WORD18_DATA_BYTE_70                        0x0001UL
#define CAN_WORD18_DATA_BYTE_7                         0x00FFUL

/* Masks for registers CS9 */
#define CAN_CS9_MASK                                   0xF7FFFFFUL
#define CAN_CS9_CODE3                                  0x8000000UL
#define CAN_CS9_CODE2                                  0x4000000UL
#define CAN_CS9_CODE1                                  0x2000000UL
#define CAN_CS9_CODE0                                  0x1000000UL
#define CAN_CS9_CODE                                   0xF000000UL
#define CAN_CS9_SRR                                    0x400000UL
#define CAN_CS9_IDE                                    0x200000UL
#define CAN_CS9_RTR                                    0x100000UL
#define CAN_CS9_DLC3                                   0x80000UL
#define CAN_CS9_DLC2                                   0x40000UL
#define CAN_CS9_DLC1                                   0x20000UL
#define CAN_CS9_DLC0                                   0x10000UL
#define CAN_CS9_DLC                                    0xF0000UL
#define CAN_CS9_TIME_STAMP15                           0x8000UL
#define CAN_CS9_TIME_STAMP14                           0x4000UL
#define CAN_CS9_TIME_STAMP13                           0x2000UL
#define CAN_CS9_TIME_STAMP12                           0x1000UL
#define CAN_CS9_TIME_STAMP11                           0x0800UL
#define CAN_CS9_TIME_STAMP10                           0x0400UL
#define CAN_CS9_TIME_STAMP9                            0x0200UL
#define CAN_CS9_TIME_STAMP8                            0x0100UL
#define CAN_CS9_TIME_STAMP7                            0x0080UL
#define CAN_CS9_TIME_STAMP6                            0x0040UL
#define CAN_CS9_TIME_STAMP5                            0x0020UL
#define CAN_CS9_TIME_STAMP4                            0x0010UL
#define CAN_CS9_TIME_STAMP3                            0x0008UL
#define CAN_CS9_TIME_STAMP2                            0x0004UL
#define CAN_CS9_TIME_STAMP1                            0x0002UL
#define CAN_CS9_TIME_STAMP0                            0x0001UL
#define CAN_CS9_TIME_STAMP                             0xFFFFUL

/* Masks for registers ID9 */
#define CAN_ID9_MASK                                   0xFFFFFFFFUL
#define CAN_ID9_PRIO2                                  0x80000000UL
#define CAN_ID9_PRIO1                                  0x40000000UL
#define CAN_ID9_PRIO0                                  0x20000000UL
#define CAN_ID9_PRIO                                   0xE0000000UL
#define CAN_ID9_STD10                                  0x10000000UL
#define CAN_ID9_STD9                                   0x8000000UL
#define CAN_ID9_STD8                                   0x4000000UL
#define CAN_ID9_STD7                                   0x2000000UL
#define CAN_ID9_STD6                                   0x1000000UL
#define CAN_ID9_STD5                                   0x800000UL
#define CAN_ID9_STD4                                   0x400000UL
#define CAN_ID9_STD3                                   0x200000UL
#define CAN_ID9_STD2                                   0x100000UL
#define CAN_ID9_STD1                                   0x80000UL
#define CAN_ID9_STD0                                   0x40000UL
#define CAN_ID9_STD                                    0x1FFC0000UL
#define CAN_ID9_EXT17                                  0x20000UL
#define CAN_ID9_EXT16                                  0x10000UL
#define CAN_ID9_EXT15                                  0x8000UL
#define CAN_ID9_EXT14                                  0x4000UL
#define CAN_ID9_EXT13                                  0x2000UL
#define CAN_ID9_EXT12                                  0x1000UL
#define CAN_ID9_EXT11                                  0x0800UL
#define CAN_ID9_EXT10                                  0x0400UL
#define CAN_ID9_EXT9                                   0x0200UL
#define CAN_ID9_EXT8                                   0x0100UL
#define CAN_ID9_EXT7                                   0x0080UL
#define CAN_ID9_EXT6                                   0x0040UL
#define CAN_ID9_EXT5                                   0x0020UL
#define CAN_ID9_EXT4                                   0x0010UL
#define CAN_ID9_EXT3                                   0x0008UL
#define CAN_ID9_EXT2                                   0x0004UL
#define CAN_ID9_EXT1                                   0x0002UL
#define CAN_ID9_EXT0                                   0x0001UL
#define CAN_ID9_EXT                                    0x3FFFFUL

/* Masks for registers WORD09 */
#define CAN_WORD09_MASK                                0xFFFFFFFFUL
#define CAN_WORD09_DATA_BYTE_07                        0x80000000UL
#define CAN_WORD09_DATA_BYTE_06                        0x40000000UL
#define CAN_WORD09_DATA_BYTE_05                        0x20000000UL
#define CAN_WORD09_DATA_BYTE_04                        0x10000000UL
#define CAN_WORD09_DATA_BYTE_03                        0x8000000UL
#define CAN_WORD09_DATA_BYTE_02                        0x4000000UL
#define CAN_WORD09_DATA_BYTE_01                        0x2000000UL
#define CAN_WORD09_DATA_BYTE_00                        0x1000000UL
#define CAN_WORD09_DATA_BYTE_0                         0xFF000000UL
#define CAN_WORD09_DATA_BYTE_17                        0x800000UL
#define CAN_WORD09_DATA_BYTE_16                        0x400000UL
#define CAN_WORD09_DATA_BYTE_15                        0x200000UL
#define CAN_WORD09_DATA_BYTE_14                        0x100000UL
#define CAN_WORD09_DATA_BYTE_13                        0x80000UL
#define CAN_WORD09_DATA_BYTE_12                        0x40000UL
#define CAN_WORD09_DATA_BYTE_11                        0x20000UL
#define CAN_WORD09_DATA_BYTE_10                        0x10000UL
#define CAN_WORD09_DATA_BYTE_1                         0xFF0000UL
#define CAN_WORD09_DATA_BYTE_27                        0x8000UL
#define CAN_WORD09_DATA_BYTE_26                        0x4000UL
#define CAN_WORD09_DATA_BYTE_25                        0x2000UL
#define CAN_WORD09_DATA_BYTE_24                        0x1000UL
#define CAN_WORD09_DATA_BYTE_23                        0x0800UL
#define CAN_WORD09_DATA_BYTE_22                        0x0400UL
#define CAN_WORD09_DATA_BYTE_21                        0x0200UL
#define CAN_WORD09_DATA_BYTE_20                        0x0100UL
#define CAN_WORD09_DATA_BYTE_2                         0xFF00UL
#define CAN_WORD09_DATA_BYTE_37                        0x0080UL
#define CAN_WORD09_DATA_BYTE_36                        0x0040UL
#define CAN_WORD09_DATA_BYTE_35                        0x0020UL
#define CAN_WORD09_DATA_BYTE_34                        0x0010UL
#define CAN_WORD09_DATA_BYTE_33                        0x0008UL
#define CAN_WORD09_DATA_BYTE_32                        0x0004UL
#define CAN_WORD09_DATA_BYTE_31                        0x0002UL
#define CAN_WORD09_DATA_BYTE_30                        0x0001UL
#define CAN_WORD09_DATA_BYTE_3                         0x00FFUL

/* Masks for registers WORD19 */
#define CAN_WORD19_MASK                                0xFFFFFFFFUL
#define CAN_WORD19_DATA_BYTE_47                        0x80000000UL
#define CAN_WORD19_DATA_BYTE_46                        0x40000000UL
#define CAN_WORD19_DATA_BYTE_45                        0x20000000UL
#define CAN_WORD19_DATA_BYTE_44                        0x10000000UL
#define CAN_WORD19_DATA_BYTE_43                        0x8000000UL
#define CAN_WORD19_DATA_BYTE_42                        0x4000000UL
#define CAN_WORD19_DATA_BYTE_41                        0x2000000UL
#define CAN_WORD19_DATA_BYTE_40                        0x1000000UL
#define CAN_WORD19_DATA_BYTE_4                         0xFF000000UL
#define CAN_WORD19_DATA_BYTE_57                        0x800000UL
#define CAN_WORD19_DATA_BYTE_56                        0x400000UL
#define CAN_WORD19_DATA_BYTE_55                        0x200000UL
#define CAN_WORD19_DATA_BYTE_54                        0x100000UL
#define CAN_WORD19_DATA_BYTE_53                        0x80000UL
#define CAN_WORD19_DATA_BYTE_52                        0x40000UL
#define CAN_WORD19_DATA_BYTE_51                        0x20000UL
#define CAN_WORD19_DATA_BYTE_50                        0x10000UL
#define CAN_WORD19_DATA_BYTE_5                         0xFF0000UL
#define CAN_WORD19_DATA_BYTE_67                        0x8000UL
#define CAN_WORD19_DATA_BYTE_66                        0x4000UL
#define CAN_WORD19_DATA_BYTE_65                        0x2000UL
#define CAN_WORD19_DATA_BYTE_64                        0x1000UL
#define CAN_WORD19_DATA_BYTE_63                        0x0800UL
#define CAN_WORD19_DATA_BYTE_62                        0x0400UL
#define CAN_WORD19_DATA_BYTE_61                        0x0200UL
#define CAN_WORD19_DATA_BYTE_60                        0x0100UL
#define CAN_WORD19_DATA_BYTE_6                         0xFF00UL
#define CAN_WORD19_DATA_BYTE_77                        0x0080UL
#define CAN_WORD19_DATA_BYTE_76                        0x0040UL
#define CAN_WORD19_DATA_BYTE_75                        0x0020UL
#define CAN_WORD19_DATA_BYTE_74                        0x0010UL
#define CAN_WORD19_DATA_BYTE_73                        0x0008UL
#define CAN_WORD19_DATA_BYTE_72                        0x0004UL
#define CAN_WORD19_DATA_BYTE_71                        0x0002UL
#define CAN_WORD19_DATA_BYTE_70                        0x0001UL
#define CAN_WORD19_DATA_BYTE_7                         0x00FFUL

/* Masks for registers CS10 */
#define CAN_CS10_MASK                                  0xF7FFFFFUL
#define CAN_CS10_CODE3                                 0x8000000UL
#define CAN_CS10_CODE2                                 0x4000000UL
#define CAN_CS10_CODE1                                 0x2000000UL
#define CAN_CS10_CODE0                                 0x1000000UL
#define CAN_CS10_CODE                                  0xF000000UL
#define CAN_CS10_SRR                                   0x400000UL
#define CAN_CS10_IDE                                   0x200000UL
#define CAN_CS10_RTR                                   0x100000UL
#define CAN_CS10_DLC3                                  0x80000UL
#define CAN_CS10_DLC2                                  0x40000UL
#define CAN_CS10_DLC1                                  0x20000UL
#define CAN_CS10_DLC0                                  0x10000UL
#define CAN_CS10_DLC                                   0xF0000UL
#define CAN_CS10_TIME_STAMP15                          0x8000UL
#define CAN_CS10_TIME_STAMP14                          0x4000UL
#define CAN_CS10_TIME_STAMP13                          0x2000UL
#define CAN_CS10_TIME_STAMP12                          0x1000UL
#define CAN_CS10_TIME_STAMP11                          0x0800UL
#define CAN_CS10_TIME_STAMP10                          0x0400UL
#define CAN_CS10_TIME_STAMP9                           0x0200UL
#define CAN_CS10_TIME_STAMP8                           0x0100UL
#define CAN_CS10_TIME_STAMP7                           0x0080UL
#define CAN_CS10_TIME_STAMP6                           0x0040UL
#define CAN_CS10_TIME_STAMP5                           0x0020UL
#define CAN_CS10_TIME_STAMP4                           0x0010UL
#define CAN_CS10_TIME_STAMP3                           0x0008UL
#define CAN_CS10_TIME_STAMP2                           0x0004UL
#define CAN_CS10_TIME_STAMP1                           0x0002UL
#define CAN_CS10_TIME_STAMP0                           0x0001UL
#define CAN_CS10_TIME_STAMP                            0xFFFFUL

/* Masks for registers ID10 */
#define CAN_ID10_MASK                                  0xFFFFFFFFUL
#define CAN_ID10_PRIO2                                 0x80000000UL
#define CAN_ID10_PRIO1                                 0x40000000UL
#define CAN_ID10_PRIO0                                 0x20000000UL
#define CAN_ID10_PRIO                                  0xE0000000UL
#define CAN_ID10_STD10                                 0x10000000UL
#define CAN_ID10_STD9                                  0x8000000UL
#define CAN_ID10_STD8                                  0x4000000UL
#define CAN_ID10_STD7                                  0x2000000UL
#define CAN_ID10_STD6                                  0x1000000UL
#define CAN_ID10_STD5                                  0x800000UL
#define CAN_ID10_STD4                                  0x400000UL
#define CAN_ID10_STD3                                  0x200000UL
#define CAN_ID10_STD2                                  0x100000UL
#define CAN_ID10_STD1                                  0x80000UL
#define CAN_ID10_STD0                                  0x40000UL
#define CAN_ID10_STD                                   0x1FFC0000UL
#define CAN_ID10_EXT17                                 0x20000UL
#define CAN_ID10_EXT16                                 0x10000UL
#define CAN_ID10_EXT15                                 0x8000UL
#define CAN_ID10_EXT14                                 0x4000UL
#define CAN_ID10_EXT13                                 0x2000UL
#define CAN_ID10_EXT12                                 0x1000UL
#define CAN_ID10_EXT11                                 0x0800UL
#define CAN_ID10_EXT10                                 0x0400UL
#define CAN_ID10_EXT9                                  0x0200UL
#define CAN_ID10_EXT8                                  0x0100UL
#define CAN_ID10_EXT7                                  0x0080UL
#define CAN_ID10_EXT6                                  0x0040UL
#define CAN_ID10_EXT5                                  0x0020UL
#define CAN_ID10_EXT4                                  0x0010UL
#define CAN_ID10_EXT3                                  0x0008UL
#define CAN_ID10_EXT2                                  0x0004UL
#define CAN_ID10_EXT1                                  0x0002UL
#define CAN_ID10_EXT0                                  0x0001UL
#define CAN_ID10_EXT                                   0x3FFFFUL

/* Masks for registers WORD010 */
#define CAN_WORD010_MASK                               0xFFFFFFFFUL
#define CAN_WORD010_DATA_BYTE_07                       0x80000000UL
#define CAN_WORD010_DATA_BYTE_06                       0x40000000UL
#define CAN_WORD010_DATA_BYTE_05                       0x20000000UL
#define CAN_WORD010_DATA_BYTE_04                       0x10000000UL
#define CAN_WORD010_DATA_BYTE_03                       0x8000000UL
#define CAN_WORD010_DATA_BYTE_02                       0x4000000UL
#define CAN_WORD010_DATA_BYTE_01                       0x2000000UL
#define CAN_WORD010_DATA_BYTE_00                       0x1000000UL
#define CAN_WORD010_DATA_BYTE_0                        0xFF000000UL
#define CAN_WORD010_DATA_BYTE_17                       0x800000UL
#define CAN_WORD010_DATA_BYTE_16                       0x400000UL
#define CAN_WORD010_DATA_BYTE_15                       0x200000UL
#define CAN_WORD010_DATA_BYTE_14                       0x100000UL
#define CAN_WORD010_DATA_BYTE_13                       0x80000UL
#define CAN_WORD010_DATA_BYTE_12                       0x40000UL
#define CAN_WORD010_DATA_BYTE_11                       0x20000UL
#define CAN_WORD010_DATA_BYTE_10                       0x10000UL
#define CAN_WORD010_DATA_BYTE_1                        0xFF0000UL
#define CAN_WORD010_DATA_BYTE_27                       0x8000UL
#define CAN_WORD010_DATA_BYTE_26                       0x4000UL
#define CAN_WORD010_DATA_BYTE_25                       0x2000UL
#define CAN_WORD010_DATA_BYTE_24                       0x1000UL
#define CAN_WORD010_DATA_BYTE_23                       0x0800UL
#define CAN_WORD010_DATA_BYTE_22                       0x0400UL
#define CAN_WORD010_DATA_BYTE_21                       0x0200UL
#define CAN_WORD010_DATA_BYTE_20                       0x0100UL
#define CAN_WORD010_DATA_BYTE_2                        0xFF00UL
#define CAN_WORD010_DATA_BYTE_37                       0x0080UL
#define CAN_WORD010_DATA_BYTE_36                       0x0040UL
#define CAN_WORD010_DATA_BYTE_35                       0x0020UL
#define CAN_WORD010_DATA_BYTE_34                       0x0010UL
#define CAN_WORD010_DATA_BYTE_33                       0x0008UL
#define CAN_WORD010_DATA_BYTE_32                       0x0004UL
#define CAN_WORD010_DATA_BYTE_31                       0x0002UL
#define CAN_WORD010_DATA_BYTE_30                       0x0001UL
#define CAN_WORD010_DATA_BYTE_3                        0x00FFUL

/* Masks for registers WORD110 */
#define CAN_WORD110_MASK                               0xFFFFFFFFUL
#define CAN_WORD110_DATA_BYTE_47                       0x80000000UL
#define CAN_WORD110_DATA_BYTE_46                       0x40000000UL
#define CAN_WORD110_DATA_BYTE_45                       0x20000000UL
#define CAN_WORD110_DATA_BYTE_44                       0x10000000UL
#define CAN_WORD110_DATA_BYTE_43                       0x8000000UL
#define CAN_WORD110_DATA_BYTE_42                       0x4000000UL
#define CAN_WORD110_DATA_BYTE_41                       0x2000000UL
#define CAN_WORD110_DATA_BYTE_40                       0x1000000UL
#define CAN_WORD110_DATA_BYTE_4                        0xFF000000UL
#define CAN_WORD110_DATA_BYTE_57                       0x800000UL
#define CAN_WORD110_DATA_BYTE_56                       0x400000UL
#define CAN_WORD110_DATA_BYTE_55                       0x200000UL
#define CAN_WORD110_DATA_BYTE_54                       0x100000UL
#define CAN_WORD110_DATA_BYTE_53                       0x80000UL
#define CAN_WORD110_DATA_BYTE_52                       0x40000UL
#define CAN_WORD110_DATA_BYTE_51                       0x20000UL
#define CAN_WORD110_DATA_BYTE_50                       0x10000UL
#define CAN_WORD110_DATA_BYTE_5                        0xFF0000UL
#define CAN_WORD110_DATA_BYTE_67                       0x8000UL
#define CAN_WORD110_DATA_BYTE_66                       0x4000UL
#define CAN_WORD110_DATA_BYTE_65                       0x2000UL
#define CAN_WORD110_DATA_BYTE_64                       0x1000UL
#define CAN_WORD110_DATA_BYTE_63                       0x0800UL
#define CAN_WORD110_DATA_BYTE_62                       0x0400UL
#define CAN_WORD110_DATA_BYTE_61                       0x0200UL
#define CAN_WORD110_DATA_BYTE_60                       0x0100UL
#define CAN_WORD110_DATA_BYTE_6                        0xFF00UL
#define CAN_WORD110_DATA_BYTE_77                       0x0080UL
#define CAN_WORD110_DATA_BYTE_76                       0x0040UL
#define CAN_WORD110_DATA_BYTE_75                       0x0020UL
#define CAN_WORD110_DATA_BYTE_74                       0x0010UL
#define CAN_WORD110_DATA_BYTE_73                       0x0008UL
#define CAN_WORD110_DATA_BYTE_72                       0x0004UL
#define CAN_WORD110_DATA_BYTE_71                       0x0002UL
#define CAN_WORD110_DATA_BYTE_70                       0x0001UL
#define CAN_WORD110_DATA_BYTE_7                        0x00FFUL

/* Masks for registers CS11 */
#define CAN_CS11_MASK                                  0xF7FFFFFUL
#define CAN_CS11_CODE3                                 0x8000000UL
#define CAN_CS11_CODE2                                 0x4000000UL
#define CAN_CS11_CODE1                                 0x2000000UL
#define CAN_CS11_CODE0                                 0x1000000UL
#define CAN_CS11_CODE                                  0xF000000UL
#define CAN_CS11_SRR                                   0x400000UL
#define CAN_CS11_IDE                                   0x200000UL
#define CAN_CS11_RTR                                   0x100000UL
#define CAN_CS11_DLC3                                  0x80000UL
#define CAN_CS11_DLC2                                  0x40000UL
#define CAN_CS11_DLC1                                  0x20000UL
#define CAN_CS11_DLC0                                  0x10000UL
#define CAN_CS11_DLC                                   0xF0000UL
#define CAN_CS11_TIME_STAMP15                          0x8000UL
#define CAN_CS11_TIME_STAMP14                          0x4000UL
#define CAN_CS11_TIME_STAMP13                          0x2000UL
#define CAN_CS11_TIME_STAMP12                          0x1000UL
#define CAN_CS11_TIME_STAMP11                          0x0800UL
#define CAN_CS11_TIME_STAMP10                          0x0400UL
#define CAN_CS11_TIME_STAMP9                           0x0200UL
#define CAN_CS11_TIME_STAMP8                           0x0100UL
#define CAN_CS11_TIME_STAMP7                           0x0080UL
#define CAN_CS11_TIME_STAMP6                           0x0040UL
#define CAN_CS11_TIME_STAMP5                           0x0020UL
#define CAN_CS11_TIME_STAMP4                           0x0010UL
#define CAN_CS11_TIME_STAMP3                           0x0008UL
#define CAN_CS11_TIME_STAMP2                           0x0004UL
#define CAN_CS11_TIME_STAMP1                           0x0002UL
#define CAN_CS11_TIME_STAMP0                           0x0001UL
#define CAN_CS11_TIME_STAMP                            0xFFFFUL

/* Masks for registers ID11 */
#define CAN_ID11_MASK                                  0xFFFFFFFFUL
#define CAN_ID11_PRIO2                                 0x80000000UL
#define CAN_ID11_PRIO1                                 0x40000000UL
#define CAN_ID11_PRIO0                                 0x20000000UL
#define CAN_ID11_PRIO                                  0xE0000000UL
#define CAN_ID11_STD10                                 0x10000000UL
#define CAN_ID11_STD9                                  0x8000000UL
#define CAN_ID11_STD8                                  0x4000000UL
#define CAN_ID11_STD7                                  0x2000000UL
#define CAN_ID11_STD6                                  0x1000000UL
#define CAN_ID11_STD5                                  0x800000UL
#define CAN_ID11_STD4                                  0x400000UL
#define CAN_ID11_STD3                                  0x200000UL
#define CAN_ID11_STD2                                  0x100000UL
#define CAN_ID11_STD1                                  0x80000UL
#define CAN_ID11_STD0                                  0x40000UL
#define CAN_ID11_STD                                   0x1FFC0000UL
#define CAN_ID11_EXT17                                 0x20000UL
#define CAN_ID11_EXT16                                 0x10000UL
#define CAN_ID11_EXT15                                 0x8000UL
#define CAN_ID11_EXT14                                 0x4000UL
#define CAN_ID11_EXT13                                 0x2000UL
#define CAN_ID11_EXT12                                 0x1000UL
#define CAN_ID11_EXT11                                 0x0800UL
#define CAN_ID11_EXT10                                 0x0400UL
#define CAN_ID11_EXT9                                  0x0200UL
#define CAN_ID11_EXT8                                  0x0100UL
#define CAN_ID11_EXT7                                  0x0080UL
#define CAN_ID11_EXT6                                  0x0040UL
#define CAN_ID11_EXT5                                  0x0020UL
#define CAN_ID11_EXT4                                  0x0010UL
#define CAN_ID11_EXT3                                  0x0008UL
#define CAN_ID11_EXT2                                  0x0004UL
#define CAN_ID11_EXT1                                  0x0002UL
#define CAN_ID11_EXT0                                  0x0001UL
#define CAN_ID11_EXT                                   0x3FFFFUL

/* Masks for registers WORD011 */
#define CAN_WORD011_MASK                               0xFFFFFFFFUL
#define CAN_WORD011_DATA_BYTE_07                       0x80000000UL
#define CAN_WORD011_DATA_BYTE_06                       0x40000000UL
#define CAN_WORD011_DATA_BYTE_05                       0x20000000UL
#define CAN_WORD011_DATA_BYTE_04                       0x10000000UL
#define CAN_WORD011_DATA_BYTE_03                       0x8000000UL
#define CAN_WORD011_DATA_BYTE_02                       0x4000000UL
#define CAN_WORD011_DATA_BYTE_01                       0x2000000UL
#define CAN_WORD011_DATA_BYTE_00                       0x1000000UL
#define CAN_WORD011_DATA_BYTE_0                        0xFF000000UL
#define CAN_WORD011_DATA_BYTE_17                       0x800000UL
#define CAN_WORD011_DATA_BYTE_16                       0x400000UL
#define CAN_WORD011_DATA_BYTE_15                       0x200000UL
#define CAN_WORD011_DATA_BYTE_14                       0x100000UL
#define CAN_WORD011_DATA_BYTE_13                       0x80000UL
#define CAN_WORD011_DATA_BYTE_12                       0x40000UL
#define CAN_WORD011_DATA_BYTE_11                       0x20000UL
#define CAN_WORD011_DATA_BYTE_10                       0x10000UL
#define CAN_WORD011_DATA_BYTE_1                        0xFF0000UL
#define CAN_WORD011_DATA_BYTE_27                       0x8000UL
#define CAN_WORD011_DATA_BYTE_26                       0x4000UL
#define CAN_WORD011_DATA_BYTE_25                       0x2000UL
#define CAN_WORD011_DATA_BYTE_24                       0x1000UL
#define CAN_WORD011_DATA_BYTE_23                       0x0800UL
#define CAN_WORD011_DATA_BYTE_22                       0x0400UL
#define CAN_WORD011_DATA_BYTE_21                       0x0200UL
#define CAN_WORD011_DATA_BYTE_20                       0x0100UL
#define CAN_WORD011_DATA_BYTE_2                        0xFF00UL
#define CAN_WORD011_DATA_BYTE_37                       0x0080UL
#define CAN_WORD011_DATA_BYTE_36                       0x0040UL
#define CAN_WORD011_DATA_BYTE_35                       0x0020UL
#define CAN_WORD011_DATA_BYTE_34                       0x0010UL
#define CAN_WORD011_DATA_BYTE_33                       0x0008UL
#define CAN_WORD011_DATA_BYTE_32                       0x0004UL
#define CAN_WORD011_DATA_BYTE_31                       0x0002UL
#define CAN_WORD011_DATA_BYTE_30                       0x0001UL
#define CAN_WORD011_DATA_BYTE_3                        0x00FFUL

/* Masks for registers WORD111 */
#define CAN_WORD111_MASK                               0xFFFFFFFFUL
#define CAN_WORD111_DATA_BYTE_47                       0x80000000UL
#define CAN_WORD111_DATA_BYTE_46                       0x40000000UL
#define CAN_WORD111_DATA_BYTE_45                       0x20000000UL
#define CAN_WORD111_DATA_BYTE_44                       0x10000000UL
#define CAN_WORD111_DATA_BYTE_43                       0x8000000UL
#define CAN_WORD111_DATA_BYTE_42                       0x4000000UL
#define CAN_WORD111_DATA_BYTE_41                       0x2000000UL
#define CAN_WORD111_DATA_BYTE_40                       0x1000000UL
#define CAN_WORD111_DATA_BYTE_4                        0xFF000000UL
#define CAN_WORD111_DATA_BYTE_57                       0x800000UL
#define CAN_WORD111_DATA_BYTE_56                       0x400000UL
#define CAN_WORD111_DATA_BYTE_55                       0x200000UL
#define CAN_WORD111_DATA_BYTE_54                       0x100000UL
#define CAN_WORD111_DATA_BYTE_53                       0x80000UL
#define CAN_WORD111_DATA_BYTE_52                       0x40000UL
#define CAN_WORD111_DATA_BYTE_51                       0x20000UL
#define CAN_WORD111_DATA_BYTE_50                       0x10000UL
#define CAN_WORD111_DATA_BYTE_5                        0xFF0000UL
#define CAN_WORD111_DATA_BYTE_67                       0x8000UL
#define CAN_WORD111_DATA_BYTE_66                       0x4000UL
#define CAN_WORD111_DATA_BYTE_65                       0x2000UL
#define CAN_WORD111_DATA_BYTE_64                       0x1000UL
#define CAN_WORD111_DATA_BYTE_63                       0x0800UL
#define CAN_WORD111_DATA_BYTE_62                       0x0400UL
#define CAN_WORD111_DATA_BYTE_61                       0x0200UL
#define CAN_WORD111_DATA_BYTE_60                       0x0100UL
#define CAN_WORD111_DATA_BYTE_6                        0xFF00UL
#define CAN_WORD111_DATA_BYTE_77                       0x0080UL
#define CAN_WORD111_DATA_BYTE_76                       0x0040UL
#define CAN_WORD111_DATA_BYTE_75                       0x0020UL
#define CAN_WORD111_DATA_BYTE_74                       0x0010UL
#define CAN_WORD111_DATA_BYTE_73                       0x0008UL
#define CAN_WORD111_DATA_BYTE_72                       0x0004UL
#define CAN_WORD111_DATA_BYTE_71                       0x0002UL
#define CAN_WORD111_DATA_BYTE_70                       0x0001UL
#define CAN_WORD111_DATA_BYTE_7                        0x00FFUL

/* Masks for registers CS12 */
#define CAN_CS12_MASK                                  0xF7FFFFFUL
#define CAN_CS12_CODE3                                 0x8000000UL
#define CAN_CS12_CODE2                                 0x4000000UL
#define CAN_CS12_CODE1                                 0x2000000UL
#define CAN_CS12_CODE0                                 0x1000000UL
#define CAN_CS12_CODE                                  0xF000000UL
#define CAN_CS12_SRR                                   0x400000UL
#define CAN_CS12_IDE                                   0x200000UL
#define CAN_CS12_RTR                                   0x100000UL
#define CAN_CS12_DLC3                                  0x80000UL
#define CAN_CS12_DLC2                                  0x40000UL
#define CAN_CS12_DLC1                                  0x20000UL
#define CAN_CS12_DLC0                                  0x10000UL
#define CAN_CS12_DLC                                   0xF0000UL
#define CAN_CS12_TIME_STAMP15                          0x8000UL
#define CAN_CS12_TIME_STAMP14                          0x4000UL
#define CAN_CS12_TIME_STAMP13                          0x2000UL
#define CAN_CS12_TIME_STAMP12                          0x1000UL
#define CAN_CS12_TIME_STAMP11                          0x0800UL
#define CAN_CS12_TIME_STAMP10                          0x0400UL
#define CAN_CS12_TIME_STAMP9                           0x0200UL
#define CAN_CS12_TIME_STAMP8                           0x0100UL
#define CAN_CS12_TIME_STAMP7                           0x0080UL
#define CAN_CS12_TIME_STAMP6                           0x0040UL
#define CAN_CS12_TIME_STAMP5                           0x0020UL
#define CAN_CS12_TIME_STAMP4                           0x0010UL
#define CAN_CS12_TIME_STAMP3                           0x0008UL
#define CAN_CS12_TIME_STAMP2                           0x0004UL
#define CAN_CS12_TIME_STAMP1                           0x0002UL
#define CAN_CS12_TIME_STAMP0                           0x0001UL
#define CAN_CS12_TIME_STAMP                            0xFFFFUL

/* Masks for registers ID12 */
#define CAN_ID12_MASK                                  0xFFFFFFFFUL
#define CAN_ID12_PRIO2                                 0x80000000UL
#define CAN_ID12_PRIO1                                 0x40000000UL
#define CAN_ID12_PRIO0                                 0x20000000UL
#define CAN_ID12_PRIO                                  0xE0000000UL
#define CAN_ID12_STD10                                 0x10000000UL
#define CAN_ID12_STD9                                  0x8000000UL
#define CAN_ID12_STD8                                  0x4000000UL
#define CAN_ID12_STD7                                  0x2000000UL
#define CAN_ID12_STD6                                  0x1000000UL
#define CAN_ID12_STD5                                  0x800000UL
#define CAN_ID12_STD4                                  0x400000UL
#define CAN_ID12_STD3                                  0x200000UL
#define CAN_ID12_STD2                                  0x100000UL
#define CAN_ID12_STD1                                  0x80000UL
#define CAN_ID12_STD0                                  0x40000UL
#define CAN_ID12_STD                                   0x1FFC0000UL
#define CAN_ID12_EXT17                                 0x20000UL
#define CAN_ID12_EXT16                                 0x10000UL
#define CAN_ID12_EXT15                                 0x8000UL
#define CAN_ID12_EXT14                                 0x4000UL
#define CAN_ID12_EXT13                                 0x2000UL
#define CAN_ID12_EXT12                                 0x1000UL
#define CAN_ID12_EXT11                                 0x0800UL
#define CAN_ID12_EXT10                                 0x0400UL
#define CAN_ID12_EXT9                                  0x0200UL
#define CAN_ID12_EXT8                                  0x0100UL
#define CAN_ID12_EXT7                                  0x0080UL
#define CAN_ID12_EXT6                                  0x0040UL
#define CAN_ID12_EXT5                                  0x0020UL
#define CAN_ID12_EXT4                                  0x0010UL
#define CAN_ID12_EXT3                                  0x0008UL
#define CAN_ID12_EXT2                                  0x0004UL
#define CAN_ID12_EXT1                                  0x0002UL
#define CAN_ID12_EXT0                                  0x0001UL
#define CAN_ID12_EXT                                   0x3FFFFUL

/* Masks for registers WORD012 */
#define CAN_WORD012_MASK                               0xFFFFFFFFUL
#define CAN_WORD012_DATA_BYTE_07                       0x80000000UL
#define CAN_WORD012_DATA_BYTE_06                       0x40000000UL
#define CAN_WORD012_DATA_BYTE_05                       0x20000000UL
#define CAN_WORD012_DATA_BYTE_04                       0x10000000UL
#define CAN_WORD012_DATA_BYTE_03                       0x8000000UL
#define CAN_WORD012_DATA_BYTE_02                       0x4000000UL
#define CAN_WORD012_DATA_BYTE_01                       0x2000000UL
#define CAN_WORD012_DATA_BYTE_00                       0x1000000UL
#define CAN_WORD012_DATA_BYTE_0                        0xFF000000UL
#define CAN_WORD012_DATA_BYTE_17                       0x800000UL
#define CAN_WORD012_DATA_BYTE_16                       0x400000UL
#define CAN_WORD012_DATA_BYTE_15                       0x200000UL
#define CAN_WORD012_DATA_BYTE_14                       0x100000UL
#define CAN_WORD012_DATA_BYTE_13                       0x80000UL
#define CAN_WORD012_DATA_BYTE_12                       0x40000UL
#define CAN_WORD012_DATA_BYTE_11                       0x20000UL
#define CAN_WORD012_DATA_BYTE_10                       0x10000UL
#define CAN_WORD012_DATA_BYTE_1                        0xFF0000UL
#define CAN_WORD012_DATA_BYTE_27                       0x8000UL
#define CAN_WORD012_DATA_BYTE_26                       0x4000UL
#define CAN_WORD012_DATA_BYTE_25                       0x2000UL
#define CAN_WORD012_DATA_BYTE_24                       0x1000UL
#define CAN_WORD012_DATA_BYTE_23                       0x0800UL
#define CAN_WORD012_DATA_BYTE_22                       0x0400UL
#define CAN_WORD012_DATA_BYTE_21                       0x0200UL
#define CAN_WORD012_DATA_BYTE_20                       0x0100UL
#define CAN_WORD012_DATA_BYTE_2                        0xFF00UL
#define CAN_WORD012_DATA_BYTE_37                       0x0080UL
#define CAN_WORD012_DATA_BYTE_36                       0x0040UL
#define CAN_WORD012_DATA_BYTE_35                       0x0020UL
#define CAN_WORD012_DATA_BYTE_34                       0x0010UL
#define CAN_WORD012_DATA_BYTE_33                       0x0008UL
#define CAN_WORD012_DATA_BYTE_32                       0x0004UL
#define CAN_WORD012_DATA_BYTE_31                       0x0002UL
#define CAN_WORD012_DATA_BYTE_30                       0x0001UL
#define CAN_WORD012_DATA_BYTE_3                        0x00FFUL

/* Masks for registers WORD112 */
#define CAN_WORD112_MASK                               0xFFFFFFFFUL
#define CAN_WORD112_DATA_BYTE_47                       0x80000000UL
#define CAN_WORD112_DATA_BYTE_46                       0x40000000UL
#define CAN_WORD112_DATA_BYTE_45                       0x20000000UL
#define CAN_WORD112_DATA_BYTE_44                       0x10000000UL
#define CAN_WORD112_DATA_BYTE_43                       0x8000000UL
#define CAN_WORD112_DATA_BYTE_42                       0x4000000UL
#define CAN_WORD112_DATA_BYTE_41                       0x2000000UL
#define CAN_WORD112_DATA_BYTE_40                       0x1000000UL
#define CAN_WORD112_DATA_BYTE_4                        0xFF000000UL
#define CAN_WORD112_DATA_BYTE_57                       0x800000UL
#define CAN_WORD112_DATA_BYTE_56                       0x400000UL
#define CAN_WORD112_DATA_BYTE_55                       0x200000UL
#define CAN_WORD112_DATA_BYTE_54                       0x100000UL
#define CAN_WORD112_DATA_BYTE_53                       0x80000UL
#define CAN_WORD112_DATA_BYTE_52                       0x40000UL
#define CAN_WORD112_DATA_BYTE_51                       0x20000UL
#define CAN_WORD112_DATA_BYTE_50                       0x10000UL
#define CAN_WORD112_DATA_BYTE_5                        0xFF0000UL
#define CAN_WORD112_DATA_BYTE_67                       0x8000UL
#define CAN_WORD112_DATA_BYTE_66                       0x4000UL
#define CAN_WORD112_DATA_BYTE_65                       0x2000UL
#define CAN_WORD112_DATA_BYTE_64                       0x1000UL
#define CAN_WORD112_DATA_BYTE_63                       0x0800UL
#define CAN_WORD112_DATA_BYTE_62                       0x0400UL
#define CAN_WORD112_DATA_BYTE_61                       0x0200UL
#define CAN_WORD112_DATA_BYTE_60                       0x0100UL
#define CAN_WORD112_DATA_BYTE_6                        0xFF00UL
#define CAN_WORD112_DATA_BYTE_77                       0x0080UL
#define CAN_WORD112_DATA_BYTE_76                       0x0040UL
#define CAN_WORD112_DATA_BYTE_75                       0x0020UL
#define CAN_WORD112_DATA_BYTE_74                       0x0010UL
#define CAN_WORD112_DATA_BYTE_73                       0x0008UL
#define CAN_WORD112_DATA_BYTE_72                       0x0004UL
#define CAN_WORD112_DATA_BYTE_71                       0x0002UL
#define CAN_WORD112_DATA_BYTE_70                       0x0001UL
#define CAN_WORD112_DATA_BYTE_7                        0x00FFUL

/* Masks for registers CS13 */
#define CAN_CS13_MASK                                  0xF7FFFFFUL
#define CAN_CS13_CODE3                                 0x8000000UL
#define CAN_CS13_CODE2                                 0x4000000UL
#define CAN_CS13_CODE1                                 0x2000000UL
#define CAN_CS13_CODE0                                 0x1000000UL
#define CAN_CS13_CODE                                  0xF000000UL
#define CAN_CS13_SRR                                   0x400000UL
#define CAN_CS13_IDE                                   0x200000UL
#define CAN_CS13_RTR                                   0x100000UL
#define CAN_CS13_DLC3                                  0x80000UL
#define CAN_CS13_DLC2                                  0x40000UL
#define CAN_CS13_DLC1                                  0x20000UL
#define CAN_CS13_DLC0                                  0x10000UL
#define CAN_CS13_DLC                                   0xF0000UL
#define CAN_CS13_TIME_STAMP15                          0x8000UL
#define CAN_CS13_TIME_STAMP14                          0x4000UL
#define CAN_CS13_TIME_STAMP13                          0x2000UL
#define CAN_CS13_TIME_STAMP12                          0x1000UL
#define CAN_CS13_TIME_STAMP11                          0x0800UL
#define CAN_CS13_TIME_STAMP10                          0x0400UL
#define CAN_CS13_TIME_STAMP9                           0x0200UL
#define CAN_CS13_TIME_STAMP8                           0x0100UL
#define CAN_CS13_TIME_STAMP7                           0x0080UL
#define CAN_CS13_TIME_STAMP6                           0x0040UL
#define CAN_CS13_TIME_STAMP5                           0x0020UL
#define CAN_CS13_TIME_STAMP4                           0x0010UL
#define CAN_CS13_TIME_STAMP3                           0x0008UL
#define CAN_CS13_TIME_STAMP2                           0x0004UL
#define CAN_CS13_TIME_STAMP1                           0x0002UL
#define CAN_CS13_TIME_STAMP0                           0x0001UL
#define CAN_CS13_TIME_STAMP                            0xFFFFUL

/* Masks for registers ID13 */
#define CAN_ID13_MASK                                  0xFFFFFFFFUL
#define CAN_ID13_PRIO2                                 0x80000000UL
#define CAN_ID13_PRIO1                                 0x40000000UL
#define CAN_ID13_PRIO0                                 0x20000000UL
#define CAN_ID13_PRIO                                  0xE0000000UL
#define CAN_ID13_STD10                                 0x10000000UL
#define CAN_ID13_STD9                                  0x8000000UL
#define CAN_ID13_STD8                                  0x4000000UL
#define CAN_ID13_STD7                                  0x2000000UL
#define CAN_ID13_STD6                                  0x1000000UL
#define CAN_ID13_STD5                                  0x800000UL
#define CAN_ID13_STD4                                  0x400000UL
#define CAN_ID13_STD3                                  0x200000UL
#define CAN_ID13_STD2                                  0x100000UL
#define CAN_ID13_STD1                                  0x80000UL
#define CAN_ID13_STD0                                  0x40000UL
#define CAN_ID13_STD                                   0x1FFC0000UL
#define CAN_ID13_EXT17                                 0x20000UL
#define CAN_ID13_EXT16                                 0x10000UL
#define CAN_ID13_EXT15                                 0x8000UL
#define CAN_ID13_EXT14                                 0x4000UL
#define CAN_ID13_EXT13                                 0x2000UL
#define CAN_ID13_EXT12                                 0x1000UL
#define CAN_ID13_EXT11                                 0x0800UL
#define CAN_ID13_EXT10                                 0x0400UL
#define CAN_ID13_EXT9                                  0x0200UL
#define CAN_ID13_EXT8                                  0x0100UL
#define CAN_ID13_EXT7                                  0x0080UL
#define CAN_ID13_EXT6                                  0x0040UL
#define CAN_ID13_EXT5                                  0x0020UL
#define CAN_ID13_EXT4                                  0x0010UL
#define CAN_ID13_EXT3                                  0x0008UL
#define CAN_ID13_EXT2                                  0x0004UL
#define CAN_ID13_EXT1                                  0x0002UL
#define CAN_ID13_EXT0                                  0x0001UL
#define CAN_ID13_EXT                                   0x3FFFFUL

/* Masks for registers WORD013 */
#define CAN_WORD013_MASK                               0xFFFFFFFFUL
#define CAN_WORD013_DATA_BYTE_07                       0x80000000UL
#define CAN_WORD013_DATA_BYTE_06                       0x40000000UL
#define CAN_WORD013_DATA_BYTE_05                       0x20000000UL
#define CAN_WORD013_DATA_BYTE_04                       0x10000000UL
#define CAN_WORD013_DATA_BYTE_03                       0x8000000UL
#define CAN_WORD013_DATA_BYTE_02                       0x4000000UL
#define CAN_WORD013_DATA_BYTE_01                       0x2000000UL
#define CAN_WORD013_DATA_BYTE_00                       0x1000000UL
#define CAN_WORD013_DATA_BYTE_0                        0xFF000000UL
#define CAN_WORD013_DATA_BYTE_17                       0x800000UL
#define CAN_WORD013_DATA_BYTE_16                       0x400000UL
#define CAN_WORD013_DATA_BYTE_15                       0x200000UL
#define CAN_WORD013_DATA_BYTE_14                       0x100000UL
#define CAN_WORD013_DATA_BYTE_13                       0x80000UL
#define CAN_WORD013_DATA_BYTE_12                       0x40000UL
#define CAN_WORD013_DATA_BYTE_11                       0x20000UL
#define CAN_WORD013_DATA_BYTE_10                       0x10000UL
#define CAN_WORD013_DATA_BYTE_1                        0xFF0000UL
#define CAN_WORD013_DATA_BYTE_27                       0x8000UL
#define CAN_WORD013_DATA_BYTE_26                       0x4000UL
#define CAN_WORD013_DATA_BYTE_25                       0x2000UL
#define CAN_WORD013_DATA_BYTE_24                       0x1000UL
#define CAN_WORD013_DATA_BYTE_23                       0x0800UL
#define CAN_WORD013_DATA_BYTE_22                       0x0400UL
#define CAN_WORD013_DATA_BYTE_21                       0x0200UL
#define CAN_WORD013_DATA_BYTE_20                       0x0100UL
#define CAN_WORD013_DATA_BYTE_2                        0xFF00UL
#define CAN_WORD013_DATA_BYTE_37                       0x0080UL
#define CAN_WORD013_DATA_BYTE_36                       0x0040UL
#define CAN_WORD013_DATA_BYTE_35                       0x0020UL
#define CAN_WORD013_DATA_BYTE_34                       0x0010UL
#define CAN_WORD013_DATA_BYTE_33                       0x0008UL
#define CAN_WORD013_DATA_BYTE_32                       0x0004UL
#define CAN_WORD013_DATA_BYTE_31                       0x0002UL
#define CAN_WORD013_DATA_BYTE_30                       0x0001UL
#define CAN_WORD013_DATA_BYTE_3                        0x00FFUL

/* Masks for registers WORD113 */
#define CAN_WORD113_MASK                               0xFFFFFFFFUL
#define CAN_WORD113_DATA_BYTE_47                       0x80000000UL
#define CAN_WORD113_DATA_BYTE_46                       0x40000000UL
#define CAN_WORD113_DATA_BYTE_45                       0x20000000UL
#define CAN_WORD113_DATA_BYTE_44                       0x10000000UL
#define CAN_WORD113_DATA_BYTE_43                       0x8000000UL
#define CAN_WORD113_DATA_BYTE_42                       0x4000000UL
#define CAN_WORD113_DATA_BYTE_41                       0x2000000UL
#define CAN_WORD113_DATA_BYTE_40                       0x1000000UL
#define CAN_WORD113_DATA_BYTE_4                        0xFF000000UL
#define CAN_WORD113_DATA_BYTE_57                       0x800000UL
#define CAN_WORD113_DATA_BYTE_56                       0x400000UL
#define CAN_WORD113_DATA_BYTE_55                       0x200000UL
#define CAN_WORD113_DATA_BYTE_54                       0x100000UL
#define CAN_WORD113_DATA_BYTE_53                       0x80000UL
#define CAN_WORD113_DATA_BYTE_52                       0x40000UL
#define CAN_WORD113_DATA_BYTE_51                       0x20000UL
#define CAN_WORD113_DATA_BYTE_50                       0x10000UL
#define CAN_WORD113_DATA_BYTE_5                        0xFF0000UL
#define CAN_WORD113_DATA_BYTE_67                       0x8000UL
#define CAN_WORD113_DATA_BYTE_66                       0x4000UL
#define CAN_WORD113_DATA_BYTE_65                       0x2000UL
#define CAN_WORD113_DATA_BYTE_64                       0x1000UL
#define CAN_WORD113_DATA_BYTE_63                       0x0800UL
#define CAN_WORD113_DATA_BYTE_62                       0x0400UL
#define CAN_WORD113_DATA_BYTE_61                       0x0200UL
#define CAN_WORD113_DATA_BYTE_60                       0x0100UL
#define CAN_WORD113_DATA_BYTE_6                        0xFF00UL
#define CAN_WORD113_DATA_BYTE_77                       0x0080UL
#define CAN_WORD113_DATA_BYTE_76                       0x0040UL
#define CAN_WORD113_DATA_BYTE_75                       0x0020UL
#define CAN_WORD113_DATA_BYTE_74                       0x0010UL
#define CAN_WORD113_DATA_BYTE_73                       0x0008UL
#define CAN_WORD113_DATA_BYTE_72                       0x0004UL
#define CAN_WORD113_DATA_BYTE_71                       0x0002UL
#define CAN_WORD113_DATA_BYTE_70                       0x0001UL
#define CAN_WORD113_DATA_BYTE_7                        0x00FFUL

/* Masks for registers CS14 */
#define CAN_CS14_MASK                                  0xF7FFFFFUL
#define CAN_CS14_CODE3                                 0x8000000UL
#define CAN_CS14_CODE2                                 0x4000000UL
#define CAN_CS14_CODE1                                 0x2000000UL
#define CAN_CS14_CODE0                                 0x1000000UL
#define CAN_CS14_CODE                                  0xF000000UL
#define CAN_CS14_SRR                                   0x400000UL
#define CAN_CS14_IDE                                   0x200000UL
#define CAN_CS14_RTR                                   0x100000UL
#define CAN_CS14_DLC3                                  0x80000UL
#define CAN_CS14_DLC2                                  0x40000UL
#define CAN_CS14_DLC1                                  0x20000UL
#define CAN_CS14_DLC0                                  0x10000UL
#define CAN_CS14_DLC                                   0xF0000UL
#define CAN_CS14_TIME_STAMP15                          0x8000UL
#define CAN_CS14_TIME_STAMP14                          0x4000UL
#define CAN_CS14_TIME_STAMP13                          0x2000UL
#define CAN_CS14_TIME_STAMP12                          0x1000UL
#define CAN_CS14_TIME_STAMP11                          0x0800UL
#define CAN_CS14_TIME_STAMP10                          0x0400UL
#define CAN_CS14_TIME_STAMP9                           0x0200UL
#define CAN_CS14_TIME_STAMP8                           0x0100UL
#define CAN_CS14_TIME_STAMP7                           0x0080UL
#define CAN_CS14_TIME_STAMP6                           0x0040UL
#define CAN_CS14_TIME_STAMP5                           0x0020UL
#define CAN_CS14_TIME_STAMP4                           0x0010UL
#define CAN_CS14_TIME_STAMP3                           0x0008UL
#define CAN_CS14_TIME_STAMP2                           0x0004UL
#define CAN_CS14_TIME_STAMP1                           0x0002UL
#define CAN_CS14_TIME_STAMP0                           0x0001UL
#define CAN_CS14_TIME_STAMP                            0xFFFFUL

/* Masks for registers ID14 */
#define CAN_ID14_MASK                                  0xFFFFFFFFUL
#define CAN_ID14_PRIO2                                 0x80000000UL
#define CAN_ID14_PRIO1                                 0x40000000UL
#define CAN_ID14_PRIO0                                 0x20000000UL
#define CAN_ID14_PRIO                                  0xE0000000UL
#define CAN_ID14_STD10                                 0x10000000UL
#define CAN_ID14_STD9                                  0x8000000UL
#define CAN_ID14_STD8                                  0x4000000UL
#define CAN_ID14_STD7                                  0x2000000UL
#define CAN_ID14_STD6                                  0x1000000UL
#define CAN_ID14_STD5                                  0x800000UL
#define CAN_ID14_STD4                                  0x400000UL
#define CAN_ID14_STD3                                  0x200000UL
#define CAN_ID14_STD2                                  0x100000UL
#define CAN_ID14_STD1                                  0x80000UL
#define CAN_ID14_STD0                                  0x40000UL
#define CAN_ID14_STD                                   0x1FFC0000UL
#define CAN_ID14_EXT17                                 0x20000UL
#define CAN_ID14_EXT16                                 0x10000UL
#define CAN_ID14_EXT15                                 0x8000UL
#define CAN_ID14_EXT14                                 0x4000UL
#define CAN_ID14_EXT13                                 0x2000UL
#define CAN_ID14_EXT12                                 0x1000UL
#define CAN_ID14_EXT11                                 0x0800UL
#define CAN_ID14_EXT10                                 0x0400UL
#define CAN_ID14_EXT9                                  0x0200UL
#define CAN_ID14_EXT8                                  0x0100UL
#define CAN_ID14_EXT7                                  0x0080UL
#define CAN_ID14_EXT6                                  0x0040UL
#define CAN_ID14_EXT5                                  0x0020UL
#define CAN_ID14_EXT4                                  0x0010UL
#define CAN_ID14_EXT3                                  0x0008UL
#define CAN_ID14_EXT2                                  0x0004UL
#define CAN_ID14_EXT1                                  0x0002UL
#define CAN_ID14_EXT0                                  0x0001UL
#define CAN_ID14_EXT                                   0x3FFFFUL

/* Masks for registers WORD014 */
#define CAN_WORD014_MASK                               0xFFFFFFFFUL
#define CAN_WORD014_DATA_BYTE_07                       0x80000000UL
#define CAN_WORD014_DATA_BYTE_06                       0x40000000UL
#define CAN_WORD014_DATA_BYTE_05                       0x20000000UL
#define CAN_WORD014_DATA_BYTE_04                       0x10000000UL
#define CAN_WORD014_DATA_BYTE_03                       0x8000000UL
#define CAN_WORD014_DATA_BYTE_02                       0x4000000UL
#define CAN_WORD014_DATA_BYTE_01                       0x2000000UL
#define CAN_WORD014_DATA_BYTE_00                       0x1000000UL
#define CAN_WORD014_DATA_BYTE_0                        0xFF000000UL
#define CAN_WORD014_DATA_BYTE_17                       0x800000UL
#define CAN_WORD014_DATA_BYTE_16                       0x400000UL
#define CAN_WORD014_DATA_BYTE_15                       0x200000UL
#define CAN_WORD014_DATA_BYTE_14                       0x100000UL
#define CAN_WORD014_DATA_BYTE_13                       0x80000UL
#define CAN_WORD014_DATA_BYTE_12                       0x40000UL
#define CAN_WORD014_DATA_BYTE_11                       0x20000UL
#define CAN_WORD014_DATA_BYTE_10                       0x10000UL
#define CAN_WORD014_DATA_BYTE_1                        0xFF0000UL
#define CAN_WORD014_DATA_BYTE_27                       0x8000UL
#define CAN_WORD014_DATA_BYTE_26                       0x4000UL
#define CAN_WORD014_DATA_BYTE_25                       0x2000UL
#define CAN_WORD014_DATA_BYTE_24                       0x1000UL
#define CAN_WORD014_DATA_BYTE_23                       0x0800UL
#define CAN_WORD014_DATA_BYTE_22                       0x0400UL
#define CAN_WORD014_DATA_BYTE_21                       0x0200UL
#define CAN_WORD014_DATA_BYTE_20                       0x0100UL
#define CAN_WORD014_DATA_BYTE_2                        0xFF00UL
#define CAN_WORD014_DATA_BYTE_37                       0x0080UL
#define CAN_WORD014_DATA_BYTE_36                       0x0040UL
#define CAN_WORD014_DATA_BYTE_35                       0x0020UL
#define CAN_WORD014_DATA_BYTE_34                       0x0010UL
#define CAN_WORD014_DATA_BYTE_33                       0x0008UL
#define CAN_WORD014_DATA_BYTE_32                       0x0004UL
#define CAN_WORD014_DATA_BYTE_31                       0x0002UL
#define CAN_WORD014_DATA_BYTE_30                       0x0001UL
#define CAN_WORD014_DATA_BYTE_3                        0x00FFUL

/* Masks for registers WORD114 */
#define CAN_WORD114_MASK                               0xFFFFFFFFUL
#define CAN_WORD114_DATA_BYTE_47                       0x80000000UL
#define CAN_WORD114_DATA_BYTE_46                       0x40000000UL
#define CAN_WORD114_DATA_BYTE_45                       0x20000000UL
#define CAN_WORD114_DATA_BYTE_44                       0x10000000UL
#define CAN_WORD114_DATA_BYTE_43                       0x8000000UL
#define CAN_WORD114_DATA_BYTE_42                       0x4000000UL
#define CAN_WORD114_DATA_BYTE_41                       0x2000000UL
#define CAN_WORD114_DATA_BYTE_40                       0x1000000UL
#define CAN_WORD114_DATA_BYTE_4                        0xFF000000UL
#define CAN_WORD114_DATA_BYTE_57                       0x800000UL
#define CAN_WORD114_DATA_BYTE_56                       0x400000UL
#define CAN_WORD114_DATA_BYTE_55                       0x200000UL
#define CAN_WORD114_DATA_BYTE_54                       0x100000UL
#define CAN_WORD114_DATA_BYTE_53                       0x80000UL
#define CAN_WORD114_DATA_BYTE_52                       0x40000UL
#define CAN_WORD114_DATA_BYTE_51                       0x20000UL
#define CAN_WORD114_DATA_BYTE_50                       0x10000UL
#define CAN_WORD114_DATA_BYTE_5                        0xFF0000UL
#define CAN_WORD114_DATA_BYTE_67                       0x8000UL
#define CAN_WORD114_DATA_BYTE_66                       0x4000UL
#define CAN_WORD114_DATA_BYTE_65                       0x2000UL
#define CAN_WORD114_DATA_BYTE_64                       0x1000UL
#define CAN_WORD114_DATA_BYTE_63                       0x0800UL
#define CAN_WORD114_DATA_BYTE_62                       0x0400UL
#define CAN_WORD114_DATA_BYTE_61                       0x0200UL
#define CAN_WORD114_DATA_BYTE_60                       0x0100UL
#define CAN_WORD114_DATA_BYTE_6                        0xFF00UL
#define CAN_WORD114_DATA_BYTE_77                       0x0080UL
#define CAN_WORD114_DATA_BYTE_76                       0x0040UL
#define CAN_WORD114_DATA_BYTE_75                       0x0020UL
#define CAN_WORD114_DATA_BYTE_74                       0x0010UL
#define CAN_WORD114_DATA_BYTE_73                       0x0008UL
#define CAN_WORD114_DATA_BYTE_72                       0x0004UL
#define CAN_WORD114_DATA_BYTE_71                       0x0002UL
#define CAN_WORD114_DATA_BYTE_70                       0x0001UL
#define CAN_WORD114_DATA_BYTE_7                        0x00FFUL

/* Masks for registers CS15 */
#define CAN_CS15_MASK                                  0xF7FFFFFUL
#define CAN_CS15_CODE3                                 0x8000000UL
#define CAN_CS15_CODE2                                 0x4000000UL
#define CAN_CS15_CODE1                                 0x2000000UL
#define CAN_CS15_CODE0                                 0x1000000UL
#define CAN_CS15_CODE                                  0xF000000UL
#define CAN_CS15_SRR                                   0x400000UL
#define CAN_CS15_IDE                                   0x200000UL
#define CAN_CS15_RTR                                   0x100000UL
#define CAN_CS15_DLC3                                  0x80000UL
#define CAN_CS15_DLC2                                  0x40000UL
#define CAN_CS15_DLC1                                  0x20000UL
#define CAN_CS15_DLC0                                  0x10000UL
#define CAN_CS15_DLC                                   0xF0000UL
#define CAN_CS15_TIME_STAMP15                          0x8000UL
#define CAN_CS15_TIME_STAMP14                          0x4000UL
#define CAN_CS15_TIME_STAMP13                          0x2000UL
#define CAN_CS15_TIME_STAMP12                          0x1000UL
#define CAN_CS15_TIME_STAMP11                          0x0800UL
#define CAN_CS15_TIME_STAMP10                          0x0400UL
#define CAN_CS15_TIME_STAMP9                           0x0200UL
#define CAN_CS15_TIME_STAMP8                           0x0100UL
#define CAN_CS15_TIME_STAMP7                           0x0080UL
#define CAN_CS15_TIME_STAMP6                           0x0040UL
#define CAN_CS15_TIME_STAMP5                           0x0020UL
#define CAN_CS15_TIME_STAMP4                           0x0010UL
#define CAN_CS15_TIME_STAMP3                           0x0008UL
#define CAN_CS15_TIME_STAMP2                           0x0004UL
#define CAN_CS15_TIME_STAMP1                           0x0002UL
#define CAN_CS15_TIME_STAMP0                           0x0001UL
#define CAN_CS15_TIME_STAMP                            0xFFFFUL

/* Masks for registers ID15 */
#define CAN_ID15_MASK                                  0xFFFFFFFFUL
#define CAN_ID15_PRIO2                                 0x80000000UL
#define CAN_ID15_PRIO1                                 0x40000000UL
#define CAN_ID15_PRIO0                                 0x20000000UL
#define CAN_ID15_PRIO                                  0xE0000000UL
#define CAN_ID15_STD10                                 0x10000000UL
#define CAN_ID15_STD9                                  0x8000000UL
#define CAN_ID15_STD8                                  0x4000000UL
#define CAN_ID15_STD7                                  0x2000000UL
#define CAN_ID15_STD6                                  0x1000000UL
#define CAN_ID15_STD5                                  0x800000UL
#define CAN_ID15_STD4                                  0x400000UL
#define CAN_ID15_STD3                                  0x200000UL
#define CAN_ID15_STD2                                  0x100000UL
#define CAN_ID15_STD1                                  0x80000UL
#define CAN_ID15_STD0                                  0x40000UL
#define CAN_ID15_STD                                   0x1FFC0000UL
#define CAN_ID15_EXT17                                 0x20000UL
#define CAN_ID15_EXT16                                 0x10000UL
#define CAN_ID15_EXT15                                 0x8000UL
#define CAN_ID15_EXT14                                 0x4000UL
#define CAN_ID15_EXT13                                 0x2000UL
#define CAN_ID15_EXT12                                 0x1000UL
#define CAN_ID15_EXT11                                 0x0800UL
#define CAN_ID15_EXT10                                 0x0400UL
#define CAN_ID15_EXT9                                  0x0200UL
#define CAN_ID15_EXT8                                  0x0100UL
#define CAN_ID15_EXT7                                  0x0080UL
#define CAN_ID15_EXT6                                  0x0040UL
#define CAN_ID15_EXT5                                  0x0020UL
#define CAN_ID15_EXT4                                  0x0010UL
#define CAN_ID15_EXT3                                  0x0008UL
#define CAN_ID15_EXT2                                  0x0004UL
#define CAN_ID15_EXT1                                  0x0002UL
#define CAN_ID15_EXT0                                  0x0001UL
#define CAN_ID15_EXT                                   0x3FFFFUL

/* Masks for registers WORD015 */
#define CAN_WORD015_MASK                               0xFFFFFFFFUL
#define CAN_WORD015_DATA_BYTE_07                       0x80000000UL
#define CAN_WORD015_DATA_BYTE_06                       0x40000000UL
#define CAN_WORD015_DATA_BYTE_05                       0x20000000UL
#define CAN_WORD015_DATA_BYTE_04                       0x10000000UL
#define CAN_WORD015_DATA_BYTE_03                       0x8000000UL
#define CAN_WORD015_DATA_BYTE_02                       0x4000000UL
#define CAN_WORD015_DATA_BYTE_01                       0x2000000UL
#define CAN_WORD015_DATA_BYTE_00                       0x1000000UL
#define CAN_WORD015_DATA_BYTE_0                        0xFF000000UL
#define CAN_WORD015_DATA_BYTE_17                       0x800000UL
#define CAN_WORD015_DATA_BYTE_16                       0x400000UL
#define CAN_WORD015_DATA_BYTE_15                       0x200000UL
#define CAN_WORD015_DATA_BYTE_14                       0x100000UL
#define CAN_WORD015_DATA_BYTE_13                       0x80000UL
#define CAN_WORD015_DATA_BYTE_12                       0x40000UL
#define CAN_WORD015_DATA_BYTE_11                       0x20000UL
#define CAN_WORD015_DATA_BYTE_10                       0x10000UL
#define CAN_WORD015_DATA_BYTE_1                        0xFF0000UL
#define CAN_WORD015_DATA_BYTE_27                       0x8000UL
#define CAN_WORD015_DATA_BYTE_26                       0x4000UL
#define CAN_WORD015_DATA_BYTE_25                       0x2000UL
#define CAN_WORD015_DATA_BYTE_24                       0x1000UL
#define CAN_WORD015_DATA_BYTE_23                       0x0800UL
#define CAN_WORD015_DATA_BYTE_22                       0x0400UL
#define CAN_WORD015_DATA_BYTE_21                       0x0200UL
#define CAN_WORD015_DATA_BYTE_20                       0x0100UL
#define CAN_WORD015_DATA_BYTE_2                        0xFF00UL
#define CAN_WORD015_DATA_BYTE_37                       0x0080UL
#define CAN_WORD015_DATA_BYTE_36                       0x0040UL
#define CAN_WORD015_DATA_BYTE_35                       0x0020UL
#define CAN_WORD015_DATA_BYTE_34                       0x0010UL
#define CAN_WORD015_DATA_BYTE_33                       0x0008UL
#define CAN_WORD015_DATA_BYTE_32                       0x0004UL
#define CAN_WORD015_DATA_BYTE_31                       0x0002UL
#define CAN_WORD015_DATA_BYTE_30                       0x0001UL
#define CAN_WORD015_DATA_BYTE_3                        0x00FFUL

/* Masks for registers WORD115 */
#define CAN_WORD115_MASK                               0xFFFFFFFFUL
#define CAN_WORD115_DATA_BYTE_47                       0x80000000UL
#define CAN_WORD115_DATA_BYTE_46                       0x40000000UL
#define CAN_WORD115_DATA_BYTE_45                       0x20000000UL
#define CAN_WORD115_DATA_BYTE_44                       0x10000000UL
#define CAN_WORD115_DATA_BYTE_43                       0x8000000UL
#define CAN_WORD115_DATA_BYTE_42                       0x4000000UL
#define CAN_WORD115_DATA_BYTE_41                       0x2000000UL
#define CAN_WORD115_DATA_BYTE_40                       0x1000000UL
#define CAN_WORD115_DATA_BYTE_4                        0xFF000000UL
#define CAN_WORD115_DATA_BYTE_57                       0x800000UL
#define CAN_WORD115_DATA_BYTE_56                       0x400000UL
#define CAN_WORD115_DATA_BYTE_55                       0x200000UL
#define CAN_WORD115_DATA_BYTE_54                       0x100000UL
#define CAN_WORD115_DATA_BYTE_53                       0x80000UL
#define CAN_WORD115_DATA_BYTE_52                       0x40000UL
#define CAN_WORD115_DATA_BYTE_51                       0x20000UL
#define CAN_WORD115_DATA_BYTE_50                       0x10000UL
#define CAN_WORD115_DATA_BYTE_5                        0xFF0000UL
#define CAN_WORD115_DATA_BYTE_67                       0x8000UL
#define CAN_WORD115_DATA_BYTE_66                       0x4000UL
#define CAN_WORD115_DATA_BYTE_65                       0x2000UL
#define CAN_WORD115_DATA_BYTE_64                       0x1000UL
#define CAN_WORD115_DATA_BYTE_63                       0x0800UL
#define CAN_WORD115_DATA_BYTE_62                       0x0400UL
#define CAN_WORD115_DATA_BYTE_61                       0x0200UL
#define CAN_WORD115_DATA_BYTE_60                       0x0100UL
#define CAN_WORD115_DATA_BYTE_6                        0xFF00UL
#define CAN_WORD115_DATA_BYTE_77                       0x0080UL
#define CAN_WORD115_DATA_BYTE_76                       0x0040UL
#define CAN_WORD115_DATA_BYTE_75                       0x0020UL
#define CAN_WORD115_DATA_BYTE_74                       0x0010UL
#define CAN_WORD115_DATA_BYTE_73                       0x0008UL
#define CAN_WORD115_DATA_BYTE_72                       0x0004UL
#define CAN_WORD115_DATA_BYTE_71                       0x0002UL
#define CAN_WORD115_DATA_BYTE_70                       0x0001UL
#define CAN_WORD115_DATA_BYTE_7                        0x00FFUL

/* Masks for registers RXIMR0 */
#define CAN_RXIMR0_MASK                                0xFFFFFFFFUL
#define CAN_RXIMR0_MI31                                0x80000000UL
#define CAN_RXIMR0_MI30                                0x40000000UL
#define CAN_RXIMR0_MI29                                0x20000000UL
#define CAN_RXIMR0_MI28                                0x10000000UL
#define CAN_RXIMR0_MI27                                0x8000000UL
#define CAN_RXIMR0_MI26                                0x4000000UL
#define CAN_RXIMR0_MI25                                0x2000000UL
#define CAN_RXIMR0_MI24                                0x1000000UL
#define CAN_RXIMR0_MI23                                0x800000UL
#define CAN_RXIMR0_MI22                                0x400000UL
#define CAN_RXIMR0_MI21                                0x200000UL
#define CAN_RXIMR0_MI20                                0x100000UL
#define CAN_RXIMR0_MI19                                0x80000UL
#define CAN_RXIMR0_MI18                                0x40000UL
#define CAN_RXIMR0_MI17                                0x20000UL
#define CAN_RXIMR0_MI16                                0x10000UL
#define CAN_RXIMR0_MI15                                0x8000UL
#define CAN_RXIMR0_MI14                                0x4000UL
#define CAN_RXIMR0_MI13                                0x2000UL
#define CAN_RXIMR0_MI12                                0x1000UL
#define CAN_RXIMR0_MI11                                0x0800UL
#define CAN_RXIMR0_MI10                                0x0400UL
#define CAN_RXIMR0_MI9                                 0x0200UL
#define CAN_RXIMR0_MI8                                 0x0100UL
#define CAN_RXIMR0_MI7                                 0x0080UL
#define CAN_RXIMR0_MI6                                 0x0040UL
#define CAN_RXIMR0_MI5                                 0x0020UL
#define CAN_RXIMR0_MI4                                 0x0010UL
#define CAN_RXIMR0_MI3                                 0x0008UL
#define CAN_RXIMR0_MI2                                 0x0004UL
#define CAN_RXIMR0_MI1                                 0x0002UL
#define CAN_RXIMR0_MI0                                 0x0001UL
#define CAN_RXIMR0_MI                                  0xFFFFFFFFUL

/* Masks for registers RXIMR1 */
#define CAN_RXIMR1_MASK                                0xFFFFFFFFUL
#define CAN_RXIMR1_MI31                                0x80000000UL
#define CAN_RXIMR1_MI30                                0x40000000UL
#define CAN_RXIMR1_MI29                                0x20000000UL
#define CAN_RXIMR1_MI28                                0x10000000UL
#define CAN_RXIMR1_MI27                                0x8000000UL
#define CAN_RXIMR1_MI26                                0x4000000UL
#define CAN_RXIMR1_MI25                                0x2000000UL
#define CAN_RXIMR1_MI24                                0x1000000UL
#define CAN_RXIMR1_MI23                                0x800000UL
#define CAN_RXIMR1_MI22                                0x400000UL
#define CAN_RXIMR1_MI21                                0x200000UL
#define CAN_RXIMR1_MI20                                0x100000UL
#define CAN_RXIMR1_MI19                                0x80000UL
#define CAN_RXIMR1_MI18                                0x40000UL
#define CAN_RXIMR1_MI17                                0x20000UL
#define CAN_RXIMR1_MI16                                0x10000UL
#define CAN_RXIMR1_MI15                                0x8000UL
#define CAN_RXIMR1_MI14                                0x4000UL
#define CAN_RXIMR1_MI13                                0x2000UL
#define CAN_RXIMR1_MI12                                0x1000UL
#define CAN_RXIMR1_MI11                                0x0800UL
#define CAN_RXIMR1_MI10                                0x0400UL
#define CAN_RXIMR1_MI9                                 0x0200UL
#define CAN_RXIMR1_MI8                                 0x0100UL
#define CAN_RXIMR1_MI7                                 0x0080UL
#define CAN_RXIMR1_MI6                                 0x0040UL
#define CAN_RXIMR1_MI5                                 0x0020UL
#define CAN_RXIMR1_MI4                                 0x0010UL
#define CAN_RXIMR1_MI3                                 0x0008UL
#define CAN_RXIMR1_MI2                                 0x0004UL
#define CAN_RXIMR1_MI1                                 0x0002UL
#define CAN_RXIMR1_MI0                                 0x0001UL
#define CAN_RXIMR1_MI                                  0xFFFFFFFFUL

/* Masks for registers RXIMR2 */
#define CAN_RXIMR2_MASK                                0xFFFFFFFFUL
#define CAN_RXIMR2_MI31                                0x80000000UL
#define CAN_RXIMR2_MI30                                0x40000000UL
#define CAN_RXIMR2_MI29                                0x20000000UL
#define CAN_RXIMR2_MI28                                0x10000000UL
#define CAN_RXIMR2_MI27                                0x8000000UL
#define CAN_RXIMR2_MI26                                0x4000000UL
#define CAN_RXIMR2_MI25                                0x2000000UL
#define CAN_RXIMR2_MI24                                0x1000000UL
#define CAN_RXIMR2_MI23                                0x800000UL
#define CAN_RXIMR2_MI22                                0x400000UL
#define CAN_RXIMR2_MI21                                0x200000UL
#define CAN_RXIMR2_MI20                                0x100000UL
#define CAN_RXIMR2_MI19                                0x80000UL
#define CAN_RXIMR2_MI18                                0x40000UL
#define CAN_RXIMR2_MI17                                0x20000UL
#define CAN_RXIMR2_MI16                                0x10000UL
#define CAN_RXIMR2_MI15                                0x8000UL
#define CAN_RXIMR2_MI14                                0x4000UL
#define CAN_RXIMR2_MI13                                0x2000UL
#define CAN_RXIMR2_MI12                                0x1000UL
#define CAN_RXIMR2_MI11                                0x0800UL
#define CAN_RXIMR2_MI10                                0x0400UL
#define CAN_RXIMR2_MI9                                 0x0200UL
#define CAN_RXIMR2_MI8                                 0x0100UL
#define CAN_RXIMR2_MI7                                 0x0080UL
#define CAN_RXIMR2_MI6                                 0x0040UL
#define CAN_RXIMR2_MI5                                 0x0020UL
#define CAN_RXIMR2_MI4                                 0x0010UL
#define CAN_RXIMR2_MI3                                 0x0008UL
#define CAN_RXIMR2_MI2                                 0x0004UL
#define CAN_RXIMR2_MI1                                 0x0002UL
#define CAN_RXIMR2_MI0                                 0x0001UL
#define CAN_RXIMR2_MI                                  0xFFFFFFFFUL

/* Masks for registers RXIMR3 */
#define CAN_RXIMR3_MASK                                0xFFFFFFFFUL
#define CAN_RXIMR3_MI31                                0x80000000UL
#define CAN_RXIMR3_MI30                                0x40000000UL
#define CAN_RXIMR3_MI29                                0x20000000UL
#define CAN_RXIMR3_MI28                                0x10000000UL
#define CAN_RXIMR3_MI27                                0x8000000UL
#define CAN_RXIMR3_MI26                                0x4000000UL
#define CAN_RXIMR3_MI25                                0x2000000UL
#define CAN_RXIMR3_MI24                                0x1000000UL
#define CAN_RXIMR3_MI23                                0x800000UL
#define CAN_RXIMR3_MI22                                0x400000UL
#define CAN_RXIMR3_MI21                                0x200000UL
#define CAN_RXIMR3_MI20                                0x100000UL
#define CAN_RXIMR3_MI19                                0x80000UL
#define CAN_RXIMR3_MI18                                0x40000UL
#define CAN_RXIMR3_MI17                                0x20000UL
#define CAN_RXIMR3_MI16                                0x10000UL
#define CAN_RXIMR3_MI15                                0x8000UL
#define CAN_RXIMR3_MI14                                0x4000UL
#define CAN_RXIMR3_MI13                                0x2000UL
#define CAN_RXIMR3_MI12                                0x1000UL
#define CAN_RXIMR3_MI11                                0x0800UL
#define CAN_RXIMR3_MI10                                0x0400UL
#define CAN_RXIMR3_MI9                                 0x0200UL
#define CAN_RXIMR3_MI8                                 0x0100UL
#define CAN_RXIMR3_MI7                                 0x0080UL
#define CAN_RXIMR3_MI6                                 0x0040UL
#define CAN_RXIMR3_MI5                                 0x0020UL
#define CAN_RXIMR3_MI4                                 0x0010UL
#define CAN_RXIMR3_MI3                                 0x0008UL
#define CAN_RXIMR3_MI2                                 0x0004UL
#define CAN_RXIMR3_MI1                                 0x0002UL
#define CAN_RXIMR3_MI0                                 0x0001UL
#define CAN_RXIMR3_MI                                  0xFFFFFFFFUL

/* Masks for registers RXIMR4 */
#define CAN_RXIMR4_MASK                                0xFFFFFFFFUL
#define CAN_RXIMR4_MI31                                0x80000000UL
#define CAN_RXIMR4_MI30                                0x40000000UL
#define CAN_RXIMR4_MI29                                0x20000000UL
#define CAN_RXIMR4_MI28                                0x10000000UL
#define CAN_RXIMR4_MI27                                0x8000000UL
#define CAN_RXIMR4_MI26                                0x4000000UL
#define CAN_RXIMR4_MI25                                0x2000000UL
#define CAN_RXIMR4_MI24                                0x1000000UL
#define CAN_RXIMR4_MI23                                0x800000UL
#define CAN_RXIMR4_MI22                                0x400000UL
#define CAN_RXIMR4_MI21                                0x200000UL
#define CAN_RXIMR4_MI20                                0x100000UL
#define CAN_RXIMR4_MI19                                0x80000UL
#define CAN_RXIMR4_MI18                                0x40000UL
#define CAN_RXIMR4_MI17                                0x20000UL
#define CAN_RXIMR4_MI16                                0x10000UL
#define CAN_RXIMR4_MI15                                0x8000UL
#define CAN_RXIMR4_MI14                                0x4000UL
#define CAN_RXIMR4_MI13                                0x2000UL
#define CAN_RXIMR4_MI12                                0x1000UL
#define CAN_RXIMR4_MI11                                0x0800UL
#define CAN_RXIMR4_MI10                                0x0400UL
#define CAN_RXIMR4_MI9                                 0x0200UL
#define CAN_RXIMR4_MI8                                 0x0100UL
#define CAN_RXIMR4_MI7                                 0x0080UL
#define CAN_RXIMR4_MI6                                 0x0040UL
#define CAN_RXIMR4_MI5                                 0x0020UL
#define CAN_RXIMR4_MI4                                 0x0010UL
#define CAN_RXIMR4_MI3                                 0x0008UL
#define CAN_RXIMR4_MI2                                 0x0004UL
#define CAN_RXIMR4_MI1                                 0x0002UL
#define CAN_RXIMR4_MI0                                 0x0001UL
#define CAN_RXIMR4_MI                                  0xFFFFFFFFUL

/* Masks for registers RXIMR5 */
#define CAN_RXIMR5_MASK                                0xFFFFFFFFUL
#define CAN_RXIMR5_MI31                                0x80000000UL
#define CAN_RXIMR5_MI30                                0x40000000UL
#define CAN_RXIMR5_MI29                                0x20000000UL
#define CAN_RXIMR5_MI28                                0x10000000UL
#define CAN_RXIMR5_MI27                                0x8000000UL
#define CAN_RXIMR5_MI26                                0x4000000UL
#define CAN_RXIMR5_MI25                                0x2000000UL
#define CAN_RXIMR5_MI24                                0x1000000UL
#define CAN_RXIMR5_MI23                                0x800000UL
#define CAN_RXIMR5_MI22                                0x400000UL
#define CAN_RXIMR5_MI21                                0x200000UL
#define CAN_RXIMR5_MI20                                0x100000UL
#define CAN_RXIMR5_MI19                                0x80000UL
#define CAN_RXIMR5_MI18                                0x40000UL
#define CAN_RXIMR5_MI17                                0x20000UL
#define CAN_RXIMR5_MI16                                0x10000UL
#define CAN_RXIMR5_MI15                                0x8000UL
#define CAN_RXIMR5_MI14                                0x4000UL
#define CAN_RXIMR5_MI13                                0x2000UL
#define CAN_RXIMR5_MI12                                0x1000UL
#define CAN_RXIMR5_MI11                                0x0800UL
#define CAN_RXIMR5_MI10                                0x0400UL
#define CAN_RXIMR5_MI9                                 0x0200UL
#define CAN_RXIMR5_MI8                                 0x0100UL
#define CAN_RXIMR5_MI7                                 0x0080UL
#define CAN_RXIMR5_MI6                                 0x0040UL
#define CAN_RXIMR5_MI5                                 0x0020UL
#define CAN_RXIMR5_MI4                                 0x0010UL
#define CAN_RXIMR5_MI3                                 0x0008UL
#define CAN_RXIMR5_MI2                                 0x0004UL
#define CAN_RXIMR5_MI1                                 0x0002UL
#define CAN_RXIMR5_MI0                                 0x0001UL
#define CAN_RXIMR5_MI                                  0xFFFFFFFFUL

/* Masks for registers RXIMR6 */
#define CAN_RXIMR6_MASK                                0xFFFFFFFFUL
#define CAN_RXIMR6_MI31                                0x80000000UL
#define CAN_RXIMR6_MI30                                0x40000000UL
#define CAN_RXIMR6_MI29                                0x20000000UL
#define CAN_RXIMR6_MI28                                0x10000000UL
#define CAN_RXIMR6_MI27                                0x8000000UL
#define CAN_RXIMR6_MI26                                0x4000000UL
#define CAN_RXIMR6_MI25                                0x2000000UL
#define CAN_RXIMR6_MI24                                0x1000000UL
#define CAN_RXIMR6_MI23                                0x800000UL
#define CAN_RXIMR6_MI22                                0x400000UL
#define CAN_RXIMR6_MI21                                0x200000UL
#define CAN_RXIMR6_MI20                                0x100000UL
#define CAN_RXIMR6_MI19                                0x80000UL
#define CAN_RXIMR6_MI18                                0x40000UL
#define CAN_RXIMR6_MI17                                0x20000UL
#define CAN_RXIMR6_MI16                                0x10000UL
#define CAN_RXIMR6_MI15                                0x8000UL
#define CAN_RXIMR6_MI14                                0x4000UL
#define CAN_RXIMR6_MI13                                0x2000UL
#define CAN_RXIMR6_MI12                                0x1000UL
#define CAN_RXIMR6_MI11                                0x0800UL
#define CAN_RXIMR6_MI10                                0x0400UL
#define CAN_RXIMR6_MI9                                 0x0200UL
#define CAN_RXIMR6_MI8                                 0x0100UL
#define CAN_RXIMR6_MI7                                 0x0080UL
#define CAN_RXIMR6_MI6                                 0x0040UL
#define CAN_RXIMR6_MI5                                 0x0020UL
#define CAN_RXIMR6_MI4                                 0x0010UL
#define CAN_RXIMR6_MI3                                 0x0008UL
#define CAN_RXIMR6_MI2                                 0x0004UL
#define CAN_RXIMR6_MI1                                 0x0002UL
#define CAN_RXIMR6_MI0                                 0x0001UL
#define CAN_RXIMR6_MI                                  0xFFFFFFFFUL

/* Masks for registers RXIMR7 */
#define CAN_RXIMR7_MASK                                0xFFFFFFFFUL
#define CAN_RXIMR7_MI31                                0x80000000UL
#define CAN_RXIMR7_MI30                                0x40000000UL
#define CAN_RXIMR7_MI29                                0x20000000UL
#define CAN_RXIMR7_MI28                                0x10000000UL
#define CAN_RXIMR7_MI27                                0x8000000UL
#define CAN_RXIMR7_MI26                                0x4000000UL
#define CAN_RXIMR7_MI25                                0x2000000UL
#define CAN_RXIMR7_MI24                                0x1000000UL
#define CAN_RXIMR7_MI23                                0x800000UL
#define CAN_RXIMR7_MI22                                0x400000UL
#define CAN_RXIMR7_MI21                                0x200000UL
#define CAN_RXIMR7_MI20                                0x100000UL
#define CAN_RXIMR7_MI19                                0x80000UL
#define CAN_RXIMR7_MI18                                0x40000UL
#define CAN_RXIMR7_MI17                                0x20000UL
#define CAN_RXIMR7_MI16                                0x10000UL
#define CAN_RXIMR7_MI15                                0x8000UL
#define CAN_RXIMR7_MI14                                0x4000UL
#define CAN_RXIMR7_MI13                                0x2000UL
#define CAN_RXIMR7_MI12                                0x1000UL
#define CAN_RXIMR7_MI11                                0x0800UL
#define CAN_RXIMR7_MI10                                0x0400UL
#define CAN_RXIMR7_MI9                                 0x0200UL
#define CAN_RXIMR7_MI8                                 0x0100UL
#define CAN_RXIMR7_MI7                                 0x0080UL
#define CAN_RXIMR7_MI6                                 0x0040UL
#define CAN_RXIMR7_MI5                                 0x0020UL
#define CAN_RXIMR7_MI4                                 0x0010UL
#define CAN_RXIMR7_MI3                                 0x0008UL
#define CAN_RXIMR7_MI2                                 0x0004UL
#define CAN_RXIMR7_MI1                                 0x0002UL
#define CAN_RXIMR7_MI0                                 0x0001UL
#define CAN_RXIMR7_MI                                  0xFFFFFFFFUL

/* Masks for registers RXIMR8 */
#define CAN_RXIMR8_MASK                                0xFFFFFFFFUL
#define CAN_RXIMR8_MI31                                0x80000000UL
#define CAN_RXIMR8_MI30                                0x40000000UL
#define CAN_RXIMR8_MI29                                0x20000000UL
#define CAN_RXIMR8_MI28                                0x10000000UL
#define CAN_RXIMR8_MI27                                0x8000000UL
#define CAN_RXIMR8_MI26                                0x4000000UL
#define CAN_RXIMR8_MI25                                0x2000000UL
#define CAN_RXIMR8_MI24                                0x1000000UL
#define CAN_RXIMR8_MI23                                0x800000UL
#define CAN_RXIMR8_MI22                                0x400000UL
#define CAN_RXIMR8_MI21                                0x200000UL
#define CAN_RXIMR8_MI20                                0x100000UL
#define CAN_RXIMR8_MI19                                0x80000UL
#define CAN_RXIMR8_MI18                                0x40000UL
#define CAN_RXIMR8_MI17                                0x20000UL
#define CAN_RXIMR8_MI16                                0x10000UL
#define CAN_RXIMR8_MI15                                0x8000UL
#define CAN_RXIMR8_MI14                                0x4000UL
#define CAN_RXIMR8_MI13                                0x2000UL
#define CAN_RXIMR8_MI12                                0x1000UL
#define CAN_RXIMR8_MI11                                0x0800UL
#define CAN_RXIMR8_MI10                                0x0400UL
#define CAN_RXIMR8_MI9                                 0x0200UL
#define CAN_RXIMR8_MI8                                 0x0100UL
#define CAN_RXIMR8_MI7                                 0x0080UL
#define CAN_RXIMR8_MI6                                 0x0040UL
#define CAN_RXIMR8_MI5                                 0x0020UL
#define CAN_RXIMR8_MI4                                 0x0010UL
#define CAN_RXIMR8_MI3                                 0x0008UL
#define CAN_RXIMR8_MI2                                 0x0004UL
#define CAN_RXIMR8_MI1                                 0x0002UL
#define CAN_RXIMR8_MI0                                 0x0001UL
#define CAN_RXIMR8_MI                                  0xFFFFFFFFUL

/* Masks for registers RXIMR9 */
#define CAN_RXIMR9_MASK                                0xFFFFFFFFUL
#define CAN_RXIMR9_MI31                                0x80000000UL
#define CAN_RXIMR9_MI30                                0x40000000UL
#define CAN_RXIMR9_MI29                                0x20000000UL
#define CAN_RXIMR9_MI28                                0x10000000UL
#define CAN_RXIMR9_MI27                                0x8000000UL
#define CAN_RXIMR9_MI26                                0x4000000UL
#define CAN_RXIMR9_MI25                                0x2000000UL
#define CAN_RXIMR9_MI24                                0x1000000UL
#define CAN_RXIMR9_MI23                                0x800000UL
#define CAN_RXIMR9_MI22                                0x400000UL
#define CAN_RXIMR9_MI21                                0x200000UL
#define CAN_RXIMR9_MI20                                0x100000UL
#define CAN_RXIMR9_MI19                                0x80000UL
#define CAN_RXIMR9_MI18                                0x40000UL
#define CAN_RXIMR9_MI17                                0x20000UL
#define CAN_RXIMR9_MI16                                0x10000UL
#define CAN_RXIMR9_MI15                                0x8000UL
#define CAN_RXIMR9_MI14                                0x4000UL
#define CAN_RXIMR9_MI13                                0x2000UL
#define CAN_RXIMR9_MI12                                0x1000UL
#define CAN_RXIMR9_MI11                                0x0800UL
#define CAN_RXIMR9_MI10                                0x0400UL
#define CAN_RXIMR9_MI9                                 0x0200UL
#define CAN_RXIMR9_MI8                                 0x0100UL
#define CAN_RXIMR9_MI7                                 0x0080UL
#define CAN_RXIMR9_MI6                                 0x0040UL
#define CAN_RXIMR9_MI5                                 0x0020UL
#define CAN_RXIMR9_MI4                                 0x0010UL
#define CAN_RXIMR9_MI3                                 0x0008UL
#define CAN_RXIMR9_MI2                                 0x0004UL
#define CAN_RXIMR9_MI1                                 0x0002UL
#define CAN_RXIMR9_MI0                                 0x0001UL
#define CAN_RXIMR9_MI                                  0xFFFFFFFFUL

/* Masks for registers RXIMR10 */
#define CAN_RXIMR10_MASK                               0xFFFFFFFFUL
#define CAN_RXIMR10_MI31                               0x80000000UL
#define CAN_RXIMR10_MI30                               0x40000000UL
#define CAN_RXIMR10_MI29                               0x20000000UL
#define CAN_RXIMR10_MI28                               0x10000000UL
#define CAN_RXIMR10_MI27                               0x8000000UL
#define CAN_RXIMR10_MI26                               0x4000000UL
#define CAN_RXIMR10_MI25                               0x2000000UL
#define CAN_RXIMR10_MI24                               0x1000000UL
#define CAN_RXIMR10_MI23                               0x800000UL
#define CAN_RXIMR10_MI22                               0x400000UL
#define CAN_RXIMR10_MI21                               0x200000UL
#define CAN_RXIMR10_MI20                               0x100000UL
#define CAN_RXIMR10_MI19                               0x80000UL
#define CAN_RXIMR10_MI18                               0x40000UL
#define CAN_RXIMR10_MI17                               0x20000UL
#define CAN_RXIMR10_MI16                               0x10000UL
#define CAN_RXIMR10_MI15                               0x8000UL
#define CAN_RXIMR10_MI14                               0x4000UL
#define CAN_RXIMR10_MI13                               0x2000UL
#define CAN_RXIMR10_MI12                               0x1000UL
#define CAN_RXIMR10_MI11                               0x0800UL
#define CAN_RXIMR10_MI10                               0x0400UL
#define CAN_RXIMR10_MI9                                0x0200UL
#define CAN_RXIMR10_MI8                                0x0100UL
#define CAN_RXIMR10_MI7                                0x0080UL
#define CAN_RXIMR10_MI6                                0x0040UL
#define CAN_RXIMR10_MI5                                0x0020UL
#define CAN_RXIMR10_MI4                                0x0010UL
#define CAN_RXIMR10_MI3                                0x0008UL
#define CAN_RXIMR10_MI2                                0x0004UL
#define CAN_RXIMR10_MI1                                0x0002UL
#define CAN_RXIMR10_MI0                                0x0001UL
#define CAN_RXIMR10_MI                                 0xFFFFFFFFUL

/* Masks for registers RXIMR11 */
#define CAN_RXIMR11_MASK                               0xFFFFFFFFUL
#define CAN_RXIMR11_MI31                               0x80000000UL
#define CAN_RXIMR11_MI30                               0x40000000UL
#define CAN_RXIMR11_MI29                               0x20000000UL
#define CAN_RXIMR11_MI28                               0x10000000UL
#define CAN_RXIMR11_MI27                               0x8000000UL
#define CAN_RXIMR11_MI26                               0x4000000UL
#define CAN_RXIMR11_MI25                               0x2000000UL
#define CAN_RXIMR11_MI24                               0x1000000UL
#define CAN_RXIMR11_MI23                               0x800000UL
#define CAN_RXIMR11_MI22                               0x400000UL
#define CAN_RXIMR11_MI21                               0x200000UL
#define CAN_RXIMR11_MI20                               0x100000UL
#define CAN_RXIMR11_MI19                               0x80000UL
#define CAN_RXIMR11_MI18                               0x40000UL
#define CAN_RXIMR11_MI17                               0x20000UL
#define CAN_RXIMR11_MI16                               0x10000UL
#define CAN_RXIMR11_MI15                               0x8000UL
#define CAN_RXIMR11_MI14                               0x4000UL
#define CAN_RXIMR11_MI13                               0x2000UL
#define CAN_RXIMR11_MI12                               0x1000UL
#define CAN_RXIMR11_MI11                               0x0800UL
#define CAN_RXIMR11_MI10                               0x0400UL
#define CAN_RXIMR11_MI9                                0x0200UL
#define CAN_RXIMR11_MI8                                0x0100UL
#define CAN_RXIMR11_MI7                                0x0080UL
#define CAN_RXIMR11_MI6                                0x0040UL
#define CAN_RXIMR11_MI5                                0x0020UL
#define CAN_RXIMR11_MI4                                0x0010UL
#define CAN_RXIMR11_MI3                                0x0008UL
#define CAN_RXIMR11_MI2                                0x0004UL
#define CAN_RXIMR11_MI1                                0x0002UL
#define CAN_RXIMR11_MI0                                0x0001UL
#define CAN_RXIMR11_MI                                 0xFFFFFFFFUL

/* Masks for registers RXIMR12 */
#define CAN_RXIMR12_MASK                               0xFFFFFFFFUL
#define CAN_RXIMR12_MI31                               0x80000000UL
#define CAN_RXIMR12_MI30                               0x40000000UL
#define CAN_RXIMR12_MI29                               0x20000000UL
#define CAN_RXIMR12_MI28                               0x10000000UL
#define CAN_RXIMR12_MI27                               0x8000000UL
#define CAN_RXIMR12_MI26                               0x4000000UL
#define CAN_RXIMR12_MI25                               0x2000000UL
#define CAN_RXIMR12_MI24                               0x1000000UL
#define CAN_RXIMR12_MI23                               0x800000UL
#define CAN_RXIMR12_MI22                               0x400000UL
#define CAN_RXIMR12_MI21                               0x200000UL
#define CAN_RXIMR12_MI20                               0x100000UL
#define CAN_RXIMR12_MI19                               0x80000UL
#define CAN_RXIMR12_MI18                               0x40000UL
#define CAN_RXIMR12_MI17                               0x20000UL
#define CAN_RXIMR12_MI16                               0x10000UL
#define CAN_RXIMR12_MI15                               0x8000UL
#define CAN_RXIMR12_MI14                               0x4000UL
#define CAN_RXIMR12_MI13                               0x2000UL
#define CAN_RXIMR12_MI12                               0x1000UL
#define CAN_RXIMR12_MI11                               0x0800UL
#define CAN_RXIMR12_MI10                               0x0400UL
#define CAN_RXIMR12_MI9                                0x0200UL
#define CAN_RXIMR12_MI8                                0x0100UL
#define CAN_RXIMR12_MI7                                0x0080UL
#define CAN_RXIMR12_MI6                                0x0040UL
#define CAN_RXIMR12_MI5                                0x0020UL
#define CAN_RXIMR12_MI4                                0x0010UL
#define CAN_RXIMR12_MI3                                0x0008UL
#define CAN_RXIMR12_MI2                                0x0004UL
#define CAN_RXIMR12_MI1                                0x0002UL
#define CAN_RXIMR12_MI0                                0x0001UL
#define CAN_RXIMR12_MI                                 0xFFFFFFFFUL

/* Masks for registers RXIMR13 */
#define CAN_RXIMR13_MASK                               0xFFFFFFFFUL
#define CAN_RXIMR13_MI31                               0x80000000UL
#define CAN_RXIMR13_MI30                               0x40000000UL
#define CAN_RXIMR13_MI29                               0x20000000UL
#define CAN_RXIMR13_MI28                               0x10000000UL
#define CAN_RXIMR13_MI27                               0x8000000UL
#define CAN_RXIMR13_MI26                               0x4000000UL
#define CAN_RXIMR13_MI25                               0x2000000UL
#define CAN_RXIMR13_MI24                               0x1000000UL
#define CAN_RXIMR13_MI23                               0x800000UL
#define CAN_RXIMR13_MI22                               0x400000UL
#define CAN_RXIMR13_MI21                               0x200000UL
#define CAN_RXIMR13_MI20                               0x100000UL
#define CAN_RXIMR13_MI19                               0x80000UL
#define CAN_RXIMR13_MI18                               0x40000UL
#define CAN_RXIMR13_MI17                               0x20000UL
#define CAN_RXIMR13_MI16                               0x10000UL
#define CAN_RXIMR13_MI15                               0x8000UL
#define CAN_RXIMR13_MI14                               0x4000UL
#define CAN_RXIMR13_MI13                               0x2000UL
#define CAN_RXIMR13_MI12                               0x1000UL
#define CAN_RXIMR13_MI11                               0x0800UL
#define CAN_RXIMR13_MI10                               0x0400UL
#define CAN_RXIMR13_MI9                                0x0200UL
#define CAN_RXIMR13_MI8                                0x0100UL
#define CAN_RXIMR13_MI7                                0x0080UL
#define CAN_RXIMR13_MI6                                0x0040UL
#define CAN_RXIMR13_MI5                                0x0020UL
#define CAN_RXIMR13_MI4                                0x0010UL
#define CAN_RXIMR13_MI3                                0x0008UL
#define CAN_RXIMR13_MI2                                0x0004UL
#define CAN_RXIMR13_MI1                                0x0002UL
#define CAN_RXIMR13_MI0                                0x0001UL
#define CAN_RXIMR13_MI                                 0xFFFFFFFFUL

/* Masks for registers RXIMR14 */
#define CAN_RXIMR14_MASK                               0xFFFFFFFFUL
#define CAN_RXIMR14_MI31                               0x80000000UL
#define CAN_RXIMR14_MI30                               0x40000000UL
#define CAN_RXIMR14_MI29                               0x20000000UL
#define CAN_RXIMR14_MI28                               0x10000000UL
#define CAN_RXIMR14_MI27                               0x8000000UL
#define CAN_RXIMR14_MI26                               0x4000000UL
#define CAN_RXIMR14_MI25                               0x2000000UL
#define CAN_RXIMR14_MI24                               0x1000000UL
#define CAN_RXIMR14_MI23                               0x800000UL
#define CAN_RXIMR14_MI22                               0x400000UL
#define CAN_RXIMR14_MI21                               0x200000UL
#define CAN_RXIMR14_MI20                               0x100000UL
#define CAN_RXIMR14_MI19                               0x80000UL
#define CAN_RXIMR14_MI18                               0x40000UL
#define CAN_RXIMR14_MI17                               0x20000UL
#define CAN_RXIMR14_MI16                               0x10000UL
#define CAN_RXIMR14_MI15                               0x8000UL
#define CAN_RXIMR14_MI14                               0x4000UL
#define CAN_RXIMR14_MI13                               0x2000UL
#define CAN_RXIMR14_MI12                               0x1000UL
#define CAN_RXIMR14_MI11                               0x0800UL
#define CAN_RXIMR14_MI10                               0x0400UL
#define CAN_RXIMR14_MI9                                0x0200UL
#define CAN_RXIMR14_MI8                                0x0100UL
#define CAN_RXIMR14_MI7                                0x0080UL
#define CAN_RXIMR14_MI6                                0x0040UL
#define CAN_RXIMR14_MI5                                0x0020UL
#define CAN_RXIMR14_MI4                                0x0010UL
#define CAN_RXIMR14_MI3                                0x0008UL
#define CAN_RXIMR14_MI2                                0x0004UL
#define CAN_RXIMR14_MI1                                0x0002UL
#define CAN_RXIMR14_MI0                                0x0001UL
#define CAN_RXIMR14_MI                                 0xFFFFFFFFUL

/* Masks for registers RXIMR15 */
#define CAN_RXIMR15_MASK                               0xFFFFFFFFUL
#define CAN_RXIMR15_MI31                               0x80000000UL
#define CAN_RXIMR15_MI30                               0x40000000UL
#define CAN_RXIMR15_MI29                               0x20000000UL
#define CAN_RXIMR15_MI28                               0x10000000UL
#define CAN_RXIMR15_MI27                               0x8000000UL
#define CAN_RXIMR15_MI26                               0x4000000UL
#define CAN_RXIMR15_MI25                               0x2000000UL
#define CAN_RXIMR15_MI24                               0x1000000UL
#define CAN_RXIMR15_MI23                               0x800000UL
#define CAN_RXIMR15_MI22                               0x400000UL
#define CAN_RXIMR15_MI21                               0x200000UL
#define CAN_RXIMR15_MI20                               0x100000UL
#define CAN_RXIMR15_MI19                               0x80000UL
#define CAN_RXIMR15_MI18                               0x40000UL
#define CAN_RXIMR15_MI17                               0x20000UL
#define CAN_RXIMR15_MI16                               0x10000UL
#define CAN_RXIMR15_MI15                               0x8000UL
#define CAN_RXIMR15_MI14                               0x4000UL
#define CAN_RXIMR15_MI13                               0x2000UL
#define CAN_RXIMR15_MI12                               0x1000UL
#define CAN_RXIMR15_MI11                               0x0800UL
#define CAN_RXIMR15_MI10                               0x0400UL
#define CAN_RXIMR15_MI9                                0x0200UL
#define CAN_RXIMR15_MI8                                0x0100UL
#define CAN_RXIMR15_MI7                                0x0080UL
#define CAN_RXIMR15_MI6                                0x0040UL
#define CAN_RXIMR15_MI5                                0x0020UL
#define CAN_RXIMR15_MI4                                0x0010UL
#define CAN_RXIMR15_MI3                                0x0008UL
#define CAN_RXIMR15_MI2                                0x0004UL
#define CAN_RXIMR15_MI1                                0x0002UL
#define CAN_RXIMR15_MI0                                0x0001UL
#define CAN_RXIMR15_MI                                 0xFFFFFFFFUL



/******************************************
*** Peripheral FACN_MB0
*******************************************/  

typedef volatile struct {  
  UWord32 cs;                          /*** CAN_CS0 - Message Buffer 0 CS Register; 0x0000E880 ***/
  UWord32 id;                          /*** CAN_ID0 - Message Buffer 0 ID Register; 0x0000E884 ***/
  UWord32 word0;                       /*** CAN_WORD00 - Message Buffer 0 WORD0 Register; 0x0000E888 ***/
  UWord32 word1;                       /*** CAN_WORD10 - Message Buffer 0 WORD1 Register; 0x0000E88C ***/
} arch_sFCAN_MB0;

/******************************************
*** Peripheral FACN_MB1
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS1 - Message Buffer 1 CS Register; 0x0000E890 ***/
  UWord32 id;                          /*** CAN_ID1 - Message Buffer 1 ID Register; 0x0000E894 ***/
  UWord32 word0;                       /*** CAN_WORD01 - Message Buffer 1 WORD0 Register; 0x0000E898 ***/
  UWord32 word1;                       /*** CAN_WORD11 - Message Buffer 1 WORD1 Register; 0x0000E89C ***/
} arch_sFCAN_MB1;

/******************************************
*** Peripheral FACN_MB2
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS2 - Message Buffer 2 CS Register; 0x0000E8A0 ***/
  UWord32 id;                          /*** CAN_ID2 - Message Buffer 2 ID Register; 0x0000E8A4 ***/
  UWord32 word0;                       /*** CAN_WORD02 - Message Buffer 2 WORD0 Register; 0x0000E8A8 ***/
  UWord32 word1;                       /*** CAN_WORD12 - Message Buffer 2 WORD1 Register; 0x0000E8AC ***/
} arch_sFCAN_MB2;

/******************************************
*** Peripheral FACN_MB3
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS3 - Message Buffer 3 CS Register; 0x0000E8B0 ***/
  UWord32 id;                          /*** CAN_ID3 - Message Buffer 3 ID Register; 0x0000E8B4 ***/
  UWord32 word0;                       /*** CAN_WORD03 - Message Buffer 3 WORD0 Register; 0x0000E8B8 ***/
  UWord32 word1;                       /*** CAN_WORD13 - Message Buffer 3 WORD1 Register; 0x0000E8BC ***/
} arch_sFCAN_MB3;

/******************************************
*** Peripheral FACN_MB4
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS4 - Message Buffer 4 CS Register; 0x0000E8C0 ***/
  UWord32 id;                          /*** CAN_ID4 - Message Buffer 4 ID Register; 0x0000E8C4 ***/
  UWord32 word0;                       /*** CAN_WORD04 - Message Buffer 4 WORD0 Register; 0x0000E8C8 ***/
  UWord32 word1;                       /*** CAN_WORD14 - Message Buffer 4 WORD1 Register; 0x0000E8CC ***/
} arch_sFCAN_MB4;

/******************************************
*** Peripheral FACN_MB5
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS5 - Message Buffer 5 CS Register; 0x0000E8D0 ***/
  UWord32 id;                          /*** CAN_ID5 - Message Buffer 5 ID Register; 0x0000E8D4 ***/
  UWord32 word0;                       /*** CAN_WORD05 - Message Buffer 5 WORD0 Register; 0x0000E8D8 ***/
  UWord32 word1;                       /*** CAN_WORD15 - Message Buffer 5 WORD1 Register; 0x0000E8DC ***/
} arch_sFCAN_MB5;

/******************************************
*** Peripheral FACN_MB6
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS6 - Message Buffer 6 CS Register; 0x0000E8E0 ***/
  UWord32 id;                          /*** CAN_ID6 - Message Buffer 6 ID Register; 0x0000E8E4 ***/
  UWord32 word0;                       /*** CAN_WORD06 - Message Buffer 6 WORD0 Register; 0x0000E8E8 ***/
  UWord32 word1;                       /*** CAN_WORD16 - Message Buffer 6 WORD1 Register; 0x0000E8EC ***/
} arch_sFCAN_MB6;

/******************************************
*** Peripheral FACN_MB7
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS7 - Message Buffer 7 CS Register; 0x0000E8F0 ***/
  UWord32 id;                          /*** CAN_ID7 - Message Buffer 7 ID Register; 0x0000E8F4 ***/
  UWord32 word0;                       /*** CAN_WORD07 - Message Buffer 7 WORD0 Register; 0x0000E8F8 ***/
  UWord32 word1;                       /*** CAN_WORD17 - Message Buffer 7 WORD1 Register; 0x0000E8FC ***/
} arch_sFCAN_MB7;

/******************************************
*** Peripheral FACN_MB8
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS8 - Message Buffer 8 CS Register; 0x0000E900 ***/
  UWord32 id;                          /*** CAN_ID8 - Message Buffer 8 ID Register; 0x0000E904 ***/
  UWord32 word0;                       /*** CAN_WORD08 - Message Buffer 8 WORD0 Register; 0x0000E908 ***/
  UWord32 word1;                       /*** CAN_WORD18 - Message Buffer 8 WORD1 Register; 0x0000E90C ***/
} arch_sFCAN_MB8;

/******************************************
*** Peripheral FACN_MB9
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS9 - Message Buffer 9 CS Register; 0x0000E910 ***/
  UWord32 id;                          /*** CAN_ID9 - Message Buffer 9 ID Register; 0x0000E914 ***/
  UWord32 word0;                       /*** CAN_WORD09 - Message Buffer 9 WORD0 Register; 0x0000E918 ***/
  UWord32 word1;                       /*** CAN_WORD19 - Message Buffer 9 WORD1 Register; 0x0000E91C ***/
} arch_sFCAN_MB9;

/******************************************
*** Peripheral FACN_MB10
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS10 - Message Buffer 10 CS Register; 0x0000E920 ***/
  UWord32 id;                          /*** CAN_ID10 - Message Buffer 10 ID Register; 0x0000E924 ***/
  UWord32 word0;                       /*** CAN_WORD010 - Message Buffer 10 WORD0 Register; 0x0000E928 ***/
  UWord32 word1;                       /*** CAN_WORD110 - Message Buffer 10 WORD1 Register; 0x0000E92C ***/
} arch_sFCAN_MB10;

/******************************************
*** Peripheral FACN_MB11
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS11 - Message Buffer 11 CS Register; 0x0000E930 ***/
  UWord32 id;                          /*** CAN_ID11 - Message Buffer 11 ID Register; 0x0000E934 ***/
  UWord32 word0;                       /*** CAN_WORD011 - Message Buffer 11 WORD0 Register; 0x0000E938 ***/
  UWord32 word1;                       /*** CAN_WORD111 - Message Buffer 11 WORD1 Register; 0x0000E93C ***/
} arch_sFCAN_MB11;

/******************************************
*** Peripheral FACN_MB12
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS12 - Message Buffer 12 CS Register; 0x0000E940 ***/
  UWord32 id;                          /*** CAN_ID12 - Message Buffer 12 ID Register; 0x0000E944 ***/
  UWord32 word0;                       /*** CAN_WORD012 - Message Buffer 12 WORD0 Register; 0x0000E948 ***/
  UWord32 word1;                       /*** CAN_WORD112 - Message Buffer 12 WORD1 Register; 0x0000E94C ***/
} arch_sFCAN_MB12;

/******************************************
*** Peripheral FACN_MB13
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS13 - Message Buffer 13 CS Register; 0x0000E950 ***/
  UWord32 id;                          /*** CAN_ID13 - Message Buffer 13 ID Register; 0x0000E954 ***/
  UWord32 word0;                       /*** CAN_WORD013 - Message Buffer 13 WORD0 Register; 0x0000E958 ***/
  UWord32 word1;                       /*** CAN_WORD113 - Message Buffer 13 WORD1 Register; 0x0000E95C ***/
} arch_sFCAN_MB13;

/******************************************
*** Peripheral FACN_MB14
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS14 - Message Buffer 14 CS Register; 0x0000E960 ***/
  UWord32 id;                          /*** CAN_ID14 - Message Buffer 14 ID Register; 0x0000E964 ***/
  UWord32 word0;                       /*** CAN_WORD014 - Message Buffer 14 WORD0 Register; 0x0000E968 ***/
  UWord32 word1;                       /*** CAN_WORD114 - Message Buffer 14 WORD1 Register; 0x0000E96C ***/
} arch_sFCAN_MB14;

/******************************************
*** Peripheral FACN_MB15
*******************************************/

typedef volatile struct {
  UWord32 cs;                          /*** CAN_CS15 - Message Buffer 15 CS Register; 0x0000E970 ***/
  UWord32 id;                          /*** CAN_ID15 - Message Buffer 15 ID Register; 0x0000E974 ***/
  UWord32 word0;                       /*** CAN_WORD015 - Message Buffer 15 WORD0 Register; 0x0000E978 ***/
  UWord32 word1;                       /*** CAN_WORD115 - Message Buffer 15 WORD1 Register; 0x0000E97C ***/
} arch_sFCAN_MB15;

// special flags for passing the ID vlaue
#define FCAN_ID_EXT 0x80000000	// specifies extended ID anywhere the ID is required
#define FCAN_ID_RTR 0x40000000	// turns on the RTR bit when calling FCANMB_SET_ID (only)
#define FCAN_MB_IDH_SRTR          0x0010
#define FCAN_MB_IDL_ERTR          0x0001
#define FCAN_MB_IDH_SRR           0x0010
#define FCAN_MB_IDH_IDE	          0x0008

/****************************************************************************
* FlexCAN inline functions
*****************************************************************************/
typedef arch_sFCAN_MB0 arch_sFlexCAN_MB;

void ioctl_FCANMB_SET_ID_V(register UWord16 * pFCanMB, register UWord32 id);
UWord32 ioctl_FCANMB_GET_ID(register UWord16* pFCanMB);

/*lint -save -e14 Disable MISRA rule (25) checking. */
inline UWord32 FCAN_Idr2Id(UWord32 idr)
{
	// Extended ID ?
	if(idr & (((UWord32)FCAN_MB_IDH_IDE) << 16))
		return ((idr >> 1) & 0x3FFFFL) | ((idr >> 3) & 0x1FFC0000) | 0x80000000;
	// Standard ID
	else
		return idr >> 21;
}
/*lint -restore */

/*lint -save -e14 Disable MISRA rule (25) checking. */
inline UWord32 FCAN_Id2Idr(UWord32 id)
{
	// Extended ID
	if(id & FCAN_ID_EXT)
		return (((id & 0x1FFC0000L) << 3) | 0x00180000L | ((id & 0x0003FFFFL) << 1));
	// Standard ID
	else
		return id << 21;
}
/*lint -restore */

/* Set 32bit ID to the apropriate bits in given MB (also set/clear RTR);  */
/*lint -save -e14 Disable MISRA rule (25) checking. */
inline void ioctl_FCANMB_SET_ID(register UWord16* pFCanMB, register UWord32 id)
{
	/* Note: we use inline function because mostly the ID is specified as constant so
          the ID->IDR conversion is done by preprocessor and code is really optimal */

	register UWord32 idr = FCAN_Id2Idr(id);

	// set RTR ?
	if(id & FCAN_ID_RTR)
		idr |= FCAN_MB_IDL_ERTR | (((UWord32)FCAN_MB_IDH_SRTR) << 16);

	// store into MB (can't use move.l due to misalignment)
	asm {
		move.w idr.1,X:(pFCanMB+1);
		asl16 idr,idr;
		move.w idr.1,X:(pFCanMB+2);
	}
}
/*lint -restore */

/***********************************************************************************************************
** CAN METHODS                                                                                   **
***********************************************************************************************************/
/*********************************************************************************************************
** Method:       FCAN_DEVICE                                                                            **
** Description:                                                                                         **
**               Module Enable/Disable.                                                                 **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Enable the FlexCAN module                                               **
**               FCAN_ENABLE - Disable the FlexCAN module                                               **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_DEVICE, FCAN_DISABLE );                                           **
**               ioctl( deviceID, FCAN_DEVICE, FCAN_DISABLE );                                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_DEVICE(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_MDIS, &periph.mcr);   /* set bit MDIS */\
  else\
    periphBitClear(CAN_MCR_MDIS, &periph.mcr); /* clear bit MDIS */

/*********************************************************************************************************
** Method:       FCAN_ENABLED_ENTER_FREEZE_MODE                                                         **
** Description:                                                                                         **
**               Freeze Enable/Disable.                                                                 **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Not enabled to enter Freeze Mode                                        **
**               FCAN_ENABLE - Enabled to enter Freeze Mode                                             **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_ENABLED_ENTER_FREEZE_MODE, FCAN_DISABLE );                        **
**               ioctl( deviceID, FCAN_ENABLED_ENTER_FREEZE_MODE, FCAN_DISABLE );                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_ENABLED_ENTER_FREEZE_MODE(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_FRZ, &periph.mcr);   /* set bit FRZ */\
  else\
    periphBitClear(CAN_MCR_FRZ, &periph.mcr); /* clear bit FRZ */

/*********************************************************************************************************
** Method:       FCAN_RX_FIFO                                                                           **
** Description:                                                                                         **
**               Rx FIFO Enable/Disable.                                                                **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Rx FIFO not enabled                                                     **
**               FCAN_ENABLE - Rx FIFO enabled                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_RX_FIFO, FCAN_DISABLE );                                          **
**               ioctl( deviceID, FCAN_RX_FIFO, FCAN_DISABLE );                                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_RX_FIFO(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_RFEN, &periph.mcr);   /* set bit RFEN */\
  else\
    periphBitClear(CAN_MCR_RFEN, &periph.mcr); /* clear bit RFEN */

/*********************************************************************************************************
** Method:       FCAN_FREEZE_MODE                                                                       **
** Description:                                                                                         **
**               Halt FlexCAN Enable/Disable.                                                           **
** Parameters:                                                                                          **
**               FCAN_DISABLE - No Freeze Mode request                                                  **
**               FCAN_ENABLE - Enters Freeze Mode if the FRZ bit is asserted                            **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_FREEZE_MODE, FCAN_DISABLE );                                      **
**               ioctl( deviceID, FCAN_FREEZE_MODE, FCAN_DISABLE );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_FREEZE_MODE(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_HALT, &periph.mcr);   /* set bit HALT */\
  else\
    periphBitClear(CAN_MCR_HALT, &periph.mcr); /* clear bit HALT */

/*********************************************************************************************************
** Method:       FCAN_TEST_READY                                                                        **
** Description:                                                                                         **
**               Get FlexCAN Not Ready.                                                                 **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_TEST_READY, NULL );                                           **
**               w = ioctl( deviceID, FCAN_TEST_READY, NULL );                                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_TEST_READY(periph, param) \
  periphBitTest(CAN_MCR_NOTRDY, &periph.mcr) /* read bit NOTRDY */

/*********************************************************************************************************
** Method:       FCAN_WAKEUP_INT                                                                        **
** Description:                                                                                         **
**               Wake Up Interrupt Mask Enable/Disable.                                                 **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Wake Up Interrupt is disabled                                           **
**               FCAN_ENABLE - Wake Up Interrupt is enabled                                             **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WAKEUP_INT, FCAN_DISABLE );                                       **
**               ioctl( deviceID, FCAN_WAKEUP_INT, FCAN_DISABLE );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WAKEUP_INT(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_WAKMSK, &periph.mcr);   /* set bit WAKMSK */\
  else\
    periphBitClear(CAN_MCR_WAKMSK, &periph.mcr); /* clear bit WAKMSK */

/*********************************************************************************************************
** Method:       FCAN_WARNING_INT                                                                       **
** Description:                                                                                         **
**               Warning Interrupt Enable/Disable.                                                      **
** Parameters:                                                                                          **
**               FCAN_DISABLE - No warning interrupts                                                   **
**               FCAN_ENABLE - Warning interrupts enabled                                               **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WARNING_INT, FCAN_DISABLE );                                      **
**               ioctl( deviceID, FCAN_WARNING_INT, FCAN_DISABLE );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WARNING_INT(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_WRNEN, &periph.mcr);   /* set bit WRNEN */\
  else\
    periphBitClear(CAN_MCR_WRNEN, &periph.mcr); /* clear bit WRNEN */

/*********************************************************************************************************
** Method:       FCAN_SOFT_RESET                                                                        **
** Description:                                                                                         **
**               Soft Reset.                                                                            **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SOFT_RESET, NULL );                                               **
**               ioctl( deviceID, FCAN_SOFT_RESET, NULL );                                              **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SOFT_RESET(periph, param) \
  periphBitSet(CAN_MCR_SOFTRST, &periph.mcr) /* set bit SOFTRST */

/*********************************************************************************************************
** Method:       FCAN_TEST_FREEZE_MODE                                                                  **
** Description:                                                                                         **
**               Get Freeze Mode Acknowledge.                                                           **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_TEST_FREEZE_MODE, NULL );                                     **
**               w = ioctl( deviceID, FCAN_TEST_FREEZE_MODE, NULL );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_TEST_FREEZE_MODE(periph, param) \
  periphBitTest(CAN_MCR_FRZACK, &periph.mcr) /* read bit FRZACK */

/*********************************************************************************************************
** Method:       FCAN_MODE                                                                              **
** Description:                                                                                         **
**               Set Supervisor Mode.                                                                   **
** Parameters:                                                                                          **
**               FCAN_USER - FlexCAN is in User Mode                                                    **
**               FCAN_SUPERVISOR - FlexCAN is in Supervisor Mode                                        **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_MODE, FCAN_USER );                                                **
**               ioctl( deviceID, FCAN_MODE, FCAN_USER );                                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_MODE(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_SUPV, &periph.mcr);   /* set bit SUPV */\
  else\
    periphBitClear(CAN_MCR_SUPV, &periph.mcr); /* clear bit SUPV */

/*********************************************************************************************************
** Method:       FCAN_SELF_WAKEUP_MODE                                                                  **
** Description:                                                                                         **
**               Self Wake Up Enable/Disable.                                                           **
** Parameters:                                                                                          **
**               FCAN_DISABLE - FlexCAN Self Wake Up feature is disabled                                **
**               FCAN_ENABLE - FlexCAN Self Wake Up feature is enabled                                  **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SELF_WAKEUP_MODE, FCAN_DISABLE );                                 **
**               ioctl( deviceID, FCAN_SELF_WAKEUP_MODE, FCAN_DISABLE );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SELF_WAKEUP_MODE(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_SLFWAK, &periph.mcr);   /* set bit SLFWAK */\
  else\
    periphBitClear(CAN_MCR_SLFWAK, &periph.mcr); /* clear bit SLFWAK */

/*********************************************************************************************************
** Method:       FCAN_TEST_LOW_POWER_MODE                                                               **
** Description:                                                                                         **
**               Get Low Power Mode Acknowledge.                                                        **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_TEST_LOW_POWER_MODE, NULL );                                  **
**               w = ioctl( deviceID, FCAN_TEST_LOW_POWER_MODE, NULL );                                 **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_TEST_LOW_POWER_MODE(periph, param) \
  periphBitTest(CAN_MCR_LPMACK, &periph.mcr) /* read bit LPMACK */

/*********************************************************************************************************
** Method:       FCAN_WAKE_UP_SOURCE                                                                    **
** Description:                                                                                         **
**               Set Wake Up Source.                                                                    **
** Parameters:                                                                                          **
**               FCAN_UNFILTRED_RX - FlexCAN uses the unfiltered Rx input                               **
**               FCAN_FILTRED_RX - FlexCAN uses the filtered Rx input                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WAKE_UP_SOURCE, FCAN_UNFILTRED_RX );                              **
**               ioctl( deviceID, FCAN_WAKE_UP_SOURCE, FCAN_UNFILTRED_RX );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WAKE_UP_SOURCE(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_WAKSRC, &periph.mcr);   /* set bit WAKSRC */\
  else\
    periphBitClear(CAN_MCR_WAKSRC, &periph.mcr); /* clear bit WAKSRC */

/*********************************************************************************************************
** Method:       FCAN_DOZE_MODE                                                                         **
** Description:                                                                                         **
**               Doze Mode Enable/Disable.                                                              **
** Parameters:                                                                                          **
**               FCAN_DISABLE - FlexCAN is not enabled to enter low power mode when Doze Mode is requested **
**               FCAN_ENABLE - FlexCAN is enabled to enter low power mode when Doze Mode is requested   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_DOZE_MODE, FCAN_DISABLE );                                        **
**               ioctl( deviceID, FCAN_DOZE_MODE, FCAN_DISABLE );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_DOZE_MODE(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_DOZE, &periph.mcr);   /* set bit DOZE */\
  else\
    periphBitClear(CAN_MCR_DOZE, &periph.mcr); /* clear bit DOZE */

/*********************************************************************************************************
** Method:       FCAN_SELF_RECEPTION                                                                    **
** Description:                                                                                         **
**               Self Reception Enable/Disable.                                                         **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Self reception disabled                                                 **
**               FCAN_ENABLE - Self reception enabled                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SELF_RECEPTION, FCAN_DISABLE );                                   **
**               ioctl( deviceID, FCAN_SELF_RECEPTION, FCAN_DISABLE );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SELF_RECEPTION(periph, param) \
  if (param)\
    periphBitClear(CAN_MCR_SRXDIS, &periph.mcr);   /* clear bit SRXDIS */\
  else\
    periphBitSet(CAN_MCR_SRXDIS, &periph.mcr); /* set bit SRXDIS */

/*********************************************************************************************************
** Method:       FCAN_INVIDUAL_MASKING                                                                  **
** Description:                                                                                         **
**               Individual Rx Masking and Queue Enable/Disable.                                        **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Individual Rx masking and queue feature are disabled                    **
**               FCAN_ENABLE - Individual Rx masking and queue feature are enabled                      **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_INVIDUAL_MASKING, FCAN_DISABLE );                                 **
**               ioctl( deviceID, FCAN_INVIDUAL_MASKING, FCAN_DISABLE );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_INVIDUAL_MASKING(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_IRMQ, &periph.mcr);   /* set bit IRMQ */\
  else\
    periphBitClear(CAN_MCR_IRMQ, &periph.mcr); /* clear bit IRMQ */

/*********************************************************************************************************
** Method:       FCAN_LOCAL_PRIORITY                                                                    **
** Description:                                                                                         **
**               Local Priority Enable/Disable.                                                         **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Local Priority disabled                                                 **
**               FCAN_ENABLE - Local Priority enabled                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_LOCAL_PRIORITY, FCAN_DISABLE );                                   **
**               ioctl( deviceID, FCAN_LOCAL_PRIORITY, FCAN_DISABLE );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_LOCAL_PRIORITY(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_LPRIOEN, &periph.mcr);   /* set bit LPRIOEN */\
  else\
    periphBitClear(CAN_MCR_LPRIOEN, &periph.mcr); /* clear bit LPRIOEN */

/*********************************************************************************************************
** Method:       FCAN_ABORT_MODE                                                                        **
** Description:                                                                                         **
**               Abort Enable/Disable.                                                                  **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Abort disabled                                                          **
**               FCAN_ENABLE - Abort enabled                                                            **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_ABORT_MODE, FCAN_DISABLE );                                       **
**               ioctl( deviceID, FCAN_ABORT_MODE, FCAN_DISABLE );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_ABORT_MODE(periph, param) \
  if (param)\
    periphBitSet(CAN_MCR_AEN, &periph.mcr);   /* set bit AEN */\
  else\
    periphBitClear(CAN_MCR_AEN, &periph.mcr); /* clear bit AEN */

/*********************************************************************************************************
** Method:       FCAN_ID_ACCEPTANCE_MODE                                                                **
** Description:                                                                                         **
**               Set ID Acceptance Mode.                                                                **
** Parameters:                                                                                          **
**               FCAN_FORMAT_A - One full ID (standard and extended) per ID Filter Table element        **
**               FCAN_FORMAT_B - Two full standard IDs or two partial 14-bit (standard and extended) IDs per ID Filter Table element **
**               FCAN_FORMAT_C - Four partial 8-bit Standard IDs per ID Filter Table element            **
**               FCAN_FORMAT_D - All frames rejected                                                    **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_ID_ACCEPTANCE_MODE, FCAN_FORMAT_A );                              **
**               ioctl( deviceID, FCAN_ID_ACCEPTANCE_MODE, FCAN_FORMAT_A );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_ID_ACCEPTANCE_MODE(periph, param) \
  periphBitGrpSet((CAN_MCR_IDAM), (UWord32)(param) << 8, &periph.mcr) /* set group IDAM */

/*********************************************************************************************************
** Method:       FCAN_SET_MAXMB                                                                         **
** Description:                                                                                         **
**               Set Number of the Last Message Buffer.                                                 **
** Parameters:                                                                                          **
**               Byte - Value 0-127                                                                     **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_MAXMB, 1 );                                                   **
**               ioctl( deviceID, FCAN_SET_MAXMB, 1 );                                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_MAXMB(periph, param) \
  periphBitGrpSet((CAN_MCR_MAXMB), param, &periph.mcr) /* set group MAXMB */

/*********************************************************************************************************
** Method:       FCAN_SET_PRESCALER                                                                     **
** Description:                                                                                         **
**               Prescaler Division FactorSet .                                                         **
** Parameters:                                                                                          **
**               Byte - Value 0-255                                                                     **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_PRESCALER, 1 );                                               **
**               ioctl( deviceID, FCAN_SET_PRESCALER, 1 );                                              **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_PRESCALER(periph, param) \
  periphBitGrpSet((CAN_CTRL1_PRESDIV), (UWord32)(param) << 24, &periph.ctrl1) /* set group PRESDIV */

/*********************************************************************************************************
** Method:       FCAN_SET_RJW                                                                           **
** Description:                                                                                         **
**               Set Resync Jump Width.                                                                 **
** Parameters:                                                                                          **
**               FCAN_RJW_1 - Resync Jump Width = 1                                                     **
**               FCAN_RJW_2 - Resync Jump Width = 2                                                     **
**               FCAN_RJW_3 - Resync Jump Width = 3                                                     **
**               FCAN_RJW_4 - Resync Jump Width = 4                                                     **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RJW, FCAN_RJW_1 );                                            **
**               ioctl( deviceID, FCAN_SET_RJW, FCAN_RJW_1 );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RJW(periph, param) \
  periphBitGrpSet((CAN_CTRL1_RJW), (UWord32)(param) << 22, &periph.ctrl1) /* set group RJW */

/*********************************************************************************************************
** Method:       FCAN_SET_PHASE_SEG1                                                                    **
** Description:                                                                                         **
**               Set Phase Segment 1.                                                                   **
** Parameters:                                                                                          **
**               FCAN_PSEG_1 - Phase Buffer Segment 1 = 1 x Time-Quanta                                 **
**               FCAN_PSEG_2 - Phase Buffer Segment 1 = 2 x Time-Quanta                                 **
**               FCAN_PSEG_3 - Phase Buffer Segment 1 = 3 x Time-Quanta                                 **
**               FCAN_PSEG_4 - Phase Buffer Segment 1 = 4 x Time-Quanta                                 **
**               FCAN_PSEG_5 - Phase Buffer Segment 1 = 5 x Time-Quanta                                 **
**               FCAN_PSEG_6 - Phase Buffer Segment 1 = 6 x Time-Quanta                                 **
**               FCAN_PSEG_7 - Phase Buffer Segment 1 = 7 x Time-Quanta                                 **
**               FCAN_PSEG_8 - Phase Buffer Segment 1 = 8 x Time-Quanta                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_PHASE_SEG1, FCAN_PSEG_1 );                                    **
**               ioctl( deviceID, FCAN_SET_PHASE_SEG1, FCAN_PSEG_1 );                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_PHASE_SEG1(periph, param) \
  periphBitGrpSet((CAN_CTRL1_PSEG1), (UWord32)(param) << 19, &periph.ctrl1) /* set group PSEG1 */

/*********************************************************************************************************
** Method:       FCAN_SET_PHASE_SEG2                                                                    **
** Description:                                                                                         **
**               Set Phase Segment 2.                                                                   **
** Parameters:                                                                                          **
**               FCAN_PSEG_1 - Phase Buffer Segment 2 = 1 x Time-Quanta                                 **
**               FCAN_PSEG_2 - Phase Buffer Segment 2 = 2 x Time-Quanta                                 **
**               FCAN_PSEG_3 - Phase Buffer Segment 2 = 3 x Time-Quanta                                 **
**               FCAN_PSEG_4 - Phase Buffer Segment 2 = 4 x Time-Quanta                                 **
**               FCAN_PSEG_5 - Phase Buffer Segment 2 = 5 x Time-Quanta                                 **
**               FCAN_PSEG_6 - Phase Buffer Segment 2 = 6 x Time-Quanta                                 **
**               FCAN_PSEG_7 - Phase Buffer Segment 2 = 7 x Time-Quanta                                 **
**               FCAN_PSEG_8 - Phase Buffer Segment 2 = 8 x Time-Quanta                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_PHASE_SEG2, FCAN_PSEG_1 );                                    **
**               ioctl( deviceID, FCAN_SET_PHASE_SEG2, FCAN_PSEG_1 );                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_PHASE_SEG2(periph, param) \
  periphBitGrpSet((CAN_CTRL1_PSEG2), (UWord32)(param) << 16, &periph.ctrl1) /* set group PSEG2 */

/*********************************************************************************************************
** Method:       FCAN_BUS_OFF_INT                                                                       **
** Description:                                                                                         **
**               Bus Off Mask Enable/Disable.                                                           **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Bus Off interrupt disabled                                              **
**               FCAN_ENABLE - Bus Off interrupt enabled                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_BUS_OFF_INT, FCAN_DISABLE );                                      **
**               ioctl( deviceID, FCAN_BUS_OFF_INT, FCAN_DISABLE );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_BUS_OFF_INT(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL1_BOFFMSK, &periph.ctrl1);   /* set bit BOFFMSK */\
  else\
    periphBitClear(CAN_CTRL1_BOFFMSK, &periph.ctrl1); /* clear bit BOFFMSK */

/*********************************************************************************************************
** Method:       FCAN_ERROR_INT                                                                         **
** Description:                                                                                         **
**               Error Mask Enable/Disable.                                                             **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Error interrupt disabled                                                **
**               FCAN_ENABLE - Error interrupt enabled                                                  **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_ERROR_INT, FCAN_DISABLE );                                        **
**               ioctl( deviceID, FCAN_ERROR_INT, FCAN_DISABLE );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_ERROR_INT(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL1_ERRMSK, &periph.ctrl1);   /* set bit ERRMSK */\
  else\
    periphBitClear(CAN_CTRL1_ERRMSK, &periph.ctrl1); /* clear bit ERRMSK */

/*********************************************************************************************************
** Method:       FCAN_SET_CLOCK_SOURCE                                                                  **
** Description:                                                                                         **
**               Set CAN Engine Clock Source.                                                           **
** Parameters:                                                                                          **
**               FCAN_OSCILLATOR_CLK - Oscillator clock                                                 **
**               FCAN_BUS_CLK - Bus clock                                                               **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_CLOCK_SOURCE, FCAN_OSCILLATOR_CLK );                          **
**               ioctl( deviceID, FCAN_SET_CLOCK_SOURCE, FCAN_OSCILLATOR_CLK );                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_CLOCK_SOURCE(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL1_CLKSRC, &periph.ctrl1);   /* set bit CLKSRC */\
  else\
    periphBitClear(CAN_CTRL1_CLKSRC, &periph.ctrl1); /* clear bit CLKSRC */

/*********************************************************************************************************
** Method:       FCAN_LOOPBACK_MODE                                                                     **
** Description:                                                                                         **
**               Loop Back Mode Enable/Disable.                                                         **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Loop Back disabled                                                      **
**               FCAN_ENABLE - Loop Back enabled                                                        **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_LOOPBACK_MODE, FCAN_DISABLE );                                    **
**               ioctl( deviceID, FCAN_LOOPBACK_MODE, FCAN_DISABLE );                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_LOOPBACK_MODE(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL1_LPB, &periph.ctrl1);   /* set bit LPB */\
  else\
    periphBitClear(CAN_CTRL1_LPB, &periph.ctrl1); /* clear bit LPB */

/*********************************************************************************************************
** Method:       FCAN_TX_WARNING_INT                                                                    **
** Description:                                                                                         **
**               Tx Warning Interrupt Mask Enable/Disable.                                              **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Tx Warning Interrupt disabled                                           **
**               FCAN_ENABLE - Tx Warning Interrupt enabled                                             **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_TX_WARNING_INT, FCAN_DISABLE );                                   **
**               ioctl( deviceID, FCAN_TX_WARNING_INT, FCAN_DISABLE );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_TX_WARNING_INT(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL1_TWRNMSK, &periph.ctrl1);   /* set bit TWRNMSK */\
  else\
    periphBitClear(CAN_CTRL1_TWRNMSK, &periph.ctrl1); /* clear bit TWRNMSK */

/*********************************************************************************************************
** Method:       FCAN_RX_WARNING_INT                                                                    **
** Description:                                                                                         **
**               Rx Warning Interrupt Mask Enable/Disable.                                              **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Rx Warning Interrupt disabled                                           **
**               FCAN_ENABLE - Rx Warning Interrupt enabled                                             **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_RX_WARNING_INT, FCAN_DISABLE );                                   **
**               ioctl( deviceID, FCAN_RX_WARNING_INT, FCAN_DISABLE );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_RX_WARNING_INT(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL1_RWRNMSK, &periph.ctrl1);   /* set bit RWRNMSK */\
  else\
    periphBitClear(CAN_CTRL1_RWRNMSK, &periph.ctrl1); /* clear bit RWRNMSK */

/*********************************************************************************************************
** Method:       FCAN_SET_BIT_SAMPLING                                                                  **
** Description:                                                                                         **
**               Rx Warning Interrupt Mask Enable/Disable.                                              **
** Parameters:                                                                                          **
**               FCAN_1SAMP_PER_BIT - One sample used to determine the bit value                        **
**               FCAN_3SAMPS_PER_BIT - Regular one (sample point) and 2 preceding samples used to determine the value of the received bit **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_BIT_SAMPLING, FCAN_1SAMP_PER_BIT );                           **
**               ioctl( deviceID, FCAN_SET_BIT_SAMPLING, FCAN_1SAMP_PER_BIT );                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_BIT_SAMPLING(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL1_SMP, &periph.ctrl1);   /* set bit SMP */\
  else\
    periphBitClear(CAN_CTRL1_SMP, &periph.ctrl1); /* clear bit SMP */

/*********************************************************************************************************
** Method:       FCAN_BUS_OFF_RECOVERY                                                                  **
** Description:                                                                                         **
**               Bus Off Recovery Enable/Disable.                                                       **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Automatic recovering from Bus Off state disabled                        **
**               FCAN_ENABLE - Automatic recovering from Bus Off state enabled                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_BUS_OFF_RECOVERY, FCAN_DISABLE );                                 **
**               ioctl( deviceID, FCAN_BUS_OFF_RECOVERY, FCAN_DISABLE );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_BUS_OFF_RECOVERY(periph, param) \
  if (param)\
    periphBitClear(CAN_CTRL1_BOFFREC, &periph.ctrl1);   /* clear bit BOFFREC */\
  else\
    periphBitSet(CAN_CTRL1_BOFFREC, &periph.ctrl1); /* set bit BOFFREC */

/*********************************************************************************************************
** Method:       FCAN_TIMER_SYNC_MODE                                                                   **
** Description:                                                                                         **
**               Timer Sync Enable/Disable.                                                             **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Timer Sync feature disabled                                             **
**               FCAN_ENABLE - Timer Sync feature enabled                                               **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_TIMER_SYNC_MODE, FCAN_DISABLE );                                  **
**               ioctl( deviceID, FCAN_TIMER_SYNC_MODE, FCAN_DISABLE );                                 **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_TIMER_SYNC_MODE(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL1_TSYN, &periph.ctrl1);   /* set bit TSYN */\
  else\
    periphBitClear(CAN_CTRL1_TSYN, &periph.ctrl1); /* clear bit TSYN */

/*********************************************************************************************************
** Method:       FCAN_SET_TX_FIRST_SCHEME                                                               **
** Description:                                                                                         **
**               Set Timer Sync Scheme.                                                                 **
** Parameters:                                                                                          **
**               FCAN_LOWEST_ID - Buffer with highest priority is transmitted first                     **
**               FCAN_LOWEST_MB_NUMBER - Lowest number buffer is transmitted first                      **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_TX_FIRST_SCHEME, FCAN_LOWEST_ID );                            **
**               ioctl( deviceID, FCAN_SET_TX_FIRST_SCHEME, FCAN_LOWEST_ID );                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_TX_FIRST_SCHEME(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL1_LBUF, &periph.ctrl1);   /* set bit LBUF */\
  else\
    periphBitClear(CAN_CTRL1_LBUF, &periph.ctrl1); /* clear bit LBUF */

/*********************************************************************************************************
** Method:       FCAN_LISTEN_ONLY_MODE                                                                  **
** Description:                                                                                         **
**               Listen-Only Mode Enable/Disable.                                                       **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Listen-Only Mode is deactivated                                         **
**               FCAN_ENABLE - FlexCAN module operates in Listen-Only Mode                              **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_LISTEN_ONLY_MODE, FCAN_DISABLE );                                 **
**               ioctl( deviceID, FCAN_LISTEN_ONLY_MODE, FCAN_DISABLE );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_LISTEN_ONLY_MODE(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL1_LOM, &periph.ctrl1);   /* set bit LOM */\
  else\
    periphBitClear(CAN_CTRL1_LOM, &periph.ctrl1); /* clear bit LOM */

/*********************************************************************************************************
** Method:       FCAN_SET_PROP_SEG                                                                      **
** Description:                                                                                         **
**               Set Propagation Segment.                                                               **
** Parameters:                                                                                          **
**               FCAN_PROPSEG_1 - Propagation Segment Time = 1 x Time-Quanta                            **
**               FCAN_PROPSEG_2 - Propagation Segment Time = 2 x Time-Quanta                            **
**               FCAN_PROPSEG_3 - Propagation Segment Time = 3 x Time-Quanta                            **
**               FCAN_PROPSEG_4 - Propagation Segment Time = 4 x Time-Quanta                            **
**               FCAN_PROPSEG_5 - Propagation Segment Time = 5 x Time-Quanta                            **
**               FCAN_PROPSEG_6 - Propagation Segment Time = 6 x Time-Quanta                            **
**               FCAN_PROPSEG_7 - Propagation Segment Time = 7 x Time-Quanta                            **
**               FCAN_PROPSEG_8 - Propagation Segment Time = 8 x Time-Quanta                            **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_PROP_SEG, FCAN_PROPSEG_1 );                                   **
**               ioctl( deviceID, FCAN_SET_PROP_SEG, FCAN_PROPSEG_1 );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_PROP_SEG(periph, param) \
  periphBitGrpSet((CAN_CTRL1_PROPSEG), param, &periph.ctrl1) /* set group PROPSEG */

/*********************************************************************************************************
** Method:       FCAN_SET_TIMER                                                                         **
** Description:                                                                                         **
**               Set Timer value.                                                                       **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_TIMER, 1 );                                                   **
**               ioctl( deviceID, FCAN_SET_TIMER, 1 );                                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_TIMER(periph, param) \
  periphMemWrite(param, &periph.timer) /* set group TIMER */

/*********************************************************************************************************
** Method:       FCAN_GET_TIMER                                                                         **
** Description:                                                                                         **
**               Get Timer value.                                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**                w = PESL( deviceID, FCAN_GET_TIMER, NULL );                                           **
**                w =  ioctl( deviceID, FCAN_GET_TIMER, NULL );                                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_TIMER(periph, param) \
  ((periphMemRead(&periph.timer) & (CAN_TIMER_TIMER)) >> 0) /* read group TIMER */

/*********************************************************************************************************
** Method:       FCAN_SET_RXMGMASK                                                                      **
** Description:                                                                                         **
**               Set Rx Mailboxes Global Mask Register.                                                 **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXMGMASK, 1 );                                                **
**               ioctl( deviceID, FCAN_SET_RXMGMASK, 1 );                                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXMGMASK(periph, param) \
  periphMemWrite(param, &periph.rxmgmask)

/*********************************************************************************************************
** Method:       FCAN_SET_RX14MGMASK                                                                    **
** Description:                                                                                         **
**               Set Rx 14 Mask Register.                                                               **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RX14MGMASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RX14MGMASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RX14MGMASK(periph, param) \
  periphMemWrite(param, &periph.rx14mask)

/*********************************************************************************************************
** Method:       FCAN_SET_RX15MGMASK                                                                    **
** Description:                                                                                         **
**               Set Rx 15 Mask Register.                                                               **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RX15MGMASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RX15MGMASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RX15MGMASK(periph, param) \
  periphMemWrite(param, &periph.rx15mask)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_MAILBOXES_REG                                                            **
** Description:                                                                                         **
**               Write Rx Mailboxes Global Mask Register.                                               **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_MAILBOXES_REG, 1 );                                      **
**               ioctl( deviceID, FCAN_WRITE_RX_MAILBOXES_REG, 1 );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_MAILBOXES_REG(periph, param) \
  periphMemWrite(param, &periph.rxmgmask)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_14_MASK_REG                                                              **
** Description:                                                                                         **
**               Write Rx 14 Mask Register.                                                             **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_14_MASK_REG, 1 );                                        **
**               ioctl( deviceID, FCAN_WRITE_RX_14_MASK_REG, 1 );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_14_MASK_REG(periph, param) \
  periphMemWrite(param, &periph.rx14mask)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_15_MASK_REG                                                              **
** Description:                                                                                         **
**               Write Rx 15 Mask Register.                                                             **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_15_MASK_REG, 1 );                                        **
**               ioctl( deviceID, FCAN_WRITE_RX_15_MASK_REG, 1 );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_15_MASK_REG(periph, param) \
  periphMemWrite(param, &periph.rx15mask)

/*********************************************************************************************************
** Method:       FCAN_GET_RX_ERR_COUNT                                                                  **
** Description:                                                                                         **
**               Get Receive Error Counter.                                                             **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**                w = PESL( deviceID, FCAN_GET_RX_ERR_COUNT, NULL );                                    **
**                w =  ioctl( deviceID, FCAN_GET_RX_ERR_COUNT, NULL );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_RX_ERR_COUNT(periph, param) \
  (periphBitTest((CAN_ECR_RXERRCNT), &periph.ecr)  >> 8) /* read group RXERRCNT */

/*********************************************************************************************************
** Method:       FCAN_GET_TX_ERR_COUNT                                                                  **
** Description:                                                                                         **
**               Get Transmit Error Counter.                                                            **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**                w = PESL( deviceID, FCAN_GET_TX_ERR_COUNT, NULL );                                    **
**                w =  ioctl( deviceID, FCAN_GET_TX_ERR_COUNT, NULL );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_TX_ERR_COUNT(periph, param) \
  (periphBitTest((CAN_ECR_TXERRCNT), &periph.ecr) ) /* read group TXERRCNT */

/*********************************************************************************************************
** Method:       FCAN_READ_ERROR_STATUS_REG1                                                            **
** Description:                                                                                         **
**               Get Error and Status 1 Register.                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw32;                                                                         **
**                . . .                                                                                 **
**               uw32 = PESL( deviceID, FCAN_READ_ERROR_STATUS_REG1, NULL );                            **
**               uw32 = ioctl( deviceID, FCAN_READ_ERROR_STATUS_REG1, NULL );                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_ERROR_STATUS_REG1(periph, param)  \
  periphMemRead(&periph.esr1)

/*********************************************************************************************************
** Method:       FCAN_GET_SYNCHRONIZATION_STATUS                                                        **
** Description:                                                                                         **
**               Get CAN Synchronization Status.                                                        **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_SYNCHRONIZATION_STATUS, NULL );                           **
**               w = ioctl( deviceID, FCAN_GET_SYNCHRONIZATION_STATUS, NULL );                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_SYNCHRONIZATION_STATUS(periph, param) \
  periphBitTest(CAN_ESR1_SYNCH, &periph.esr1) /* read bit SYNCH */

/*********************************************************************************************************
** Method:       FCAN_GET_RX_WARNING_FLAG                                                               **
** Description:                                                                                         **
**               Get Rx Warning Interrupt Flag.                                                         **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_RX_WARNING_FLAG, NULL );                                  **
**               w = ioctl( deviceID, FCAN_GET_RX_WARNING_FLAG, NULL );                                 **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_RX_WARNING_FLAG(periph, param) \
  periphBitTest(CAN_ESR1_RWRNINT, &periph.esr1) /* read bit RWRNINT */

/*********************************************************************************************************
** Method:       FCAN_CLEAR_RX_WARNING_FLAG                                                             **
** Description:                                                                                         **
**               Clear Rx Warning Interrupt Flag.                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_CLEAR_RX_WARNING_FLAG, NULL );                                    **
**               ioctl( deviceID, FCAN_CLEAR_RX_WARNING_FLAG, NULL );                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
 #define ioctlFCAN_CLEAR_RX_WARNING_FLAG(periph, param) \
  periphSafeAckByOne((CAN_ESR1_RWRNINT | CAN_ESR1_TWRNINT | CAN_ESR1_BOFFINT | CAN_ESR1_ERRINT | CAN_ESR1_WAKINT), CAN_ESR1_RWRNINT_MASK, &periph.esr1)


/*********************************************************************************************************
** Method:       FCAN_GET_TX_WARNING_FLAG                                                               **
** Description:                                                                                         **
**               Get Tx Warning Interrupt Flag.                                                         **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_TX_WARNING_FLAG, NULL );                                  **
**               w = ioctl( deviceID, FCAN_GET_TX_WARNING_FLAG, NULL );                                 **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_TX_WARNING_FLAG(periph, param) \
  periphBitTest(CAN_ESR1_TWRNINT, &periph.esr1) /* read bit TWRNINT */

/*********************************************************************************************************
** Method:       FCAN_CLEAR_TX_WARNING_FLAG                                                             **
** Description:                                                                                         **
**               Clear Tx Warning Interrupt Flag.                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_CLEAR_TX_WARNING_FLAG, NULL );                                    **
**               ioctl( deviceID, FCAN_CLEAR_TX_WARNING_FLAG, NULL );                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
 #define ioctlFCAN_CLEAR_TX_WARNING_FLAG(periph, param) \
  periphSafeAckByOne((CAN_ESR1_RWRNINT | CAN_ESR1_TWRNINT | CAN_ESR1_BOFFINT | CAN_ESR1_ERRINT | CAN_ESR1_WAKINT), CAN_ESR1_TWRNINT_MASK, &periph.esr1)


/*********************************************************************************************************
** Method:       FCAN_GET_BIT1_ERROR                                                                    **
** Description:                                                                                         **
**               Get Bit1 Error.                                                                        **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_BIT1_ERROR, NULL );                                       **
**               w = ioctl( deviceID, FCAN_GET_BIT1_ERROR, NULL );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_BIT1_ERROR(periph, param) \
  periphBitTest(CAN_ESR1_BIT1ERR, &periph.esr1) /* read bit BIT1ERR */

/*********************************************************************************************************
** Method:       FCAN_GET_BIT0_ERROR                                                                    **
** Description:                                                                                         **
**               Get Bit0 Error.                                                                        **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_BIT0_ERROR, NULL );                                       **
**               w = ioctl( deviceID, FCAN_GET_BIT0_ERROR, NULL );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_BIT0_ERROR(periph, param) \
  periphBitTest(CAN_ESR1_BIT0ERR, &periph.esr1) /* read bit BIT0ERR */

/*********************************************************************************************************
** Method:       FCAN_GET_ACKNOWLEDGE_ERROR                                                             **
** Description:                                                                                         **
**               Get Acknowledge Error.                                                                 **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_ACKNOWLEDGE_ERROR, NULL );                                **
**               w = ioctl( deviceID, FCAN_GET_ACKNOWLEDGE_ERROR, NULL );                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_ACKNOWLEDGE_ERROR(periph, param) \
  periphBitTest(CAN_ESR1_ACKERR, &periph.esr1) /* read bit ACKERR */

/*********************************************************************************************************
** Method:       FCAN_GET_CRC_ERROR                                                                     **
** Description:                                                                                         **
**               Get Cyclic Redundancy Check Error.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_CRC_ERROR, NULL );                                        **
**               w = ioctl( deviceID, FCAN_GET_CRC_ERROR, NULL );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_CRC_ERROR(periph, param) \
  periphBitTest(CAN_ESR1_CRCERR, &periph.esr1) /* read bit CRCERR */

/*********************************************************************************************************
** Method:       FCAN_GET_FORM_ERROR                                                                    **
** Description:                                                                                         **
**               Get Form Error.                                                                        **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_FORM_ERROR, NULL );                                       **
**               w = ioctl( deviceID, FCAN_GET_FORM_ERROR, NULL );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_FORM_ERROR(periph, param) \
  periphBitTest(CAN_ESR1_FRMERR, &periph.esr1) /* read bit FRMERR */

/*********************************************************************************************************
** Method:       FCAN_GET_STUFFING_ERROR                                                                **
** Description:                                                                                         **
**               Get Stuffing Error.                                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_STUFFING_ERROR, NULL );                                   **
**               w = ioctl( deviceID, FCAN_GET_STUFFING_ERROR, NULL );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_STUFFING_ERROR(periph, param) \
  periphBitTest(CAN_ESR1_STFERR, &periph.esr1) /* read bit STFERR */

/*********************************************************************************************************
** Method:       FCAN_GET_TX_WARNING_ERROR                                                              **
** Description:                                                                                         **
**               Get TX Error Warning.                                                                  **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_TX_WARNING_ERROR, NULL );                                 **
**               w = ioctl( deviceID, FCAN_GET_TX_WARNING_ERROR, NULL );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_TX_WARNING_ERROR(periph, param) \
  periphBitTest(CAN_ESR1_TXWRN, &periph.esr1) /* read bit TXWRN */

/*********************************************************************************************************
** Method:       FCAN_GET_RX_WARNING_ERROR                                                              **
** Description:                                                                                         **
**               Get RX Error Warning.                                                                  **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_RX_WARNING_ERROR, NULL );                                 **
**               w = ioctl( deviceID, FCAN_GET_RX_WARNING_ERROR, NULL );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_RX_WARNING_ERROR(periph, param) \
  periphBitTest(CAN_ESR1_RXWRN, &periph.esr1) /* read bit RXWRN */

/*********************************************************************************************************
** Method:       FCAN_GET_IDLE_BUS                                                                      **
** Description:                                                                                         **
**               Get CAN bus in IDLE state..                                                            **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_IDLE_BUS, NULL );                                         **
**               w = ioctl( deviceID, FCAN_GET_IDLE_BUS, NULL );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_IDLE_BUS(periph, param) \
  periphBitTest(CAN_ESR1_IDLE, &periph.esr1) /* read bit IDLE */

/*********************************************************************************************************
** Method:       FCAN_GET_TRANSMISSION                                                                  **
** Description:                                                                                         **
**               Get FlexCAN in Transmission.                                                           **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_TRANSMISSION, NULL );                                     **
**               w = ioctl( deviceID, FCAN_GET_TRANSMISSION, NULL );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_TRANSMISSION(periph, param) \
  periphBitTest(CAN_ESR1_TX, &periph.esr1) /* read bit TX */

/*********************************************************************************************************
** Method:       FCAN_GET_FAULT_CONFINEMENT                                                             **
** Description:                                                                                         **
**               Get Fault Confinement State.                                                           **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**                w = PESL( deviceID, FCAN_GET_FAULT_CONFINEMENT, NULL );                               **
**                w =  ioctl( deviceID, FCAN_GET_FAULT_CONFINEMENT, NULL );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_FAULT_CONFINEMENT(periph, param) \
  (periphBitTest((CAN_ESR1_FLTCONF), &periph.esr1)  >> 4) /* read group FLTCONF */

/*********************************************************************************************************
** Method:       FCAN_GET_RECEPTION                                                                     **
** Description:                                                                                         **
**               Get FlexCAN in Reception.                                                              **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_RECEPTION, NULL );                                        **
**               w = ioctl( deviceID, FCAN_GET_RECEPTION, NULL );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_RECEPTION(periph, param) \
  periphBitTest(CAN_ESR1_RX, &periph.esr1) /* read bit RX */

/*********************************************************************************************************
** Method:       FCAN_GET_BUS_OFF_FLAG                                                                  **
** Description:                                                                                         **
**               Get Bus Off Interrupt.                                                                 **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_BUS_OFF_FLAG, NULL );                                     **
**               w = ioctl( deviceID, FCAN_GET_BUS_OFF_FLAG, NULL );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_BUS_OFF_FLAG(periph, param) \
  periphBitTest(CAN_ESR1_BOFFINT, &periph.esr1) /* read bit BOFFINT */

/*********************************************************************************************************
** Method:       FCAN_CLEAR_BUS_OFF_FLAG                                                                **
** Description:                                                                                         **
**               Clear Bus Off Interrupt Flag.                                                          **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_CLEAR_BUS_OFF_FLAG, NULL );                                       **
**               ioctl( deviceID, FCAN_CLEAR_BUS_OFF_FLAG, NULL );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
 #define ioctlFCAN_CLEAR_BUS_OFF_FLAG(periph, param) \
  periphSafeAckByOne((CAN_ESR1_RWRNINT | CAN_ESR1_TWRNINT | CAN_ESR1_BOFFINT | CAN_ESR1_ERRINT | CAN_ESR1_WAKINT), CAN_ESR1_BOFFINT_MASK, &periph.esr1)


/*********************************************************************************************************
** Method:       FCAN_GET_ERROR_FLAG                                                                    **
** Description:                                                                                         **
**               Get Error Interrupt.                                                                   **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_ERROR_FLAG, NULL );                                       **
**               w = ioctl( deviceID, FCAN_GET_ERROR_FLAG, NULL );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_ERROR_FLAG(periph, param) \
  periphBitTest(CAN_ESR1_ERRINT, &periph.esr1) /* read bit ERRINT */

/*********************************************************************************************************
** Method:       FCAN_CLEAR_ERROR_FLAG                                                                  **
** Description:                                                                                         **
**               Clear Error Interrupt Flag.                                                            **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_CLEAR_ERROR_FLAG, NULL );                                         **
**               ioctl( deviceID, FCAN_CLEAR_ERROR_FLAG, NULL );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
 #define ioctlFCAN_CLEAR_ERROR_FLAG(periph, param) \
  periphSafeAckByOne((CAN_ESR1_RWRNINT | CAN_ESR1_TWRNINT | CAN_ESR1_BOFFINT | CAN_ESR1_ERRINT | CAN_ESR1_WAKINT), CAN_ESR1_ERRINT_MASK, &periph.esr1)


/*********************************************************************************************************
** Method:       FCAN_GET_WAKE_UP_FLAG                                                                  **
** Description:                                                                                         **
**               Get Wake-Up Interrupt.                                                                 **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_WAKE_UP_FLAG, NULL );                                     **
**               w = ioctl( deviceID, FCAN_GET_WAKE_UP_FLAG, NULL );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_WAKE_UP_FLAG(periph, param) \
  periphBitTest(CAN_ESR1_WAKINT, &periph.esr1) /* read bit WAKINT */

/*********************************************************************************************************
** Method:       FCAN_CLEAR_WAKE_UP_FLAG                                                                **
** Description:                                                                                         **
**               Clear Wake-Up Interrupt Flag.                                                          **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_CLEAR_WAKE_UP_FLAG, NULL );                                       **
**               ioctl( deviceID, FCAN_CLEAR_WAKE_UP_FLAG, NULL );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
 #define ioctlFCAN_CLEAR_WAKE_UP_FLAG(periph, param) \
  periphSafeAckByOne((CAN_ESR1_RWRNINT | CAN_ESR1_TWRNINT | CAN_ESR1_BOFFINT | CAN_ESR1_ERRINT | CAN_ESR1_WAKINT), CAN_ESR1_WAKINT_MASK, &periph.esr1)


/*********************************************************************************************************
** Method:       FCAN_MBINT_0_31_ENABLE                                                                 **
** Description:                                                                                         **
**               Enable Buffer MBi Mask.                                                                **
** Parameters:                                                                                          **
**               FCAN_MBINT_0 - Message Buffer 0                                                        **
**               FCAN_MBINT_1 - Message Buffer 1                                                        **
**               FCAN_MBINT_2 - Message Buffer 2                                                        **
**               FCAN_MBINT_3 - Message Buffer 3                                                        **
**               FCAN_MBINT_4 - Message Buffer 4                                                        **
**               FCAN_MBINT_5 - Message Buffer 5                                                        **
**               FCAN_MBINT_6 - Message Buffer 6                                                        **
**               FCAN_MBINT_7 - Message Buffer 7                                                        **
**               FCAN_MBINT_8 - Message Buffer 8                                                        **
**               FCAN_MBINT_9 - Message Buffer 9                                                        **
**               FCAN_MBINT_10 - Message Buffer 10                                                      **
**               FCAN_MBINT_11 - Message Buffer 11                                                      **
**               FCAN_MBINT_12 - Message Buffer 12                                                      **
**               FCAN_MBINT_13 - Message Buffer 13                                                      **
**               FCAN_MBINT_14 - Message Buffer 14                                                      **
**               FCAN_MBINT_15 - Message Buffer 15                                                      **
**               FCAN_MBINT_16 - Message Buffer 16                                                      **
**               FCAN_MBINT_17 - Message Buffer 17                                                      **
**               FCAN_MBINT_18 - Message Buffer 18                                                      **
**               FCAN_MBINT_19 - Message Buffer 19                                                      **
**               FCAN_MBINT_20 - Message Buffer 20                                                      **
**               FCAN_MBINT_21 - Message Buffer 21                                                      **
**               FCAN_MBINT_22 - Message Buffer 22                                                      **
**               FCAN_MBINT_23 - Message Buffer 23                                                      **
**               FCAN_MBINT_24 - Message Buffer 24                                                      **
**               FCAN_MBINT_25 - Message Buffer 25                                                      **
**               FCAN_MBINT_26 - Message Buffer 26                                                      **
**               FCAN_MBINT_27 - Message Buffer 27                                                      **
**               FCAN_MBINT_28 - Message Buffer 28                                                      **
**               FCAN_MBINT_29 - Message Buffer 29                                                      **
**               FCAN_MBINT_30 - Message Buffer 30                                                      **
**               FCAN_MBINT_31 - Message Buffer 31                                                      **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_MBINT_0_31_ENABLE, FCAN_MBINT_0 );                                **
**               ioctl( deviceID, FCAN_MBINT_0_31_ENABLE, FCAN_MBINT_0 );                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_MBINT_0_31_ENABLE(periph, param) \
  periphBitSet(param, &periph.imask1) /* set group bits BUFLM */

/*********************************************************************************************************
** Method:       FCAN_MBINT_0_31_DISABLE                                                                **
** Description:                                                                                         **
**               Disable Buffer MBi Mask.                                                               **
** Parameters:                                                                                          **
**               FCAN_MBINT_0 - Message Buffer 0                                                        **
**               FCAN_MBINT_1 - Message Buffer 1                                                        **
**               FCAN_MBINT_2 - Message Buffer 2                                                        **
**               FCAN_MBINT_3 - Message Buffer 3                                                        **
**               FCAN_MBINT_4 - Message Buffer 4                                                        **
**               FCAN_MBINT_5 - Message Buffer 5                                                        **
**               FCAN_MBINT_6 - Message Buffer 6                                                        **
**               FCAN_MBINT_7 - Message Buffer 7                                                        **
**               FCAN_MBINT_8 - Message Buffer 8                                                        **
**               FCAN_MBINT_9 - Message Buffer 9                                                        **
**               FCAN_MBINT_10 - Message Buffer 10                                                      **
**               FCAN_MBINT_11 - Message Buffer 11                                                      **
**               FCAN_MBINT_12 - Message Buffer 12                                                      **
**               FCAN_MBINT_13 - Message Buffer 13                                                      **
**               FCAN_MBINT_14 - Message Buffer 14                                                      **
**               FCAN_MBINT_15 - Message Buffer 15                                                      **
**               FCAN_MBINT_16 - Message Buffer 16                                                      **
**               FCAN_MBINT_17 - Message Buffer 17                                                      **
**               FCAN_MBINT_18 - Message Buffer 18                                                      **
**               FCAN_MBINT_19 - Message Buffer 19                                                      **
**               FCAN_MBINT_20 - Message Buffer 20                                                      **
**               FCAN_MBINT_21 - Message Buffer 21                                                      **
**               FCAN_MBINT_22 - Message Buffer 22                                                      **
**               FCAN_MBINT_23 - Message Buffer 23                                                      **
**               FCAN_MBINT_24 - Message Buffer 24                                                      **
**               FCAN_MBINT_25 - Message Buffer 25                                                      **
**               FCAN_MBINT_26 - Message Buffer 26                                                      **
**               FCAN_MBINT_27 - Message Buffer 27                                                      **
**               FCAN_MBINT_28 - Message Buffer 28                                                      **
**               FCAN_MBINT_29 - Message Buffer 29                                                      **
**               FCAN_MBINT_30 - Message Buffer 30                                                      **
**               FCAN_MBINT_31 - Message Buffer 31                                                      **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_MBINT_0_31_DISABLE, FCAN_MBINT_0 );                               **
**               ioctl( deviceID, FCAN_MBINT_0_31_DISABLE, FCAN_MBINT_0 );                              **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_MBINT_0_31_DISABLE(periph, param) \
  periphBitClear(param, &periph.imask1) /* clear group of bits BUFLM */

/*********************************************************************************************************
** Method:       FCAN_GET_MBINT_0_15_FLAGS                                                              **
** Description:                                                                                         **
**               Get Interrupt Flags 0-15.                                                              **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word - constants from FCAN_CLEAR_MBINT_0_15_FLAGS can be used                          **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCAN_GET_MBINT_0_15_FLAGS, NULL );                                 **
**               w = ioctl( deviceID, FCAN_GET_MBINT_0_15_FLAGS, NULL );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_GET_MBINT_0_15_FLAGS(periph, param)  \
  periphMemRead(&periph.iflag1)

/*********************************************************************************************************
** Method:       FCAN_CLEAR_MBINT_0_15_FLAGS                                                            **
** Description:                                                                                         **
**               Clear Interrupt Flags 0-15.                                                            **
** Parameters:                                                                                          **
**               FCAN_MBINT_0 - Message Buffer 0                                                        **
**               FCAN_MBINT_1 - Message Buffer 1                                                        **
**               FCAN_MBINT_2 - Message Buffer 2                                                        **
**               FCAN_MBINT_3 - Message Buffer 3                                                        **
**               FCAN_MBINT_4 - Message Buffer 4                                                        **
**               FCAN_MBINT_5 - Message Buffer 5                                                        **
**               FCAN_MBINT_6 - Message Buffer 6                                                        **
**               FCAN_MBINT_7 - Message Buffer 7                                                        **
**               FCAN_MBINT_8 - Message Buffer 8                                                        **
**               FCAN_MBINT_9 - Message Buffer 9                                                        **
**               FCAN_MBINT_10 - Message Buffer 10                                                      **
**               FCAN_MBINT_11 - Message Buffer 11                                                      **
**               FCAN_MBINT_12 - Message Buffer 12                                                      **
**               FCAN_MBINT_13 - Message Buffer 13                                                      **
**               FCAN_MBINT_14 - Message Buffer 14                                                      **
**               FCAN_MBINT_15 - Message Buffer 15                                                      **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_CLEAR_MBINT_0_15_FLAGS, FCAN_MBINT_0 );                           **
**               ioctl( deviceID, FCAN_CLEAR_MBINT_0_15_FLAGS, FCAN_MBINT_0 );                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_CLEAR_MBINT_0_15_FLAGS(periph, param) \
  periphBitSet(param, &periph.iflag1)

/*********************************************************************************************************
** Method:       FCAN_WRITE_ACCESS_TO_MEMORY                                                            **
** Description:                                                                                         **
**               Enable/Disable Write-Access to Memory in Freeze mode.                                  **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Maintain the write access restrictions                                  **
**               FCAN_ENABLE - Enable unrestricted write access to FlexCAN memory                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_ACCESS_TO_MEMORY, FCAN_DISABLE );                           **
**               ioctl( deviceID, FCAN_WRITE_ACCESS_TO_MEMORY, FCAN_DISABLE );                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_ACCESS_TO_MEMORY(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL2_WRMFRZ, &periph.ctrl2);   /* set bit WRMFRZ */\
  else\
    periphBitClear(CAN_CTRL2_WRMFRZ, &periph.ctrl2); /* clear bit WRMFRZ */

/*********************************************************************************************************
** Method:       FCAN_SET_RX_FIFO_FILTER_NUMBER                                                         **
** Description:                                                                                         **
**               Set Number of Rx FIFO Filters.                                                         **
** Parameters:                                                                                          **
**               Byte - Value 0 - 15                                                                    **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RX_FIFO_FILTER_NUMBER, 1 );                                   **
**               ioctl( deviceID, FCAN_SET_RX_FIFO_FILTER_NUMBER, 1 );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RX_FIFO_FILTER_NUMBER(periph, param) \
  periphBitGrpSet((CAN_CTRL2_RFFN), (UWord32)(param) << 24, &periph.ctrl2) /* set group RFFN */

/*********************************************************************************************************
** Method:       FCAN_SET_TX_ARBITRATION_START_DELAY                                                    **
** Description:                                                                                         **
**               Set Tx Arbitration Start Delay.                                                        **
** Parameters:                                                                                          **
**               Byte - Value 0 - 31                                                                    **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_TX_ARBITRATION_START_DELAY, 1 );                              **
**               ioctl( deviceID, FCAN_SET_TX_ARBITRATION_START_DELAY, 1 );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_TX_ARBITRATION_START_DELAY(periph, param) \
  periphBitGrpSet((CAN_CTRL2_TASD), (UWord32)(param) << 19, &periph.ctrl2) /* set group TASD */

/*********************************************************************************************************
** Method:       FCAN_SET_RECEPTION_PRIORITY                                                            **
** Description:                                                                                         **
**               Set Mailboxes Reception Priority.                                                      **
** Parameters:                                                                                          **
**               Byte - Value 0 - 31                                                                    **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RECEPTION_PRIORITY, FCAN_MAILBOXES_START );                   **
**               ioctl( deviceID, FCAN_SET_RECEPTION_PRIORITY, FCAN_MAILBOXES_START );                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RECEPTION_PRIORITY(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL2_MRP, &periph.ctrl2);   /* set bit MRP */\
  else\
    periphBitClear(CAN_CTRL2_MRP, &periph.ctrl2); /* clear bit MRP */

/*********************************************************************************************************
** Method:       FCAN_SET_REMOTE_REQUEST                                                                **
** Description:                                                                                         **
**               Set Remote Request Storing.                                                            **
** Parameters:                                                                                          **
**               Byte - Value 0 - 31                                                                    **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_REMOTE_REQUEST, FCAN_GENERATED );                             **
**               ioctl( deviceID, FCAN_SET_REMOTE_REQUEST, FCAN_GENERATED );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_REMOTE_REQUEST(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL2_RRS, &periph.ctrl2);   /* set bit RRS */\
  else\
    periphBitClear(CAN_CTRL2_RRS, &periph.ctrl2); /* clear bit RRS */

/*********************************************************************************************************
** Method:       FCAN_RTR_COMPARISON                                                                    **
** Description:                                                                                         **
**               Enable/Disable Entire Frame Arbitration Field Comparison for Rx Mailboxes.             **
** Parameters:                                                                                          **
**               FCAN_DISABLE - Disables the comparison                                                 **
**               FCAN_ENABLE - Enables the comparison                                                   **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_RTR_COMPARISON, FCAN_DISABLE );                                   **
**               ioctl( deviceID, FCAN_RTR_COMPARISON, FCAN_DISABLE );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_RTR_COMPARISON(periph, param) \
  if (param)\
    periphBitSet(CAN_CTRL2_EACEN, &periph.ctrl2);   /* set bit EACEN */\
  else\
    periphBitClear(CAN_CTRL2_EACEN, &periph.ctrl2); /* clear bit EACEN */

/*********************************************************************************************************
** Method:       FCAN_READ_ERROR_STATUS_2_REG                                                           **
** Description:                                                                                         **
**               Read Error and Status 2 Register.                                                      **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw32;                                                                         **
**                . . .                                                                                 **
**                uw32 = PESL( deviceID, FCAN_READ_ERROR_STATUS_2_REG, NULL );                          **
**                uw32 =  ioctl( deviceID, FCAN_READ_ERROR_STATUS_2_REG, NULL );                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_ERROR_STATUS_2_REG(periph, param)  \
  periphMemRead(&periph.esr2)

/*********************************************************************************************************
** Method:       FCAN_READ_CRC_REG                                                                      **
** Description:                                                                                         **
**               Read CRC Register.                                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw32;                                                                         **
**                . . .                                                                                 **
**                uw32 = PESL( deviceID, FCAN_READ_CRC_REG, NULL );                                     **
**                uw32 =  ioctl( deviceID, FCAN_READ_CRC_REG, NULL );                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_CRC_REG(periph, param)  \
  periphMemRead(&periph.crcr)

/*********************************************************************************************************
** Method:       FCAN_SET_RX_FIFO_GMASK                                                                 **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RX_FIFO_GMASK, 1 );                                           **
**               ioctl( deviceID, FCAN_SET_RX_FIFO_GMASK, 1 );                                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RX_FIFO_GMASK(periph, param) \
  periphMemWrite(param, &periph.rxfgmask) /* set group FGM */

/*********************************************************************************************************
** Method:       FCAN_READ_RX_FIFO_INFO_REG                                                             **
** Description:                                                                                         **
**               Read Rx FIFO Information Register.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw32;                                                                         **
**                . . .                                                                                 **
**                uw32 = PESL( deviceID, FCAN_READ_RX_FIFO_INFO_REG, NULL );                            **
**                uw32 =  ioctl( deviceID, FCAN_READ_RX_FIFO_INFO_REG, NULL );                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_FIFO_INFO_REG(periph, param)  \
  periphMemRead(&periph.rxfir)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR0MASK                                                                    **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR0MASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RXIMR0MASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR0MASK(periph, param) \
  periphMemWrite(param, &periph.rximr0)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR1MASK                                                                    **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR1MASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RXIMR1MASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR1MASK(periph, param) \
  periphMemWrite(param, &periph.rximr1)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR2MASK                                                                    **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR2MASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RXIMR2MASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR2MASK(periph, param) \
  periphMemWrite(param, &periph.rximr2)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR3MASK                                                                    **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR3MASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RXIMR3MASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR3MASK(periph, param) \
  periphMemWrite(param, &periph.rximr3)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR4MASK                                                                    **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR4MASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RXIMR4MASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR4MASK(periph, param) \
  periphMemWrite(param, &periph.rximr4)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR5MASK                                                                    **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR5MASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RXIMR5MASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR5MASK(periph, param) \
  periphMemWrite(param, &periph.rximr5)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR6MASK                                                                    **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR6MASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RXIMR6MASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR6MASK(periph, param) \
  periphMemWrite(param, &periph.rximr6)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR7MASK                                                                    **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR7MASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RXIMR7MASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR7MASK(periph, param) \
  periphMemWrite(param, &periph.rximr7)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR8MASK                                                                    **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR8MASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RXIMR8MASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR8MASK(periph, param) \
  periphMemWrite(param, &periph.rximr8)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR9MASK                                                                    **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR9MASK, 1 );                                              **
**               ioctl( deviceID, FCAN_SET_RXIMR9MASK, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR9MASK(periph, param) \
  periphMemWrite(param, &periph.rximr9)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR10MASK                                                                   **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR10MASK, 1 );                                             **
**               ioctl( deviceID, FCAN_SET_RXIMR10MASK, 1 );                                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR10MASK(periph, param) \
  periphMemWrite(param, &periph.rximr10)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR11MASK                                                                   **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR11MASK, 1 );                                             **
**               ioctl( deviceID, FCAN_SET_RXIMR11MASK, 1 );                                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR11MASK(periph, param) \
  periphMemWrite(param, &periph.rximr11)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR12MASK                                                                   **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR12MASK, 1 );                                             **
**               ioctl( deviceID, FCAN_SET_RXIMR12MASK, 1 );                                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR12MASK(periph, param) \
  periphMemWrite(param, &periph.rximr12)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR13MASK                                                                   **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR13MASK, 1 );                                             **
**               ioctl( deviceID, FCAN_SET_RXIMR13MASK, 1 );                                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR13MASK(periph, param) \
  periphMemWrite(param, &periph.rximr13)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR14MASK                                                                   **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR14MASK, 1 );                                             **
**               ioctl( deviceID, FCAN_SET_RXIMR14MASK, 1 );                                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR14MASK(periph, param) \
  periphMemWrite(param, &periph.rximr14)

/*********************************************************************************************************
** Method:       FCAN_SET_RXIMR15MASK                                                                   **
** Description:                                                                                         **
**               Set Rx FIFO Global Mask Bits.                                                          **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0xFFFFFFFF                                                          **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_SET_RXIMR15MASK, 1 );                                             **
**               ioctl( deviceID, FCAN_SET_RXIMR15MASK, 1 );                                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_SET_RXIMR15MASK(periph, param) \
  periphMemWrite(param, &periph.rximr15)

/*********************************************************************************************************
** Method:       FCAN_READ_CONFIGURATION_REG                                                            **
** Description:                                                                                         **
**               Read Module Configuration Register.                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_CONFIGURATION_REG, NULL );                              **
**               uw = ioctl( deviceID, FCAN_READ_CONFIGURATION_REG, NULL );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_CONFIGURATION_REG(periph, param)  \
  periphMemRead(&periph.mcr)

/*********************************************************************************************************
** Method:       FCAN_READ_CONTROL_1_REG                                                                **
** Description:                                                                                         **
**               Read Control 1 Register.                                                               **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_CONTROL_1_REG, NULL );                                  **
**               uw = ioctl( deviceID, FCAN_READ_CONTROL_1_REG, NULL );                                 **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_CONTROL_1_REG(periph, param)  \
  periphMemRead(&periph.ctrl1)

/*********************************************************************************************************
** Method:       FCAN_READ_TIMER_REG                                                                    **
** Description:                                                                                         **
**               Read Free Running Timer.                                                               **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_TIMER_REG, NULL );                                      **
**               uw = ioctl( deviceID, FCAN_READ_TIMER_REG, NULL );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_TIMER_REG(periph, param)  \
  periphMemRead(&periph.timer)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_MAILBOXES_REG                                                             **
** Description:                                                                                         **
**               Read Rx Mailboxes Global Mask Register.                                                **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_MAILBOXES_REG, NULL );                               **
**               uw = ioctl( deviceID, FCAN_READ_RX_MAILBOXES_REG, NULL );                              **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_MAILBOXES_REG(periph, param)  \
  periphMemRead(&periph.rxmgmask)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_14_MASK_REG                                                               **
** Description:                                                                                         **
**               Read Rx 14 Mask Register.                                                              **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_14_MASK_REG, NULL );                                 **
**               uw = ioctl( deviceID, FCAN_READ_RX_14_MASK_REG, NULL );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_14_MASK_REG(periph, param)  \
  periphMemRead(&periph.rx14mask)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_15_MASK_REG                                                               **
** Description:                                                                                         **
**               Read Rx 15 Mask Register.                                                              **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_15_MASK_REG, NULL );                                 **
**               uw = ioctl( deviceID, FCAN_READ_RX_15_MASK_REG, NULL );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_15_MASK_REG(periph, param)  \
  periphMemRead(&periph.rx15mask)

/*********************************************************************************************************
** Method:       FCAN_READ_ERROR_COUNTER_REG                                                            **
** Description:                                                                                         **
**               Read Error Counter.                                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_ERROR_COUNTER_REG, NULL );                              **
**               uw = ioctl( deviceID, FCAN_READ_ERROR_COUNTER_REG, NULL );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_ERROR_COUNTER_REG(periph, param)  \
  periphMemRead(&periph.ecr)

/*********************************************************************************************************
** Method:       FCAN_READ_INT_MASK_2_REG                                                               **
** Description:                                                                                         **
**               Read Interrupt Masks 2 Register.                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_INT_MASK_2_REG, NULL );                                 **
**               uw = ioctl( deviceID, FCAN_READ_INT_MASK_2_REG, NULL );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_INT_MASK_2_REG(periph, param)  \
  periphMemRead(&periph.imask2)

/*********************************************************************************************************
** Method:       FCAN_READ_INT_MASK_1_REG                                                               **
** Description:                                                                                         **
**               Read Interrupt Masks 1 Register.                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_INT_MASK_1_REG, NULL );                                 **
**               uw = ioctl( deviceID, FCAN_READ_INT_MASK_1_REG, NULL );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_INT_MASK_1_REG(periph, param)  \
  periphMemRead(&periph.imask1)

/*********************************************************************************************************
** Method:       FCAN_READ_INT_FLAG_2_REG                                                               **
** Description:                                                                                         **
**               Read Interrupt Flags 2 Register.                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_INT_FLAG_2_REG, NULL );                                 **
**               uw = ioctl( deviceID, FCAN_READ_INT_FLAG_2_REG, NULL );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_INT_FLAG_2_REG(periph, param)  \
  periphMemRead(&periph.iflag2)

/*********************************************************************************************************
** Method:       FCAN_READ_INT_FLAG_1_REG                                                               **
** Description:                                                                                         **
**               Read Interrupt Flags 1 Register.                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_INT_FLAG_1_REG, NULL );                                 **
**               uw = ioctl( deviceID, FCAN_READ_INT_FLAG_1_REG, NULL );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_INT_FLAG_1_REG(periph, param)  \
  periphMemRead(&periph.iflag1)

/*********************************************************************************************************
** Method:       FCAN_READ_CONTROL_2_REG                                                                **
** Description:                                                                                         **
**               Read Control 2 Register.                                                               **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_CONTROL_2_REG, NULL );                                  **
**               uw = ioctl( deviceID, FCAN_READ_CONTROL_2_REG, NULL );                                 **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_CONTROL_2_REG(periph, param)  \
  periphMemRead(&periph.ctrl2)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_FIFO_REG                                                                  **
** Description:                                                                                         **
**               Read Rx FIFO Global Mask Register.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_FIFO_REG, NULL );                                    **
**               uw = ioctl( deviceID, FCAN_READ_RX_FIFO_REG, NULL );                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_FIFO_REG(periph, param)  \
  periphMemRead(&periph.rxfgmask)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_0_REG                                                     **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_0_REG, NULL );                       **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_0_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_0_REG(periph, param)  \
  periphMemRead(&periph.rximr0)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_1_REG                                                     **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_1_REG, NULL );                       **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_1_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_1_REG(periph, param)  \
  periphMemRead(&periph.rximr1)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_2_REG                                                     **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_2_REG, NULL );                       **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_2_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_2_REG(periph, param)  \
  periphMemRead(&periph.rximr2)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_3_REG                                                     **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_3_REG, NULL );                       **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_3_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_3_REG(periph, param)  \
  periphMemRead(&periph.rximr3)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_4_REG                                                     **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_4_REG, NULL );                       **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_4_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_4_REG(periph, param)  \
  periphMemRead(&periph.rximr4)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_5_REG                                                     **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_5_REG, NULL );                       **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_5_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_5_REG(periph, param)  \
  periphMemRead(&periph.rximr5)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_6_REG                                                     **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_6_REG, NULL );                       **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_6_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_6_REG(periph, param)  \
  periphMemRead(&periph.rximr6)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_7_REG                                                     **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_7_REG, NULL );                       **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_7_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_7_REG(periph, param)  \
  periphMemRead(&periph.rximr7)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_8_REG                                                     **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_8_REG, NULL );                       **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_8_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_8_REG(periph, param)  \
  periphMemRead(&periph.rximr8)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_9_REG                                                     **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_9_REG, NULL );                       **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_9_REG, NULL );                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_9_REG(periph, param)  \
  periphMemRead(&periph.rximr9)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_10_REG                                                    **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_10_REG, NULL );                      **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_10_REG, NULL );                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_10_REG(periph, param)  \
  periphMemRead(&periph.rximr10)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_11_REG                                                    **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_11_REG, NULL );                      **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_11_REG, NULL );                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_11_REG(periph, param)  \
  periphMemRead(&periph.rximr11)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_12_REG                                                    **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_12_REG, NULL );                      **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_12_REG, NULL );                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_12_REG(periph, param)  \
  periphMemRead(&periph.rximr12)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_13_REG                                                    **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_13_REG, NULL );                      **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_13_REG, NULL );                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_13_REG(periph, param)  \
  periphMemRead(&periph.rximr13)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_14_REG                                                    **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_14_REG, NULL );                      **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_14_REG, NULL );                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_14_REG(periph, param)  \
  periphMemRead(&periph.rximr14)

/*********************************************************************************************************
** Method:       FCAN_READ_RX_INDIVIDUAL_MASK_15_REG                                                    **
** Description:                                                                                         **
**               Read Rx Individual Mask Registers.                                                     **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_15_REG, NULL );                      **
**               uw = ioctl( deviceID, FCAN_READ_RX_INDIVIDUAL_MASK_15_REG, NULL );                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_READ_RX_INDIVIDUAL_MASK_15_REG(periph, param)  \
  periphMemRead(&periph.rximr15)

/*********************************************************************************************************
** Method:       FCAN_WRITE_CONFIGURATION_REG                                                           **
** Description:                                                                                         **
**               Write Module Configuration Register.                                                   **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_CONFIGURATION_REG, 1 );                                     **
**               ioctl( deviceID, FCAN_WRITE_CONFIGURATION_REG, 1 );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_CONFIGURATION_REG(periph, param) \
  periphMemWrite(param, &periph.mcr)

/*********************************************************************************************************
** Method:       FCAN_WRITE_CONTROL_1_REG                                                               **
** Description:                                                                                         **
**               Write Control 1 Register.                                                              **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_CONTROL_1_REG, 1 );                                         **
**               ioctl( deviceID, FCAN_WRITE_CONTROL_1_REG, 1 );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_CONTROL_1_REG(periph, param) \
  periphMemWrite(param, &periph.ctrl1)

/*********************************************************************************************************
** Method:       FCAN_WRITE_TIMER_REG                                                                   **
** Description:                                                                                         **
**               Write Free Running Timer.                                                              **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_TIMER_REG, 1 );                                             **
**               ioctl( deviceID, FCAN_WRITE_TIMER_REG, 1 );                                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_TIMER_REG(periph, param) \
  periphMemWrite(param, &periph.timer)

/*********************************************************************************************************
** Method:       FCAN_WRITE_ERROR_COUNTER_REG                                                           **
** Description:                                                                                         **
**               Write Error Counter.                                                                   **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_ERROR_COUNTER_REG, 1 );                                     **
**               ioctl( deviceID, FCAN_WRITE_ERROR_COUNTER_REG, 1 );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_ERROR_COUNTER_REG(periph, param) \
  periphMemWrite(param, &periph.ecr)

/*********************************************************************************************************
** Method:       FCAN_WRITE_CAN_ESR_1_REG                                                               **
** Description:                                                                                         **
**               Write Error and Status 1 Register.                                                     **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_CAN_ESR_1_REG, 1 );                                         **
**               ioctl( deviceID, FCAN_WRITE_CAN_ESR_1_REG, 1 );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_CAN_ESR_1_REG(periph, param) \
  periphMemWrite(param, &periph.esr1)

/*********************************************************************************************************
** Method:       FCAN_WRITE_INT_MASK_2_REG                                                              **
** Description:                                                                                         **
**               Write Interrupt Masks 2 Register.                                                      **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_INT_MASK_2_REG, 1 );                                        **
**               ioctl( deviceID, FCAN_WRITE_INT_MASK_2_REG, 1 );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_INT_MASK_2_REG(periph, param) \
  periphMemWrite(param, &periph.imask2)

/*********************************************************************************************************
** Method:       FCAN_WRITE_INT_MASK_1_REG                                                              **
** Description:                                                                                         **
**               Write Interrupt Masks 1 Register.                                                      **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_INT_MASK_1_REG, 1 );                                        **
**               ioctl( deviceID, FCAN_WRITE_INT_MASK_1_REG, 1 );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_INT_MASK_1_REG(periph, param) \
  periphMemWrite(param, &periph.imask1)

/*********************************************************************************************************
** Method:       FCAN_WRITE_INT_FLAG_2_REG                                                              **
** Description:                                                                                         **
**               Write Interrupt Flags 2 Register.                                                      **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_INT_FLAG_2_REG, 1 );                                        **
**               ioctl( deviceID, FCAN_WRITE_INT_FLAG_2_REG, 1 );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_INT_FLAG_2_REG(periph, param) \
  periphMemWrite(param, &periph.iflag2)

/*********************************************************************************************************
** Method:       FCAN_WRITE_INT_FLAG_1_REG                                                              **
** Description:                                                                                         **
**               Write Interrupt Flags 1 Register.                                                      **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_INT_FLAG_1_REG, 1 );                                        **
**               ioctl( deviceID, FCAN_WRITE_INT_FLAG_1_REG, 1 );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_INT_FLAG_1_REG(periph, param) \
  periphMemWrite(param, &periph.iflag1)

/*********************************************************************************************************
** Method:       FCAN_WRITE_CONTROL_2_REG                                                               **
** Description:                                                                                         **
**               Write Control 2 Register.                                                              **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_CONTROL_2_REG, 1 );                                         **
**               ioctl( deviceID, FCAN_WRITE_CONTROL_2_REG, 1 );                                        **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_CONTROL_2_REG(periph, param) \
  periphMemWrite(param, &periph.ctrl2)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_FIFO_REG                                                                 **
** Description:                                                                                         **
**               Write Rx FIFO Global Mask Register.                                                    **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_FIFO_REG, 1 );                                           **
**               ioctl( deviceID, FCAN_WRITE_RX_FIFO_REG, 1 );                                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_FIFO_REG(periph, param) \
  periphMemWrite(param, &periph.rxfgmask)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_FIFO_INFO_REG                                                            **
** Description:                                                                                         **
**               Write Rx FIFO Information Register.                                                    **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_FIFO_INFO_REG, 1 );                                      **
**               ioctl( deviceID, FCAN_WRITE_RX_FIFO_INFO_REG, 1 );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_FIFO_INFO_REG(periph, param) \
  periphMemWrite(param, &periph.rxfir)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_0_REG                                                    **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_0_REG, 1 );                              **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_0_REG, 1 );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_0_REG(periph, param) \
  periphMemWrite(param, &periph.rximr0)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_1_REG                                                    **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_1_REG, 1 );                              **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_1_REG, 1 );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_1_REG(periph, param) \
  periphMemWrite(param, &periph.rximr1)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_2_REG                                                    **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_2_REG, 1 );                              **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_2_REG, 1 );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_2_REG(periph, param) \
  periphMemWrite(param, &periph.rximr2)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_3_REG                                                    **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_3_REG, 1 );                              **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_3_REG, 1 );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_3_REG(periph, param) \
  periphMemWrite(param, &periph.rximr3)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_4_REG                                                    **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_4_REG, 1 );                              **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_4_REG, 1 );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_4_REG(periph, param) \
  periphMemWrite(param, &periph.rximr4)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_5_REG                                                    **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_5_REG, 1 );                              **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_5_REG, 1 );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_5_REG(periph, param) \
  periphMemWrite(param, &periph.rximr5)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_6_REG                                                    **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_6_REG, 1 );                              **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_6_REG, 1 );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_6_REG(periph, param) \
  periphMemWrite(param, &periph.rximr6)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_7_REG                                                    **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_7_REG, 1 );                              **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_7_REG, 1 );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_7_REG(periph, param) \
  periphMemWrite(param, &periph.rximr7)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_8_REG                                                    **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_8_REG, 1 );                              **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_8_REG, 1 );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_8_REG(periph, param) \
  periphMemWrite(param, &periph.rximr8)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_9_REG                                                    **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_9_REG, 1 );                              **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_9_REG, 1 );                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_9_REG(periph, param) \
  periphMemWrite(param, &periph.rximr9)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_10_REG                                                   **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_10_REG, 1 );                             **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_10_REG, 1 );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_10_REG(periph, param) \
  periphMemWrite(param, &periph.rximr10)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_11_REG                                                   **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_11_REG, 1 );                             **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_11_REG, 1 );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_11_REG(periph, param) \
  periphMemWrite(param, &periph.rximr11)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_12_REG                                                   **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_12_REG, 1 );                             **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_12_REG, 1 );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_12_REG(periph, param) \
  periphMemWrite(param, &periph.rximr12)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_13_REG                                                   **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_13_REG, 1 );                             **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_13_REG, 1 );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_13_REG(periph, param) \
  periphMemWrite(param, &periph.rximr13)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_14_REG                                                   **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_14_REG, 1 );                             **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_14_REG, 1 );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_14_REG(periph, param) \
  periphMemWrite(param, &periph.rximr14)

/*********************************************************************************************************
** Method:       FCAN_WRITE_RX_INDIVIDUAL_MASK_15_REG                                                   **
** Description:                                                                                         **
**               Write Rx Individual Mask Registers.                                                    **
** Parameters:                                                                                          **
**               UWord32                                                                                **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_15_REG, 1 );                             **
**               ioctl( deviceID, FCAN_WRITE_RX_INDIVIDUAL_MASK_15_REG, 1 );                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCAN_WRITE_RX_INDIVIDUAL_MASK_15_REG(periph, param) \
  periphMemWrite(param, &periph.rximr15)

/*********************************************************************************************************
** Method:       FCANMB_READ_CS_REG                                                                     **
** Description:                                                                                         **
**               Read Message Buffer CS Register.                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCANMB_READ_CS_REG, NULL );                                       **
**               uw = ioctl( deviceID, FCANMB_READ_CS_REG, NULL );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_READ_CS_REG(periph, param)  \
  periphMemRead(&periph.cs)

/*********************************************************************************************************
** Method:       FCANMB_READ_ID_REG                                                                     **
** Description:                                                                                         **
**               Read Message Buffer ID Register.                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCANMB_READ_ID_REG, NULL );                                       **
**               uw = ioctl( deviceID, FCANMB_READ_ID_REG, NULL );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_READ_ID_REG(periph, param)  \
  periphMemRead(&periph.id)

/*********************************************************************************************************
** Method:       FCANMB_READ_WORD_0_REG                                                                 **
** Description:                                                                                         **
**               Read Message Buffer WORD0 Register.                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCANMB_READ_WORD_0_REG, NULL );                                   **
**               uw = ioctl( deviceID, FCANMB_READ_WORD_0_REG, NULL );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_READ_WORD_0_REG(periph, param)  \
  periphMemRead(&periph.word0)

/*********************************************************************************************************
** Method:       FCANMB_READ_WORD_1_REG                                                                 **
** Description:                                                                                         **
**               Read Message Buffer WORD1 Register.                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw;                                                                           **
**                . . .                                                                                 **
**               uw = PESL( deviceID, FCANMB_READ_WORD_1_REG, NULL );                                   **
**               uw = ioctl( deviceID, FCANMB_READ_WORD_1_REG, NULL );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_READ_WORD_1_REG(periph, param)  \
  periphMemRead(&periph.word1)

/*********************************************************************************************************
** Method:       FCANMB_WRITE_CS_REG                                                                    **
** Description:                                                                                         **
**               Write Message Buffer CS Register.                                                      **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_WRITE_CS_REG, 1 );                                              **
**               ioctl( deviceID, FCANMB_WRITE_CS_REG, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_WRITE_CS_REG(periph, param) \
  periphMemWrite(param, &periph.cs)

/*********************************************************************************************************
** Method:       FCANMB_WRITE_ID_REG                                                                    **
** Description:                                                                                         **
**               Write Message Buffer ID Register.                                                      **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_WRITE_ID_REG, 1 );                                              **
**               ioctl( deviceID, FCANMB_WRITE_ID_REG, 1 );                                             **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_WRITE_ID_REG(periph, param) \
  periphMemWrite(param, &periph.id)

/*********************************************************************************************************
** Method:       FCANMB_WRITE_WORD_0_REG                                                                **
** Description:                                                                                         **
**               Write Message Buffer WORD0 Register.                                                   **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_WRITE_WORD_0_REG, 1 );                                          **
**               ioctl( deviceID, FCANMB_WRITE_WORD_0_REG, 1 );                                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_WRITE_WORD_0_REG(periph, param) \
  periphMemWrite(param, &periph.word0)

/*********************************************************************************************************
** Method:       FCANMB_WRITE_WORD_1_REG                                                                **
** Description:                                                                                         **
**               Write Message Buffer WORD1 Register.                                                   **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_WRITE_WORD_1_REG, 1 );                                          **
**               ioctl( deviceID, FCANMB_WRITE_WORD_1_REG, 1 );                                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_WRITE_WORD_1_REG(periph, param) \
  periphMemWrite(param, &periph.word1)

/*********************************************************************************************************
** Method:       FCANMB_SET_CODE                                                                        **
** Description:                                                                                         **
**               Set Message Buffer 0 Code.                                                             **
** Parameters:                                                                                          **
**               FCANMB_RX_NOT_ACTIVE - MB is not active                                                **
**               FCANMB_RX_EMPTY - MB is active and empty                                               **
**               FCANMB_RX_FULL - MB is full                                                            **
**               FCANMB_RX_OVERRUN - MB is being overwritten into a full buffer                         **
**               FCANMB_RX_RANSWER - A frame was configured to recognize a Remote Request Frame and transmit a Response Frame in return **
**               FCANMB_RX_BUSY - FlexCAN is updating the contents of the MB                            **
**               FCANMB_TX_NOT_ACTIVE - MB is not active                                                **
**               FCANMB_TX_ABORT - MB is aborted                                                        **
**               FCANMB_TX_DATA_FRAME - MB is a Tx Data Frame (MB RTR must be 0)                        **
**               FCANMB_TX_TANSWER - MB is a Tx Response Frame from an incoming Remote Request Frame    **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SET_CODE, FCANMB_RX_NOT_ACTIVE );                               **
**               ioctl( deviceID, FCANMB_SET_CODE, FCANMB_RX_NOT_ACTIVE );                              **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_SET_CODE(periph, param) \
  periphBitGrpSet((CAN_CS0_CODE), (UWord32)(param) << 24, &periph.cs) /* set group CODE */

/*********************************************************************************************************
** Method:       FCANMB_GET_CODE                                                                        **
** Description:                                                                                         **
**               Get Message Buffer 0 Code.                                                             **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32 - FCANMB_SET_CODE constants can be used                                        **
** Example:                                                                                             **
**                UWord32 uw32;                                                                         **
**                . . .                                                                                 **
**               uw32 = PESL( deviceID, FCANMB_GET_CODE, NULL );                                        **
**               uw32 = ioctl( deviceID, FCANMB_GET_CODE, NULL );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_CODE(periph, param) \
  (periphBitTest((CAN_CS0_CODE), &periph.cs)  >> 24) /* read group CODE */

/*********************************************************************************************************
** Method:       FCANMB_SRR                                                                             **
** Description:                                                                                         **
**               Enable/Disable Substitute Remote Request.                                              **
** Parameters:                                                                                          **
**               FCANMB_DISABLE - Dominant is not a valid value for transmission in Extended Format frames **
**               FCANMB_ENABLE - Recessive value is compulsory for transmission in Extended Format frames **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SRR, FCANMB_DISABLE );                                          **
**               ioctl( deviceID, FCANMB_SRR, FCANMB_DISABLE );                                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_SRR(periph, param) \
  if (param)\
    periphBitSet(CAN_CS0_SRR, &periph.cs);   /* set bit SRR */\
  else\
    periphBitClear(CAN_CS0_SRR, &periph.cs); /* clear bit SRR */

/*********************************************************************************************************
** Method:       FCANMB_GET_SRR                                                                         **
** Description:                                                                                         **
**               Get Substitute Remote Request.                                                         **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCANMB_GET_SRR, NULL );                                            **
**               w = ioctl( deviceID, FCANMB_GET_SRR, NULL );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_SRR(periph, param) \
  periphBitTest(CAN_CS0_SRR, &periph.cs) /* read bit SRR */

/*********************************************************************************************************
** Method:       FCANMB_SET_ID_TYPE                                                                     **
** Description:                                                                                         **
**               Set ID Extended.                                                                       **
** Parameters:                                                                                          **
**               FCANMB_STANDARD - Frame format is standard                                             **
**               FCANMB_EXTENDED - Frame format is extended                                             **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SET_ID_TYPE, FCANMB_STANDARD );                                 **
**               ioctl( deviceID, FCANMB_SET_ID_TYPE, FCANMB_STANDARD );                                **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_SET_ID_TYPE(periph, param) \
  if (param)\
    periphBitSet(CAN_CS0_IDE, &periph.cs);   /* set bit IDE */\
  else\
    periphBitClear(CAN_CS0_IDE, &periph.cs); /* clear bit IDE */

/*********************************************************************************************************
** Method:       FCANMB_GET_ID_TYPE                                                                     **
** Description:                                                                                         **
**               Get ID Extended.                                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32 - FCANMB_SET_ID_TYPE constants can be used                                     **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCANMB_GET_ID_TYPE, NULL );                                        **
**               w = ioctl( deviceID, FCANMB_GET_ID_TYPE, NULL );                                       **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_ID_TYPE(periph, param) \
  periphBitTest(CAN_CS0_IDE, &periph.cs) /* read bit IDE */

/*********************************************************************************************************
** Method:       FCANMB_SET_DATA_LENGTH                                                                 **
** Description:                                                                                         **
**               Set length of the data to be stored/transmitted.                                       **
** Parameters:                                                                                          **
**               Byte - Value 0 - 15                                                                    **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SET_DATA_LENGTH, 1 );                                           **
**               ioctl( deviceID, FCANMB_SET_DATA_LENGTH, 1 );                                          **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_SET_DATA_LENGTH(periph, param) \
  periphBitGrpSet((CAN_CS0_DLC), (UWord32)(param) << 16, &periph.cs) /* set group DLC */

/*********************************************************************************************************
** Method:       FCANMB_GET_DATA_LENGTH                                                                 **
** Description:                                                                                         **
**               Get length of the data to be stored/transmitted.                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Byte                                                                                   **
** Example:                                                                                             **
**                Byte b;                                                                               **
**                . . .                                                                                 **
**               b = PESL( deviceID, FCANMB_GET_DATA_LENGTH, NULL );                                    **
**               b = ioctl( deviceID, FCANMB_GET_DATA_LENGTH, NULL );                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_DATA_LENGTH(periph, param) \
  (periphBitTest((CAN_CS0_DLC), &periph.cs)  >> 16) /* read group DLC */

/*********************************************************************************************************
** Method:       FCANMB_SET_TIME_STAMP                                                                  **
** Description:                                                                                         **
**               Set Free-Running Counter Time stamp..                                                  **
** Parameters:                                                                                          **
**               Word - Value 0 - 65535                                                                 **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SET_TIME_STAMP, 1 );                                            **
**               ioctl( deviceID, FCANMB_SET_TIME_STAMP, 1 );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_SET_TIME_STAMP(periph, param) \
  periphBitGrpSet((CAN_CS0_TIME_STAMP), param, &periph.cs) /* set group TIME_STAMP */

/*********************************************************************************************************
** Method:       FCANMB_GET_TIME_STAMP                                                                  **
** Description:                                                                                         **
**               Get Free-Running Counter Time stamp..                                                  **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**                w = PESL( deviceID, FCANMB_GET_TIME_STAMP, NULL );                                    **
**                w =  ioctl( deviceID, FCANMB_GET_TIME_STAMP, NULL );                                  **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_TIME_STAMP(periph, param) \
  (periphBitTest((CAN_CS0_TIME_STAMP), &periph.cs) ) /* read group TIME_STAMP */

/*********************************************************************************************************
** Method:       FCANMB_RTR                                                                             **
** Description:                                                                                         **
**               Enable/Disable Remote Transmission Request.                                            **
** Parameters:                                                                                          **
**               FCANMB_DISABLE - Disable Remote Transmission Request                                   **
**               FCANMB_ENABLE - Enable Remote Transmission Request                                     **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_RTR, FCANMB_DISABLE );                                          **
**               ioctl( deviceID, FCANMB_RTR, FCANMB_DISABLE );                                         **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_RTR(periph, param) \
  if (param)\
    periphBitSet(CAN_CS0_RTR, &periph.cs);   /* set bit RTR */\
  else\
    periphBitClear(CAN_CS0_RTR, &periph.cs); /* clear bit RTR */

/*********************************************************************************************************
** Method:       FCANMB_GET_RTR                                                                         **
** Description:                                                                                         **
**               Get Remote Transmission Request.                                                       **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Bool                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**               w = PESL( deviceID, FCANMB_GET_RTR, NULL );                                            **
**               w = ioctl( deviceID, FCANMB_GET_RTR, NULL );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_RTR(periph, param) \
  periphBitTest(CAN_CS0_RTR, &periph.cs) /* read bit RTR */

/*********************************************************************************************************
** Method:       FCANMB_SET_LOCAL_PRIO                                                                  **
** Description:                                                                                         **
**               Set Local priority.                                                                    **
** Parameters:                                                                                          **
**               Byte - Value 0 - 7                                                                     **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SET_LOCAL_PRIO, 1 );                                            **
**               ioctl( deviceID, FCANMB_SET_LOCAL_PRIO, 1 );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_SET_LOCAL_PRIO(periph, param) \
  periphBitGrpSet((CAN_ID0_PRIO), (UWord32)(param) << 29, &periph.id) /* set group PRIO */

/*********************************************************************************************************
** Method:       FCANMB_GET_LOCAL_PRIO                                                                  **
** Description:                                                                                         **
**               Get local priority.                                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               Byte                                                                                   **
** Example:                                                                                             **
**                Byte b;                                                                               **
**                . . .                                                                                 **
**               b = PESL( deviceID, FCANMB_GET_LOCAL_PRIO, NULL );                                     **
**               b = ioctl( deviceID, FCANMB_GET_LOCAL_PRIO, NULL );                                    **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_LOCAL_PRIO(periph, param) \
  (periphBitTest((CAN_ID0_PRIO), &periph.id)  >> 29) /* read group PRIO */

/*********************************************************************************************************
** Method:       FCANMB_SET_ID_STD                                                                      **
** Description:                                                                                         **
**               Set standard identifier of message buffer.                                             **
** Parameters:                                                                                          **
**               Word - Value 0x0 - 0x7FF                                                               **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SET_ID_STD, 1 );                                                **
**               ioctl( deviceID, FCANMB_SET_ID_STD, 1 );                                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_SET_ID_STD(periph, param) \
  periphBitGrpSet((CAN_ID0_STD), (UWord32)(param) << 18, &periph.id) /* set group STD */

/*********************************************************************************************************
** Method:       FCANMB_GET_ID_STD                                                                      **
** Description:                                                                                         **
**               Get standard identifier of message buffer.                                             **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               word                                                                                   **
** Example:                                                                                             **
**                word w;                                                                               **
**                . . .                                                                                 **
**                w = PESL( deviceID, FCANMB_GET_ID_STD, NULL );                                        **
**                w =  ioctl( deviceID, FCANMB_GET_ID_STD, NULL );                                      **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_ID_STD(periph, param) \
  (periphBitTest((CAN_ID0_STD), &periph.id)  >> 18) /* read group STD */

/*********************************************************************************************************
** Method:       FCANMB_SET_ID_EXT                                                                      **
** Description:                                                                                         **
**               Set extended identifier of message buffer.                                             **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0x1FFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SET_ID_EXT, 1 );                                                **
**               ioctl( deviceID, FCANMB_SET_ID_EXT, 1 );                                               **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_SET_ID_EXT(periph, param) \
  periphBitGrpSet((CAN_ID0_STD | CAN_ID0_EXT), param, &periph.id)

/*********************************************************************************************************
** Method:       FCANMB_GET_ID_EXT                                                                      **
** Description:                                                                                         **
**               Get extended identifier of message buffer.                                             **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw32;                                                                         **
**                . . .                                                                                 **
**               uw32 = PESL( deviceID, FCANMB_GET_ID_EXT, NULL );                                      **
**               uw32 = ioctl( deviceID, FCANMB_GET_ID_EXT, NULL );                                     **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_ID_EXT(periph, param) \
  (periphBitTest((CAN_ID0_EXT | CAN_ID0_STD), &periph.id)) /* read group EXT */

/*********************************************************************************************************
** Method:       FCANMB_SET_DATA_WORD0                                                                  **
** Description:                                                                                         **
**               Write Message Buffer WORD0 Register.                                                   **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SET_DATA_WORD0, 1 );                                            **
**               ioctl( deviceID, FCANMB_SET_DATA_WORD0, 1 );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_SET_DATA_WORD0(periph, param) \
  periphMemWrite(param, &periph.word0)

/*********************************************************************************************************
** Method:       FCANMB_GET_DATA_WORD0                                                                  **
** Description:                                                                                         **
**               Read Message Buffer WORD0 Register.                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw32;                                                                         **
**                . . .                                                                                 **
**               uw32 = PESL( deviceID, FCANMB_GET_DATA_WORD0, NULL );                                  **
**               uw32 = ioctl( deviceID, FCANMB_GET_DATA_WORD0, NULL );                                 **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_DATA_WORD0(periph, param)  \
  periphMemRead(&periph.word0)

/*********************************************************************************************************
** Method:       FCANMB_SET_DATA_WORD1                                                                  **
** Description:                                                                                         **
**               Write Message Buffer WORD1 Register.                                                   **
** Parameters:                                                                                          **
**               UWord32 - Value 0x0 - 0xFFFFFFFF                                                       **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SET_DATA_WORD1, 1 );                                            **
**               ioctl( deviceID, FCANMB_SET_DATA_WORD1, 1 );                                           **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_SET_DATA_WORD1(periph, param) \
  periphMemWrite(param, &periph.word1)

/*********************************************************************************************************
** Method:       FCANMB_GET_DATA_WORD1                                                                  **
** Description:                                                                                         **
**               Read Message Buffer WORD1 Register.                                                    **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 uw32;                                                                         **
**                . . .                                                                                 **
**               uw32 = PESL( deviceID, FCANMB_GET_DATA_WORD1, NULL );                                  **
**               uw32 = ioctl( deviceID, FCANMB_GET_DATA_WORD1, NULL );                                 **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_DATA_WORD1(periph, param)  \
  periphMemRead(&periph.word1)
  
/*********************************************************************************************************
** Method:       FCANMB_SET_ID                                                                          **
** Description:                                                                                         **
**               Set FlexCAN Message Buffer ID.                                                         **
** Parameters:                                                                                          **
**               UWord32 - UWord32                                                                      **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SET_ID, 1 );                                                    **
**               ioctl( deviceID, FCANMB_SET_ID, 1 );                                                   **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
 #define ioctlFCANMB_SET_ID(periph, param) \
  ioctl_FCANMB_SET_ID((UWord16 *)&periph, param)

/*********************************************************************************************************
** Method:       FCANMB_SET_ID_V                                                                        **
** Description:                                                                                         **
**               Set FlexCAN Message Buffer ID.                                                         **
** Parameters:                                                                                          **
**               Word - UWord32                                                                         **
** Result:                                                                                              **
**               NULL                                                                                   **
** Example:                                                                                             **
**               PESL( deviceID, FCANMB_SET_ID_V, 1 );                                                  **
**               ioctl( deviceID, FCANMB_SET_ID_V, 1 );                                                 **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
 #define ioctlFCANMB_SET_ID_V(periph, param) \
  ioctl_FCANMB_SET_ID_V((UWord16 *)&periph, param)
  
/*********************************************************************************************************
** Method:       FCANMB_GET_ID                                                                          **
** Description:                                                                                         **
**               Parse 29+1bit ID from the apropriate bits in given MB.                                 **
** Parameters:                                                                                          **
**               NULL                                                                                   **
** Result:                                                                                              **
**               UWord32                                                                                **
** Example:                                                                                             **
**                UWord32 l;                                                                            **
**                . . .                                                                                 **
**               l = PESL( deviceID, FCANMB_GET_ID, NULL );                                             **
**               l = ioctl( deviceID, FCANMB_GET_ID, NULL );                                            **
**                                                                                                      **
**                                                                                                      **
*********************************************************************************************************/
#define ioctlFCANMB_GET_ID(periph, param) \
  ioctl_FCANMB_GET_ID((UWord16 *)&periph)

/**********************************************************************************************************/
/**********************************************************************************************************/
#endif __PE_peslCAN
/**********************************************************************************************************/
/**********************************************************************************************************/
#endif
