/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : Init_PIT
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-06, 13:58, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_Init_PIT */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "Timer.h"
#include "Cap1.h"
#include "Bit1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"


void main(void)
{
  test_sRec testRec;
  
  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/  

  TEST1_testStart(&testRec, "Init_PIT test");
  TEST1_testComment( &testRec , "Please interconnect pins GPIOC3/TA0/CMPA_O/RXD0/CLKIN1 and GPIOC4/TA1/CMPB_O/XB_IN8/EWM_OUT_B." );
  event = 0;
  overflow = FALSE;
  Bit1_ClrVal();

  TEST1_testComment( &testRec , "Bean will generate 3 pulses (10ms low, 10ms high)");
  Cap1_Enable();         /* enable measuring */
  PESL(PIT0, PIT_DEVICE, PIT_ENABLE );       /* start pulse generation */
  Cpu_Delay100US(560);   /* wait 56ms */
  Cap1_Disable();        /* 3 pulses should be measured then disable capture bean */
  
  TEST1_testComment( &testRec , "Test Capture overflow event:");
  if (overflow) {
	  TEST1_testFailed(&testRec, "failed");
  } else {
	  TEST1_testComment( &testRec , "OK");
  }  
  
  event=0;
  TEST1_testComment( &testRec , "First pulse - high level(1%):");
  if ((Ticks[event] < (5000-50)) || (Ticks[event] > (5000+50))) {   /* 10ms */
    TEST1_testFailed(&testRec, "number of ticks");
  } else {
	  TEST1_testComment( &testRec , "number of ticks OK.");
  }
  event++;
  TEST1_testComment( &testRec , "First pulse - low level (1%):");
  if ((Ticks[event] < (10000-100)) || (Ticks[event] > (10000+100))) { /* 20ms */
    TEST1_testFailed(&testRec, "number of ticks");
  } else {
	  TEST1_testComment( &testRec , "number of ticks OK.");  
  event++;
  }
  TEST1_testComment( &testRec , "Second pulse  - high level (1%):");
  if ((Ticks[event] < (15000-150)) || (Ticks[event] > (15000+150))) { /* 30ms */
    TEST1_testFailed(&testRec, "number of ticks");
  } else {
    TEST1_testComment( &testRec , "number of ticks OK.");
  }
  event++;
  TEST1_testComment( &testRec , "Second pulse - low level (1%):");
  if ((Ticks[event] < (20000-200)) || (Ticks[event] > (20000+200))) { /* 40ms */
    TEST1_testFailed(&testRec, "number of ticks");
  } else {
    TEST1_testComment( &testRec , "number of ticks OK."); 
  }
  event++;
  TEST1_testComment( &testRec , "Third pulse  - high level(1%):");
  if ((Ticks[event] < (25000-250)) || (Ticks[event] > (25000+250))) { /* 50ms */
    TEST1_testFailed(&testRec, "number of ticks");
  } else {
	TEST1_testComment( &testRec , "number of ticks OK.");
  }
  event++;
  TEST1_testComment( &testRec , "Third pulse - low level (1%):");
  if ((Ticks[event] < (30000-300)) || (Ticks[event] > (30000+300))) { /* 60ms */
	TEST1_testFailed(&testRec, "number of ticks.");
  } else {
	TEST1_testComment( &testRec , "number of ticks OK."); 
  }

  TEST1_testEnd( &testRec );
}

/* END demo_Init_PIT */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
