/** ###################################################################
**     Filename    : Events.c
**     Project     : Init_PIT
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-06, 13:58, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

bool overflow;
word event;
word Ticks[6];

/*
** ===================================================================
**     Event       :  Cap1_OnCapture (module Events)
**
**     From bean   :  Cap1 [Capture]
**     Description :
**         This event is called on capturing of Timer/Counter actual
**         value (only when the bean is enabled - <Enable> and the
**         events are enabled - <EnableEvent>.This event is available
**         only if a <interrupt service/event> is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void Cap1_OnCapture(void)
{
  Cap1_GetCaptureValue(&Ticks[event++]);
}

/*
** ===================================================================
**     Event       :  Cap1_OnOverflow (module Events)
**
**     From bean   :  Cap1 [Capture]
**     Description :
**         This event is called if counter overflows (only when the
**         bean is enabled - <Enable> and the events are enabled -
**         <EnableEvent>.This event is available only if a <interrupt
**         service/event> is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void Cap1_OnOverflow(void)
{
  overflow = TRUE;
}

/*
** ===================================================================
**     Interrupt handler : PIT_ISR
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#if defined(PIT_ISR_FAST_INT)
#pragma interrupt fast
#elif defined(PIT_ISR_VECT_TABLE_ISR_FAST_INT)
#pragma define_section interrupt_fast "interrupt_fast.text"  RX
#pragma section interrupt_fast begin
#pragma interrupt fast
#else
#pragma interrupt
#endif
void PIT_ISR(void)
{
	  PESL(Timer_DEVICE, PIT_READ_CONTROL_REG, NULL);	/*clearing roll-over flag*/ 
	  PESL(Timer_DEVICE, PIT_CLEAR_FLAG, NULL);

	  Bit1_NegVal();
}
#if defined(PIT_ISR_VECT_TABLE_ISR_FAST_INT)
#pragma section interrupt_fast end
#endif


/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
