/** ###################################################################
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* File: dspfunc.h */

#ifndef __DSPFUNC_H
#define __DSPFUNC_H

#ifndef SDK_LIBRARY
 #include "configdefines.h"

 #ifndef INCLUDE_DSPFUNC
  #error INCLUDE_DSPFUNC must be defined in AppConfig.h to initialize the DSP Function Library
 #endif
#endif

/*
   This include file is the master include file for the
   DSP568xx Digital Signal Processing Function Library -
   Fractional Algorithms for C and Assembly Programmers.
*/

/***************************
 Foundational Include Files
****************************/
#include "port.h"
#include "arch.h"
#include "prototype.h"
#include "dfr16priv.h"   /* MIEL_PRASAD */

/***************************
 Trigonometric Functions
****************************/
#include "tfr16.h"

/***************************
 Signal Processing Functions
****************************/
#include "dfr16.h"

void dspfuncInitialize(void);

#endif
