/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Version     : Driver 01.14
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-13, 12:17, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE ProcessorExpert */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "DMA1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define BLOCK_LENGTH  16

bool transComplete = FALSE;

void main(void)
{
  test_sRec testRec;
  byte i;
  bool cmpFailed;
  byte srcData[ BLOCK_LENGTH ];
  byte destData[ BLOCK_LENGTH ];
  
  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "Init_DMA");
  //
  for ( i = 0 ; i < BLOCK_LENGTH ; i++ ) {
    srcData[ i ] = i;
    destData[ i ] = 0xff;
  }
  //
  TEST1_testComment(&testRec, "Transmitting data ...");
  //
  PESL( DMA, DMA_SET_BYTE_CNT_CH0, BLOCK_LENGTH );
  PESL( DMA, DMA_SET_SRC_ADDR_CH0, ( UInt32 ) srcData );
  PESL( DMA, DMA_SET_DEST_ADDR_CH0, ( UInt32 ) destData );
  PESL( DMA, DMA_START_TRANSFER_CH0, NULL );
  //
  while( !transComplete ) {}
  //
  TEST1_testComment(&testRec, "OK");
  //
  TEST1_testComment(&testRec, "Comparing received/sent data ...");
  cmpFailed = FALSE;
  for ( i = 0 ; i < BLOCK_LENGTH ; i++ ) {
    if ( srcData[ i ] !=  destData[ i ]) {
      cmpFailed = TRUE;
    } 
  }
  if ( cmpFailed ) {
    TEST1_testFailed( &testRec, "comparing" );
  } else {
    TEST1_testComment( &testRec, "comparing OK" );
  }  
  //
  TEST1_testComment( &testRec, "Testing OnComplete event ..." );
  if ( !transComplete ) {
    TEST1_testFailed( &testRec, "event" );
  } else {
    TEST1_testComment( &testRec, "event OK" );
  }  
  //
  TEST1_testEnd(&testRec);
  //
  
  for(;;) {}
}

/* END ProcessorExpert */
/*
** ###################################################################
**
**     This file was created by Processor Expert 0.00.00 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
