/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : Init_DAC
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 11:45, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_Init_DAC */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "DAC1.h"
#include "AD1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

byte i;
word Value[5] = {70, 500, 1000, 2000, 4000};
word Value16[5] = {800, 10000, 32768, 48000, 65000};
word TmpValue;
bool Error;

void main(void)
{
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "Init_DAC test");
  TEST1_testComment(&testRec, "Please interconnect the pins GPIOA7_ANA7 and GPIOC5_DACO_XB_IN7.");

  /* Init value */
  Error = FALSE;
  Cpu_Delay100US(10);
  AD1_Measure(TRUE);
  AD1_GetValue16(&TmpValue);
  TmpValue >>= 4;
  if (TmpValue < 1000) {
    if ((1000 - TmpValue) > 64) {
      Error = TRUE;
    }
  }
  else {
    if ((TmpValue - 1000) > 64) {
      Error = TRUE;
    }
  }
  if (!Error)
    TEST1_testComment(&testRec, "Init value test OK.");
  else  
    TEST1_testFailed(&testRec, "Init value method.");

  /* DAC_WRITE_DATA_REG macro */
  Error = FALSE;
  for (i = 0; i < 5; i++) {
    PESL(DAC, DAC_WRITE_DATA_REG, Value[i]);
    Cpu_Delay100US(10);
    AD1_Measure(TRUE);
    AD1_GetValue16(&TmpValue);
    TmpValue >>= 4;
    if (TmpValue < Value[i]) {
      if ((Value[i] - TmpValue) > 64) {
        Error = TRUE;
      }
    }
    else {
      if ((TmpValue - Value[i]) > 64) {
        Error = TRUE;
      }
    }
  }
  if (!Error)
    TEST1_testComment(&testRec, "DAC_WRITE_DATA_REG macro test OK.");
  else  
    TEST1_testFailed(&testRec, "DAC_WRITE_DATA_REG macro.");

  /* DAC_WRITE_DATA_REG_RIGHT macro */
  Error = FALSE;
  for (i = 0; i < 5; i++) {
    PESL(DAC, DAC_WRITE_DATA_REG_RIGHT, Value[i]);
    Cpu_Delay100US(10);
    AD1_Measure(TRUE);
    AD1_GetValue16(&TmpValue);
    TmpValue >>= 4;
    if (TmpValue < Value[i]) {
      if ((Value[i] - TmpValue) > 64) {
        Error = TRUE;
      }
    }
    else {
      if ((TmpValue - Value[i]) > 64) {
        Error = TRUE;
      }
    }
  }
  if (!Error)
    TEST1_testComment(&testRec, "DAC_WRITE_DATA_REG_RIGHT macro test OK.");
  else  
    TEST1_testFailed(&testRec, "DAC_WRITE_DATA_REG_RIGHT macro.");

  /* DAC_SET_DATA_FORMAT */
  PESL(DAC, DAC_SET_DATA_FORMAT, DAC_LEFT_JUSTIFIED);

  /* DAC_WRITE_DATA_REG macro */
  Error = FALSE;
  for (i = 0; i < 5; i++) {
    PESL(DAC, DAC_WRITE_DATA_REG, Value16[i]);
    Cpu_Delay100US(10);
    AD1_Measure(TRUE);
    AD1_GetValue16(&TmpValue);
    if (TmpValue < Value16[i]) {
      if ((Value16[i] - TmpValue) > 1024) {
        Error = TRUE;
      }
    }
    else {
      if ((TmpValue - Value16[i]) > 1024) {
        Error = TRUE;
      }
    }
  }
  if (!Error)
    TEST1_testComment(&testRec, "DAC_WRITE_DATA_REG macro test OK.");
  else  
    TEST1_testFailed(&testRec, "DAC_WRITE_DATA_REG macro.");

  /* DAC_WRITE_DATA_REG_LEFT macro */
  Error = FALSE;
  for (i = 0; i < 5; i++) {
    PESL(DAC, DAC_WRITE_DATA_REG_LEFT, Value[i]);
    Cpu_Delay100US(10);
    AD1_Measure(TRUE);
    AD1_GetValue16(&TmpValue);
    TmpValue >>= 4;
    if (TmpValue < Value[i]) {
      if ((Value[i] - TmpValue) > 64) {
        Error = TRUE;
      }
    }
    else {
      if ((TmpValue - Value[i]) > 64) {
        Error = TRUE;
      }
    }
  }
  if (!Error)
    TEST1_testComment(&testRec, "DAC_WRITE_DATA_REG_LEFT macro test OK.");
  else  
    TEST1_testFailed(&testRec, "DAC_WRITE_DATA_REG_LEFT macro.");


  //
  TEST1_testEnd(&testRec);
  //
}
/* END demo_Init_DAC */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
