/** ###################################################################
**     Filename    : Events.h
**     Project     : Init_MSCAN
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 13:30, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/

#ifndef __Events_H
#define __Events_H
/* MODULE Events */

#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "CAN.h"
#include "TEST1.h"
#include "FC1.h"


/*
** ===================================================================
**     Interrupt handler : CAN_MB_or_ISR
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void CAN_MB_or_ISR(void);



/*
** ===================================================================
**     Interrupt handler : Error_ISR
**
**     Description :
**         To satisfy compiler 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void Error_ISR(void);


/*
** ===================================================================
**     Interrupt handler : BusOff_ISR
**
**     Description :
**         To satisfy compiler 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void BusOff_ISR(void);


/* END Events */
#endif /* __Events_H*/

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
