/** ###################################################################
**     Filename    : Events.c
**     Project     : Init_MSCAN
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 13:30, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

extern volatile byte OnFreeTxBuffer;
extern volatile byte OnFullRxBuffer;

/*
** ===================================================================
**     Interrupt handler : CAN_INT_RxFull
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void CAN_MB_or_ISR(void)
{
	if( PESL(CAN, FCAN_GET_MBINT_0_15_FLAGS, NULL ) & FCAN_MBINT_0 ) {
		PESL(CAN, FCAN_CLEAR_MBINT_0_15_FLAGS, FCAN_MBINT_0 );
		OnFreeTxBuffer++;
	} else if( PESL(CAN, FCAN_GET_MBINT_0_15_FLAGS, NULL ) & FCAN_MBINT_1 ) {
		PESL(CAN, FCAN_CLEAR_MBINT_0_15_FLAGS, FCAN_MBINT_1 );
		OnFullRxBuffer++;
	}

}


/*
** ===================================================================
**     Interrupt handler : Error_ISR
**
**     Description :
**         To satisfy compiler 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void Error_ISR(void) {
	
}


/*
** ===================================================================
**     Interrupt handler : BusOff_ISR
**
**     Description :
**         To satisfy compiler 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void BusOff_ISR(void) {
	
}



/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
