/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : InFlash
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 08:43, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_InFlash */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "IFsh1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* The test data (256 words) will be written to the program flash
/* under the flash memory configuration field. The area is excluded
/* from p_Code memory segment (no application code or data will be
/* written there).
*/
#define FLASH_CNF_FIELD_SIZE 8
#define TEST_AREA_SIZE 0x010
#define TEST_AREA_END (PROG_FLASH_END - FLASH_CNF_FIELD_SIZE)
#define TEST_AREA_BEG (TEST_AREA_END - TEST_AREA_SIZE + 1)

void main(void)
{
  test_sRec testRec;
  word WriteData, err, ReadData;
  dword Address;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "Internal FLASH test");

  WriteData = 0;
  Address = TEST_AREA_END;
  Counter = 0;

/*  TEST1_testComment(&testRec, "remove global protection");
  err = IFsh1_SetGlobalProtection(FALSE);
  if (err != ERR_OK) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, " OK");
  }  */

  TEST1_testComment(&testRec, "erase sector");
  err = IFsh1_EraseSector(TEST_AREA_BEG);
  if (err != ERR_OK) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, " OK");
  }  

  TEST1_testComment(&testRec, "program sector");
  do {
    err = IFsh1_SetWordFlash(Address, ++WriteData);
    if (err != ERR_OK) break;
    err = IFsh1_GetWordFlash(Address--, &ReadData);
    if (err != ERR_OK) break;
    if (ReadData != WriteData) break;
  } while (Address >= TEST_AREA_BEG);
  if ((ReadData != WriteData) | (err != ERR_OK)) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, " OK");
  }  

  TEST1_testComment(&testRec, "number of events");
  if (Counter != TEST_AREA_SIZE) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, " OK");
  }  

  TEST1_testEnd(&testRec);

}


/* END demo_InFlash */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
