/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : IFsh1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : IntFLASH
**     Version     : Component 02.383, Driver 01.01, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:44, # CodeGen: 13
**     Abstract    :
**         This component "IntFLASH" implements an access to internal FLASH.
**         The component support reading/writing data into FLASH, erasing of
**         selected sector.
**         The component supports events if the write interrupt is supported.
**         The component supports following modes of write operations:
**           - Write - writing without any test.
**           - Destructive write - sector is erased if necessary.
**           - Safe write - user event is invoked to save and resore data
**                          from the current sector.
**         The component requires on-chip FLASH memory (not used/allocated by
**         other components).
**     Settings    :
**         FLASH memory type                 : Program FLASH
**         Memory size                       : 131072 words
**         Sector size                       : 1024 words
**         Interrupt service                 : Enabled
**         Write method                      : Write
**         Wait in RAM                       : no
**     Contents    :
**         DisableEvent - byte IFsh1_DisableEvent(void);
**         EnableEvent  - byte IFsh1_EnableEvent(void);
**         Busy         - bool IFsh1_Busy(byte Block);
**         EraseSector  - byte IFsh1_EraseSector(IFsh1_TAddress Addr);
**         SetByteFlash - byte IFsh1_SetByteFlash(IFsh1_TAddress Addr, byte Data);
**         SetWordFlash - byte IFsh1_SetWordFlash(IFsh1_TAddress Addr, word Data);
**         GetWordFlash - byte IFsh1_GetWordFlash(IFsh1_TAddress Addr, word *Data);
**         DataPtr2Addr - IFsh1_TAddress IFsh1_DataPtr2Addr(void* Addr);
**         FuncPtr2Addr - IFsh1_TAddress IFsh1_FuncPtr2Addr(void(*Addr)());
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __IFsh1
#define __IFsh1

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* Include inherited components */
#include "Cpu.h"

/* MODULE IFsh1. */

/* FLASH memory size and location in 16-bit words */
#define PROG_FLASH_START               0x00U
#define PROG_FLASH_END                 0x0001FFFFU
#define PROG_FLASH_SECTOR_SIZE         0x0400U
#define PROG_FLASH_PROT_UNIT_SIZE      0x1000U

/* Common data fields for all IntFLASH component's modules */
#ifndef CommonFlashData
  #define CommonFlashData

  /* Flash user mode commands */
  #define ERASE_VERIFY 0x00U
  #define PROGRAM      0x06U
  #define PAGE_ERASE   0x09U
  #define MASS_ERASE   0x08U
#endif /* Common data fields for all IntFLASH component's modules */

#ifndef __BWUserType_IFsh1_TAddress
#define __BWUserType_IFsh1_TAddress
   typedef dword IFsh1_TAddress;       /* Component type for address to the FLASH.*/
#endif
#ifndef __BWUserType_IFsh1_TDataAddress
#define __BWUserType_IFsh1_TDataAddress
  typedef dword IFsh1_TDataAddress;    /* Component type for data address. */
#endif


byte IFsh1_DisableEvent(void);
/*
** ===================================================================
**     Method      :  IFsh1_DisableEvent (component IntFLASH)
**
**     Description :
**         This method disables all the events except <OnSaveBuffer>,
**         <OnRestoreBuffer> and <OnEraseError>. The method is
**         available only if any event is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes: 
**                           - ERR_OK - OK 
**                           - ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte IFsh1_EnableEvent(void);
/*
** ===================================================================
**     Method      :  IFsh1_EnableEvent (component IntFLASH)
**
**     Description :
**         This method enables all the events except <OnSaveBuffer>,
**         <OnRestoreBuffer> and <OnEraseError>. The method is
**         available only if any event is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes: 
**                           - ERR_OK - OK 
**                           - ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

/*
Test the Command complete flag in the flash status register
*/
#define IFsh1_Busy(Block) ((bool)( \
  (getRegBit(FTFL_FSTAT, CCIF)) ? \
  (FALSE) : \
  (TRUE)))
/*
** ===================================================================
**     Method      :  IFsh1_Busy (component IntFLASH)
**
**     Description :
**         Method return status of the FLASH device
**     Parameters  :
**         NAME            - DESCRIPTION
**         Block           - Block number. Not used for Freescale
**                           56800 and HCS12X derivates - any value may be passed.
**     Returns     :
**         ---             - TRUE/FALSE - FLASH is busy/ready
** ===================================================================
*/

byte IFsh1_SetByteFlash(IFsh1_TAddress Addr,byte Data);
/*
** ===================================================================
**     Method      :  IFsh1_SetByteFlash (component IntFLASH)
**
**     Description :
**         Write byte to address in FLASH.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Addr            - Address to FLASH.
**         Data            - Data to write.
**     Returns     :
**         ---             - Error code, possible codes:
**                           - ERR_OK - OK
**                           - ERR_NOTAVAIL - Desired program/erase
**                           operation is not available
**                           - ERR_RANGE - Address is out of range
**                           - ERR_VALUE - Read value is not equal to
**                           written value
**                           - ERR_SPEED - This device does not work
**                           in the active speed mode
** ===================================================================
*/

byte IFsh1_SetWordFlash(IFsh1_TAddress Addr,word Data);
/*
** ===================================================================
**     Method      :  IFsh1_SetWordFlash (component IntFLASH)
**
**     Description :
**         Write word to address in FLASH.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Addr            - Address to FLASH.
**         Data            - Data to write.
**     Returns     :
**         ---             - Error code, possible codes:
**                           - ERR_OK - OK
**                           - ERR_NOTAVAIL - Desired program/erase
**                           operation is not available
**                           - ERR_RANGE - Address is out of range
**                           - ERR_VALUE - Read value is not equal to
**                           written value
**                           - ERR_SPEED - This device does not work
**                           in the active speed mode
** ===================================================================
*/

byte IFsh1_GetWordFlash(IFsh1_TAddress Addr,word *Data);
/*
** ===================================================================
**     Method      :  IFsh1_GetWordFlash (component IntFLASH)
**
**     Description :
**         Get word from address in FLASH.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Addr            - Address to FLASH
**       * Data            - Pointer to returned 16-bit data
**     Returns     :
**         ---             - Error code, possible codes:
**                           - ERR_OK - OK
**                           - ERR_RANGE - Address is out of range
** ===================================================================
*/

byte IFsh1_EraseSector(IFsh1_TAddress Addr);
/*
** ===================================================================
**     Method      :  IFsh1_EraseSector (component IntFLASH)
**
**     Description :
**         Erase sector to which address Addr belongs.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Addr            - Address in FLASH.
**     Returns     :
**         ---             - Error code, possible codes:
**                           - ERR_OK - OK
**                           - ERR_NOTAVAIL - Desired program/erase
**                           operation is not available
**                           - ERR_RANGE - Address is out of range
**                           - ERR_SPEED - This device does not work
**                           in the active speed mode
** ===================================================================
*/

void IFsh1_Init(void);
/*
** ===================================================================
**     Method      :  IFsh1_Init (component IntFLASH)
**
**     Description :
**         Initializes the associated peripheral(s) and the components 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void IFsh1_CommandCompleteInterrupt(void);
/*
** ===================================================================
**     Method      :  IFsh1_CommandCompleteInterrupt (component IntFLASH)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the components event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void IFsh1_ReadCollisionErrorInterrupt(void);
/*
** ===================================================================
**     Method      :  IFsh1_ReadCollisionErrorInterrupt (component IntFLASH)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the components event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define IFsh1_DataPtr2Addr(DataPtr) ((IFsh1_TAddress)(DataPtr))
/*
** ===================================================================
**     Method      :  IFsh1_DataPtr2Addr (component IntFLASH)
**
**     Description :
**         This method converts data pointer to format of a component's
**         method address parameter. Generally a data pointer format is
**         different from format of a method Addr parameter.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Addr            - Data pointer.
**     Returns     :
**         ---             - Address in the format used in the
**                           component methods.
**                           [ Version specific information for 56800
**                           derivatives ] 
**                           The return value is address of a byte
**                           location of the object the input parameter
**                           - pointer pointing at (address of a 16 bit
**                           word location multiplied by 2 and the least
**                           significant bit determines even or odd byte).
** ===================================================================
*/

#define IFsh1_FuncPtr2Addr(FuncPtr) ((IFsh1_TAddress)(FuncPtr))
/*
** ===================================================================
**     Method      :  IFsh1_FuncPtr2Addr (component IntFLASH)
**
**     Description :
**         This method converts function pointer to format of a
**         component's method address parameter. Generally a function
**         pointer format is different from format of a method Addr
**         parameter.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Addr            - Function pointer.
**     Returns     :
**         ---             - Address in the format used in the
**                           component methods.
**                           [ Version specific information for 56800
**                           derivatives ] 
**                           The return value is address of a byte
**                           location of the object the input parameter
**                           - pointer pointing at (address of a 16 bit
**                           word location multiplied by 2 and the least
**                           significant bit determines even or odd byte).
** ===================================================================
*/

/* END IFsh1. */

#endif /* ifndef __IFsh1 */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
