/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : IFsh1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : IntFLASH
**     Version     : Component 02.383, Driver 01.01, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:44, # CodeGen: 13
**     Abstract    :
**         This component "IntFLASH" implements an access to internal FLASH.
**         The component support reading/writing data into FLASH, erasing of
**         selected sector.
**         The component supports events if the write interrupt is supported.
**         The component supports following modes of write operations:
**           - Write - writing without any test.
**           - Destructive write - sector is erased if necessary.
**           - Safe write - user event is invoked to save and resore data
**                          from the current sector.
**         The component requires on-chip FLASH memory (not used/allocated by
**         other components).
**     Settings    :
**         FLASH memory type                 : Program FLASH
**         Memory size                       : 131072 words
**         Sector size                       : 1024 words
**         Interrupt service                 : Enabled
**         Write method                      : Write
**         Wait in RAM                       : no
**     Contents    :
**         DisableEvent - byte IFsh1_DisableEvent(void);
**         EnableEvent  - byte IFsh1_EnableEvent(void);
**         Busy         - bool IFsh1_Busy(byte Block);
**         EraseSector  - byte IFsh1_EraseSector(IFsh1_TAddress Addr);
**         SetByteFlash - byte IFsh1_SetByteFlash(IFsh1_TAddress Addr, byte Data);
**         SetWordFlash - byte IFsh1_SetWordFlash(IFsh1_TAddress Addr, word Data);
**         GetWordFlash - byte IFsh1_GetWordFlash(IFsh1_TAddress Addr, word *Data);
**         DataPtr2Addr - IFsh1_TAddress IFsh1_DataPtr2Addr(void* Addr);
**         FuncPtr2Addr - IFsh1_TAddress IFsh1_FuncPtr2Addr(void(*Addr)());
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/
/* MODULE IFsh1. */

#include "Events.h"
#include "IFsh1.h"

volatile static byte Err;              /* Error state of current process */
volatile static bool EnEvent;          /* Enable/Disable events */
volatile static bool EnWriteEnd;       /* Enable/Disable call write end events */

static word readflash(IFsh1_TAddress address);
static void procflash(IFsh1_TAddress Address, dword Data, byte Command);

/*
** ===================================================================
**     Method      :  IFsh1_OutOfRange (component IntFLASH)
**
**     Description :
**         The method returns FALSE, if both of the input parameters are 
**         in an allowed flash memory address range. If at least one of 
**         the parameters is out of the range, return TRUE.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static bool OutOfRange(IFsh1_TAddress addr1,IFsh1_TAddress addr2)
{
  return (bool)(((addr1 > addr2)||(addr1 < PROG_FLASH_START)||(addr2 > PROG_FLASH_END))? TRUE:FALSE);
}

/*
** ===================================================================
**     Method      :  IFsh1_SectorSize (component IntFLASH)
**
**     Description :
**         The method returns flash memory sector (erase page) size of a 
**         desired area.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#define SectorSize(addr) (PROG_FLASH_SECTOR_SIZE)

/*
** ===================================================================
**     Method      :  ClearFlags (component IntFLASH)
**
**     Description :
**         The method clears the flash memory interface complete and 
**         error flags.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/*
** ===================================================================
**     Method      :  readflash (component IntFLASH)
**
**     Description :
**         The method reads 16-bit word from a flash memory.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
/*lint -save  -e586 Disable MISRA rule (2.1) checking. */
static asm word readflash(IFsh1_TAddress address)
{
  move.l A10,R2                        /* Move given address to pointer register */
  move.w p:(r2)+,y0                    /* Read data from program memory */
  rts
}
/*lint -restore Enable MISRA rule (2.1) checking. */

/*
** ===================================================================
**     Method      :  procflash (component IntFLASH)
**
**     Description :
**         The method programs 16-bit word to a flash memory.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void procflash(IFsh1_TAddress Address, dword Data, byte Command)
{
  if (IFsh1_Busy()) {                  /* Is a command in progress in any of the flash devices? */
    Err = ERR_BUSY;                    /* If yes then set error */
    return;
  }
  *((dword *)(void *)&FTFL_FCCOB3) = (dword)(Address << 1); /* Set program flash address value */
  *((dword *)(void *)&FTFL_FCCOB7) = Data; /* Set data/parameter value */
  setReg8(FTFL_FCCOB0, Command);       /* Write given command to Command register */
  setReg8(FTFL_FSTAT, FTFL_FSTAT_CCIF_MASK); /* launch the command */
  setReg8Bit(FTFL_FCNFG, CCIE);        /* Enable interrupt */
}

/*
** ===================================================================
**     Method      :  WriteWords (component IntFLASH)
**
**     Description :
**         The method writes block of 16-bit words to a flash memory.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static byte WriteWords(IFsh1_TAddress Addr, word* PData, dword Size)
{
  register word i;
  register word* tmpPData = PData;
  register word tmpData;

  Err = ERR_OK;
  if (OutOfRange(Addr, (Addr + Size) - 1U)) { /* Is the address out of range? */
    return ERR_RANGE;                  /* If yes then exit */
  }
  for (i = 0U; i < Size; i++) {        /* For all given data */
    if (readflash(Addr+i) != tmpPData[i]) { /* Is the FLASH programming necessary? */
      if (((Addr+i) & 0x01U) == 0x00U) {
        tmpData = readflash((Addr+i) + 1U);
        procflash((Addr+i), (dword)(((dword)tmpData << 16) | tmpPData[i]), PROGRAM); /* Write new data to Flash */
      } else {
        tmpData = readflash((Addr+i) - 1U);
        procflash(((Addr+i) - 1U), (dword)(tmpData  | ((dword)tmpPData[i] << 16)), PROGRAM); /* Write new data to Flash */
      }
    }
    while(getRegBit(FTFL_FSTAT, CCIF) == 0x00U){} /* Wait to command complete */
    if (Err != ERR_OK) {               /* If an error occurred then exit */
      return Err;
    }
  }
  while(getRegBit(FTFL_FSTAT, CCIF) == 0x00U){} /* Wait to command complete */
  for (i = 0U; i < Size; i++) {        /* Check all given data were written good */
    if (readflash(Addr+i) != tmpPData[i]) {
      return ERR_VALUE;                /* If an error occurred exit */
    }
  }
  EnWriteEnd = TRUE;                   /* Enable call WriteEnd event */
  setReg8Bit(FTFL_FCNFG, CCIE);        /* Enable interrupt */
  return Err;
}

/*
** ===================================================================
**     Method      :  IFsh1_DisableEvent (component IntFLASH)
**
**     Description :
**         This method disables all the events except <OnSaveBuffer>,
**         <OnRestoreBuffer> and <OnEraseError>. The method is
**         available only if any event is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes: 
**                           - ERR_OK - OK 
**                           - ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte IFsh1_DisableEvent(void)
{
  EnEvent = FALSE;                     /* Set the flag "events disabled" */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  IFsh1_EnableEvent (component IntFLASH)
**
**     Description :
**         This method enables all the events except <OnSaveBuffer>,
**         <OnRestoreBuffer> and <OnEraseError>. The method is
**         available only if any event is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes: 
**                           - ERR_OK - OK 
**                           - ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte IFsh1_EnableEvent(void)
{
  EnEvent = TRUE;                      /* Set the flag "events enabled" */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  IFsh1_Busy (component IntFLASH)
**
**     Description :
**         Method return status of the FLASH device
**     Parameters  :
**         NAME            - DESCRIPTION
**         Block           - Block number. Not used for Freescale
**                           56800 and HCS12X derivates - any value may be passed.
**     Returns     :
**         ---             - TRUE/FALSE - FLASH is busy/ready
** ===================================================================
*/
/*
bool IFsh1_Busy(byte Block)

**      This method is implemented as macro. See IFsh1.h file.      **
*/

/*
** ===================================================================
**     Method      :  IFsh1_SetByteFlash (component IntFLASH)
**
**     Description :
**         Write byte to address in FLASH.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Addr            - Address to FLASH.
**         Data            - Data to write.
**     Returns     :
**         ---             - Error code, possible codes:
**                           - ERR_OK - OK
**                           - ERR_NOTAVAIL - Desired program/erase
**                           operation is not available
**                           - ERR_RANGE - Address is out of range
**                           - ERR_VALUE - Read value is not equal to
**                           written value
**                           - ERR_SPEED - This device does not work
**                           in the active speed mode
** ===================================================================
*/
byte IFsh1_SetByteFlash(IFsh1_TAddress Addr, byte Data)
{
  register IFsh1_TAddress Addr16;
  word Data16;
  byte rot;

  Addr16 = (Addr >> 1);                /* Determine WORD16 address */
  rot = (byte)((Addr % 2U) * 8U);
  Data16 = (readflash(Addr16) & ((word)0xFF00U >> rot)) + (((word)Data & 0xFFU) << rot);
  return WriteWords(Addr16, &Data16, sizeof(Data16)/sizeof(word)); /* Write data to FLASH - use block method */
}

/*
** ===================================================================
**     Method      :  IFsh1_SetWordFlash (component IntFLASH)
**
**     Description :
**         Write word to address in FLASH.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Addr            - Address to FLASH.
**         Data            - Data to write.
**     Returns     :
**         ---             - Error code, possible codes:
**                           - ERR_OK - OK
**                           - ERR_NOTAVAIL - Desired program/erase
**                           operation is not available
**                           - ERR_RANGE - Address is out of range
**                           - ERR_VALUE - Read value is not equal to
**                           written value
**                           - ERR_SPEED - This device does not work
**                           in the active speed mode
** ===================================================================
*/
byte IFsh1_SetWordFlash(IFsh1_TAddress Addr,word Data)
{
  return WriteWords(Addr, &Data, sizeof(Data)/sizeof(word)); /* Write data to FLASH - use block method */
}

/*
** ===================================================================
**     Method      :  IFsh1_GetWordFlash (component IntFLASH)
**
**     Description :
**         Get word from address in FLASH.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Addr            - Address to FLASH
**       * Data            - Pointer to returned 16-bit data
**     Returns     :
**         ---             - Error code, possible codes:
**                           - ERR_OK - OK
**                           - ERR_RANGE - Address is out of range
** ===================================================================
*/
byte IFsh1_GetWordFlash(IFsh1_TAddress Addr,word *Data)
{
  if (OutOfRange(Addr, Addr)) {        /* Check range of address */
    return ERR_RANGE;
  }
  *Data = readflash(Addr);             /* read data from FLASH */
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  IFsh1_EraseSector (component IntFLASH)
**
**     Description :
**         Erase sector to which address Addr belongs.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Addr            - Address in FLASH.
**     Returns     :
**         ---             - Error code, possible codes:
**                           - ERR_OK - OK
**                           - ERR_NOTAVAIL - Desired program/erase
**                           operation is not available
**                           - ERR_RANGE - Address is out of range
**                           - ERR_SPEED - This device does not work
**                           in the active speed mode
** ===================================================================
*/
byte IFsh1_EraseSector(IFsh1_TAddress Addr)
{
  Err = ERR_OK;
  if (OutOfRange(Addr, Addr)) {        /* Check range of address */
    return ERR_RANGE;
  }
  procflash((Addr & 0xFFFFFFFEU), 0U, PAGE_ERASE); /* Erase the sector */
  while(getRegBit(FTFL_FSTAT, CCIF) == 0x00U){} /* Wait to command complete */
  return Err;                          /* OK */
}

/*
** ===================================================================
**     Method      :  IFsh1_Init (component IntFLASH)
**
**     Description :
**         Initializes the associated peripheral(s) and the components 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void IFsh1_Init(void)
{
  EnEvent = TRUE;                      /* Enable events */
  EnWriteEnd = FALSE;                  /* Initialize calling write end events flag */
  /* FTFL_FCNFG: CCIE=0,RDCOLLIE=1,ERSAREQ=0,ERSSUSP=0,??=0,PFLSH=0,RAMRDY=0,EEERDY=0 */
  setReg8Bit(FTFL_FCNFG, RDCOLLIE);    /* Enable read collision interrupt */
}

/*
** ===================================================================
**     Method      :  IFsh1_CommandCompleteInterrupt (component IntFLASH)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the components event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void IFsh1_CommandCompleteInterrupt(void)
{
  register byte StatusReg;

  StatusReg = getReg8(FTFL_FSTAT);     /* Get status reg. values */
  clrReg8Bit(FTFL_FCNFG, CCIE);        /* Disable command complete interrupt */
  if ((StatusReg & (FTFL_FSTAT_ACCERR_MASK | FTFL_FSTAT_FPVIOL_MASK)) != 0x00U) {
    setReg8(FTFL_FSTAT, (FTFL_FSTAT_ACCERR_MASK | FTFL_FSTAT_FPVIOL_MASK)); /* Clear error interrupt flags */
    Err = ERR_NOTAVAIL;                /* Set error value to be returned by process function */
    if ((StatusReg & FTFL_FSTAT_FPVIOL_MASK) != 0x00U) {
      Err = ERR_PROTECT;               /* Set error value to be returned by process function */
    }
  } else {
    if (EnWriteEnd) {
      EnWriteEnd = FALSE;              /* Disable call WriteEnd event */
      if (EnEvent) {
        IFsh1_OnWriteEnd();            /* Invoke user event */
      }
    }
  }
}

/*
** ===================================================================
**     Method      :  IFsh1_ReadCollisionErrorInterrupt (component IntFLASH)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the components event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void IFsh1_ReadCollisionErrorInterrupt(void)
{
  Err = ERR_NOTAVAIL;                  /* Set error value to be returned by process function */
  setReg8(FTFL_FSTAT, FTFL_FSTAT_RDCOLERR_MASK); /* Clear read collision error interrupt flag */
}

/*
** ===================================================================
**     Method      :  IFsh1_DataPtr2Addr (component IntFLASH)
**
**     Description :
**         This method converts data pointer to format of a component's
**         method address parameter. Generally a data pointer format is
**         different from format of a method Addr parameter.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Addr            - Data pointer.
**     Returns     :
**         ---             - Address in the format used in the
**                           component methods.
**                           [ Version specific information for 56800
**                           derivatives ] 
**                           The return value is address of a byte
**                           location of the object the input parameter
**                           - pointer pointing at (address of a 16 bit
**                           word location multiplied by 2 and the least
**                           significant bit determines even or odd byte).
** ===================================================================
*/
/*
IFsh1_TAddress IFsh1_DataPtr2Addr(void DataPtr)

**  This method is implemented as a macro. See IFsh1.h file.  **
*/

/*
** ===================================================================
**     Method      :  IFsh1_FuncPtr2Addr (component IntFLASH)
**
**     Description :
**         This method converts function pointer to format of a
**         component's method address parameter. Generally a function
**         pointer format is different from format of a method Addr
**         parameter.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Addr            - Function pointer.
**     Returns     :
**         ---             - Address in the format used in the
**                           component methods.
**                           [ Version specific information for 56800
**                           derivatives ] 
**                           The return value is address of a byte
**                           location of the object the input parameter
**                           - pointer pointing at (address of a 16 bit
**                           word location multiplied by 2 and the least
**                           significant bit determines even or odd byte).
** ===================================================================
*/
/*
IFsh1_TAddress IFsh1_FuncPtr2Addr(void FuncPtr)

**  This method is implemented as a macro. See IFsh1.h file.  **
*/

/* END IFsh1. */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
