/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : FreeCn8
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 08:38, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_FreeCn8 */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "FC81.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define COUNT 3

void main(void)
{
  word Time[COUNT];
  byte err[COUNT];
  byte i;
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/


  TEST1_testStart(&testRec, "Free running 8-bit counter test");

  (void)FC81_Reset();
  for(i=0;i<COUNT;i++) {
    Cpu_Delay100US(100); /* delay 10ms */
    err[i]=FC81_GetTimeUS(&Time[i]);
    if (err[i] == ERR_OVERFLOW)
      FC81_Reset();
  }
  TEST1_testComment(&testRec, "test measured time (5%)");
  for(i=0;i<COUNT;i++) {
    if ( err[i] == ERR_OVERFLOW) {
      TEST1_testFailed(&testRec, "ERR_OVERFLOW");
    }
    else {
      if ((Time[i] < ((i+1)*(10000-500))) || (Time[i] > ((i+1)*(10000+500)))) {
        TEST1_testFailed(&testRec, "");
      } else {
        TEST1_testComment(&testRec, "time OK");
      }  
    }
  }

  TEST1_testEnd(&testRec);

}


/* END demo_FreeCn8 */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
