/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : FC81.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : FreeCntr8
**     Version     : Component 02.076, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:43, # CodeGen: 7
**     Abstract    :
**         This device "FreeCntr8" implements 8-bit Free Running Counter
**     Settings    :
**         Timer name                  : TMRA0 (16-bit)
**         Compare name                : TMRA0_Compare
**         Counter shared              : No
**
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 100000000 Hz
**           Resolution of timer
**             Xtal ticks              : 1200
**             microseconds            : 150
**             seconds (real)          : 0.00015
**             Hz                      : 6667
**             kHz                     : 7
**
**         Initialization:
**              Timer                  : Enabled
**
**         Timer registers
**              Counter                : TMRA_0_CNTR [E145]
**              Mode                   : TMRA_0_CTRL [E146]
**              Run                    : TMRA_0_CTRL [E146]
**              Prescaler              : TMRA_0_CTRL [E146]
**
**         Compare registers
**              Compare                : TMRA_0_COMP1 [E140]
**     Contents    :
**         Reset     - byte FC81_Reset(void);
**         GetTimeUS - byte FC81_GetTimeUS(word *Time);
**         GetTimeMS - byte FC81_GetTimeMS(word *Time);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __FC81
#define __FC81

/* MODULE FC81. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "PE_Timer.h"
#include "Cpu.h"


byte FC81_Reset(void);
/*
** ===================================================================
**     Method      :  FC81_Reset (component FreeCntr8)
**
**     Description :
**         This method clears the counter.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte FC81_GetTimeUS(word *Time);
/*
** ===================================================================
**     Method      :  FC81_GetTimeUS (component FreeCntr8)
**
**     Description :
**         Returns the time (as a 16-bit unsigned integer) in microseconds
**         since the last resetting after the last reset.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Time            - A pointer to the returned 16-bit value
**                           in microseconds
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_OVERFLOW - Software counter overflow
**                           ERR_MATH - Overflow during evaluation
** ===================================================================
*/

byte FC81_GetTimeMS(word *Time);
/*
** ===================================================================
**     Method      :  FC81_GetTimeMS (component FreeCntr8)
**
**     Description :
**         Returns the time (as a 16-bit unsigned integer) in milliseconds
**         since the last resetting after the last reset.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Time            - A pointer to the returned 16-bit value
**                           in milliseconds
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_OVERFLOW - Software counter overflow
**                           ERR_MATH - Overflow during evaluation
** ===================================================================
*/

void FC81_Init(void);
/*
** ===================================================================
**     Method      :  FC81_Init (component FreeCntr8)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void FC81_Interrupt(void);
/*
** ===================================================================
**     Method      :  FC81_Interrupt (component FreeCntr8)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/* END FC81. */

#endif /* ifndef __FC81 */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
