/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : PE_Timer.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : PE_Timer
**     Version     : Driver 01.04
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:42, # CodeGen: 7
**     Abstract    :
**         This module "PE_Timer" implements internal methods and definitions
**         used by components working with timers.
**     Settings    :
**     Contents    :
**         No public methods
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE PE_Timer. */

#include "PE_Timer.h"

typedef dword UINT32;

typedef union {
  UINT32 val;
  struct {
    word lo16,hi16;
  } s;
} OP_UINT32;

typedef struct {
  word dummy;
  word midlo16,midhi16;
} M_UINT32;

typedef struct {
  UINT32 lo32, hi32;
} UINT64;

typedef union {
  UINT64 val;
  M_UINT32 m; 
} OP_UINT64;

/*
** ===================================================================
**     Method      :  PE_Timer_LngMul (component PE_Timer)
**
**     Description :
**         32bits number x 32bits number -> 64bits number. The method is 
**         called automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PE_Timer_LngMul(dword va1, dword va2, dlong *var)
{
  OP_UINT32 *va = (void*)&va1;
  OP_UINT32 *vb = (void*)&va2;
  OP_UINT64 *vr = (void*)var;
  
  vr->val.hi32 = 0UL;
  vr->val.lo32 = ((UINT32)va->s.lo16)*((UINT32)vb->s.lo16);
  {
    OP_UINT32 tmp;
    OP_UINT32 register tmpx;
    
    tmp.val = ((UINT32)va->s.lo16)*((UINT32)vb->s.hi16);

    tmpx.s.lo16 = vr->m.midlo16;
    tmpx.s.hi16 = vr->m.midhi16;
    tmpx.val += (UINT32)tmp.s.lo16;
    vr->m.midlo16 = tmpx.s.lo16;
    vr->m.midhi16 = tmpx.s.hi16;

    vr->val.hi32 += (UINT32)tmp.s.hi16;
  }
  {
    OP_UINT32 tmp;
    OP_UINT32 register tmpx;
    
    tmp.val = ((UINT32)va->s.hi16)*((UINT32)vb->s.lo16);

    tmpx.s.lo16 = vr->m.midlo16;
    tmpx.s.hi16 = vr->m.midhi16;
    tmpx.val += (UINT32)tmp.s.lo16;
    vr->m.midlo16 = tmpx.s.lo16;
    vr->m.midhi16 = tmpx.s.hi16;

    vr->val.hi32 += (UINT32)tmp.s.hi16;
  }
  vr->val.hi32 += ((UINT32)va->s.hi16)*((UINT32)vb->s.hi16);
}

/*
** ===================================================================
**     Method      :  PE_Timer_LngHi2 (component PE_Timer)
**
**     Description :
**         64bits number / 2^24 -> 16bits number. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
bool PE_Timer_LngHi2(dword Low, dword High, word *Out) 
{
  if (High == 0U) {
    if ((Low & 0x8000U) != 0U) {
      if ((Low >> 16U) < 0xFFFFU) {
        *Out = ((word)(Low >> 16U))+1U;
        return FALSE;
      }  
    }
    else {
      *Out = (word)(Low >> 16U);
      return FALSE;
    }
  }
  *Out = (word)(Low >> 16U);
  return TRUE;
}

/*
** ===================================================================
**     Method      :  PE_Timer_LngHi4 (component PE_Timer)
**
**     Description :
**         64bits number / 2^40 -> 16bits number. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
bool PE_Timer_LngHi4(dword Low, dword High, word *Out) 
{
  if ((High >> 16U) == 0U) {
    if ((Low & 0x80000000UL) != 0U) {
      if (High < 0xFFFFU) {
        *Out = ((word)High)+1U;
        return FALSE;
      }  
    }  
    else { 
      *Out = (word)High;
      return FALSE;
    }
  }
  *Out = (word)High;
  return TRUE;
}

/* END PE_Timer. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
