/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : FC161.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : FreeCntr16
**     Version     : Component 02.074, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:41, # CodeGen: 7
**     Abstract    :
**         This device "FreeCntr16" implements 16-bit Free Running Counter
**     Settings    :
**         Timer name                  : TMRA0 (16-bit)
**         Compare name                : TMRA0_Compare
**         Counter shared              : No
**
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 100000000 Hz
**           Resolution of timer
**             Xtal ticks              : 1600
**             microseconds            : 200
**             seconds (real)          : 0.0002
**             Hz                      : 5000
**             kHz                     : 5
**
**         Initialization:
**              Timer                  : Enabled
**
**         Timer registers
**              Counter                : TMRA_0_CNTR [E145]
**              Mode                   : TMRA_0_CTRL [E146]
**              Run                    : TMRA_0_CTRL [E146]
**              Prescaler              : TMRA_0_CTRL [E146]
**
**         Compare registers
**              Compare                : TMRA_0_COMP1 [E140]
**     Contents    :
**         Reset     - byte FC161_Reset(void);
**         GetTimeUS - byte FC161_GetTimeUS(word *Time);
**         GetTimeMS - byte FC161_GetTimeMS(word *Time);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE FC161. */

#include "FC161.h"

static word TTicks;                    /* Counter of timer ticks */
static word LTicks;                    /* Working copy of variable TTicks */
static bool TOvf;                      /* Counter overflow flag */
static bool LOvf;                      /* Working copy of variable TOvf */

/* Internal method prototypes */
static void LoadTicks(void);
static void SetCV(word Val);
static void SetPV(byte Val);

/*
** ===================================================================
**     Method      :  SetCV (component FreeCntr16)
**
**     Description :
**         Sets compare or preload register value. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetCV(word Val)
{
  EnterCritical();                     /* Disable global interrupts */
  setReg(TMRA_0_CMPLD1,Val);           /* Store given value to the compare preload 1 register */
  setReg(TMRA_0_CMPLD2,Val);           /* Store given value to the compare preload 2 register */
  ExitCritical();                      /* Enable global interrupts */
}

/*
** ===================================================================
**     Method      :  SetPV (component FreeCntr16)
**
**     Description :
**         Sets prescaler value. The method is called automatically as a 
**         part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  setRegBitGroup(TMRA_0_CTRL,PCS,Val); /* Store given value to the prescaler */
  setReg(TMRA_0_CNTR,0);               /* Reset counter */
}

/*
** ===================================================================
**     Method      :  LoadTicks (component FreeCntr16)
**
**     Description :
**         Loads actual number of timer ticks from internal variable. The 
**         method is called automatically as a part of several internal 
**         methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void LoadTicks(void)
{
  EnterCritical();                     /* Disable global interrupts */
  LTicks = TTicks;                     /* Loading actual number of timer ticks */
  LOvf = TOvf;                         /* Loading actual state of "overflow flag" */
  ExitCritical();                      /* Enable global interrupts */
}

/*
** ===================================================================
**     Method      :  FC161_Reset (component FreeCntr16)
**
**     Description :
**         This method clears the counter.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte FC161_Reset(void)
{
  EnterCritical();                     /* Disable global interrupts */
  setReg(TMRA_0_CNTR,0x00);            /* Reset counter register */
  TTicks =  0U;                        /* Reset counter of timer ticks */
  TOvf = FALSE;                        /* Reset counter overflow flag */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  FC161_GetTimeUS (component FreeCntr16)
**
**     Description :
**         Returns the time (as a 16-bit unsigned integer) in microseconds
**         since the last resetting after the last reset.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Time            - A pointer to the returned 16-bit value
**                           in microseconds
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_OVERFLOW - Software counter overflow
**                           ERR_MATH - Overflow during evaluation
** ===================================================================
*/
byte FC161_GetTimeUS(word *Time)
{
  dlong rtval;                         /* Result of two 32-bit numbers multiplication */

  LoadTicks();                         /* Load actual state of counter */
  if (LOvf) {                          /* Testing counter overflow */
    return ERR_OVERFLOW;               /* If yes then error */
  }
  PE_Timer_LngMul((dword)LTicks,0xC8000000UL,&rtval); /* Multiply ticks and high speed CPU mode coefficient */
  if (PE_Timer_LngHi3(rtval[0],rtval[1],Time)) { /* Is the result greater or equal than 65536 ? */
    return ERR_MATH;                   /* If yes then error */
  }
  else {                               /* Is the result less than 65536 ? */
    return ERR_OK;                     /* If yes then OK */
  }
}

/*
** ===================================================================
**     Method      :  FC161_GetTimeMS (component FreeCntr16)
**
**     Description :
**         Returns the time (as a 16-bit unsigned integer) in milliseconds
**         since the last resetting after the last reset.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Time            - A pointer to the returned 16-bit value
**                           in milliseconds
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_OVERFLOW - Software counter overflow
**                           ERR_MATH - Overflow during evaluation
** ===================================================================
*/
byte FC161_GetTimeMS(word *Time)
{
  dlong rtval;                         /* Result of two 32-bit numbers multiplication */

  LoadTicks();                         /* Load actual state of counter */
  if (LOvf) {                          /* Testing counter overflow */
    return ERR_OVERFLOW;               /* If yes then error */
  }
  PE_Timer_LngMul((dword)LTicks,0x33333333UL,&rtval); /* Multiply ticks and high speed CPU mode coefficient */
  if (PE_Timer_LngHi4(rtval[0],rtval[1],Time)) { /* Is the result greater or equal than 65536 ? */
    return ERR_MATH;                   /* If yes then error */
  }
  else {                               /* Is the result less than 65536 ? */
    return ERR_OK;                     /* If yes then OK */
  }
}

/*
** ===================================================================
**     Method      :  FC161_Init (component FreeCntr16)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void FC161_Init(void)
{
  /* TMRA_0_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=1,DIR=0,COINIT=0,OUTMODE=4 */
  setReg(TMRA_0_CTRL,0x24);            /* Stop timer, use alternating compare registers */
  /* TMRA_0_SCTRL: TCF=0,TCFIE=1,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMRA_0_SCTRL,0x4000);
  setReg(TMRA_0_CNTR,0x00);            /* Reset counter register */
  setReg(TMRA_0_LOAD,0x00);            /* Reset load register */
  setReg(TMRA_0_COMP1,0x4E1F);         /* Set up compare 1 register */
  setReg(TMRA_0_COMP2,0x4E1F);         /* Set up compare 2 register */
  /* TMRA_0_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,ROC=0,TCI=0,UP=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=1,CL1=2 */
  setReg(TMRA_0_CSCTRL,0x06);          /* Enable compare 1 interrupt */
  TTicks = 0U;                         /* Counter of timer ticks */
  TOvf = FALSE;                        /* Counter overflow flag */
  SetCV((word)0x4E1F);                 /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV((byte)0x08);                   /* Set prescaler register according to the selected high speed CPU mode */
  setRegBitGroup(TMRA_0_CTRL,CM,0x01); /* Run counter */
}

/*
** ===================================================================
**     Method      :  FC161_Interrupt (component FreeCntr16)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp 
void FC161_Interrupt(void)
{
  clrRegBit(TMRA_0_SCTRL,TCF);         /* Reset interrupt request flag */
  TTicks++;                            /* Increment counter of timer ticks */
  if (TTicks == 0U) {                  /* Testing counter overflow */
    TOvf = TRUE;                       /* If yes then set overflow flag */
  }
}

/* END FC161. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
