/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : FreeCn
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 08:21, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_FreeCn */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "FC1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define CNT_TICKS (FC1_COUNTER_INPUT_CLOCK * 0.001) /* Expected value of counter after 1 ms */
#define DEV (CNT_TICKS / 20) /* allowed deviation 5% */

void main(void)
{
  word time,time0;
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/


  TEST1_testStart(&testRec, "Free running counter test");

  FC1_Reset(); /* reset the counter */
  (void)FC1_GetCounterValue(&time0);
  Cpu_Delay100US(10); /* delay 1 ms */
  (void)FC1_GetCounterValue(&time); /* read counter */
  
  
  TEST1_testComment(&testRec, "test measured time (5%)");
  if ((time < (CNT_TICKS-DEV)) || (time > (CNT_TICKS + DEV))) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "time OK");
  }  

  TEST1_testEnd(&testRec);

  for(;;) {}

}

/* END demo_FreeCn */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
