/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : EvntCn32
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-06, 16:46, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_EvntCn32 */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "EC321.h"
#include "PS1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

void main(void)
{
  test_sRec testRec;
  dword event;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/


  TEST1_testStart(&testRec, "EventCounter32 test");
  TEST1_testComment(&testRec, "Please interconnect pins GPIOC3_TA0_CMPA_O_RXD0 and GPIOC4_TA1_CMPB_O.");

  
  overflow = FALSE;

  end = FALSE;
  event = 0;

  TEST1_testComment(&testRec, "Bean PulseStream will generate 65535 pulses");
  EC321_Enable(); 							  /* start measurement */
  PS1_Enable();                               /* start pulse generation */
  
  while (!end) {}                             /* wait for last puls */

  TEST1_testComment(&testRec, "test EventCntr32 OnEnd event");
  if (overflow) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "OK");
  }  
  TEST1_testComment(&testRec, "EventCntr32 counter");
  EC321_GetNumEvents(&event);
  if (event!=65535) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of pulses OK");
  }  

  TEST1_testComment(&testRec, "Bean PulseStream will generate 2 pulse");
  end = FALSE;
  PS1_SetNumOfPulses(2);
  PS1_Enable();
  while (!end) {}                             /* wait for puls */
  TEST1_testComment(&testRec, "test EventCntr32 OnEnd");
  if (overflow) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "OK");
  }  
  TEST1_testComment(&testRec, "EventCntr32 counter");
  EC321_GetNumEvents(&event);
  if (event!=65537) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of pulses OK");
  }  


  TEST1_testComment(&testRec, "Bean PulseStream will generate 1 pulse");
  end = FALSE;
  PS1_SetNumOfPulses(1);
  PS1_Enable();
  while (!end) {}                             /* wait for puls */
  TEST1_testComment(&testRec, "test EventCntr32 OnEnd");
  if (!overflow) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "OK");
  }  
  TEST1_testComment(&testRec, "EventCntr32 counter");
  EC321_GetNumEvents(&event);
  if (event!=0) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of pulses OK");
  }  


  TEST1_testEnd(&testRec);

}

/* END demo_EvntCn32 */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
