/** ###################################################################
**     Filename    : Events.h
**     Project     : EvntCn32
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-06, 16:46, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/

#ifndef __Events_H
#define __Events_H
/* MODULE Events */

#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "EC321.h"
#include "PS1.h"
#include "TEST1.h"

extern bool end;
extern bool overflow;

void PS1_OnEnd(void);
/*
** ===================================================================
**     Event       :  PS1_OnEnd (module Events)
**
**     Component   :  PS1 [PulseStream]
**     Description :
**         This event is called after all pulses have been generated (only
**         if the events are enabled - <"EnableEvent">). The event
**         may be selected only if interrupt service is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void EC321_OnEnd(void);
/*
** ===================================================================
**     Event       :  EC321_OnEnd (module Events)
**
**     Component   :  EC321 [EventCntr32]
**     Description :
**         This event is called when the specified number of iterations
**         is generated. This event is available only if a <interrupt
**         service/event> is enabled, the bean is in <Repetitive mode>
**         and is enabled - <Enable> and the events are enabled -
**         <EnableEvent>.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/


/* END Events */
#endif /* __Events_H*/

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
