/** ###################################################################
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* File: test.h */

#ifndef __TEST_H
#define __TEST_H

#include "port.h"

#ifdef __cplusplus
extern "C" {
#endif


/*******************************************************
* Test Package
*******************************************************/

#define TEST_NAME_MAX_LEN 60

typedef struct {
  bool  passed;
  bool  completed;
  char  name[TEST_NAME_MAX_LEN];
} test_sRec;

EXPORT void    testStart   (test_sRec *pTest, const char *pName);

EXPORT void    testFailed  (test_sRec *pTest, const char *pMsg);

EXPORT void    testComment (test_sRec *pTest, const char *pMsg);

EXPORT void    testEnd     (test_sRec *pTest);

EXPORT void    testPrintString (const char *pMsg);

#ifdef __cplusplus
}
#endif

#endif
