/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : DMA
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-06, 11:20, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_DMA */

/* Including used modules for compilling procedure */
#include "Cpu.h"
#include "Events.h"
#include "DMA.h"
#include "TEST1.h"
/* Include shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include <stdio.h>

#define BLOCK_LENGTH  10

byte DMA_OutBuffer[BLOCK_LENGTH];
byte DMA_InpBuffer[BLOCK_LENGTH];
byte i;
volatile bool OnComplete = FALSE;
bool cmpFailed;

void main(void)
{
  test_sRec testRec;

  
  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "DMAChannel test");
  //
  for (i=0;i<BLOCK_LENGTH;i++) {
    DMA_OutBuffer[i] = i;
    DMA_InpBuffer[i] = 0xff;
  }
  //
  TEST1_testComment(&testRec, "Transmitting data block ...");
  //
  DMA_SetSourceAddress(DMA_OutBuffer);
  DMA_SetDestinationAddress(DMA_InpBuffer);
  DMA_Start();
  //
  while ( !DMA_GetCompleteStatus() ) {}
  //
  TEST1_testComment(&testRec, "PASSED");
  //
  TEST1_testComment(&testRec, "Comparing received/sent data ...");
  cmpFailed = FALSE;
  for (i=0;i<BLOCK_LENGTH;i++) {
    if (DMA_InpBuffer[i] !=  DMA_OutBuffer[i]) {
      cmpFailed = TRUE;
    } 
  }
  if (cmpFailed) {
    TEST1_testFailed(&testRec, "Comparing received/sent data failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }  
  //
  TEST1_testComment(&testRec, "Testing OnComplete event ...");
  if (!OnComplete) {
    TEST1_testFailed(&testRec, "Testing OnComplete event failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }  
  //
  TEST1_testEnd(&testRec);
  //
}

/* END demo_DMA */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
