/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Byte1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : ByteIO
**     Version     : Component 02.058, Driver 01.21, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:30, # CodeGen: 8
**     Abstract    :
**         This component "ByteIO" implements an one-byte input/output.
**         It uses one 8-bit port.
**         Methods of this component are mostly implemented as a macros 
**         (if supported by target langauage and compiler).
**     Settings    :
**         Port name                   : GPIOA_Low
**
**         Initial direction           : Output (direction can be changed)
**         Safe mode                   : yes
**         Initial output value        : 0 = 000H
**         Initial pull option         : off
**
**         8-bit data register         : GPIOA_DR  [E201]
**         8-bit control register      : GPIOA_DDR [E202]
**         8-bit function register     : GPIOA_PER [E203]
**
**             ----------------------------------------------------
**                   Bit     |   Pin   |   Name
**             ----------------------------------------------------
**                    0      |    22   |   GPIOA0/ANA0/CMPA_IN3/CMPC_O
**                    1      |    23   |   GPIOA1/ANA1/CMPA_IN0
**                    2      |    24   |   GPIOA2/ANA2/VREFHA/CMPA_IN1
**                    3      |    25   |   GPIOA3/ANA3/VREFLA/CMPA_IN2
**                    4      |    21   |   GPIOA4/ANA4/ANC8/CMPD_IN0
**                    5      |    20   |   GPIOA5/ANA5/ANC9
**                    6      |    19   |   GPIOA6/ANA6/ANC10
**                    7      |    17   |   GPIOA7/ANA7/ANC11
**             ----------------------------------------------------
**     Contents    :
**         GetDir    - bool Byte1_GetDir(void);
**         SetDir    - void Byte1_SetDir(bool Dir);
**         SetInput  - void Byte1_SetInput(void);
**         SetOutput - void Byte1_SetOutput(void);
**         GetVal    - byte Byte1_GetVal(void);
**         PutVal    - void Byte1_PutVal(byte Val);
**         GetBit    - bool Byte1_GetBit(byte Bit);
**         PutBit    - void Byte1_PutBit(byte Bit, bool Val);
**         SetBit    - void Byte1_SetBit(byte Bit);
**         ClrBit    - void Byte1_ClrBit(byte Bit);
**         NegBit    - void Byte1_NegBit(byte Bit);
**         GetRawVal - byte Byte1_GetRawVal(void);
**         GetRawBit - bool Byte1_GetRawBit(byte Bit);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __Byte1_H
#define __Byte1_H

/* MODULE Byte1. */

/*Including shared modules, which are used in the whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"


#define Byte1_PORT_MASK         ((byte)0xFF) /* Port mask */

/*
** ===================================================================
**     Method      :  Byte1_GetVal (component ByteIO)
**
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pins and returns it
**           b) direction = Output : returns the last written value
**     Parameters  : None
**     Returns     :
**         ---        - Input value (0 to 255)
** ===================================================================
*/
#define Byte1_GetVal() ((byte)(getReg(GPIOA_DR) & 0xFF))

/*
** ===================================================================
**     Method      :  Byte1_PutVal (component ByteIO)
**
**     Description :
**         This method writes the new output value.
**           a) direction = Input  : sets the new output value;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes the value to the
**                                   appropriate pins
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val        - Output value (0 to 255)
**     Returns     : Nothing
** ===================================================================
*/
void Byte1_PutVal(byte Val);

/*
** ===================================================================
**     Method      :  Byte1_GetBit (component ByteIO)
**
**     Description :
**         This method returns the specified bit of the input value.
**           a) direction = Input  : reads the input value from pins
**                                   and returns the specified bit
**           b) direction = Output : returns the specified bit
**                                   of the last written value
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to read (0 to 7)
**     Returns     :
**         ---        - Value of the specified bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
** ===================================================================
*/
bool Byte1_GetBit(byte Bit);

/*
** ===================================================================
**     Method      :  Byte1_PutBit (component ByteIO)
**
**     Description :
**         This method writes the new value to the specified bit
**         of the output value.
**           a) direction = Input  : sets the value of the specified
**                                   bit; this operation will be
**                                   shown on output after the
**                                   direction has been switched to
**                                   output (SetDir(TRUE);)
**           b) direction = Output : directly writes the value of the
**                                   bit to the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit (0 to 7)
**         Val        - New value of the bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
**     Returns     : Nothing
** ===================================================================
*/
void Byte1_PutBit(byte Bit, bool Val);

/*
** ===================================================================
**     Method      :  Byte1_SetBit (component ByteIO)
**
**     Description :
**         This method sets (sets to one) the specified bit of the
**         output value.
**         [ It is the same as "PutBit(Bit,TRUE);" ]
**           a) direction = Input  : sets the specified bit to "1";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "1" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to set (0 to 7)
**     Returns     : Nothing
** ===================================================================
*/
void Byte1_SetBit(byte Bit);

/*
** ===================================================================
**     Method      :  Byte1_ClrBit (component ByteIO)
**
**     Description :
**         This method clears (sets to zero) the specified bit
**         of the output value.
**         [ It is the same as "PutBit(Bit,FALSE);" ]
**           a) direction = Input  : sets the specified bit to "0";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   beenswitched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "0" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to clear (0 to 7)
**     Returns     : Nothing
** ===================================================================
*/
void Byte1_ClrBit(byte Bit);

/*
** ===================================================================
**     Method      :  Byte1_NegBit (component ByteIO)
**
**     Description :
**         This method negates (inverts) the specified bit of the
**         output value.
**           a) direction = Input  : inverts the specified bit;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly inverts the value
**                                   of the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to invert (0 to 7)
**     Returns     : Nothing
** ===================================================================
*/
void Byte1_NegBit(byte Bit);

/*
** ===================================================================
**     Method      :  Byte1_SetDir (component ByteIO)
**
**     Description :
**         This method sets direction of the component.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Dir        - Direction to set (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
**     Returns     : Nothing
** ===================================================================
*/
void Byte1_SetDir(bool Dir);

/*
** ===================================================================
**     Method      :  Byte1_SetInput (component ByteIO)
**
**     Description :
**         This method sets direction of the component to input.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#define Byte1_SetInput() (\
  clrRegBits(GPIOA_DDR,Byte1_PORT_MASK) /* Set direction to input */ \
)

/*
** ===================================================================
**     Method      :  Byte1_SetOutput (component ByteIO)
**
**     Description :
**         This method sets direction of the component to output.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Byte1_SetOutput(void);

/*
** ===================================================================
**     Method      :  Byte1_GetDir (component ByteIO)
**
**     Description :
**         This method returns direction of the component.
**     Parameters  : None
**     Returns     :
**         ---        - Direction of the component (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
** ===================================================================
*/
#define Byte1_GetDir() ((bool)(getRegBits(GPIOA_DDR,0xFF)))

/*
** ===================================================================
**     Method      :  Byte1_GetRawVal (component ByteIO)
**
**     Description :
**         Returns the value of the port. The method uses raw data
**         input register, i.e., a register that always reads back the
**         status of the port regardless of the port direction. The
**         method is available only if raw data input is supported by
**         the port.
**     Parameters  : None
**     Returns     :
**         ---             - Input value
** ===================================================================
*/
#define Byte1_GetRawVal() ((byte)(getReg(GPIOA_RAWDATA) & 0xFF))

/*
** ===================================================================
**     Method      :  Byte1_GetRawBit (component ByteIO)
**
**     Description :
**         Returns the value of the specified bit/pin. The method uses
**         raw data input register, i.e., a register that always reads
**         back the status of the port regardless of the port direction.
**         The method is available only if raw data input is supported
**         by the port.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Bit             - Bit/pin number to read.
**     Returns     :
**         ---             - Input value. Possible values:
**                           <false> - logical "0" (Low level)
**                           <true> - logical "1" (High level)
** ===================================================================
*/
bool Byte1_GetRawBit(byte Bit);

/* END Byte1. */

#endif /* __Byte1_H*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
