/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Bt21.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : Byte2IO
**     Version     : Component 02.054, Driver 01.21, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:27, # CodeGen: 9
**     Abstract    :
**         This component "Byte2IO" implements a two-byte input/output.
**         It uses two 8-bit ports.
**     Settings    :
**         1st 8-bit port name (LSB)   : GPIOF_Low
**         2nd 8-bit port name (MSB)   : GPIOC_Low
**
**         Initial direction           : Output (direction can be changed)
**         Safe mode                   : yes
**         Initial output value        : 0 = 00000H
**         Initial pull option         : off
**
**         1st 8-bit data register     : GPIOF_DR  [E251]
**         2nd 8-bit data register     : GPIOC_DR  [E221]
**         1st 8-bit control register  : GPIOF_DDR [E252]
**         2nd 8-bit control register  : GPIOC_DDR [E222]
**         1st 8-bit function register : GPIOF_PER [E253]
**         2nd 8-bit function register : GPIOC_PER [E223]
**
**             ----------------------------------------------------
**                   Bit     |   Pin   |   Name
**             ----------------------------------------------------
**                    0      |    55   |   GPIOF0/XB_IN6/TB2/SCK1
**                    1      |    77   |   GPIOF1/CLKO1/XB_IN7/CMPD_O
**                    2      |    60   |   GPIOF2/SCL1/XB_OUT6
**                    3      |    61   |   GPIOF3/SDA1/XB_OUT7
**                    4      |    62   |   GPIOF4/TXD1/XB_OUT8
**                    5      |    63   |   GPIOF5/RXD1/XB_OUT9
**                    6      |    94   |   GPIOF6/TB2/PWMA_3X/PWMB_3X/XB_IN2
**                    7      |    95   |   GPIOF7/TB3/CMPC_O/SS1_B/XB_IN3
**                    8      |    3    |   GPIOC0/EXTAL/CLKIN0
**                    9      |    4    |   GPIOC1/XTAL
**                    10     |    5    |   GPIOC2/TXD0/TB0/XB_IN2/CLKO0
**                    11     |    11   |   GPIOC3/TA0/CMPA_O/RXD0/CLKIN1
**                    12     |    12   |   GPIOC4/TA1/CMPB_O/XB_IN8/EWM_OUT_B
**                    13     |    27   |   GPIOC5/DACO/XB_IN7
**                    14     |    49   |   GPIOC6/TA2/XB_IN3/CMP_REF
**                    15     |    50   |   GPIOC7/SS0_B/TXD0
**             ----------------------------------------------------
**     Contents    :
**         GetDir    - bool Bt21_GetDir(void);
**         SetDir    - void Bt21_SetDir(bool Dir);
**         SetInput  - void Bt21_SetInput(void);
**         SetOutput - void Bt21_SetOutput(void);
**         GetVal    - word Bt21_GetVal(void);
**         PutVal    - void Bt21_PutVal(word Val);
**         GetBit    - bool Bt21_GetBit(byte Bit);
**         PutBit    - void Bt21_PutBit(byte Bit, bool Val);
**         SetBit    - void Bt21_SetBit(byte Bit);
**         ClrBit    - void Bt21_ClrBit(byte Bit);
**         NegBit    - void Bt21_NegBit(byte Bit);
**         GetRawVal - word Bt21_GetRawVal(void);
**         GetRawBit - bool Bt21_GetRawBit(byte Bit);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __Bt21_H
#define __Bt21_H

/* MODULE Bt21. */

/*Including shared modules, which are used in the whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"


#define Bt21_LOW_PORT_MASK      (byte)0xFF /* Low port mask */
#define Bt21_HIGH_PORT_MASK     (byte)0xFF /* High port mask */

/*
** ===================================================================
**     Method      :  Bt21_GetVal (component Byte2IO)
**
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pins and returns it
**           b) direction = Output : returns the last written value
**     Parameters  : None
**     Returns     :
**         ---        - Input value (0 to 65535)
** ===================================================================
*/
#define Bt21_GetVal() ( \
/*lint -save  -e740 -e931 Disable MISRA rule (1.2) checking. Order of register access is not important for IO access. */\
  ((getReg(GPIOC_DR)) << 8) | ((getReg(GPIOF_DR)) & Bt21_LOW_PORT_MASK) \
/*lint -restore Enable MISRA rule (1.2) checking. */\
)

/*
** ===================================================================
**     Method      :  Bt21_PutVal (component Byte2IO)
**
**     Description :
**         This method writes the new output value.
**           a) direction = Input  : sets the new output value;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes the value to the
**                                   appropriate pins
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val        - Output value (0 to 65535)
**     Returns     : Nothing
** ===================================================================
*/
void Bt21_PutVal(word Val);

/*
** ===================================================================
**     Method      :  Bt21_GetBit (component Byte2IO)
**
**     Description :
**         This method returns the specified bit of the input value.
**           a) direction = Input  : reads the input value from pins
**                                   and returns the specified bit
**           b) direction = Output : returns the specified bit
**                                   of the last written value
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to read (0 to 15)
**     Returns     :
**         ---        - Value of the specified bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
** ===================================================================
*/
bool Bt21_GetBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt21_PutBit (component Byte2IO)
**
**     Description :
**         This method writes the new value to the specified bit
**         of the output value.
**           a) direction = Input  : sets the value of the specified
**                                   bit; this operation will be
**                                   shown on output after the
**                                   direction has been switched to
**                                   output (SetDir(TRUE);)
**           b) direction = Output : directly writes the value of the
**                                   bit to the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit (0 to 15)
**         Val        - New value of the bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
**     Returns     : Nothing
** ===================================================================
*/
void Bt21_PutBit(byte Bit, bool Val);

/*
** ===================================================================
**     Method      :  Bt21_SetBit (component Byte2IO)
**
**     Description :
**         This method sets (sets to one) the specified bit of the
**         output value.
**         [ It is the same as "PutBit(Bit,TRUE);" ]
**           a) direction = Input  : sets the specified bit to "1";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "1" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to set (0 to 15)
**     Returns     : Nothing
** ===================================================================
*/
void Bt21_SetBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt21_ClrBit (component Byte2IO)
**
**     Description :
**         This method clears (sets to zero) the specified bit
**         of the output value.
**         [ It is the same as "PutBit(Bit,FALSE);" ]
**           a) direction = Input  : sets the specified bit to "0";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   beenswitched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "0" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to clear (0 to 15)
**     Returns     : Nothing
** ===================================================================
*/
void Bt21_ClrBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt21_NegBit (component Byte2IO)
**
**     Description :
**         This method negates (inverts) the specified bit of the
**         output value.
**           a) direction = Input  : inverts the specified bit;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly inverts the value
**                                   of the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to invert (0 to 15)
**     Returns     : Nothing
** ===================================================================
*/
void Bt21_NegBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt21_SetDir (component Byte2IO)
**
**     Description :
**         This method sets direction of the component.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Dir        - Direction to set (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
**     Returns     : Nothing
** ===================================================================
*/
void Bt21_SetDir(bool Dir);

/*
** ===================================================================
**     Method      :  Bt21_SetInput (component Byte2IO)
**
**     Description :
**         This method sets direction of the component to input.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#define Bt21_SetInput() (\
  clrRegBits(GPIOF_DDR,Bt21_LOW_PORT_MASK), /* Set direction to input */ \
  clrRegBits(GPIOC_DDR,Bt21_HIGH_PORT_MASK) /* Set direction to input */ \
)

/*
** ===================================================================
**     Method      :  Bt21_SetOutput (component Byte2IO)
**
**     Description :
**         This method sets direction of the component to output.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Bt21_SetOutput(void);

/*
** ===================================================================
**     Method      :  Bt21_GetDir (component Byte2IO)
**
**     Description :
**         This method returns direction of the component.
**     Parameters  : None
**     Returns     :
**         ---        - Direction of the component (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
** ===================================================================
*/
#define Bt21_GetDir() (bool)(getRegBits(GPIOF_DDR,0xFF))

/*
** ===================================================================
**     Method      :  Bt21_GetRawVal (component Byte2IO)
**
**     Description :
**         Returns the value of the ports. The method uses raw data
**         input register, i.e., a register that always reads back
**         the status of the port regardless of the port direction.
**         The method is available only if raw data input is
**         supported by all selected ports.
**     Parameters  : None
**     Returns     :
**         ---             - Input value
** ===================================================================
*/
#define Bt21_GetRawVal() (\
/*lint -save  -e740 -e931 Disable MISRA rule (1.2) checking. Order of register access is not important for IO access. */\
  ((getReg(GPIOC_RAWDATA)) << 8) | ((getReg(GPIOF_RAWDATA)) & Bt21_LOW_PORT_MASK)\
/*lint -restore Enable MISRA rule (1.2) checking. */\
)

/*
** ===================================================================
**     Method      :  Bt21_GetRawBit (component Byte2IO)
**
**     Description :
**         Returns the value of the specified bit/pin. The method
**         uses raw data input register, ie. a register that always
**         reads back the status of the port regardless of the port
**         direction. The method is available only if raw data input
**         is supported by all selected ports.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Bit             - Bit/pin number to read.
**     Returns     :
**         ---             - Input value. Possible values:
**                           FALSE - logical "0" (Low level)
**                           TRUE - logical "1" (High level)
** ===================================================================
*/
bool Bt21_GetRawBit(byte Bit);

/* END Bt21. */

#endif /* __Bt21_H*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
