/*
 * flash.h
 *
 *  Created on: Mar 20, 2012
 *      Author: a13984
 */

#ifndef FLASH_H_
#define FLASH_H_
#include "types.h"
#include "MC56F84789.h"


// SRecord mark for data memory or x memory
#define DATA_MEM_ADDRESS_MASK           0x02000000L

// Must disable flash cache before memory verification 
#define disable_flash_cache()	    	FMC_PFB0CR |= FMC_PFB0CR_CINV_WAY
#define enable_flash_cache()			FMC_PFB0CR &= ~FMC_PFB0CR_CINV_WAY



#if	defined(MC56F8478x) || defined(MC56F8458x)
	// 256KB flash and 32/2 FlexNVM/FlexRAM
	// program flash memory range
	#define PP_FLASH_START			0x0000000L	// program p-flash start address
	#define PP_FLASH_END			0x001FFFFL	// program p-flash end address
	#define PD_FLASH_START			0x0068000L	// program d-flash start address
	#define PD_FLASH_END			0x006BFFFL	// program d-flash end address
	
	// data flash memory range
	#define DD_FLASH_START			0x0008000L	// data d-flash start address
	#define DD_FLASH_END			0x000BFFFL	// data d-flash end address
	#define DP_FLASH_START			0x0020000L	// data p-flash start address
	#define DP_FLASH_END			0x003FFFFL	// data p-flash end address
#elif defined(MC56F8476x) || defined(MC56F8456x)
	// 128KB flash and 32/2 FlexNVM/FlexRAM
	// program flash memory range
	#define PP_FLASH_START			0x0000000L	// program p-flash start address
	#define PP_FLASH_END			0x000FFFFL	// program p-flash end address
	#define PD_FLASH_START			0x0068000L	// program d-flash start address
	#define PD_FLASH_END			0x006BFFFL	// program d-flash end address
	
	// data flash memory range
	#define DD_FLASH_START			0x0008000L	// data d-flash start address
	#define DD_FLASH_END			0x000BFFFL	// data d-flash end address
	#define DP_FLASH_START			0x0020000L	// data p-flash start address
	#define DP_FLASH_END			0x002FFFFL	// data p-flash end address
#elif defined(MC56F8455x)|| defined(MC56F8445x)
	// 96KB flash and 32/2 FlexNVM/FlexRAM
	#define PP_FLASH_START			0x0000000L	// program p-flash start address
	#define PP_FLASH_END			0x000BFFFL	// program p-flash end address
	#define PD_FLASH_START			0x0068000L	// program d-flash start address
	#define PD_FLASH_END			0x006BFFFL	// program d-flash end address
	
	// data flash memory range
	#define DD_FLASH_START			0x0008000L	// data d-flash start address
	#define DD_FLASH_END			0x000BFFFL	// data d-flash end address
	#define DP_FLASH_START			0x0020000L	// data p-flash start address
	#define DP_FLASH_END			0x002BFFFL	// data p-flash end address
#elif defined(MC56F8454x) || defined(MC56F8444x)
	// 64KB flash and 0 FlexNVM/FlexRAM
	#define PP_FLASH_START			0x0000000L	// program p-flash start address
	#define PP_FLASH_END			0x0007FFFL	// program p-flash end address
	#define PD_FLASH_START			0	// program d-flash start address
	#define PD_FLASH_END			0	// program d-flash end address
	
	// data flash memory range
	#define DD_FLASH_START			0	// data d-flash start address
	#define DD_FLASH_END			0	// data d-flash end address
	#define DP_FLASH_START			0x0020000L	// data p-flash start address
	#define DP_FLASH_END			0x0027FFFL	// data p-flash end address
#endif

/* Flash configuration words */
#define FTFL_Config_Security_Addr	 (UInt16*)0x206	//  word address for security word
  
/* Flash sector size for FlexNVM/data flash */
#define FTFL_DFLASH_SECTOR_SIZE      0x00000400      /* 1 KB size   */

/* Flash sector size for p-flash*/
#define FTFL_PFLASH_SECTOR_SIZE      0x00000800      /* 2 KB size   */

// Flash address mark for d-flash/secondary flash
#define FTFL_DFLASH_ADDR_MARK		 0x00800000		 /* bit 23 = 1 for d-flash */


/*------------- Flash hardware algorithm operation commands -------------*/
#define FTFL_VERIFY_BLOCK		       0x00
#define FTFL_VERIFY_SECTION  		   0x01
#define FTFL_PROGRAM_CHECK		       0x02
#define FTFL_READ_RESOURCE             0x03
#define FTFL_PROGRAM_BYTE              0x04		// reserved
#define FTFL_PROGRAM_WORD              0x05		// reserved
#define FTFL_PROGRAM_LONGWORD          0x06
#define FTFL_ERASE_BLOCK	           0x08
#define FTFL_ERASE_SECTOR		       0x09
#define FTFL_PROGRAM_SECTION           0x0B
#define FTFL_VERIFY_ALL_BLOCK          0x40
#define FTFL_READ_ONCE                 0x41
#define FTFL_PROGRAM_ONCE    		   0x43
#define FTFL_ERASE_ALL_BLOCK           0x44
#define FTFL_SECURITY_BY_PASS          0x45
#define FTFL_PROGRAM_PARTITION		   0x80
#define FTFL_SET_EERAM    			   0x81

/* Flash margin read settings */
#define FTFL_MARGIN_NORMAL             0x0000
#define FTFL_USER_MARGIN_LEVEL1        0x0001
#define FTFL_USER_MARGIN_LEVEL0        0x0002
#define FTFL_FACTORY_MARGIN_LEVEL0     0x0003
#define FTFL_FACTORY_MARGIN_LEVEL1     0x0004


/* Flash common command object registers (FCCOB0-B) */
#define FTFL_FCCOB0_OFFSET             0x00000007
#define FTFL_FCCOB1_OFFSET             0x00000006
#define FTFL_FCCOB2_OFFSET             0x00000005
#define FTFL_FCCOB3_OFFSET             0x00000004
#define FTFL_FCCOB4_OFFSET             0x0000000B
#define FTFL_FCCOB5_OFFSET             0x0000000A
#define FTFL_FCCOB6_OFFSET             0x00000009
#define FTFL_FCCOB7_OFFSET             0x00000008
#define FTFL_FCCOB8_OFFSET             0x0000000F
#define FTFL_FCCOB9_OFFSET             0x0000000E
#define FTFL_FCCOBA_OFFSET             0x0000000D
#define FTFL_FCCOBB_OFFSET             0x0000000C

// Types
typedef	struct
{
	UInt8 ByteCount;			// # of byte/data params
	UInt8 AddrAlignMask;		// address align mask: 0x07 for phrase aligned, 0x03 for longword aligned 
} TFTFL_CmdOBJ;

// Prototypes
UInt16 hfm_command(UInt16 cmd, UInt16 *addr, UInt16 *data, UInt16 cnt);
UInt8  FTFL_ProtectionCheck(void);

#pragma define_section pram_code "pram_code.text" RWX

#endif /* FLASH_H_ */
