

#include "sci.h"



/**
 * TERMIO_PutChar:   This function sends a character through the SPI. 
 *
 * Parameters:    character to be sent
 *
 * Subfunctions:  none.
 *
 * Return:        void
 */ 
void TERMIO_PutChar(int8_t send) 
{
  int8_t dummy;
  
  while( !(QSCI0_STAT & QSCI0_STAT_TDRE) );
  dummy = QSCI0_STAT;
  QSCI0_DATA  = send;    
}//end TERMIO_PutChar


void sci_putc(char ch) 
{
	TERMIO_PutChar((int8_t)ch);
    
}//end TERMIO_PutChar


/**
 * TERMIO_GetChar:   This function receives a character through the SPI 
 *
 * Parameters:    none
 *
 * Subfunctions:  none.
 *
 * Return:        character recieved
 */ 

int8_t TERMIO_GetChar(void) 
{
  int8_t dummy;
  
  while(! (QSCI0_STAT & QSCI0_STAT_RDRF));
  dummy = QSCI0_STAT;
  return QSCI0_DATA;  
} //end TERMIO_GetChar 


/**
 * TERMIO_Print:   This function sends a character string ended with 0 through the SCI
 *
 * Parameters:    character to be sent
 *
 * Subfunctions:  none.
 *
 * Return:        void
 */ 
void TERMIO_Print(int8_t * str ) 
{ 
	uint8_t dummy;
	
	while(*str) 
	{
	  while( !(QSCI0_STAT & QSCI0_STAT_TDRE) );
	 // dummy = QSCI0_STAT;
	  QSCI0_DATA  = *str++;    		
	}
  
}//end TERMIO_PutChar


/**
 * TERMIO_PrintDigit:   This function sends a digit number through the SCI
 *
 * Parameters:    number to be sent
 *
 * Subfunctions:  none.
 *
 * Return:        void
 */ 
void TERMIO_PrintDigit(uint16_t number  ) 
{ 
	uint8_t dummy;
	uint8_t buf[4];
	int8_t  i = 0;
	
	for(i = 0; i < 4; i++)
	{
		buf[i] = (number>>(i<<2)) & 0x000f;
		if(buf[i] >= 0 && buf[i] <= 9)
		{
			buf[i] += '0';
		}
		if(buf[i] >= 0x0a && buf[i] <= 0x0f)
		{
			buf[i] += 'A';
		}			
	}
	
	for( i = 3; i >= 0; i--) 
	{
	  while( !(QSCI0_STAT & QSCI0_STAT_TDRE) );
	  dummy = QSCI0_STAT;
	  QSCI0_DATA  = buf[i];    		
	}
  
}//end TERMIO_Printdigit

/**
 * TERMIO_Init: This function initial the terminal. 
 *
 * Parameters:             void
 *
 * Subfunctions:           none.
 *
 * Return:                 void
 */ 

#pragma interrupt alignsp called
void TERMIO_Init(uint32_t baudrate) 
{
	uint16_t	sbr;
	uint8_t	frac_sbr;

#if defined(USE_SCI0)	
	// select 2x clock as input (i.e. 200MHz)
	//SIM_PCR |= SIM_PCR_SCI0_CR;
	
	// configure SCI pins
#if	defined(SCI0_PIN_GPIOF11_GPIOF15)	
	/* Configure GPIOF11 as TXD0,GPIOF15 as RXD0 */
	SIM_PCE0  |= SIM_PCE0_GPIOF; /* Enable GPIOF Clock */
	GPIOF_PER |= GPIOF_PER_PE_11 | GPIOF_PER_PE_15; /* PER Enable for GPIOF15/RXD0,GPIOF11/TXD0 */ 
	SIM_GPSFH &= ~(SIM_GPSFH_F11 | SIM_GPSFH_F15) ; 
#else	
	/* Configure GPIOC2 as TXD0, GPIOF8 as RXD0 */
	SIM_PCE0  |= SIM_PCE0_GPIOC; /* Enable GPIOC Clock */
	GPIOC_PER |= GPIOC_PER_PE_2; /* PER Enable for GPIOC2 - TXD0 */ 
	//SIM_GPSCL |= 0; /* peripheral select TXD0 on GPIOC2 */

	SIM_PCE0  |= SIM_PCE0_GPIOF; /* Enable GPIOF Clock */
	GPIOF_PER |= GPIOF_PER_PE_8; /* PER Enable for GPIOF8 - RXD0 */ 
	//SIM_GPSFH |= 0; /* peripheral select RXD0 on GPIOF8 */	
#endif	
	/* Enable clock to SCI0 */
	SIM_PCE1 |= SIM_PCE1_SCI0;
	
	sbr = (QSCI0_CLOCK_HZ>>4)/ baudrate;
	frac_sbr = ((QSCI0_CLOCK_HZ>>1)/baudrate - (sbr<<3)) & 0x7;
	QSCI0_RATE = (sbr<<3) | frac_sbr;     
	
	QSCI0_CTRL1 = (QSCI0_CTRL1_TE | QSCI0_CTRL1_RE);
 
	// Setup fast interrupt for SCI
	INTC_FIVAL0 = (vuint16_t)fisr_sci_rx_full;
	INTC_FIVAH0 = ((vuint32_t)fisr_sci_rx_full>>16) & 0x001F;
	INTC_FIM0   = 51;	// SCI0 rx error
	INTC_FIVAL1 = (vuint16_t)fisr_sci_rx_full;
	INTC_FIVAH1 = ((vuint32_t)fisr_sci_rx_full>>16) & 0x001F;
	INTC_FIM1   = 52; // SCI0 rx full 
	
	// enable Rx full and error interrupts
	QSCI0_CTRL1 |= QSCI0_CTRL1_RFIE | QSCI0_CTRL1_REIE;
	setReg16Bits(INTC_IPR5,0x00F0); /* enable receive full interrupt and error interrupt */
#elif	defined(USE_SCI1)
	// select 2x clock as input (i.e. 200MHz)
	//SIM_PCR |= SIM_PCR_SCI0_CR;
	
#if	defined(SCI1_PIN_GPIOF4_GPIOF5)
	/* Configure GPIOF4 as TXD1,GPIOF5 as RXD1 */
	SIM_PCE0  |= SIM_PCE0_GPIOF; /* Enable GPIOF Clock */
	GPIOF_PER |= GPIOF_PER_PE_4 | GPIOF_PER_PE_5; /* PER Enable for GPIOF4/TXD1,GPIOF5/RXD1 */ 
	SIM_GPSFL &= ~(SIM_GPSFL_F4 | SIM_GPSFL_F5) ; 
	
#elif defined(SCI1_PIN_GPIOC11_GPIOC12)	
	/* Configure GPIOC11 as TXD1,GPIOC12 as RXD1 */
	SIM_PCE0  |= SIM_PCE0_GPIOC; /* Enable GPIOC Clock */
	GPIOC_PER |= GPIOC_PER_PE_11 | GPIOC_PER_PE_12; /* PER Enable for GPIOC11/12 */ 
	SIM_GPSCH &= ~(SIM_GPSCH_C12 | SIM_GPSCH_C11) ; 
	SIM_GPSCH |= SIM_GPSCH_C12_1 | SIM_GPSCH_C11_1; 	
#else
	// use default GPIOF4/F5
	/* Configure GPIOF4 as TXD1,GPIOF5 as RXD1 */
	SIM_PCE0  |= SIM_PCE0_GPIOF; /* Enable GPIOF Clock */
	GPIOF_PER |= GPIOF_PER_PE_4 | GPIOF_PER_PE_5; /* PER Enable for GPIOF4/TXD1,GPIOF5/RXD1 */ 
	SIM_GPSFL &= ~(SIM_GPSFL_F4 | SIM_GPSFL_F5) ; 	
#endif
	
	/* Enable clock to SCI1 */
	SIM_PCE1 |= SIM_PCE1_SCI1;
	
	sbr = (QSCI0_CLOCK_HZ>>4)/ baudrate;
	frac_sbr = ((QSCI0_CLOCK_HZ>>1)/baudrate - (sbr<<3)) & 0x7;
	QSCI1_RATE = (sbr<<3) | frac_sbr;     
	
	QSCI1_CTRL1 = (QSCI1_CTRL1_TE | QSCI1_CTRL1_RE);
 
	// Setup fast interrupt for SCI
	INTC_FIVAL0 = (vuint16_t)fisr_sci_rx_full;
	INTC_FIVAH0 = ((vuint32_t)fisr_sci_rx_full>>16) & 0x001F;
	INTC_FIM0   = 47;	// SCI rx error
	INTC_FIVAL1 = (vuint16_t)fisr_sci_rx_full;
	INTC_FIVAH1 = ((vuint32_t)fisr_sci_rx_full>>16) & 0x001F;
	INTC_FIM1   = 48; // SCI rx full 
	
	// enable Rx full and error interrupts
	QSCI1_CTRL1 |= QSCI1_CTRL1_RFIE | QSCI1_CTRL1_REIE;
	setReg16Bits(INTC_IPR4,0xF000); /* enable receive full interrupt and error interrupt */	
#elif	defined(USE_SCI2)
	// select 2x clock as input (i.e. 200MHz)
	//SIM_PCR |= SIM_PCR_SCI2_CR;

#if	defined(SCI2_PIN_GPIOF9_GPIOF10)
	/* Configure GPIOF9 as RXD2,GPIOF10 as RXD2 */
	SIM_PCE0  |= SIM_PCE0_GPIOF; /* Enable GPIOF Clock */
	GPIOF_PER |= GPIOF_PER_PE_9 | GPIOF_PER_PE_10; /* PER Enable for GPIOF9/RXD2,GPIOF10/TXD2 */ 
	SIM_GPSFH &= ~(SIM_GPSFH_F9 | SIM_GPSFH_F10) ; 
	
#elif defined(SCI2_PIN_GPIOD5_GPIOD6)	
	/* Configure GPIOD6 as TXD2,GPIOD5 as RXD2 */
	SIM_PCE0  |= SIM_PCE0_GPIOD; /* Enable GPIOD Clock */
	GPIOD_PER |= GPIOD_PER_PE_6 | GPIOD_PER_PE_5;  
	SIM_GPSDL &= ~(SIM_GPSDL_D5 | SIM_GPSDL_D6) ; 
#else
	/* Configure GPIOD6 as TXD2,GPIOD5 as RXD2 */
	SIM_PCE0  |= SIM_PCE0_GPIOD; /* Enable GPIOD Clock */
	GPIOD_PER |= GPIOD_PER_PE_6 | GPIOD_PER_PE_5;  
	SIM_GPSDL &= ~(SIM_GPSDL_D5 | SIM_GPSDL_D6) ; 
#endif
	
	/* Enable clock to SCI2 */
	SIM_PCE1 |= SIM_PCE1_SCI2;
	
	sbr = (QSCI0_CLOCK_HZ>>4)/ baudrate;
	frac_sbr = ((QSCI0_CLOCK_HZ>>1)/baudrate - (sbr<<3)) & 0x7;
	QSCI2_RATE = (sbr<<3) | frac_sbr;     
	
	QSCI2_CTRL1 = (QSCI2_CTRL1_TE | QSCI2_CTRL1_RE);
 
	// Setup fast interrupt for SCI
	INTC_FIVAL0 = (vuint16_t)fisr_sci_rx_full;
	INTC_FIVAH0 = ((vuint32_t)fisr_sci_rx_full>>16) & 0x001F;
	INTC_FIM0   = 43;	// SCI rx error
	INTC_FIVAL1 = (vuint16_t)fisr_sci_rx_full;
	INTC_FIVAH1 = ((vuint32_t)fisr_sci_rx_full>>16) & 0x001F;
	INTC_FIM1   = 44; // SCI rx full 
	
	// enable Rx full and error interrupts
	QSCI2_CTRL1 |= QSCI2_CTRL1_RFIE | QSCI2_CTRL1_REIE;
	setReg16Bits(INTC_IPR4,0x00F0); /* enable receive full interrupt and error interrupt */		
#endif
	
}//end TERMIO_Init








