/*
 * cpu.c
 *
 *  Created on: Mar 21, 2012
 *      Author: a13984
 */

/** ###################################################################
**     Filename  : Cpu.C
**     Processor : 56F84xx
**     Author    : Richy.Ye
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 03/05/2009
**     Abstract  :
**
**     Settings  :
**
**     Contents  :
**         EnableInt      - void Cpu_EnableInt(void);
**         DisableInt     - void Cpu_DisableInt(void);
**         GetResetSource - byte Cpu_GetResetSource(void);
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     (c) Copyright UNIS, a.s. 1997-2008
** ###################################################################*/

/* MODULE Cpu. */
#include "Types.h"
//#include "Registers_Nevis.h"
#include "MC56F84789.h"
#include "Events.h"
#include "Cpu.h"
#include "sci.h"


/* Global variables */
extern UWord32 _vector_addr;
/*
** ===================================================================
**     Method      :  Cpu_DisableInt (bean 56F84xx)
**
**     Description :
**         Disables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_DisableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_EnableInt (bean 56F8023)
**
**     Description :
**         Enables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_EnableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_GetResetSource (bean 56F8023)
**
**     Description :
**         Gets low byte of the reset status register.
**     Parameters  : None
**     Returns     :
**         ---             - Content of the reset status register.
**                           You can use predefined constants listed
**                           bellow to find out a reset cause.
**                           Reset source (predefined constants):
**                           RSTSRC_POR - Power-on reset
**                           RSTSRC_PIN - External reset
**                           RSTSRC_LOR - COP Loss of Reference reset
**                           RSTSRC_TOR - COP Time-Out reset
**                           RSTSRC_SWR - Software reset
** ===================================================================
*/
/*
byte Cpu_GetResetSource(void)

**      This method is implemented as macro in the header module. **
*/


/*
** ===================================================================
**     Method      :  _EntryPoint (bean 56F8023)
**
**     Description :
**         Initializes the whole system like timing and so on. At the end 
**         of this function, the C startup is invoked to initialize stack,
**         memory areas and so on.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
extern void init_56800_(void);		/*Forward declaration of external startup function declared in startup file*/


/*
** ===================================================================
**     Method      :  OCCS_Init (void)
**
**     Description :
**         This function implement to initialize the on-chip clock 
**         synthesis circuit for proper operation.
** ===================================================================
*/
inline void OCCS_Init(void)
{
  
 /*Configure relaxation oscillator and PLL output as master system clock*/
 // setReg16(OCCS_CTRL, 0x31);		/*Reset control register*/
 // setReg16(OCCS_STAT, 0x0E011);		/*Reset status register*/
 // setReg16(OCCS_OSCTL1, 0x1620);		/*Reset oscillator control register1*/
 // setReg16(OCCS_OSCTL2, 0xC100);		/*Reset oscillator control register2*/
  //setRegBitGroup(OCCS_OSCTL1, TRIM, ((word)getReg(HFM_IFR_OPT0) & 0x3FF)); /* Set the trim osc freq with factory programmed value */
 // clrSetReg16Bits(OCCS_OSCTL1, 0x03FF, 0x0270);
  clrSetReg16Bits(OCCS_OSCTL1, 0x03FF, 0x0240); // trimmed version

  setReg16(OCCS_DIVBY, 0x2031);		/*Set the detection time of LOL as 2 reference clock,postscaler as 1*/
  //clrReg16Bit(OCCS_CTRL,DCCPD);			/*Enable DCCPD*/
  clrReg16Bits(OCCS_CTRL, OCCS_CTRL_PLLPD);		/*Enable PLL*/
  setReg16Bits(OCCS_CTRL, OCCS_CTRL_LCKON);		/*Enable lock detector*/
  while((OCCS_STAT & 0x60) != 0x60)		/*Wait for PLL lock*/
  {
  	asm(nop);
  }
  setReg16Bits(OCCS_CTRL, OCCS_CTRL_ZSRC);		/*Switch clock source to PLL output*/
  while((OCCS_STAT & OCCS_STAT_ZSRCS) != OCCS_STAT_ZSRCS_0)		/*Wait for switch completion*/		
  {
  	asm(nop);
  }
  
  
  // Configure 32khz osc trim values
  clrSetReg16Bits(OCCS_OSCTL2, 0x01FF, 0x0111);
  // clear power down bit
  clrReg16Bits(OCCS_OSCTL2,OCCS_OSCTL2_ROPD32K); 
}

void _EntryPoint(void)
{
  
  /*** ### 56F84xxx "Cpu" init code ... ***/
  __DI();		/*Disable the maskable interrupts*/
  setReg16(COP_CTRL, 0x00);		/*Disable COP running after reset*/
  
  /*** PE initialization code after reset ***/
  /*System clock initialization*/
  //OCCS_Init();
  /*Configure relaxation oscillator and PLL output as master system clock*/
  // setReg16(OCCS_CTRL, 0x31);		/*Reset control register*/
  // setReg16(OCCS_STAT, 0x0E011);		/*Reset status register*/
  // setReg16(OCCS_OSCTL1, 0x1620);		/*Reset oscillator control register1*/
  // setReg16(OCCS_OSCTL2, 0xC100);		/*Reset oscillator control register2*/
   //setRegBitGroup(OCCS_OSCTL1, TRIM, ((word)getReg(HFM_IFR_OPT0) & 0x3FF)); /* Set the trim osc freq with factory programmed value */
  // clrSetReg16Bits(OCCS_OSCTL1, 0x03FF, 0x0270);
#if	defined(CLOCK_UNTRIMMED)
   clrSetReg16Bits(OCCS_OSCTL1, 0x03FF, 0x0240); // untrimmed version
#endif

   setReg16(OCCS_DIVBY, 0x2031);		/*Set the detection time of LOL as 2 reference clock,postscaler as 1*/
   //clrReg16Bit(OCCS_CTRL,DCCPD);			/*Enable DCCPD*/
   clrReg16Bits(OCCS_CTRL, OCCS_CTRL_PLLPD);		/*Enable PLL*/
   setReg16Bits(OCCS_CTRL, OCCS_CTRL_LCKON);		/*Enable lock detector*/
   while((OCCS_STAT & 0x60) != 0x60)		/*Wait for PLL lock*/
   {
   	asm(nop);
   }
   setReg16Bits(OCCS_CTRL, OCCS_CTRL_ZSRC);		/*Switch clock source to PLL output*/
   while((OCCS_STAT & OCCS_STAT_ZSRCS) != OCCS_STAT_ZSRCS_0)		/*Wait for switch completion*/		
   {
   	asm(nop);
   }
   
   
   // Configure 32khz osc trim values
   clrSetReg16Bits(OCCS_OSCTL2, 0x01FF, 0x0111);
   // clear power down bit
   clrReg16Bits(OCCS_OSCTL2,OCCS_OSCTL2_ROPD32K);   
    
  /*Set the flash clock prescaler*/
  //setReg16(HFM_CLKD, 0x28); 
  /*** End of PE initialization code after reset ***/
  asm(JMP init_56800_);		/*Jump to C startup code*/

}

/*
** ===================================================================
**     Method      :  PE_low_level_init (bean 56F8023)
**
**     Description :
**         Initializes beans and provides common register initialization. 
**         The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PE_low_level_init(void)
{
  /*Configure SIM registers*/
  setReg16(SIM_PCR, 0x0000);		/* Set up the peripheral clock rate register */
  setReg16(SIM_PCE0, 0xE07F);		/* Enable clock to TA0, TA1, TA2, all GPIOs */
  setReg16(SIM_PCE1, 0x0000);		/* Set up the peripheral clock enable register 1 */
  setReg16(SIM_PCE2, 0x0000);		/* Set up the peripheral clock enable register 2 */
  setReg16(SIM_PCE3, 0x0000);		/* Set up the peripheral clock enable register 3 */
  setReg16(SIM_PROT, 0x0000);		/* Set up the SIM protection register */
  setReg16(SIM_CTRL, 0x0000);		/* Set up the SIM control register. dma enabled */
  setReg16(SIM_PWR, 0x0000);		/* Set up the SIM power control register */
  setReg16(SIM_CLKOUT, 0x0000);		/* Set up the SIM clock output select register */ 

  /* GPIO initialization */
  setReg16Bits(GPIOE_DRIVE, 0x01);	    /*Set high drive strength for GPIOE0*/
  setReg16Bits(GPIOE_DDR, 0x01);		/*Configure as output for GPIOE0*/
  setReg16Bits(GPIOE_PUS, 0x01);		/*Configure as pull-up for GPIOE0*/
  clrReg16Bits(GPIOE_PER, 0x01);		/*Configure as GPIO for GPIOE0*/
  setReg16Bits(GPIOE_DR, 0x01);	    	/*Turn LED2 off*/
  
  //setReg16Bits(GPIOC_PER, 0x04);		/*Configure as CLKOUT for GPIOC2*/
  //setReg16Bits(SIM_GPSCL, 0x30);
  setReg16Bits(GPIOF_PER, 0x02);		/*Configure as CLKOUT for GPIOF1*/
  clrReg16Bits(SIM_GPSFL, 0x0C);
  
  
  TERMIO_Init(SCI_BAUDRATE);	/* initialize SCI */ 
  
  clrReg16Bits(INTC_CTRL, 0x20);		/* Enable all interrupts */
  
  //__EI(0);                              /* Enable interrupts of the selected priority level */
}



/* END Cpu. */

/*
** ###################################################################
**
**     This file is created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
