/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : AsMaster
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-21, 10:32, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_AsMaster */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "AM1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define LOOP_LENGTH  7

byte LoopTxBuffer[LOOP_LENGTH];
byte LoopRxBuffer[LOOP_LENGTH];
byte i, err;
word sent, recv;
byte volatile OnTxCharNum = 0;
byte volatile OnRxCharNum = 0;
bool brk, cmpFailed;

void main(void)
{
  test_sRec testRec;
  
  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "AsynchroSerialMaster test");
  //
  for (i=0;i<LOOP_LENGTH;i++) {
    LoopTxBuffer[i] = (byte)i;
    LoopRxBuffer[i] = 0xff;
  }
  //
  AM1_TurnRxOff();
  err=AM1_SelectSlave(1);      // select slave with address 1
  //
  TEST1_testComment(&testRec, "Transmitting one character ...");
  AM1_TurnRxOn();
  err = AM1_SendChar(LoopTxBuffer[0]);
  //
  while (AM1_GetCharsInRxBuf() == 0) {}
  //
  if (err == ERR_OK)
    TEST1_testComment(&testRec, "PASSED");
  else  
    TEST1_testFailed(&testRec, "Transmitting one character failed");
  //
  TEST1_testComment(&testRec, "Receiving one character ...");
  err = AM1_RecvChar(&LoopRxBuffer[0]);
  if ((err != ERR_OK) || (LoopRxBuffer[0] != LoopTxBuffer[0]))
    TEST1_testFailed(&testRec, "Receiving one character failed");
  else  
    TEST1_testComment(&testRec, "PASSED");
  //
  TEST1_testComment(&testRec, "Transmitting data block ...");
  err = AM1_SendBlock(LoopTxBuffer, LOOP_LENGTH, &sent);
  //
  while (AM1_GetCharsInRxBuf() < LOOP_LENGTH) {}
  //
  if ((err == ERR_OK) && (sent == LOOP_LENGTH))
    TEST1_testComment(&testRec, "PASSED");
  else  
    TEST1_testFailed(&testRec, "Transmitting data block failed");
  //
  TEST1_testComment(&testRec, "Receiving data block ...");
  err = AM1_RecvBlock(LoopRxBuffer, LOOP_LENGTH, &recv);
  if (err != ERR_OK)
    TEST1_testFailed(&testRec, "Receiving data block failed");
  else  
    TEST1_testComment(&testRec, "PASSED");
  //
  TEST1_testComment(&testRec, "Comparing received/sent data ...");
  cmpFailed = FALSE;
  for (i=0;i<LOOP_LENGTH;i++) {
    if ( LoopTxBuffer[i] !=  LoopRxBuffer[i]) {
      cmpFailed = TRUE;
    } 
  }
  if (cmpFailed) {
    TEST1_testFailed(&testRec, "Comparing received/sent data failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }  
  //
  TEST1_testComment(&testRec, "Testing OnTxCharNum event ...");
  if (OnTxCharNum != LOOP_LENGTH + 1) {
    TEST1_testFailed(&testRec, "Testing OnTxCharNum event failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }  
  TEST1_testComment(&testRec, "Testing OnRxCharNum event ...");
  if (OnRxCharNum != LOOP_LENGTH + 1) {
    TEST1_testFailed(&testRec, "Testing OnRxCharNum event failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }  
  //
  TEST1_testComment(&testRec, "Generating break ...");
  (void)AM1_SetBreak();
  brk = FALSE;
  while (!brk) {
    (void)AM1_GetBreak(&brk);
  }  
  if (brk) { 
    TEST1_testComment(&testRec, "PASSED");
  } else {
    TEST1_testFailed(&testRec, "Generating break failed");
  }  
  //
  TEST1_testEnd(&testRec);
  //
}

/* END demo_AsMaster */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
