/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : AM1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : AsynchroMaster
**     Version     : Component 02.288, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:03, # CodeGen: 18
**     Abstract    :
**         This component "AsynchroMaster" implements MASTER part of asynchronous
**         serial master-slave communication.
**     Settings    :
**         Asynchro type               : MASTER
**
**         Serial channel              : QSCI0
**
**         Protocol
**             Init baud rate          : 9600baud
**             Width                   : 9 bits
**             Stop bits               : 0
**             Parity                  : hardware wake-up
**             Breaks                  : Enabled
**             Input buffer size       : 12
**             Output buffer size      : 12
**
**         Registers
**             Input buffer            : QSCI0_DATA [E084]
**             Output buffer           : QSCI0_DATA [E084]
**             Control register        : QSCI0_CTRL1 [E081]
**             Mode register           : QSCI0_CTRL1 [E081]
**             Baud setting reg.       : QSCI0_RATE [E080]
**
**         Input interrupt
**             Vector name             : INT_QSCI0_RCV
**
**         Output interrupt
**             Vector name             : INT_QSCI0_TDRE
**
**         Used pins:
**         ----------------------------------------------------------
**           Function | On package           |    Name
**         ----------------------------------------------------------
**            Input   |     6                |  GPIOF8/RXD0/TB1/CMPD_O
**            Output  |     50               |  GPIOC7/SS0_B/TXD0
**         ----------------------------------------------------------
**
**     Contents    :
**         RecvChar        - byte AM1_RecvChar(AM1_TComData *Chr);
**         SendChar        - byte AM1_SendChar(AM1_TComData Chr);
**         RecvBlock       - byte AM1_RecvBlock(AM1_TComData *Ptr, word Size, word *Rcv);
**         SendBlock       - byte AM1_SendBlock(AM1_TComData *Ptr, word Size, word *Snd);
**         ClearRxBuf      - byte AM1_ClearRxBuf(void);
**         ClearTxBuf      - byte AM1_ClearTxBuf(void);
**         GetCharsInRxBuf - word AM1_GetCharsInRxBuf(void);
**         GetCharsInTxBuf - word AM1_GetCharsInTxBuf(void);
**         GetBreak        - byte AM1_GetBreak(bool *Brk);
**         SetBreak        - byte AM1_SetBreak(void);
**         SelectSlave     - byte AM1_SelectSlave(byte Slv);
**         GetSelected     - byte AM1_GetSelected(byte *Slv);
**         TurnRxOn        - void AM1_TurnRxOn(void);
**         TurnRxOff       - void AM1_TurnRxOff(void);
**         SetIdle         - byte AM1_SetIdle(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __AM1
#define __AM1

/* MODULE AM1. */

#include "Cpu.h"

#define NOSLAVE -1

#ifndef __BWUserType_AM1_TError
#define __BWUserType_AM1_TError
  typedef union {
    byte err;
    struct {
      /*lint -save  -e46 Disable MISRA rule (6.4) checking. */
      bool OverRun  : 1;               /* Overrun error flag */
      bool Framing  : 1;               /* Framing error flag */
      bool Parity   : 1;               /* Parity error flag */
      bool RxBufOvf : 1;               /* Rx buffer full error flag */
      bool Noise    : 1;               /* Noise error flag */
      bool Break    : 1;               /* Break detect */
      bool LINSync  : 1;               /* LIN synchronization error */
      /*lint -restore Enable MISRA rule (6.4) checking. */
    } errName;
  } AM1_TError;                        /* Error flags. For languages which don't support bit access is byte access only to error flags possible. */
#endif

#ifndef __BWUserType_AM1_TComData
#define __BWUserType_AM1_TComData
  typedef byte AM1_TComData;           /* User type for communication. Size of this type depends on the communication data witdh. */
#endif

#define AM1_INP_BUF_SIZE  0x0CU        /* Length of the RX buffer */

#define AM1_OUT_BUF_SIZE  0x0CU        /* Length of the TX buffer */

byte AM1_RecvChar(AM1_TComData *Chr);
/*
** ===================================================================
**     Method      :  AM1_RecvChar (component AsynchroMaster)
**
**     Description :
**         If any data is received, this method returns one character,
**         otherwise it returns an error code (it does not wait for
**         data). This method is enabled only if the receiver property
**         is enabled.
**         [Note:] Because the preferred method to handle error and
**         break exception in the interrupt mode is to use events
**         <OnError> and <OnBreak> the return value ERR_RXEMPTY has
**         higher priority than other error codes. As a consequence the
**         information about an exception in interrupt mode is returned
**         only if there is a valid character ready to be read.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - Pointer to a received character
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - No data in receiver
**                           ERR_BREAK - Break character is detected
**                           (only when the <Interrupt service> property
**                           is disabled and the <Break signal> property
**                           is enabled)
**                           ERR_COMMON - common error occurred (the
**                           GetError method can be used for error
**                           specification)
** ===================================================================
*/

byte AM1_SendChar(AM1_TComData Chr);
/*
** ===================================================================
**     Method      :  AM1_SendChar (component AsynchroMaster)
**
**     Description :
**         Send one character to the channel. This method is available
**         only if the transmitter property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - Transmitter is full
** ===================================================================
*/

byte AM1_RecvBlock(AM1_TComData *Ptr,word Size,word *Rcv);
/*
** ===================================================================
**     Method      :  AM1_RecvBlock (component AsynchroMaster)
**
**     Description :
**         If any data is received, this method returns the block of
**         the data and its length (and incidental error), otherwise it
**         returns an error code (it does not wait for data).
**         This method is available only if non-zero length of the
**         input buffer is defined and the receiver property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - Pointer to the block of received data
**         Size            - Size of the block
**       * Rcv             - Pointer to real number of the received data
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - The receive buffer didn't
**                           contain the requested number of data. Only
**                           available data has been returned.
**                           ERR_COMMON - Common error occurred (the
**                           GetError method can be used for error
**                           specification)
** ===================================================================
*/

byte AM1_SendBlock(AM1_TComData *Ptr,word Size,word *Snd);
/*
** ===================================================================
**     Method      :  AM1_SendBlock (component AsynchroMaster)
**
**     Description :
**         Sends a block of characters to the channel.
**         This method is available only if non-zero length of the
**         output buffer is defined and the transmitter property is
**         enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - Pointer to the block of data to send
**         Size            - Size of the block
**       * Snd             - Pointer to number of data that are sent
**                           (moved to buffer)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - It was not possible to send
**                           requested number of bytes
** ===================================================================
*/

byte AM1_ClearRxBuf(void);
/*
** ===================================================================
**     Method      :  AM1_ClearRxBuf (component AsynchroMaster)
**
**     Description :
**         Clears the receive buffer.
**         This method is available only if non-zero length of the
**         input buffer is defined and the receiver property is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte AM1_ClearTxBuf(void);
/*
** ===================================================================
**     Method      :  AM1_ClearTxBuf (component AsynchroMaster)
**
**     Description :
**         Clears the transmit buffer.
**         This method is available only if non-zero length of the
**         output buffer is defined and the receiver property is
**         enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

word AM1_GetCharsInRxBuf(void);
/*
** ===================================================================
**     Method      :  AM1_GetCharsInRxBuf (component AsynchroMaster)
**
**     Description :
**         Returns the number of characters in the input buffer. This
**         method is available only if the receiver property is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the input
**                           buffer.
** ===================================================================
*/

word AM1_GetCharsInTxBuf(void);
/*
** ===================================================================
**     Method      :  AM1_GetCharsInTxBuf (component AsynchroMaster)
**
**     Description :
**         Returns the number of characters in the output buffer. This
**         method is available only if the transmitter property is
**         enabled.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the output
**                           buffer.
** ===================================================================
*/

byte AM1_GetBreak(bool *Brk);
/*
** ===================================================================
**     Method      :  AM1_GetBreak (component AsynchroMaster)
**
**     Description :
**         Tests the internal input break flag, returns it (whether the
**         break has occurred or not) and clears it. This method is
**         available only if property <Break signal> is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Brk             - Pointer to the returned internal break flag
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte AM1_SetBreak(void);
/*
** ===================================================================
**     Method      :  AM1_SetBreak (component AsynchroMaster)
**
**     Description :
**         Sends the break sequence to the output line. This method is
**         available only if <Break signal> property is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - This component is disabled
**                           by user
** ===================================================================
*/

byte AM1_SelectSlave(byte Slv);
/*
** ===================================================================
**     Method      :  AM1_SelectSlave (component AsynchroMaster)
**
**     Description :
**         Select the slave - sends the address of the slave for
**         starting communication with it (the previous slave stops
**         communicating).
**     Parameters  :
**         NAME            - DESCRIPTION
**         Slv             - The new slave identification
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - This device is disabled
**                           ERR_BUSY - Transmitter buffer is not empty
** ===================================================================
*/

byte AM1_GetSelected(byte *Slv);
/*
** ===================================================================
**     Method      :  AM1_GetSelected (component AsynchroMaster)
**
**     Description :
**         Return the identification of the selected slave  (0-254, or
**         -1 if no slave is selected).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Slv             - Pointer to identification of the slave
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_NOTAVAIL - Slave is not selected yet
** ===================================================================
*/

void AM1_InterruptRx(void);
/*
** ===================================================================
**     Method      :  AM1_InterruptRx (component AsynchroMaster)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void AM1_InterruptTx(void);
/*
** ===================================================================
**     Method      :  AM1_InterruptTx (component AsynchroMaster)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void AM1_InterruptError(void);
/*
** ===================================================================
**     Method      :  AM1_InterruptError (component AsynchroMaster)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void AM1_Init(void);
/*
** ===================================================================
**     Method      :  AM1_Init (component AsynchroMaster)
**
**     Description :
**         Initializes the associated peripheral(s) and internal 
**         variables of the bean. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

byte AM1_SetIdle(void);
/*
** ===================================================================
**     Method      :  AM1_SetIdle (component AsynchroMaster)
**
**     Description :
**         Sends the idle character to the output line.
**         This method is available only if the transmitter property is
**         enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - This component is disabled
**                           by user
** ===================================================================
*/

#define AM1_TurnRxOff() clrRegBit(QSCI0_CTRL1, RE)
/*
** ===================================================================
**     Method      :  AM1_TurnRxOff (component AsynchroMaster)
**
**     Description :
**         Turns off the receiver. This method is available only if the
**         receiver property is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define AM1_TurnRxOn() setRegBit(QSCI0_CTRL1, RE)
/*
** ===================================================================
**     Method      :  AM1_TurnRxOn (component AsynchroMaster)
**
**     Description :
**         Turns on the receiver. This method is available only if the
**         receiver property is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/



/* END AM1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/

#endif /* ifndef __AM1 */
