/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : AM1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : AsynchroMaster
**     Version     : Component 02.288, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:03, # CodeGen: 18
**     Abstract    :
**         This component "AsynchroMaster" implements MASTER part of asynchronous
**         serial master-slave communication.
**     Settings    :
**         Asynchro type               : MASTER
**
**         Serial channel              : QSCI0
**
**         Protocol
**             Init baud rate          : 9600baud
**             Width                   : 9 bits
**             Stop bits               : 0
**             Parity                  : hardware wake-up
**             Breaks                  : Enabled
**             Input buffer size       : 12
**             Output buffer size      : 12
**
**         Registers
**             Input buffer            : QSCI0_DATA [E084]
**             Output buffer           : QSCI0_DATA [E084]
**             Control register        : QSCI0_CTRL1 [E081]
**             Mode register           : QSCI0_CTRL1 [E081]
**             Baud setting reg.       : QSCI0_RATE [E080]
**
**         Input interrupt
**             Vector name             : INT_QSCI0_RCV
**
**         Output interrupt
**             Vector name             : INT_QSCI0_TDRE
**
**         Used pins:
**         ----------------------------------------------------------
**           Function | On package           |    Name
**         ----------------------------------------------------------
**            Input   |     6                |  GPIOF8/RXD0/TB1/CMPD_O
**            Output  |     50               |  GPIOC7/SS0_B/TXD0
**         ----------------------------------------------------------
**
**     Contents    :
**         RecvChar        - byte AM1_RecvChar(AM1_TComData *Chr);
**         SendChar        - byte AM1_SendChar(AM1_TComData Chr);
**         RecvBlock       - byte AM1_RecvBlock(AM1_TComData *Ptr, word Size, word *Rcv);
**         SendBlock       - byte AM1_SendBlock(AM1_TComData *Ptr, word Size, word *Snd);
**         ClearRxBuf      - byte AM1_ClearRxBuf(void);
**         ClearTxBuf      - byte AM1_ClearTxBuf(void);
**         GetCharsInRxBuf - word AM1_GetCharsInRxBuf(void);
**         GetCharsInTxBuf - word AM1_GetCharsInTxBuf(void);
**         GetBreak        - byte AM1_GetBreak(bool *Brk);
**         SetBreak        - byte AM1_SetBreak(void);
**         SelectSlave     - byte AM1_SelectSlave(byte Slv);
**         GetSelected     - byte AM1_GetSelected(byte *Slv);
**         TurnRxOn        - void AM1_TurnRxOn(void);
**         TurnRxOff       - void AM1_TurnRxOff(void);
**         SetIdle         - byte AM1_SetIdle(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE AM1. */

#include "AM1.h"
#include "Events.h"


#define OVERRUN_ERR      0x01U         /* Overrun error flag bit   */
#define FRAMING_ERR      0x02U         /* Framing error flag bit   */
#define PARITY_ERR       0x04U         /* Parity error flag bit    */
#define CHAR_IN_RX       0x08U         /* Char is in RX buffer     */
#define FULL_TX          0x10U         /* Full transmit buffer     */
#define RUNINT_FROM_TX   0x20U         /* Interrupt is in progress */
#define FULL_RX          0x40U         /* Full receive buffer      */
#define NOISE_ERR        0x80U         /* Noise error flag bit     */
#define IDLE_ERR         0x0100U       /* Idle character flag bit  */
#define BREAK_ERR        0x0200U       /* Break detect             */
#define COMMON_ERR       0x0400U       /* Common error of RX       */

static word SerFlag;                   /* Flags for serial communication */
                                       /* Bits: 0 - OverRun error */
                                       /*       1 - Framing error */
                                       /*       2 - Parity error (not used in this bean) */
                                       /*       3 - Char in RX buffer */
                                       /*       4 - Full TX buffer */
                                       /*       5 - Running int from TX */
                                       /*       6 - Full RX buffer */
                                       /*       7 - Noise error */
                                       /*       8 - Idle character  */
                                       /*       9 - Break detected  */
                                       /*      10 - Unused */
static word ErrFlag;                   /* Error flags mirror of SerFlag */
static word InpLen;                    /* Length of input buffer's content */
static AM1_TComData *InpPtrR;          /* Pointer for reading from input buffer */
static AM1_TComData *InpPtrW;          /* Pointer for writing to input buffer */
static AM1_TComData InpBuffer[AM1_INP_BUF_SIZE]; /* Input buffer for SCI communication */
static word OutLen;                    /* Length of output bufer's content */
static AM1_TComData *OutPtrR;          /* Pointer for reading from output buffer */
static AM1_TComData *OutPtrW;          /* Pointer for writing to output buffer */
static AM1_TComData OutBuffer[AM1_OUT_BUF_SIZE]; /* Output buffer for SCI communication */
static int16_t SerSlv;                 /* Number of selected slave mode */

/*
** ===================================================================
**     Method      :  HWEnDi (component AsynchroMaster)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  getReg(QSCI0_STAT);                  /* Reset interrupt request flags */
  setRegBits(QSCI0_CTRL1, (QSCI0_CTRL1_TE_MASK | QSCI0_CTRL1_RE_MASK | QSCI0_CTRL1_RFIE_MASK | QSCI0_CTRL1_REIE_MASK)); /* Enable device */
}

/*
** ===================================================================
**     Method      :  AM1_RecvChar (component AsynchroMaster)
**
**     Description :
**         If any data is received, this method returns one character,
**         otherwise it returns an error code (it does not wait for
**         data). This method is enabled only if the receiver property
**         is enabled.
**         [Note:] Because the preferred method to handle error and
**         break exception in the interrupt mode is to use events
**         <OnError> and <OnBreak> the return value ERR_RXEMPTY has
**         higher priority than other error codes. As a consequence the
**         information about an exception in interrupt mode is returned
**         only if there is a valid character ready to be read.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - Pointer to a received character
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - No data in receiver
**                           ERR_BREAK - Break character is detected
**                           (only when the <Interrupt service> property
**                           is disabled and the <Break signal> property
**                           is enabled)
**                           ERR_COMMON - common error occurred (the
**                           GetError method can be used for error
**                           specification)
** ===================================================================
*/
byte AM1_RecvChar(AM1_TComData *Chr)
{
  register byte Result = ERR_OK;       /* Return error code */

  if (InpLen > 0x00U) {                /* Is number of received chars greater than 0? */
    EnterCritical();                   /* Disable global interrupts */
    InpLen--;                          /* Decrease number of received chars */
    *Chr = *(InpPtrR++);               /* Received char */
    /*lint -save  -e946 Disable MISRA rule (17.2) checking. */
    if (InpPtrR >= (InpBuffer + AM1_INP_BUF_SIZE)) { /* Is the pointer out of the receive buffer? */
      InpPtrR = InpBuffer;             /* Set pointer to the first item into the receive buffer */
    }
    /*lint -restore Enable MISRA rule (17.2) checking. */
    Result = (byte)((SerFlag & (OVERRUN_ERR|COMMON_ERR|BREAK_ERR|FULL_RX)) ? ERR_COMMON : ERR_OK);
    SerFlag &= (word)(~(word)(OVERRUN_ERR|COMMON_ERR|BREAK_ERR|FULL_RX|CHAR_IN_RX)); /* Clear all errors in the status variable */
    ExitCritical();                    /* Enable global interrupts */
  } else {
    return ERR_RXEMPTY;                /* Receiver is empty */
  }
  return Result;                       /* Return error code */
}

/*
** ===================================================================
**     Method      :  AM1_SendChar (component AsynchroMaster)
**
**     Description :
**         Send one character to the channel. This method is available
**         only if the transmitter property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - Transmitter is full
** ===================================================================
*/
byte AM1_SendChar(AM1_TComData Chr)
{
  if (OutLen == AM1_OUT_BUF_SIZE) {    /* Is number of chars in buffer is the same as a size of the transmit buffer */
    return ERR_TXFULL;                 /* If yes then error */
  }
  EnterCritical();                     /* Disable global interrupts */
  OutLen++;                            /* Increase number of bytes in the transmit buffer */
  *(OutPtrW++) = Chr;                  /* Store char to buffer */
    /*lint -save  -e946 Disable MISRA rule (17.2) checking. */
  if (OutPtrW >= (OutBuffer + AM1_OUT_BUF_SIZE)) { /* Is the pointer out of the transmit buffer? */
    OutPtrW = OutBuffer;               /* Set pointer to the first item in the transmit buffer */
  }
    /*lint -restore Enable MISRA rule (17.2) checking. */
  setRegBit(QSCI0_CTRL1, TEIE);        /* Enable transmit interrupt */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AM1_RecvBlock (component AsynchroMaster)
**
**     Description :
**         If any data is received, this method returns the block of
**         the data and its length (and incidental error), otherwise it
**         returns an error code (it does not wait for data).
**         This method is available only if non-zero length of the
**         input buffer is defined and the receiver property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - Pointer to the block of received data
**         Size            - Size of the block
**       * Rcv             - Pointer to real number of the received data
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - The receive buffer didn't
**                           contain the requested number of data. Only
**                           available data has been returned.
**                           ERR_COMMON - Common error occurred (the
**                           GetError method can be used for error
**                           specification)
** ===================================================================
*/
byte AM1_RecvBlock(AM1_TComData *Ptr,word Size,word *Rcv)
{
  register word count;                 /* Number of received chars */
  register byte result = ERR_OK;       /* Last error */

  for (count = 0x00U; count < Size; count++) {
    switch (AM1_RecvChar(Ptr++)) {     /* Receive data and test the return value*/
    case ERR_RXEMPTY:                  /* No data in the buffer */
      if (result == ERR_OK) {          /* If no receiver error reported */
        result = ERR_RXEMPTY;          /* Return info that requested number of data is not available */
      }
     *Rcv = count;                     /* Return number of received chars */
      return result;
    case ERR_COMMON:                   /* Receiver error reported */
      result = ERR_COMMON;             /* Return info that an error was detected */
      break;
    default:
      break;
    }
  }
  *Rcv = count;                        /* Return number of received chars */
  return result;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AM1_SendBlock (component AsynchroMaster)
**
**     Description :
**         Sends a block of characters to the channel.
**         This method is available only if non-zero length of the
**         output buffer is defined and the transmitter property is
**         enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - Pointer to the block of data to send
**         Size            - Size of the block
**       * Snd             - Pointer to number of data that are sent
**                           (moved to buffer)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - It was not possible to send
**                           requested number of bytes
** ===================================================================
*/
byte AM1_SendBlock(AM1_TComData *Ptr,word Size,word *Snd)
{
  register word count;                 /* Number of sent chars */
  register byte result = ERR_OK;       /* Last error */
  register AM1_TComData *tmpPtr = Ptr;

  for (count = 0x00U; count < Size; count++) {
    result = AM1_SendChar(*tmpPtr++);
    if (result != ERR_OK) {            /* Sending given number of chars */
      *Snd = count;                    /* Return number of sent chars */
      return result;                   /* Return last error */
    }
  }
  *Snd = count;                        /* Return number of sended chars */
  return result;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AM1_ClearRxBuf (component AsynchroMaster)
**
**     Description :
**         Clears the receive buffer.
**         This method is available only if non-zero length of the
**         input buffer is defined and the receiver property is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte AM1_ClearRxBuf(void)
{
  EnterCritical();                     /* Disable global interrupts */
  InpLen = 0x00U;                      /* Set number of chars in the transmit buffer to 0 */
  InpPtrW = InpBuffer;                 /* Set pointers on the first item in the transmit buffer */
  InpPtrR = InpBuffer;
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AM1_ClearTxBuf (component AsynchroMaster)
**
**     Description :
**         Clears the transmit buffer.
**         This method is available only if non-zero length of the
**         output buffer is defined and the receiver property is
**         enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte AM1_ClearTxBuf(void)
{
  EnterCritical();                     /* Disable global interrupts */
  OutLen = 0x00U;                      /* Set number of chars in the receive buffer to 0 */
  OutPtrW = OutBuffer;                 /* Set pointers on the first item in the receive buffer */
  OutPtrR = OutBuffer;
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AM1_GetCharsInRxBuf (component AsynchroMaster)
**
**     Description :
**         Returns the number of characters in the input buffer. This
**         method is available only if the receiver property is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the input
**                           buffer.
** ===================================================================
*/
word AM1_GetCharsInRxBuf(void)
{
  return InpLen;                       /* Return number of chars in receive buffer */
}

/*
** ===================================================================
**     Method      :  AM1_GetCharsInTxBuf (component AsynchroMaster)
**
**     Description :
**         Returns the number of characters in the output buffer. This
**         method is available only if the transmitter property is
**         enabled.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the output
**                           buffer.
** ===================================================================
*/
word AM1_GetCharsInTxBuf(void)
{
  return OutLen;                       /* Return number of chars in the transmitter buffer */
}

/*
** ===================================================================
**     Method      :  AM1_GetBreak (component AsynchroMaster)
**
**     Description :
**         Tests the internal input break flag, returns it (whether the
**         break has occurred or not) and clears it. This method is
**         available only if property <Break signal> is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Brk             - Pointer to the returned internal break flag
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte AM1_GetBreak(bool *Brk)
{
  EnterCritical();                     /* Disable global interrupts */
  *Brk = (bool)(((SerFlag & BREAK_ERR) != 0U)? TRUE : FALSE); /* If was break signal? */
  SerFlag &= (word)(~(word)(BREAK_ERR)); /* Reset break signal flag */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AM1_SetBreak (component AsynchroMaster)
**
**     Description :
**         Sends the break sequence to the output line. This method is
**         available only if <Break signal> property is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - This component is disabled
**                           by user
** ===================================================================
*/
byte AM1_SetBreak(void)
{
  EnterCritical();                     /* Disable global interrupts */
  setRegBit(QSCI0_CTRL1, SBK);         /* Send break signal */
  clrRegBit(QSCI0_CTRL1, SBK);         /* Send break signal */
  OutPtrW = OutBuffer;                 /* Set pointers to first item in the the receive buffer */
  OutPtrR = OutBuffer;
  OutLen = 0x00U;                      /* Set number of chars in the the receive buffer to 0 */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AM1_InterruptRx (component AsynchroMaster)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#define ON_ERROR    0x01U
#define ON_FULL_RX  0x02U
#define ON_RX_CHAR  0x04U
#pragma interrupt alignsp saveall
void AM1_InterruptRx(void)
{
  register AM1_TComData Data;          /* Temporary variable for data */
  register word OnFlags = 0x00U;       /* Temporary variable for flags */
  register word StatReg = getReg(QSCI0_STAT); /* Read status register */

  if((StatReg & (QSCI0_STAT_FE_MASK)) != 0x00U) { /* Is HW framing error detected? */
    return;                            /* Then decode error type in Error ISR */
  }
  Data = (AM1_TComData)getReg(QSCI0_DATA); /* Read data from the receiver */
  if((StatReg & (QSCI0_STAT_OR_MASK)) != 0x00U) { /* Is HW overrun error detected? */
    setReg(QSCI0_STAT, 0x00U);         /* Reset error request flags */
    SerFlag |= (OVERRUN_ERR);          /* Set flag OVERRUN_ERR */
    OnFlags |= (ON_ERROR);             /* Set flag "OnError" */
  }
  if (InpLen < AM1_INP_BUF_SIZE) {     /* Is number of bytes in the receive buffer lower than size of buffer? */
    InpLen++;                          /* Increase number of chars in the receive buffer */
    *(InpPtrW++) = Data;               /* Save received char to the receive buffer */
    /*lint -save  -e946 Disable MISRA rule (17.2) checking. */
    if (InpPtrW >= (InpBuffer + AM1_INP_BUF_SIZE)) { /* Is the pointer out of the receive buffer? */
      InpPtrW = InpBuffer;             /* Set pointer on the first item into the receive buffer */
    }
    /*lint -restore Enable MISRA rule (17.2) checking. */
    OnFlags |= ON_RX_CHAR;             /* Set flag "OnRXChar" */
  } else {
    SerFlag |= (FULL_RX);              /* If yes then set flag buffer overflow */
    OnFlags |= (ON_ERROR);             /* Set flag "OnError" */
  }
  if ((OnFlags & ON_ERROR) != 0x00U) { /* Was error flag detect? */
    AM1_OnError();                     /* If yes then invoke user event */
  }
  if ((OnFlags & ON_RX_CHAR) != 0x00U) { /* Is OnRxChar flag set? */
    AM1_OnRxChar();                    /* If yes then invoke user event */
  }
}

/*
** ===================================================================
**     Method      :  AM1_InterruptTx (component AsynchroMaster)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#define ON_FREE_TX  0x01U
#define ON_TX_CHAR  0x02U
#pragma interrupt alignsp saveall
void AM1_InterruptTx(void)
{
  register word OnFlags = 0x00U;       /* Temporary variable for flags */

  if ((SerFlag & RUNINT_FROM_TX) != 0x00U) { /* Is flag "running int from TX" set? */
    OnFlags |= (ON_TX_CHAR);           /* Set flag "OnTxChar" */
  }
  SerFlag &= (word)(~(word)(RUNINT_FROM_TX)); /* Reset flag "running int from TX" */
  if (OutLen > 0x00U) {                /* Is number of bytes in the transmit buffer greater then 0? */
    OutLen--;                          /* Decrease number of chars in the transmit buffer */
    SerFlag |= (RUNINT_FROM_TX);       /* Set flag "running int from TX"? */
    getReg(QSCI0_STAT);                /* Reset interrupt request flags */
    QSCI0_DATA = (AM1_TComData)*(OutPtrR++); /* Store char to transmitter register */
    /*lint -save  -e946 Disable MISRA rule (17.2) checking. */
    if (OutPtrR >= (OutBuffer + AM1_OUT_BUF_SIZE)) { /* Is the pointer out of the transmit buffer? */
      OutPtrR = OutBuffer;             /* Set pointer on the first item into the transmit buffer */
    }
    /*lint -restore Enable MISRA rule (17.2) checking. */
  } else {
    OnFlags |= ON_FREE_TX;             /* Set flag "OnFreeTxBuf" */
    clrRegBit(QSCI0_CTRL1, TEIE);      /* Disable transmit interrupt */
  }
  if ((OnFlags & ON_TX_CHAR) != 0x00U) { /* Is flag "OnTxChar" set? */
    AM1_OnTxChar();                    /* If yes then invoke user event */
  }
  if ((OnFlags & ON_FREE_TX) != 0x00U) { /* Is flag "OnFreeTxBuf" set? */
    AM1_OnFreeTxBuf();                 /* If yes then invoke user event */
  }
}

/*
** ===================================================================
**     Method      :  AM1_InterruptError (component AsynchroMaster)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void AM1_InterruptError(void)
{
  register word StatReg = getReg(QSCI0_STAT); /* Read status register */
  register word Data = getReg(QSCI0_DATA); /* Read data from the receiver */
  register word OnFlags = 0U;          /* Temporary variable for flags */

  setReg(QSCI0_STAT, 0x00U);           /* Reset error request flags */
  if ((StatReg & QSCI0_STAT_OR_MASK) != 0x00U) { /* Is overrun error flag set? */
    OnFlags |= OVERRUN_ERR;            /* If yes then set the flag */
  }
  if ((StatReg & QSCI0_STAT_NF_MASK) != 0x00U) { /* Is noise error flag set? */
    OnFlags |= NOISE_ERR;              /* If yes then set the flag */
  }
  if ((StatReg & QSCI0_STAT_FE_MASK) != 0x00U) { /* Is framing error flag set? */
    if (Data == 0x00U) {               /* When a zero character is received */
      OnFlags |= BREAK_ERR;            /* When a zero character is received and framing error ocurred the break character is received */
    } else {
      OnFlags |= FRAMING_ERR;
    }
  }
  SerFlag |= OnFlags;                  /* Copy flags status to SerFlag status variable */
  ErrFlag |= OnFlags;                  /* Copy flags status to ErrFlag status variable */
  if ((SerFlag & (OVERRUN_ERR|FRAMING_ERR|PARITY_ERR|NOISE_ERR|BREAK_ERR)) != 0x00U) { /* Was any error set? */
    if ((SerFlag & BREAK_ERR) != 0x00U) {
      AM1_OnBreak();                   /* If yes then invoke user event */
      return;
    }
    AM1_OnError();                     /* If yes then invoke user event */
  }
}

/*
** ===================================================================
**     Method      :  AM1_Init (component AsynchroMaster)
**
**     Description :
**         Initializes the associated peripheral(s) and internal 
**         variables of the bean. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void AM1_Init(void)
{
  SerFlag = 0x00U;                     /* Reset all flags */
  SerSlv = NOSLAVE;                    /* No slave is selected */
  /* QSCI0_CTRL1: LOOP=1,SWAI=0,RSRC=0,M=1,WAKE=0,POL=0,PE=0,PT=0,TEIE=0,TIIE=0,RFIE=0,REIE=0,TE=0,RE=0,RWU=0,SBK=0 */
  setReg(QSCI0_CTRL1, 0x9000);         /* Set the SCI configuration */
  InpLen = 0x00U;                      /* No char in the receive buffer */
  InpPtrR = InpBuffer;                 /* Set pointer on the first item in the receive buffer */
  InpPtrW = InpBuffer;
  OutLen = 0x00U;                      /* No char in the transmit buffer */
  OutPtrR = OutBuffer;                 /* Set pointer on the first item in the transmit buffer */
  OutPtrW = OutBuffer;
  /* QSCI0_RATE: SBR=0x0516,FRAC_SBR=1 */
  setReg(QSCI0_RATE, 0x28B1);          /* Set prescaler bits */
  HWEnDi();                            /* Enable/disable device according to status flags */
}

/*
** ===================================================================
**     Method      :  AM1_SetIdle (component AsynchroMaster)
**
**     Description :
**         Sends the idle character to the output line.
**         This method is available only if the transmitter property is
**         enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - This component is disabled
**                           by user
** ===================================================================
*/
byte AM1_SetIdle(void)
{
  clrRegBit(QSCI0_CTRL1, TE);          /* Disable the transmitter */
  setRegBit(QSCI0_CTRL1, TE);          /* Enable the transmitter */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AM1_TurnRxOff (component AsynchroMaster)
**
**     Description :
**         Turns off the receiver. This method is available only if the
**         receiver property is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void AM1_TurnRxOff(void)

**      This method is implemented as a macro. See header module. **
*/

/*
** ===================================================================
**     Method      :  AM1_TurnRxOn (component AsynchroMaster)
**
**     Description :
**         Turns on the receiver. This method is available only if the
**         receiver property is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void AM1_TurnRxOn(void)

**      This method is implemented as a macro. See header module. **
*/

/*
** ===================================================================
**     Method      :  AM1_SelectSlave (component AsynchroMaster)
**
**     Description :
**         Select the slave - sends the address of the slave for
**         starting communication with it (the previous slave stops
**         communicating).
**     Parameters  :
**         NAME            - DESCRIPTION
**         Slv             - The new slave identification
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - This device is disabled
**                           ERR_BUSY - Transmitter buffer is not empty
** ===================================================================
*/
byte AM1_SelectSlave(byte Slv)
{
  if ((OutLen > 0U) || ((SerFlag & RUNINT_FROM_TX) != 0x00U)) { /* Are any chars in the transmit buffer or any char is being transmitted now? */
    return ERR_BUSY;                   /* If yes then error */
  }
  SerSlv = (int16_t)Slv;               /* Save identification of the selected slave */
  EnterCritical();                     /* Disable global interrupts */
  getReg(QSCI0_STAT);                  /* Reset interrupt request flags */
  setRegBit(QSCI0_STAT, TDRE);         /* Reset interrupt request flags */
  setReg(QSCI0_DATA, ((word)Slv | 0x0100U)); /* Store char to the transmitter register */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AM1_GetSelected (component AsynchroMaster)
**
**     Description :
**         Return the identification of the selected slave  (0-254, or
**         -1 if no slave is selected).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Slv             - Pointer to identification of the slave
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_NOTAVAIL - Slave is not selected yet
** ===================================================================
*/
byte AM1_GetSelected(byte *Slv)
{
  if (SerSlv == NOSLAVE) {             /* Is any slave selected? */
    return ERR_NOTAVAIL;               /* If no then error */
  }
  *Slv = (byte)SerSlv;                 /* Return address of the selected slave */
  return ERR_OK;                       /* OK */
}


/* END AM1. */


/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
