#include <hidef.h>      /* common defines and macros */
#include "mm912h634.h"      /* derivative-specific definitions */
#include "quicksilver.h"    /* miscellaneous quicksilver definitions */


/* Interrupt service routine Prototypes ------------------------- */
#pragma CODE_SEG NON_BANKED
void _dummyISR(void);   /* Dummy IRQ placeholder                  */
void _OSCMON(void);     /* 0xFFFC Oscillator monitor reset        */
void _COPWD(void);      /* 0xFFFA COP watchdog reset              */
void _UIT(void);        /* 0xFFF8 Unimplemented instruction trap  */
void _SWI(void);        /* 0xFFF6 SWI                             */
void _D2DERR(void);     /* 0xFFF4 D2DI Error Interrupt            */
void _D2D(void);        /* 0xFFF2 D2DI External Error Interrupt   */
void _RTI(void);        /* 0xFFF0 Real time interrupt             */
void _SPI(void);        /* 0xFFD8 SPI                             */
void _CRGFLL(void);     /* 0xFFC6 CRG FLL lock                    */
void _FLASH(void);      /* 0xFFB8 FLASH                           */
void _SIRQ(void);       /* 0xFF80 Spurious Interrupt              */
#pragma CODE_SEG DEFAULT
/* -------------------------------------------------------------- */

void main(void) {

/* D2D Init */



  D2DCTL1  = 0x8F;  // IRQ enable, max timeout
  D2DCTL0  = 0x80;  // D2D enable, 4Bit, !Stop in Wait, D2DCLK=BUS
  D2DSTAT0 = 0x80;  // Clear D2D Errors

  MMCCTL1 = 0x01;
  B_CTR0 = TRIM0;
  B_CTR1 = TRIM1;
  B_CTR2 = TRIM2;
  B_CTR3 = TRIM3;
  B_CTR2 = 0x1E;
  MMCCTL1 = 0x00;


  B_LSCEN = 0x05;
  
  B_LSCR=3;
  B_HSCR=3;
  
  B_HSR=1;



  for(;;) {         // Trap after Wakeup (see D2D ISR below)

  if  (B_LXR&0x01){
      B_LSCR=3;
      B_HSCR=3;
  } else {
      B_LSCR=0;
      B_HSCR=0;
  }



  __asm nop;



  } //for(;;)

} //main


/*****************************************************************************/
/* Start of interrupt service routines  */
/* placed into non-banked memory segment as vectors are only 2 bytes */

#pragma CODE_SEG NON_BANKED
/******************************************************************************
Function Name	:	_OSCMON
******************************************************************************/
#pragma TRAP_PROC
void
_OSCMON(void){}
/******************************************************************************
Function Name	:	_COPWD
******************************************************************************/
#pragma TRAP_PROC
void
_COPWD(void){}
/******************************************************************************
Function Name	:	_UIT
******************************************************************************/
#pragma TRAP_PROC
void
_UIT(void){}
/******************************************************************************
Function Name	:	_SWI
******************************************************************************/
#pragma TRAP_PROC
void
_SWI(void){}
/******************************************************************************
Function Name	:	_D2DERR
******************************************************************************/
#pragma TRAP_PROC
void
_D2DERR(void){}
/******************************************************************************
Function Name	:	_D2D
******************************************************************************/
#pragma TRAP_PROC
char temp;
void
_D2D(void){
 if (B_WSR&0x01) B_LSCR = 0x01; // Read WSR, turn on LS1 if L1 is source
 if (B_RSR&0x08) B_HSCR = 0x01; // Read RST, turn on HS1 if WUR is pending
}
/******************************************************************************
Function Name	:	_RTI
******************************************************************************/
#pragma TRAP_PROC
void _RTI(void){
CPMURTI   = 0x86;  // 10000110, RTI Enable, Flag clear,
if (B_WDSR != 0xAA) B_WDSR = 0xAA;else B_WDSR = 0x55;
PORTA++;
}
/******************************************************************************
Function Name	:	_SPI
******************************************************************************/
#pragma TRAP_PROC
void
_SPI(void){}
/******************************************************************************
Function Name	:	_CRGFLL
******************************************************************************/
#pragma TRAP_PROC
void
_CRGFLL(void){}
/******************************************************************************
Function Name	:	_FLASH
******************************************************************************/
#pragma TRAP_PROC
void
_FLASH(void){}
/******************************************************************************
Function Name	:	_SIRQ
******************************************************************************/
#pragma TRAP_PROC
void
_SIRQ(void){}
/******************************************************************************
Function Name	:	_dummyISR
Notes			    :	interrupt service routine for unused interrupt vectors.
******************************************************************************/
#pragma TRAP_PROC
void
_dummyISR( void )
{
    for(;;);	/* endless loop */
}
/* End of interrupt service routines  */
/* reset code segment to default */
#pragma CODE_SEG DEFAULT
