/*
 * PWM.c
 *
 *  Created on: Jun 2, 2016
 *      Author: B42964
 */

#include "derivative.h" /* include peripheral declarations */
#include "PWM.h"
#include "CLOCK.h"

unsigned int gpwm_per;

void PWM_INIT_CHANNEL(unsigned int pwm_channel_num, unsigned int pwm_per){
	
	PWM0CTL = 0;			// Select 8 bit (CONxx=0) or 16 bit (CONxx=1) operation.
	PWM0CLK = 0;			// Select the clock source (PWMCLK register).
	PWM0PRCLK = 0x44;		// Pre-scaler Select for Clock A-B, CLKPWM = BUS_CLK/16 = 16Mhz/16 = 1MHz
	PWM0POL = 1; 			// Select the PWM polarity (PWMPOL).
	PWM0CAE = 0x00; 		// Select left aligned (CAEx=0) or center aligned (CAEx=1) output.
	gpwm_per = pwm_per;
	
	switch (pwm_channel_num){
		case 0 :
			PWM0PER0 = pwm_per;
			break;
		case 1 :
			PWM0PER1 = pwm_per;
			break;
		case 2 :
			PWM0PER2 = pwm_per;
			break;
		case 3 :
			PWM0PER3 = pwm_per;
			break;	
		case 4 :
			PWM0PER4 = pwm_per;
			break;
		case 5 :
			PWM0PER5 = pwm_per;
			break;	
		case 6 :
			PWM0PER6 = pwm_per;
			break;
		case 7 :
			PWM0PER7 = pwm_per;
			break;	
	}


}


void PWM_CTRL_CHANNEL(unsigned int pwm_channel_num, unsigned int pwm_dty, unsigned int pwm_channel_status){
	unsigned int dt;
	dt = (pwm_dty*gpwm_per)/100;
	switch (pwm_channel_num){
		case 0 :
			PWM0DTY0 = dt;								// Pulse width channel 0 is defined
		    PWM0E_PWME0 = pwm_channel_status;		// Pulse width channel 0 is enabled/disabled
			break;
		case 1 :
			PWM0DTY1 = dt;								// Pulse width channel 1 is defined
		    PWM0E_PWME1 = pwm_channel_status;		// Pulse width channel 1 is enabled/disabled
			break;
		case 2 :
			PWM0DTY2 = dt;								// Pulse width channel 2 is defined
		    PWM0E_PWME2 = pwm_channel_status;		// Pulse width channel 2 is enabled/disabled
			break;
		case 3 :
			PWM0DTY3 = dt;								// Pulse width channel 3 is defined
		    PWM0E_PWME3 = pwm_channel_status;		// Pulse width channel 3 is enabled/disabled
			break;	
		case 4 :
			PWM0DTY4 = dt;								// Pulse width channel 4 is defined
		    PWM0E_PWME4 = pwm_channel_status;		// Pulse width channel 4 is enabled/disabled
			break;
		case 5 :
			PWM0DTY5 = dt;								// Pulse width channel 5 is defined
		    PWM0E_PWME5 = pwm_channel_status;		// Pulse width channel 5 is enabled/disabled
			break;	
		case 6 :
			PWM0DTY6 = dt;								// Pulse width channel 6 is defined
		    PWM0E_PWME6 = pwm_channel_status;		// Pulse width channel 6 is enabled/disabled
			break;
		case 7 :
			PWM0DTY7 = dt;								// Pulse width channel 7 is defined
		    PWM0E_PWME7 = pwm_channel_status;		// Pulse width channel 7 is enabled/disabled
			break;	
	}	
	

}

